/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.string;

import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.Expressions;
import org.elasticsearch.xpack.sql.expression.FieldAttribute;
import org.elasticsearch.xpack.sql.expression.TypeResolutions;
import org.elasticsearch.xpack.sql.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.StringProcessor;
import org.elasticsearch.xpack.sql.expression.gen.processor.Processor;
import org.elasticsearch.xpack.sql.expression.gen.script.ParamsBuilder;
import org.elasticsearch.xpack.sql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.sql.tree.Source;

public abstract class UnaryStringIntFunction
extends UnaryScalarFunction {
    protected UnaryStringIntFunction(Source source, Expression field) {
        super(source, field);
    }

    @Override
    public boolean foldable() {
        return this.field().foldable();
    }

    @Override
    public Object fold() {
        return this.operation().apply(this.field().fold());
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        return TypeResolutions.isInteger(this.field(), this.sourceText(), Expressions.ParamOrdinal.DEFAULT);
    }

    @Override
    protected Processor makeProcessor() {
        return new StringProcessor(this.operation());
    }

    protected abstract StringProcessor.StringOperation operation();

    @Override
    public ScriptTemplate scriptWithField(FieldAttribute field) {
        return new ScriptTemplate(this.processScript("doc[{}].value"), ParamsBuilder.paramsBuilder().variable(field.name()).build(), this.dataType());
    }

    @Override
    public String processScript(String template) {
        return super.processScript(String.format(Locale.ROOT, "{sql}.%s(%s)", this.operation().toString().toLowerCase(Locale.ROOT), template));
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.field());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        UnaryStringIntFunction other = (UnaryStringIntFunction)obj;
        return Objects.equals(other.field(), this.field());
    }
}

