/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.predicate.operator.arithmetic;

import java.io.IOException;
import java.util.function.Function;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.expression.gen.processor.Processor;
import org.elasticsearch.xpack.sql.expression.predicate.operator.arithmetic.Arithmetics;

public class UnaryArithmeticProcessor
implements Processor {
    public static final String NAME = "au";
    private final UnaryArithmeticOperation operation;

    public UnaryArithmeticProcessor(UnaryArithmeticOperation operation) {
        this.operation = operation;
    }

    public UnaryArithmeticProcessor(StreamInput in) throws IOException {
        this.operation = (UnaryArithmeticOperation)in.readEnum(UnaryArithmeticOperation.class);
    }

    public String getWriteableName() {
        return NAME;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum((Enum)this.operation);
    }

    @Override
    public Object process(Object input) {
        if (input == null) {
            return null;
        }
        if (input instanceof Number) {
            return this.operation.apply((Number)input);
        }
        throw new SqlIllegalArgumentException("A number is required; received {}", input);
    }

    public String toString() {
        return this.operation.symbol() + super.toString();
    }

    public static enum UnaryArithmeticOperation {
        NEGATE(Arithmetics::negate);

        private final Function<Number, Number> process;

        private UnaryArithmeticOperation(Function<Number, Number> process) {
            this.process = process;
        }

        public final Number apply(Number number) {
            return this.process.apply(number);
        }

        public String symbol() {
            return "-";
        }
    }
}

