/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.plan.logical.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.xpack.sql.analysis.index.IndexResolution;
import org.elasticsearch.xpack.sql.expression.Attribute;
import org.elasticsearch.xpack.sql.expression.FieldAttribute;
import org.elasticsearch.xpack.sql.expression.predicate.regex.LikePattern;
import org.elasticsearch.xpack.sql.plan.logical.command.Command;
import org.elasticsearch.xpack.sql.session.Rows;
import org.elasticsearch.xpack.sql.session.SchemaRowSet;
import org.elasticsearch.xpack.sql.session.SqlSession;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.elasticsearch.xpack.sql.tree.Source;
import org.elasticsearch.xpack.sql.type.DataType;
import org.elasticsearch.xpack.sql.type.EsField;
import org.elasticsearch.xpack.sql.type.KeywordEsField;

public class ShowColumns
extends Command {
    private final String index;
    private final LikePattern pattern;

    public ShowColumns(Source source, String index, LikePattern pattern) {
        super(source);
        this.index = index;
        this.pattern = pattern;
    }

    public String index() {
        return this.index;
    }

    public LikePattern pattern() {
        return this.pattern;
    }

    @Override
    protected NodeInfo<ShowColumns> info() {
        return NodeInfo.create(this, ShowColumns::new, this.index, this.pattern);
    }

    @Override
    public List<Attribute> output() {
        return Arrays.asList(new FieldAttribute(this.source(), "column", new KeywordEsField("column")), new FieldAttribute(this.source(), "type", new KeywordEsField("type")), new FieldAttribute(this.source(), "mapping", new KeywordEsField("mapping")));
    }

    @Override
    public void execute(SqlSession session, ActionListener<SchemaRowSet> listener) {
        String idx = this.index != null ? this.index : (this.pattern != null ? this.pattern.asIndexNameWildcard() : "*");
        String regex = this.pattern != null ? this.pattern.asJavaRegex() : null;
        session.indexResolver().resolveAsMergedMapping(idx, regex, (ActionListener<IndexResolution>)ActionListener.wrap(indexResult -> {
            List<List<?>> rows = Collections.emptyList();
            if (indexResult.isValid()) {
                rows = new ArrayList();
                this.fillInRows(indexResult.get().mapping(), null, rows);
            }
            listener.onResponse((Object)Rows.of(this.output(), rows));
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private void fillInRows(Map<String, EsField> mapping, String prefix, List<List<?>> rows) {
        for (Map.Entry<String, EsField> e : mapping.entrySet()) {
            EsField field = e.getValue();
            DataType dt = field.getDataType();
            String name = e.getKey();
            if (dt == null) continue;
            rows.add(Arrays.asList(prefix != null ? prefix + "." + name : name, dt.sqlName(), dt.typeName));
            if (field.getProperties().isEmpty()) continue;
            String newPrefix = prefix != null ? prefix + "." + name : name;
            this.fillInRows(field.getProperties(), newPrefix, rows);
        }
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.index, this.pattern);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ShowColumns other = (ShowColumns)obj;
        return Objects.equals(this.index, other.index) && Objects.equals(this.pattern, other.pattern);
    }
}

