/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.querydsl.agg;

import java.util.Map;
import java.util.Objects;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.aggregations.PipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregatorBuilders;
import org.elasticsearch.xpack.sql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.sql.expression.gen.script.Scripts;
import org.elasticsearch.xpack.sql.querydsl.agg.PipelineAgg;
import org.elasticsearch.xpack.sql.util.Check;

public class AggFilter
extends PipelineAgg {
    private static final String BUCKET_SELECTOR_ID_PREFIX = "having.";
    private final ScriptTemplate scriptTemplate;
    private final Map<String, String> aggPaths;

    public AggFilter(String name, ScriptTemplate scriptTemplate) {
        super(BUCKET_SELECTOR_ID_PREFIX + name);
        Check.isTrue(scriptTemplate != null, "a valid script is required");
        this.scriptTemplate = Scripts.nullSafeFilter(scriptTemplate);
        this.aggPaths = scriptTemplate.aggPaths();
    }

    public ScriptTemplate scriptTemplate() {
        return this.scriptTemplate;
    }

    @Override
    PipelineAggregationBuilder toBuilder() {
        Script script = this.scriptTemplate.toPainless();
        return PipelineAggregatorBuilders.bucketSelector((String)this.name(), this.aggPaths, (Script)script);
    }

    public int hashCode() {
        return Objects.hash(this.name(), this.scriptTemplate);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AggFilter other = (AggFilter)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.scriptTemplate(), other.scriptTemplate());
    }

    public String toString() {
        return this.scriptTemplate.toString();
    }
}

