/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.indexlifecycle.action;

import java.io.IOException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.indexlifecycle.action.PutLifecycleAction;

public class RestPutLifecycleAction
extends BaseRestHandler {
    public RestPutLifecycleAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.PUT, "/_ilm/policy/{name}", (RestHandler)this);
    }

    public String getName() {
        return "ilm_put_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        String lifecycleName = restRequest.param("name");
        XContentParser parser = restRequest.contentParser();
        PutLifecycleAction.Request putLifecycleRequest = PutLifecycleAction.Request.parseRequest((String)lifecycleName, (XContentParser)parser);
        putLifecycleRequest.timeout(restRequest.paramAsTime("timeout", putLifecycleRequest.timeout()));
        putLifecycleRequest.masterNodeTimeout(restRequest.paramAsTime("master_timeout", putLifecycleRequest.masterNodeTimeout()));
        return channel -> client.execute((Action)PutLifecycleAction.INSTANCE, (ActionRequest)putLifecycleRequest, (ActionListener)new RestToXContentListener(channel));
    }
}

