/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.indexlifecycle.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.indexlifecycle.IndexLifecycleMetadata;
import org.elasticsearch.xpack.core.indexlifecycle.LifecyclePolicyMetadata;
import org.elasticsearch.xpack.core.indexlifecycle.action.GetLifecycleAction;

public class TransportGetLifecycleAction
extends TransportMasterNodeAction<GetLifecycleAction.Request, GetLifecycleAction.Response> {
    @Inject
    public TransportGetLifecycleAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "cluster:admin/ilm/get", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, GetLifecycleAction.Request::new);
    }

    protected String executor() {
        return "same";
    }

    protected GetLifecycleAction.Response newResponse() {
        return new GetLifecycleAction.Response();
    }

    protected void masterOperation(GetLifecycleAction.Request request, ClusterState state, ActionListener<GetLifecycleAction.Response> listener) {
        IndexLifecycleMetadata metadata = (IndexLifecycleMetadata)this.clusterService.state().metaData().custom("index_lifecycle");
        if (metadata == null) {
            if (request.getPolicyNames().length == 0) {
                listener.onResponse((Object)new GetLifecycleAction.Response(Collections.emptyList()));
            } else {
                listener.onFailure((Exception)new ResourceNotFoundException("Lifecycle policy not found: {}", new Object[]{Arrays.toString(request.getPolicyNames())}));
            }
        } else {
            ArrayList<GetLifecycleAction.LifecyclePolicyResponseItem> requestedPolicies;
            if (request.getPolicyNames().length == 0) {
                requestedPolicies = new ArrayList<GetLifecycleAction.LifecyclePolicyResponseItem>(metadata.getPolicyMetadatas().size());
                for (LifecyclePolicyMetadata policyMetadata : metadata.getPolicyMetadatas().values()) {
                    requestedPolicies.add(new GetLifecycleAction.LifecyclePolicyResponseItem(policyMetadata.getPolicy(), policyMetadata.getVersion(), policyMetadata.getModifiedDateString()));
                }
            } else {
                requestedPolicies = new ArrayList(request.getPolicyNames().length);
                for (String name : request.getPolicyNames()) {
                    LifecyclePolicyMetadata policyMetadata = (LifecyclePolicyMetadata)metadata.getPolicyMetadatas().get(name);
                    if (policyMetadata == null) {
                        listener.onFailure((Exception)new ResourceNotFoundException("Lifecycle policy not found: {}", new Object[]{name}));
                        return;
                    }
                    requestedPolicies.add(new GetLifecycleAction.LifecyclePolicyResponseItem(policyMetadata.getPolicy(), policyMetadata.getVersion(), policyMetadata.getModifiedDateString()));
                }
            }
            listener.onResponse((Object)new GetLifecycleAction.Response(requestedPolicies));
        }
    }

    protected ClusterBlockException checkBlock(GetLifecycleAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

