/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.deprecation;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.joda.JodaDeprecationPatterns;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.xpack.core.deprecation.DeprecationIssue;

public class IndexDeprecationChecks {
    private static final Set<String> TYPES_THAT_DONT_COUNT;

    private static void fieldLevelMappingIssue(IndexMetaData indexMetaData, BiConsumer<MappingMetaData, Map<String, Object>> checker) {
        for (ObjectCursor mappingMetaData : indexMetaData.getMappings().values()) {
            Map sourceAsMap = ((MappingMetaData)mappingMetaData.value).sourceAsMap();
            checker.accept((MappingMetaData)mappingMetaData.value, sourceAsMap);
        }
    }

    static List<String> findInPropertiesRecursively(String type, Map<String, Object> parentMap, Function<Map<?, ?>, Boolean> predicate, BiFunction<String, Map.Entry<?, ?>, String> fieldFormatter) {
        ArrayList<String> issues = new ArrayList<String>();
        Map properties = (Map)parentMap.get("properties");
        if (properties == null) {
            return issues;
        }
        for (Map.Entry entry : properties.entrySet()) {
            Map values;
            Map valueMap = (Map)entry.getValue();
            if (predicate.apply(valueMap).booleanValue()) {
                issues.add("[" + fieldFormatter.apply(type, entry) + "]");
            }
            if ((values = (Map)valueMap.get("fields")) != null) {
                for (Map.Entry multifieldEntry : values.entrySet()) {
                    Map multifieldValueMap = (Map)multifieldEntry.getValue();
                    if (predicate.apply(multifieldValueMap).booleanValue()) {
                        issues.add("[" + fieldFormatter.apply(type, entry) + ", multifield: " + multifieldEntry.getKey() + "]");
                    }
                    if (!multifieldValueMap.containsKey("properties")) continue;
                    issues.addAll(IndexDeprecationChecks.findInPropertiesRecursively(type, multifieldValueMap, predicate, fieldFormatter));
                }
            }
            if (!valueMap.containsKey("properties")) continue;
            issues.addAll(IndexDeprecationChecks.findInPropertiesRecursively(type, valueMap, predicate, fieldFormatter));
        }
        return issues;
    }

    private static String formatDateField(String type, Map.Entry<?, ?> entry) {
        Map value = (Map)entry.getValue();
        return "type: " + type + ", field: " + entry.getKey() + ", format: " + value.get("format") + ", suggestion: " + JodaDeprecationPatterns.formatSuggestion((String)((String)value.get("format")));
    }

    private static String formatField(String type, Map.Entry<?, ?> entry) {
        return "type: " + type + ", field: " + entry.getKey();
    }

    static DeprecationIssue delimitedPayloadFilterCheck(IndexMetaData indexMetaData) {
        ArrayList<String> issues = new ArrayList<String>();
        Map filters = indexMetaData.getSettings().getGroups("index.analysis.filter");
        for (Map.Entry entry : filters.entrySet()) {
            if (!"delimited_payload_filter".equals(((Settings)entry.getValue()).get("type"))) continue;
            issues.add("The filter [" + (String)entry.getKey() + "] is of deprecated 'delimited_payload_filter' type. The filter type should be changed to 'delimited_payload'.");
        }
        if (issues.size() > 0) {
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, "Use of 'delimited_payload_filter'.", "https://www.elastic.co/guide/en/elasticsearch/reference/7.0/breaking-changes-7.0.html#_literal_delimited_payload_filter_literal_renaming", ((Object)issues).toString());
        }
        return null;
    }

    static DeprecationIssue oldIndicesCheck(IndexMetaData indexMetaData) {
        Version createdWith = indexMetaData.getCreationVersion();
        boolean hasDefaultMapping = indexMetaData.getMappings().containsKey((Object)"_default_");
        int mappingCount = indexMetaData.getMappings().size();
        if (createdWith.before(Version.V_6_0_0)) {
            if (".tasks".equals(indexMetaData.getIndex().getName())) {
                return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, ".tasks index must be re-created", "https://www.elastic.co/guide/en/elasticsearch/reference/7.0/breaking-changes-7.0.html#_indices_created_before_7_0", "The .tasks index was created before version 6.0 and cannot be opened in 7.0. You must delete this index and allow it to be re-created by Elasticsearch. If you wish to preserve task history, reindex this index to a new index before deleting it.");
            }
            if (".watches".equals(indexMetaData.getIndex().getName())) {
                return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, ".watches was not properly upgraded before upgrading to Elasticsearch 6", "https://www.elastic.co/guide/en/elasticsearch/reference/current/migration-api-upgrade.html", "The .watches index was created before version 6.0, and was not properly upgraded in 5.6. Please upgrade this index using the Migration Upgrade API.");
            }
            if (mappingCount == 2 && !hasDefaultMapping || mappingCount > 2) {
                return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, "Index has more than one mapping type", "https://www.elastic.co/guide/en/elasticsearch/reference/7.0/removal-of-types.html#_migrating_multi_type_indices_to_single_type", "This index has more than one mapping type, which is not supported in 7.0. This index must be reindexed into one or more single-type indices. Mapping types in use: " + indexMetaData.getMappings().keys());
            }
            return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, "Index created before 6.0", "https://www.elastic.co/guide/en/elasticsearch/reference/7.0/breaking-changes-7.0.html#_indices_created_before_7_0", "This index was created using version: " + createdWith);
        }
        return null;
    }

    static DeprecationIssue indexNameCheck(IndexMetaData indexMetaData) {
        String clusterName = indexMetaData.getIndex().getName();
        if (clusterName.contains(":")) {
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, "Index name cannot contain ':'", "https://www.elastic.co/guide/en/elasticsearch/reference/7.0/breaking-changes-7.0.html#_literal_literal_is_no_longer_allowed_in_index_name", "This index is named [" + clusterName + "], which contains the illegal character ':'.");
        }
        return null;
    }

    static DeprecationIssue percolatorUnmappedFieldsAsStringCheck(IndexMetaData indexMetaData) {
        if (indexMetaData.getSettings().hasValue("index.percolator.map_unmapped_fields_as_text")) {
            String settingValue = indexMetaData.getSettings().get("index.percolator.map_unmapped_fields_as_text");
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, "Setting index.percolator.map_unmapped_fields_as_text has been renamed", "https://www.elastic.co/guide/en/elasticsearch/reference/7.0/breaking-changes-7.0.html#_percolator", "The index setting [index.percolator.map_unmapped_fields_as_text] currently set to [" + settingValue + "] been removed in favor of [index.percolator.map_unmapped_fields_as_text].");
        }
        return null;
    }

    static DeprecationIssue classicSimilarityMappingCheck(IndexMetaData indexMetaData) {
        ArrayList issues = new ArrayList();
        IndexDeprecationChecks.fieldLevelMappingIssue(indexMetaData, (mappingMetaData, sourceAsMap) -> issues.addAll(IndexDeprecationChecks.findInPropertiesRecursively(mappingMetaData.type(), sourceAsMap, property -> "classic".equals(property.get("similarity")), IndexDeprecationChecks::formatField)));
        if (issues.size() > 0) {
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, "Classic similarity has been removed", "https://www.elastic.co/guide/en/elasticsearch/reference/7.0/breaking-changes-7.0.html#_the_literal_classic_literal_similarity_has_been_removed", "Fields which use classic similarity: " + ((Object)issues).toString());
        }
        return null;
    }

    static DeprecationIssue classicSimilaritySettingsCheck(IndexMetaData indexMetaData) {
        Map similarities = indexMetaData.getSettings().getGroups("index.similarity");
        List classicSimilarities = similarities.entrySet().stream().filter(entry -> "classic".equals(((Settings)entry.getValue()).get("type"))).map(Map.Entry::getKey).collect(Collectors.toList());
        if (classicSimilarities.size() > 0) {
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, "Classic similarity has been removed", "https://www.elastic.co/guide/en/elasticsearch/reference/7.0/breaking-changes-7.0.html#_the_literal_classic_literal_similarity_has_been_removed", "Custom similarities defined using classic similarity: " + classicSimilarities.toString());
        }
        return null;
    }

    static DeprecationIssue nodeLeftDelayedTimeCheck(IndexMetaData indexMetaData) {
        TimeValue parsedValue;
        String setting = UnassignedInfo.INDEX_DELAYED_NODE_LEFT_TIMEOUT_SETTING.getKey();
        String value = indexMetaData.getSettings().get(setting);
        if (!Strings.isNullOrEmpty((String)value) && (parsedValue = TimeValue.parseTimeValue((String)value, (String)setting)).getNanos() < 0L) {
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, "Negative values for " + setting + " are deprecated and should be set to 0", "https://www.elastic.co/guide/en/elasticsearch/reference/7.0/breaking-changes-7.0.html#_literal_index_unassigned_node_left_delayed_timeout_literal_may_no_longer_be_negative", "The index [" + indexMetaData.getIndex().getName() + "] has [" + setting + "] set to [" + value + "], but negative values are not allowed");
        }
        return null;
    }

    static DeprecationIssue shardOnStartupCheck(IndexMetaData indexMetaData) {
        String setting = IndexSettings.INDEX_CHECK_ON_STARTUP.getKey();
        String value = indexMetaData.getSettings().get(setting);
        if (!Strings.isNullOrEmpty((String)value) && "fix".equalsIgnoreCase(value)) {
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, "The value [fix] for setting [" + setting + "] is no longer valid", "https://www.elastic.co/guide/en/elasticsearch/reference/7.0/breaking-changes-7.0.html#_literal_fix_literal_value_for_literal_index_shard_check_on_startup_literal_is_removed", "The index [" + indexMetaData.getIndex().getName() + "] has the setting [" + setting + "] set to value [fix], but [fix] is no longer a valid value. Valid values are true, false, and checksum");
        }
        return null;
    }

    static DeprecationIssue tooManyFieldsCheck(IndexMetaData indexMetaData) {
        if (indexMetaData.getSettings().get("index.query.default_field") == null) {
            AtomicInteger fieldCount = new AtomicInteger(0);
            IndexDeprecationChecks.fieldLevelMappingIssue(indexMetaData, (mappingMetaData, sourceAsMap) -> fieldCount.addAndGet(IndexDeprecationChecks.countFieldsRecursively(mappingMetaData.type(), sourceAsMap)));
            if (fieldCount.get() > 1024) {
                return new DeprecationIssue(DeprecationIssue.Level.WARNING, "Number of fields exceeds automatic field expansion limit", "https://www.elastic.co/guide/en/elasticsearch/reference/7.0/breaking-changes-7.0.html#_limiting_the_number_of_auto_expanded_fields", "This index has [" + fieldCount.get() + "] fields, which exceeds the automatic field expansion limit of 1024 and does not have [" + "index.query.default_field" + "] set, which may cause queries which use automatic field expansion, such as query_string, simple_query_string, and multi_match to fail if fields are not explicitly specified in the query.");
            }
        }
        return null;
    }

    static DeprecationIssue deprecatedDateTimeFormat(IndexMetaData indexMetaData) {
        ArrayList fields = new ArrayList();
        IndexDeprecationChecks.fieldLevelMappingIssue(indexMetaData, (mappingMetaData, sourceAsMap) -> fields.addAll(IndexDeprecationChecks.findInPropertiesRecursively(mappingMetaData.type(), sourceAsMap, IndexDeprecationChecks::isDateFieldWithDeprecatedPattern, IndexDeprecationChecks::formatDateField)));
        if (fields.size() > 0) {
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, "Date field format uses patterns which may change meaning in 7.0", "https://www.elastic.co/guide/en/elasticsearch/reference/7.0/breaking-changes-7.0.html#breaking_70_java_time_changes", "This index has date fields with deprecated formats: " + fields + ". " + "Prefix your date format with '8' to use the new specifier.");
        }
        return null;
    }

    private static boolean isDateFieldWithDeprecatedPattern(Map<?, ?> property) {
        return "date".equals(property.get("type")) && property.containsKey("format") && JodaDeprecationPatterns.isDeprecatedPattern((String)((String)property.get("format")));
    }

    static int countFieldsRecursively(String type, Map<String, Object> parentMap) {
        int fields = 0;
        Map properties = (Map)parentMap.get("properties");
        if (properties == null) {
            return fields;
        }
        for (Map.Entry entry : properties.entrySet()) {
            Map values;
            Map valueMap = (Map)entry.getValue();
            if (valueMap.containsKey("type") && !(valueMap.get("type").equals("object") && !valueMap.containsKey("properties")) && !TYPES_THAT_DONT_COUNT.contains(valueMap.get("type"))) {
                ++fields;
            }
            if ((values = (Map)valueMap.get("fields")) != null) {
                for (Map.Entry multifieldEntry : values.entrySet()) {
                    Map multifieldValueMap = (Map)multifieldEntry.getValue();
                    if (multifieldValueMap.containsKey("type") && !TYPES_THAT_DONT_COUNT.contains(valueMap.get("type"))) {
                        ++fields;
                    }
                    if (!multifieldValueMap.containsKey("properties")) continue;
                    fields += IndexDeprecationChecks.countFieldsRecursively(type, multifieldValueMap);
                }
            }
            if (!valueMap.containsKey("properties")) continue;
            fields += IndexDeprecationChecks.countFieldsRecursively(type, valueMap);
        }
        return fields;
    }

    static {
        HashSet<String> typesThatDontCount = new HashSet<String>();
        typesThatDontCount.add("binary");
        typesThatDontCount.add("geo_point");
        typesThatDontCount.add("geo_shape");
        TYPES_THAT_DONT_COUNT = Collections.unmodifiableSet(typesThatDontCount);
    }
}

