/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.classfile.visitor;

import java.util.List;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.instruction.bytecode.instruction.ANewArray;
import jd.core.model.instruction.bytecode.instruction.AThrow;
import jd.core.model.instruction.bytecode.instruction.ArrayLength;
import jd.core.model.instruction.bytecode.instruction.ArrayStoreInstruction;
import jd.core.model.instruction.bytecode.instruction.AssertInstruction;
import jd.core.model.instruction.bytecode.instruction.BinaryOperatorInstruction;
import jd.core.model.instruction.bytecode.instruction.CheckCast;
import jd.core.model.instruction.bytecode.instruction.ComplexConditionalBranchInstruction;
import jd.core.model.instruction.bytecode.instruction.ConvertInstruction;
import jd.core.model.instruction.bytecode.instruction.DupStore;
import jd.core.model.instruction.bytecode.instruction.GetField;
import jd.core.model.instruction.bytecode.instruction.IConst;
import jd.core.model.instruction.bytecode.instruction.IfCmp;
import jd.core.model.instruction.bytecode.instruction.IfInstruction;
import jd.core.model.instruction.bytecode.instruction.IncInstruction;
import jd.core.model.instruction.bytecode.instruction.InitArrayInstruction;
import jd.core.model.instruction.bytecode.instruction.InstanceOf;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.InvokeInstruction;
import jd.core.model.instruction.bytecode.instruction.InvokeNoStaticInstruction;
import jd.core.model.instruction.bytecode.instruction.LookupSwitch;
import jd.core.model.instruction.bytecode.instruction.MonitorEnter;
import jd.core.model.instruction.bytecode.instruction.MonitorExit;
import jd.core.model.instruction.bytecode.instruction.MultiANewArray;
import jd.core.model.instruction.bytecode.instruction.NewArray;
import jd.core.model.instruction.bytecode.instruction.Pop;
import jd.core.model.instruction.bytecode.instruction.PutField;
import jd.core.model.instruction.bytecode.instruction.PutStatic;
import jd.core.model.instruction.bytecode.instruction.ReturnInstruction;
import jd.core.model.instruction.bytecode.instruction.StoreInstruction;
import jd.core.model.instruction.bytecode.instruction.TableSwitch;
import jd.core.model.instruction.bytecode.instruction.TernaryOpStore;
import jd.core.model.instruction.bytecode.instruction.UnaryOperatorInstruction;
import jd.core.util.SignatureUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckCastAndConvertInstructionVisitor {
    private static void visit(ConstantPool constants, Instruction instruction) {
        switch (instruction.opcode) {
            case 190: {
                CheckCastAndConvertInstructionVisitor.visit(constants, ((ArrayLength)instruction).arrayref);
                break;
            }
            case 83: 
            case 272: {
                CheckCastAndConvertInstructionVisitor.visit(constants, ((ArrayStoreInstruction)instruction).arrayref);
                break;
            }
            case 286: {
                AssertInstruction ai = (AssertInstruction)instruction;
                CheckCastAndConvertInstructionVisitor.visit(constants, ai.test);
                if (ai.msg == null) break;
                CheckCastAndConvertInstructionVisitor.visit(constants, ai.msg);
                break;
            }
            case 191: {
                CheckCastAndConvertInstructionVisitor.visit(constants, ((AThrow)instruction).value);
                break;
            }
            case 266: {
                CheckCastAndConvertInstructionVisitor.visit(constants, ((UnaryOperatorInstruction)instruction).value);
                break;
            }
            case 265: 
            case 267: {
                BinaryOperatorInstruction boi = (BinaryOperatorInstruction)instruction;
                CheckCastAndConvertInstructionVisitor.visit(constants, boi.value1);
                CheckCastAndConvertInstructionVisitor.visit(constants, boi.value2);
                break;
            }
            case 192: {
                CheckCast cc = (CheckCast)instruction;
                if (cc.objectref.opcode == 192) {
                    cc.objectref = ((CheckCast)cc.objectref).objectref;
                }
                CheckCastAndConvertInstructionVisitor.visit(constants, cc.objectref);
                break;
            }
            case 54: 
            case 58: 
            case 269: {
                CheckCastAndConvertInstructionVisitor.visit(constants, ((StoreInstruction)instruction).valueref);
                break;
            }
            case 264: {
                CheckCastAndConvertInstructionVisitor.visit(constants, ((DupStore)instruction).objectref);
                break;
            }
            case 275: 
            case 276: {
                CheckCastAndConvertInstructionVisitor.visit(constants, ((ConvertInstruction)instruction).value);
                break;
            }
            case 261: {
                IfCmp ifCmp = (IfCmp)instruction;
                CheckCastAndConvertInstructionVisitor.visit(constants, ifCmp.value1);
                CheckCastAndConvertInstructionVisitor.visit(constants, ifCmp.value2);
                break;
            }
            case 260: 
            case 262: {
                CheckCastAndConvertInstructionVisitor.visit(constants, ((IfInstruction)instruction).value);
                break;
            }
            case 284: {
                List<Instruction> branchList = ((ComplexConditionalBranchInstruction)instruction).instructions;
                int i = branchList.size() - 1;
                while (i >= 0) {
                    CheckCastAndConvertInstructionVisitor.visit(constants, branchList.get(i));
                    --i;
                }
                break;
            }
            case 193: {
                CheckCastAndConvertInstructionVisitor.visit(constants, ((InstanceOf)instruction).objectref);
                break;
            }
            case 182: 
            case 183: 
            case 185: {
                CheckCastAndConvertInstructionVisitor.visit(constants, ((InvokeNoStaticInstruction)instruction).objectref);
            }
            case 184: 
            case 274: {
                List<String> parameterSignatures = ((InvokeInstruction)instruction).getListOfParameterSignatures(constants);
                if (parameterSignatures == null) break;
                List<Instruction> args = ((InvokeInstruction)instruction).args;
                int i = parameterSignatures.size();
                int j = args.size();
                block41: while (i-- > 0 && j-- > 0) {
                    Instruction arg = args.get(j);
                    block34 : switch (arg.opcode) {
                        case 16: 
                        case 17: 
                        case 256: {
                            String argSignature = ((IConst)arg).getSignature();
                            String parameterSignature = parameterSignatures.get(i);
                            if (!parameterSignature.equals(argSignature)) {
                                int paramBitFields;
                                int argBitFields = SignatureUtil.CreateArgOrReturnBitFields(argSignature);
                                if ((argBitFields | (paramBitFields = SignatureUtil.CreateTypesBitField(parameterSignature))) != 0) continue block41;
                                args.set(j, new ConvertInstruction(275, arg.offset - 1, arg.lineNumber, arg, parameterSignature));
                                break;
                            }
                            switch (parameterSignature.charAt(0)) {
                                case 'B': 
                                case 'S': {
                                    args.set(j, new ConvertInstruction(275, arg.offset - 1, arg.lineNumber, arg, parameterSignature));
                                    break block34;
                                }
                            }
                            CheckCastAndConvertInstructionVisitor.visit(constants, arg);
                            break;
                        }
                        default: {
                            CheckCastAndConvertInstructionVisitor.visit(constants, arg);
                        }
                    }
                }
                break;
            }
            case 171: {
                CheckCastAndConvertInstructionVisitor.visit(constants, ((LookupSwitch)instruction).key);
                break;
            }
            case 194: {
                CheckCastAndConvertInstructionVisitor.visit(constants, ((MonitorEnter)instruction).objectref);
                break;
            }
            case 195: {
                CheckCastAndConvertInstructionVisitor.visit(constants, ((MonitorExit)instruction).objectref);
                break;
            }
            case 197: {
                Instruction[] dimensions = ((MultiANewArray)instruction).dimensions;
                int i = dimensions.length - 1;
                while (i >= 0) {
                    CheckCastAndConvertInstructionVisitor.visit(constants, dimensions[i]);
                    --i;
                }
                break;
            }
            case 188: {
                CheckCastAndConvertInstructionVisitor.visit(constants, ((NewArray)instruction).dimension);
                break;
            }
            case 189: {
                CheckCastAndConvertInstructionVisitor.visit(constants, ((ANewArray)instruction).dimension);
                break;
            }
            case 87: {
                CheckCastAndConvertInstructionVisitor.visit(constants, ((Pop)instruction).objectref);
                break;
            }
            case 181: {
                PutField putField = (PutField)instruction;
                CheckCastAndConvertInstructionVisitor.visit(constants, putField.objectref);
                CheckCastAndConvertInstructionVisitor.visit(constants, putField.valueref);
                break;
            }
            case 179: {
                CheckCastAndConvertInstructionVisitor.visit(constants, ((PutStatic)instruction).valueref);
                break;
            }
            case 273: {
                CheckCastAndConvertInstructionVisitor.visit(constants, ((ReturnInstruction)instruction).valueref);
                break;
            }
            case 170: {
                CheckCastAndConvertInstructionVisitor.visit(constants, ((TableSwitch)instruction).key);
                break;
            }
            case 280: {
                CheckCastAndConvertInstructionVisitor.visit(constants, ((TernaryOpStore)instruction).objectref);
                break;
            }
            case 277: 
            case 278: {
                CheckCastAndConvertInstructionVisitor.visit(constants, ((IncInstruction)instruction).value);
                break;
            }
            case 180: {
                CheckCastAndConvertInstructionVisitor.visit(constants, ((GetField)instruction).objectref);
                break;
            }
            case 282: 
            case 283: {
                InitArrayInstruction iai = (InitArrayInstruction)instruction;
                CheckCastAndConvertInstructionVisitor.visit(constants, iai.newArray);
                if (iai.values == null) break;
                CheckCastAndConvertInstructionVisitor.visit(constants, iai.values);
                break;
            }
            case 0: 
            case 1: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 25: 
            case 132: 
            case 167: 
            case 168: 
            case 169: 
            case 177: 
            case 178: 
            case 187: 
            case 256: 
            case 257: 
            case 258: 
            case 259: 
            case 263: 
            case 268: 
            case 270: 
            case 271: 
            case 279: 
            case 285: {
                break;
            }
            default: {
                System.err.println("Can not check cast and convert instruction in " + instruction.getClass().getName() + ", opcode=" + instruction.opcode);
            }
        }
    }

    public static void visit(ConstantPool constants, List<Instruction> instructions) {
        int i = instructions.size() - 1;
        while (i >= 0) {
            CheckCastAndConvertInstructionVisitor.visit(constants, instructions.get(i));
            --i;
        }
    }
}

