/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.classfile.visitor;

import java.util.List;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.classfile.constant.ConstantClass;
import jd.core.model.classfile.constant.ConstantMethodref;
import jd.core.model.classfile.constant.ConstantNameAndType;
import jd.core.model.instruction.bytecode.instruction.ANewArray;
import jd.core.model.instruction.bytecode.instruction.AThrow;
import jd.core.model.instruction.bytecode.instruction.ArrayLength;
import jd.core.model.instruction.bytecode.instruction.ArrayStoreInstruction;
import jd.core.model.instruction.bytecode.instruction.AssertInstruction;
import jd.core.model.instruction.bytecode.instruction.BinaryOperatorInstruction;
import jd.core.model.instruction.bytecode.instruction.CheckCast;
import jd.core.model.instruction.bytecode.instruction.ComplexConditionalBranchInstruction;
import jd.core.model.instruction.bytecode.instruction.ConvertInstruction;
import jd.core.model.instruction.bytecode.instruction.DupStore;
import jd.core.model.instruction.bytecode.instruction.GetField;
import jd.core.model.instruction.bytecode.instruction.IConst;
import jd.core.model.instruction.bytecode.instruction.IfCmp;
import jd.core.model.instruction.bytecode.instruction.IfInstruction;
import jd.core.model.instruction.bytecode.instruction.IncInstruction;
import jd.core.model.instruction.bytecode.instruction.InitArrayInstruction;
import jd.core.model.instruction.bytecode.instruction.InstanceOf;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.InvokeInstruction;
import jd.core.model.instruction.bytecode.instruction.InvokeNoStaticInstruction;
import jd.core.model.instruction.bytecode.instruction.Invokevirtual;
import jd.core.model.instruction.bytecode.instruction.LookupSwitch;
import jd.core.model.instruction.bytecode.instruction.MonitorEnter;
import jd.core.model.instruction.bytecode.instruction.MonitorExit;
import jd.core.model.instruction.bytecode.instruction.MultiANewArray;
import jd.core.model.instruction.bytecode.instruction.NewArray;
import jd.core.model.instruction.bytecode.instruction.Pop;
import jd.core.model.instruction.bytecode.instruction.PutField;
import jd.core.model.instruction.bytecode.instruction.PutStatic;
import jd.core.model.instruction.bytecode.instruction.ReturnInstruction;
import jd.core.model.instruction.bytecode.instruction.StoreInstruction;
import jd.core.model.instruction.bytecode.instruction.TableSwitch;
import jd.core.model.instruction.bytecode.instruction.TernaryOpStore;
import jd.core.model.instruction.bytecode.instruction.UnaryOperatorInstruction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetConstantTypeInStringIndexOfMethodsVisitor {
    protected ConstantPool constants;

    public SetConstantTypeInStringIndexOfMethodsVisitor(ConstantPool constants) {
        this.constants = constants;
    }

    public void visit(Instruction instruction) {
        switch (instruction.opcode) {
            case 190: {
                this.visit(((ArrayLength)instruction).arrayref);
                break;
            }
            case 83: 
            case 272: {
                this.visit(((ArrayStoreInstruction)instruction).arrayref);
                break;
            }
            case 286: {
                AssertInstruction ai = (AssertInstruction)instruction;
                this.visit(ai.test);
                if (ai.msg == null) break;
                this.visit(ai.msg);
                break;
            }
            case 191: {
                this.visit(((AThrow)instruction).value);
                break;
            }
            case 266: {
                this.visit(((UnaryOperatorInstruction)instruction).value);
                break;
            }
            case 265: 
            case 267: {
                BinaryOperatorInstruction boi = (BinaryOperatorInstruction)instruction;
                this.visit(boi.value1);
                this.visit(boi.value2);
                break;
            }
            case 192: {
                this.visit(((CheckCast)instruction).objectref);
                break;
            }
            case 54: 
            case 58: 
            case 269: {
                this.visit(((StoreInstruction)instruction).valueref);
                break;
            }
            case 264: {
                this.visit(((DupStore)instruction).objectref);
                break;
            }
            case 275: 
            case 276: {
                this.visit(((ConvertInstruction)instruction).value);
                break;
            }
            case 261: {
                IfCmp ifCmp = (IfCmp)instruction;
                this.visit(ifCmp.value1);
                this.visit(ifCmp.value2);
                break;
            }
            case 260: 
            case 262: {
                this.visit(((IfInstruction)instruction).value);
                break;
            }
            case 284: {
                List<Instruction> branchList = ((ComplexConditionalBranchInstruction)instruction).instructions;
                int i = branchList.size() - 1;
                while (i >= 0) {
                    this.visit(branchList.get(i));
                    --i;
                }
                break;
            }
            case 193: {
                this.visit(((InstanceOf)instruction).objectref);
                break;
            }
            case 182: {
                int opcode;
                int nbrOfParameters;
                Invokevirtual iv = (Invokevirtual)instruction;
                ConstantMethodref cmr = this.constants.getConstantMethodref(iv.index);
                ConstantClass cc = this.constants.getConstantClass(cmr.class_index);
                if (cc.name_index == this.constants.stringClassNameIndex && 1 <= (nbrOfParameters = iv.args.size()) && nbrOfParameters <= 2 && ((opcode = ((Instruction)iv.args.get((int)0)).opcode) == 16 || opcode == 17) && cmr.getReturnedSignature().equals("I") && cmr.getListOfParameterSignatures().get(0).equals("I")) {
                    ConstantNameAndType cnat = this.constants.getConstantNameAndType(cmr.name_and_type_index);
                    String name = this.constants.getConstantUtf8(cnat.name_index);
                    if ("indexOf".equals(name) || "lastIndexOf".equals(name)) {
                        IConst ic = (IConst)iv.args.get(0);
                        ic.setReturnedSignature("C");
                        break;
                    }
                }
            }
            case 183: 
            case 185: {
                this.visit(((InvokeNoStaticInstruction)instruction).objectref);
            }
            case 184: 
            case 274: {
                List<Instruction> list = ((InvokeInstruction)instruction).args;
                int i = list.size() - 1;
                while (i >= 0) {
                    this.visit(list.get(i));
                    --i;
                }
                break;
            }
            case 171: {
                this.visit(((LookupSwitch)instruction).key);
                break;
            }
            case 194: {
                this.visit(((MonitorEnter)instruction).objectref);
                break;
            }
            case 195: {
                this.visit(((MonitorExit)instruction).objectref);
                break;
            }
            case 197: {
                Instruction[] dimensions = ((MultiANewArray)instruction).dimensions;
                int i = dimensions.length - 1;
                while (i >= 0) {
                    this.visit(dimensions[i]);
                    --i;
                }
                break;
            }
            case 188: {
                this.visit(((NewArray)instruction).dimension);
                break;
            }
            case 189: {
                this.visit(((ANewArray)instruction).dimension);
                break;
            }
            case 87: {
                this.visit(((Pop)instruction).objectref);
                break;
            }
            case 181: {
                PutField putField = (PutField)instruction;
                this.visit(putField.objectref);
                this.visit(putField.valueref);
                break;
            }
            case 179: {
                this.visit(((PutStatic)instruction).valueref);
                break;
            }
            case 273: {
                this.visit(((ReturnInstruction)instruction).valueref);
                break;
            }
            case 170: {
                this.visit(((TableSwitch)instruction).key);
                break;
            }
            case 280: {
                this.visit(((TernaryOpStore)instruction).objectref);
                break;
            }
            case 277: 
            case 278: {
                this.visit(((IncInstruction)instruction).value);
                break;
            }
            case 180: {
                this.visit(((GetField)instruction).objectref);
                break;
            }
            case 282: 
            case 283: {
                InitArrayInstruction iai = (InitArrayInstruction)instruction;
                this.visit(iai.newArray);
                if (iai.values == null) break;
                this.visit(iai.values);
                break;
            }
            case 0: 
            case 1: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 25: 
            case 132: 
            case 167: 
            case 168: 
            case 169: 
            case 177: 
            case 178: 
            case 187: 
            case 256: 
            case 257: 
            case 258: 
            case 259: 
            case 263: 
            case 268: 
            case 270: 
            case 271: 
            case 279: 
            case 285: {
                break;
            }
            default: {
                System.err.println("Can not search String.indexOf in " + instruction.getClass().getName() + ", opcode=" + instruction.opcode);
            }
        }
    }

    public void visit(List<Instruction> instructions) {
        int i = instructions.size() - 1;
        while (i >= 0) {
            this.visit(instructions.get(i));
            --i;
        }
    }
}

