/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.type;

import groovyjarjarasm.asm.ClassReader;
import groovyjarjarasm.asm.tree.ClassNode;
import groovyjarjarasm.asm.tree.FieldNode;
import groovyjarjarasm.asm.tree.InnerClassNode;
import groovyjarjarasm.asm.tree.MethodNode;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import org.jd.gui.api.API;
import org.jd.gui.api.model.Container;
import org.jd.gui.api.model.Type;
import org.jd.gui.service.type.AbstractTypeFactoryProvider;

public class ClassFileTypeFactoryProvider
extends AbstractTypeFactoryProvider {
    protected AbstractTypeFactoryProvider.Cache<URI, JavaType> cache = new AbstractTypeFactoryProvider.Cache();

    @Override
    public String[] getSelectors() {
        List<String> externalSelectors = this.getExternalSelectors();
        if (externalSelectors == null) {
            return new String[]{"*:file:*.class"};
        }
        int size = externalSelectors.size();
        String[] selectors = new String[size + 1];
        externalSelectors.toArray(selectors);
        selectors[size] = "*:file:*.class";
        return selectors;
    }

    @Override
    public Collection<Type> make(API api, Container.Entry entry) {
        return Collections.singletonList(this.make(api, entry, null));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Type make(API api, Container.Entry entry, String fragment) {
        JavaType type;
        URI key = entry.getUri();
        if (this.cache.containsKey(key)) {
            return (Type)this.cache.get(key);
        }
        try (InputStream is = entry.getInputStream();){
            ClassReader classReader = new ClassReader(is);
            if (fragment != null && fragment.length() > 0) {
                int index = fragment.indexOf(45);
                if (index != -1) {
                    fragment = fragment.substring(0, index);
                }
                if (!classReader.getClassName().equals(fragment)) {
                    String entryTypePath = classReader.getClassName() + ".class";
                    String fragmentTypePath = fragment + ".class";
                    while (true) {
                        if (entry.getPath().endsWith(entryTypePath)) {
                            Throwable throwable;
                            String pathToFound = entry.getPath().substring(0, entry.getPath().length() - entryTypePath.length()) + fragmentTypePath;
                            Container.Entry entryFound = null;
                            for (Container.Entry e : entry.getParent().getChildren()) {
                                if (!e.getPath().equals(pathToFound)) continue;
                                entryFound = e;
                                break;
                            }
                            if (entryFound == null) {
                                Iterator<Container.Entry> i$ = null;
                                return i$;
                            }
                            entry = entryFound;
                            try {
                                throwable = null;
                                try (InputStream is2 = entry.getInputStream();){
                                    classReader = new ClassReader(is2);
                                    break;
                                }
                                catch (Throwable x2) {
                                    throwable = x2;
                                    throw x2;
                                }
                            }
                            catch (IOException ignore) {
                                throwable = null;
                                if (is == null) return throwable;
                                if (var7_7 == null) {
                                    is.close();
                                    return throwable;
                                }
                                try {
                                    is.close();
                                    return throwable;
                                }
                                catch (Throwable x2) {
                                    var7_7.addSuppressed(x2);
                                    return throwable;
                                }
                            }
                        }
                        int firstPackageSeparatorIndex = entryTypePath.indexOf(47);
                        if (firstPackageSeparatorIndex == -1) {
                            Type type2 = null;
                            return type2;
                        }
                        entryTypePath = entryTypePath.substring(firstPackageSeparatorIndex + 1);
                        fragmentTypePath = fragmentTypePath.substring(fragmentTypePath.indexOf(47) + 1);
                    }
                }
            }
            type = new JavaType(entry, classReader, -1);
        }
        catch (IOException ignore) {
            type = null;
        }
        this.cache.put(key, type);
        return type;
    }

    static {
        JavaType.class.getName();
    }

    static class JavaType
    implements Type {
        protected ClassNode classNode = new ClassNode();
        protected Container.Entry entry;
        protected int access;
        protected String name;
        protected String superName;
        protected String outerName;
        protected String displayTypeName;
        protected String displayInnerTypeName;
        protected String displayPackageName;
        protected List<Type> innerTypes = null;
        protected List<Type.Field> fields = null;
        protected List<Type.Method> methods = null;

        protected JavaType(Container.Entry entry, ClassReader classReader, int outerAccess) {
            int lastPackageSeparatorIndex;
            int indexSeparator;
            this.entry = entry;
            classReader.accept(this.classNode, 7);
            this.access = outerAccess == -1 ? this.classNode.access : outerAccess;
            this.name = this.classNode.name;
            this.superName = (this.access & 0x200) != 0 && "java/lang/Object".equals(this.classNode.superName) ? null : this.classNode.superName;
            this.outerName = null;
            this.displayInnerTypeName = null;
            int indexDollar = this.name.lastIndexOf(36);
            if (indexDollar != -1 && indexDollar > (indexSeparator = this.name.lastIndexOf(47))) {
                for (InnerClassNode innerClassNode : this.classNode.innerClasses) {
                    if (!this.name.equals(innerClassNode.name) || innerClassNode.outerName == null) continue;
                    this.outerName = innerClassNode.outerName;
                    this.displayInnerTypeName = this.name.substring(this.outerName.length() + 1);
                }
            }
            if ((lastPackageSeparatorIndex = this.name.lastIndexOf(47)) == -1) {
                this.displayPackageName = "";
                this.displayTypeName = this.outerName == null ? this.name : null;
            } else {
                this.displayPackageName = this.name.substring(0, lastPackageSeparatorIndex).replace('/', '.');
                this.displayTypeName = this.outerName == null ? this.name.substring(lastPackageSeparatorIndex + 1) : null;
            }
        }

        @Override
        public int getFlags() {
            return this.access;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getSuperName() {
            return this.superName;
        }

        @Override
        public String getOuterName() {
            return this.outerName;
        }

        @Override
        public String getDisplayPackageName() {
            return this.displayPackageName;
        }

        @Override
        public String getDisplayTypeName() {
            if (this.displayTypeName == null) {
                this.displayTypeName = this.getDisplayTypeName(this.outerName, this.displayPackageName.length()) + '.' + this.displayInnerTypeName;
            }
            return this.displayTypeName;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected String getDisplayTypeName(String name, int packageLength) {
            String string;
            Container.Entry outerEntry;
            int indexDollar = name.lastIndexOf(36);
            if (indexDollar > packageLength && (outerEntry = this.getEntry(name)) != null) {
                try (InputStream is = outerEntry.getInputStream();){
                    ClassReader classReader = new ClassReader(is);
                    ClassNode classNode = new ClassNode();
                    classReader.accept(classNode, 7);
                    for (InnerClassNode innerClassNode : classNode.innerClasses) {
                        if (!name.equals(innerClassNode.name)) continue;
                        String string2 = this.getDisplayTypeName(innerClassNode.outerName, packageLength) + '.' + innerClassNode.innerName;
                        return string2;
                    }
                }
                catch (IOException ignore) {
                    // empty catch block
                }
            }
            if (packageLength > 0) {
                string = name.substring(packageLength + 1);
                return string;
            }
            string = name;
            return string;
        }

        @Override
        public String getDisplayInnerTypeName() {
            return this.displayInnerTypeName;
        }

        @Override
        public Icon getIcon() {
            return AbstractTypeFactoryProvider.getTypeIcon(this.access);
        }

        public List<Type> getInnerTypes() {
            if (this.innerTypes == null) {
                this.innerTypes = new ArrayList<Type>(this.classNode.innerClasses.size());
                for (InnerClassNode innerClassNode : this.classNode.innerClasses) {
                    Container.Entry innerEntry;
                    if ((innerClassNode.access & 0x1040) != 0 || !this.name.equals(innerClassNode.outerName) || (innerEntry = this.getEntry(innerClassNode.name)) == null) continue;
                    try {
                        InputStream is = innerEntry.getInputStream();
                        Throwable throwable = null;
                        try {
                            ClassReader classReader = new ClassReader(is);
                            this.innerTypes.add(new JavaType(innerEntry, classReader, innerClassNode.access));
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (is == null) continue;
                            if (throwable != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                }
                                continue;
                            }
                            is.close();
                        }
                    }
                    catch (IOException ignore) {}
                }
            }
            return this.innerTypes;
        }

        protected Container.Entry getEntry(String typeName) {
            String pathToFound = typeName + ".class";
            for (Container.Entry e : this.entry.getParent().getChildren()) {
                if (!e.getPath().equals(pathToFound)) continue;
                return e;
            }
            return null;
        }

        public List<Type.Field> getFields() {
            if (this.fields == null) {
                this.fields = new ArrayList<Type.Field>(this.classNode.fields.size());
                for (final FieldNode fieldNode : this.classNode.fields) {
                    if ((fieldNode.access & 0x5000) != 0) continue;
                    this.fields.add(new Type.Field(){

                        @Override
                        public int getFlags() {
                            return fieldNode.access;
                        }

                        @Override
                        public String getName() {
                            return fieldNode.name;
                        }

                        @Override
                        public String getDescriptor() {
                            return fieldNode.desc;
                        }

                        @Override
                        public Icon getIcon() {
                            return AbstractTypeFactoryProvider.getFieldIcon(fieldNode.access);
                        }

                        @Override
                        public String getDisplayName() {
                            StringBuffer sb = new StringBuffer();
                            sb.append(fieldNode.name).append(" : ");
                            AbstractTypeFactoryProvider.writeSignature(sb, fieldNode.desc, fieldNode.desc.length(), 0, false);
                            return sb.toString();
                        }
                    });
                }
            }
            return this.fields;
        }

        public List<Type.Method> getMethods() {
            if (this.methods == null) {
                this.methods = new ArrayList<Type.Method>(this.classNode.methods.size());
                for (final MethodNode methodNode : this.classNode.methods) {
                    if ((methodNode.access & 0x5040) != 0) continue;
                    this.methods.add(new Type.Method(){

                        @Override
                        public int getFlags() {
                            return methodNode.access;
                        }

                        @Override
                        public String getName() {
                            return methodNode.name;
                        }

                        @Override
                        public String getDescriptor() {
                            return methodNode.desc;
                        }

                        @Override
                        public Icon getIcon() {
                            return AbstractTypeFactoryProvider.getMethodIcon(methodNode.access);
                        }

                        @Override
                        public String getDisplayName() {
                            boolean isInnerClass;
                            String constructorName = JavaType.this.displayInnerTypeName;
                            boolean bl = isInnerClass = constructorName != null;
                            if (constructorName == null) {
                                constructorName = JavaType.this.getDisplayTypeName();
                            }
                            StringBuffer sb = new StringBuffer();
                            AbstractTypeFactoryProvider.writeMethodSignature(sb, JavaType.this.access, methodNode.access, isInnerClass, constructorName, methodNode.name, methodNode.desc);
                            return sb.toString();
                        }
                    });
                }
            }
            return this.methods;
        }
    }
}

