/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.xmpp;

import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.impl.protocol.xmpp.ChatRoom;
import org.jitsi.jicofo.ConferenceStore;
import org.jitsi.jicofo.TaskPools;
import org.jitsi.jicofo.conference.JitsiMeetConference;
import org.jitsi.jicofo.xmpp.AvModerationHandlerKt;
import org.jitsi.jicofo.xmpp.XmppProvider;
import org.jitsi.utils.MediaType;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.xmpp.extensions.jitsimeet.JsonMessageExtension;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.filter.MessageTypeFilter;
import org.jivesoftware.smack.packet.Stanza;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.impl.JidCreate;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0006\u0010\u0014\u001a\u00020\rR\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jitsi/jicofo/xmpp/AvModerationHandler;", "Lorg/jitsi/jicofo/xmpp/XmppProvider$Listener;", "Lorg/jivesoftware/smack/StanzaListener;", "xmppProvider", "Lorg/jitsi/jicofo/xmpp/XmppProvider;", "conferenceStore", "Lorg/jitsi/jicofo/ConferenceStore;", "(Lorg/jitsi/jicofo/xmpp/XmppProvider;Lorg/jitsi/jicofo/ConferenceStore;)V", "avModerationAddress", "Lorg/jxmpp/jid/DomainBareJid;", "logger", "Lorg/jitsi/utils/logging2/Logger;", "componentsChanged", "", "components", "", "Lorg/jitsi/jicofo/xmpp/XmppProvider$Component;", "processStanza", "stanza", "Lorg/jivesoftware/smack/packet/Stanza;", "shutdown", "jicofo"})
public final class AvModerationHandler
implements XmppProvider.Listener,
StanzaListener {
    @NotNull
    private final XmppProvider xmppProvider;
    @NotNull
    private final ConferenceStore conferenceStore;
    @Nullable
    private DomainBareJid avModerationAddress;
    @NotNull
    private final Logger logger;

    public AvModerationHandler(@NotNull XmppProvider xmppProvider, @NotNull ConferenceStore conferenceStore) {
        Intrinsics.checkNotNullParameter((Object)xmppProvider, (String)"xmppProvider");
        Intrinsics.checkNotNullParameter((Object)conferenceStore, (String)"conferenceStore");
        this.xmppProvider = xmppProvider;
        this.conferenceStore = conferenceStore;
        this.logger = LoggerExtensionsKt.createLogger$default((Object)this, null, null, (int)3, null);
        this.xmppProvider.getXmppConnection().addSyncStanzaListener((StanzaListener)this, MessageTypeFilter.NORMAL);
        this.xmppProvider.addListener((XmppProvider.Listener)this);
        this.registrationChanged(this.xmppProvider.getRegistered());
    }

    public void processStanza(@NotNull Stanza stanza) {
        Intrinsics.checkNotNullParameter((Object)stanza, (String)"stanza");
        if (!Intrinsics.areEqual((Object)stanza.getFrom(), (Object)this.avModerationAddress)) {
            return;
        }
        JsonMessageExtension jsonMessageExtension = (JsonMessageExtension)stanza.getExtension(JsonMessageExtension.class);
        if (jsonMessageExtension == null) {
            Unit unit;
            Unit it = unit = Unit.INSTANCE;
            boolean bl = false;
            this.logger.warn((Object)"Skip processing stanza without JsonMessageExtension");
            return;
        }
        JsonMessageExtension jsonMessage = jsonMessageExtension;
        TaskPools.Companion.getIoPool().execute(() -> AvModerationHandler.processStanza$lambda-2(jsonMessage, this, stanza));
    }

    public void componentsChanged(@NotNull Set<XmppProvider.Component> components) {
        DomainBareJid domainBareJid;
        String address;
        Object v0;
        block3: {
            Intrinsics.checkNotNullParameter(components, (String)"components");
            Iterable iterable = components;
            for (Object t : iterable) {
                XmppProvider.Component it = (XmppProvider.Component)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getType(), (Object)"av_moderation")) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        XmppProvider.Component component = v0;
        String string = address = component != null ? component.getAddress() : null;
        if (address == null) {
            this.logger.info((Object)"No av_moderation component discovered.");
            domainBareJid = null;
        } else {
            this.logger.info((Object)("Using av_moderation component at " + address + "."));
            domainBareJid = JidCreate.domainBareFrom((String)address);
        }
        this.avModerationAddress = domainBareJid;
    }

    public final void shutdown() {
        this.xmppProvider.getXmppConnection().removeSyncStanzaListener((StanzaListener)this);
    }

    public void registrationChanged(boolean registered) {
        XmppProvider.Listener.DefaultImpls.registrationChanged((XmppProvider.Listener)this, (boolean)registered);
    }

    private static final void processStanza$lambda-2(JsonMessageExtension $jsonMessage, AvModerationHandler this$0, Stanza $stanza) {
        Intrinsics.checkNotNullParameter((Object)$jsonMessage, (String)"$jsonMessage");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$stanza, (String)"$stanza");
        try {
            Object object = new JSONParser().parse($jsonMessage.getJson());
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.json.simple.JSONObject");
            }
            JSONObject incomingJson = (JSONObject)object;
            if (Intrinsics.areEqual((Object)incomingJson.get((Object)"type"), (Object)"av_moderation")) {
                Object object2 = incomingJson.get((Object)"room");
                EntityBareJid conferenceJid = JidCreate.entityBareFrom((String)(object2 != null ? object2.toString() : null));
                ConferenceStore conferenceStore = this$0.conferenceStore;
                Intrinsics.checkNotNullExpressionValue((Object)conferenceJid, (String)"conferenceJid");
                JitsiMeetConference jitsiMeetConference = conferenceStore.getConference(conferenceJid);
                if (jitsiMeetConference == null) {
                    throw new IllegalStateException("Conference " + conferenceJid + " does not exist.");
                }
                JitsiMeetConference conference = jitsiMeetConference;
                ChatRoom chatRoom = conference.getChatRoom();
                if (chatRoom == null) {
                    throw new IllegalStateException("Conference has no associated chatRoom.");
                }
                ChatRoom chatRoom2 = chatRoom;
                Boolean enabled2 = (Boolean)incomingJson.get((Object)"enabled");
                if (enabled2 != null) {
                    Object object3 = incomingJson.get((Object)"mediaType");
                    if (object3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    MediaType mediaType = MediaType.parseString((String)((String)object3));
                    boolean oldEnabledValue = chatRoom2.isAvModerationEnabled(mediaType);
                    chatRoom2.setAvModerationEnabled(mediaType, enabled2.booleanValue());
                    if (!Intrinsics.areEqual((Object)oldEnabledValue, (Object)enabled2) && enabled2.booleanValue()) {
                        this$0.logger.info((Object)("Moderation for " + mediaType + " in " + conferenceJid + " was enabled by " + incomingJson.get((Object)"actor")));
                        conference.muteAllParticipants(mediaType);
                    }
                } else {
                    Object object4 = incomingJson.get((Object)"whitelists");
                    if (object4 != null) {
                        Object it = object4;
                        boolean bl = false;
                        chatRoom2.updateAvModerationWhitelists(AvModerationHandlerKt.access$parseAsMapOfStringToListOfString(it));
                    }
                }
            }
        }
        catch (Exception e) {
            this$0.logger.warn((Object)("Failed to process av_moderation request from " + $stanza.getFrom()), (Throwable)e);
        }
    }
}

