/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.xmpp;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.impl.protocol.xmpp.ChatRoom;
import org.jitsi.jicofo.FocusManager;
import org.jitsi.jicofo.TaskPools;
import org.jitsi.jicofo.auth.AuthenticationAuthority;
import org.jitsi.jicofo.auth.ErrorFactory;
import org.jitsi.jicofo.conference.JitsiMeetConference;
import org.jitsi.jicofo.conference.JitsiMeetConferenceImpl;
import org.jitsi.jicofo.visitors.VisitorsConfig;
import org.jitsi.jicofo.xmpp.UtilKt;
import org.jitsi.jicofo.xmpp.XmppConfig;
import org.jitsi.jicofo.xmpp.XmppProvider;
import org.jitsi.jicofo.xmpp.XmppVisitorConnectionConfig;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.xmpp.extensions.jitsimeet.ConferenceIq;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.iqrequest.AbstractIqRequestHandler;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.ErrorIQ;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaError;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B7\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\u0006\u0010\r\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"H\u0016J\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'J\u0014\u0010(\u001a\u0004\u0018\u00010%2\b\u0010)\u001a\u0004\u0018\u00010%H\u0016J,\u0010*\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020'2\u0006\u0010+\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010'2\u0006\u0010.\u001a\u00020\nH\u0002R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0019R\u0011\u0010\r\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006/"}, d2={"Lorg/jitsi/jicofo/xmpp/ConferenceIqHandler;", "Lorg/jitsi/jicofo/xmpp/XmppProvider$Listener;", "Lorg/jivesoftware/smack/iqrequest/AbstractIqRequestHandler;", "xmppProvider", "Lorg/jitsi/jicofo/xmpp/XmppProvider;", "focusManager", "Lorg/jitsi/jicofo/FocusManager;", "focusAuthJid", "", "isFocusAnonymous", "", "authAuthority", "Lorg/jitsi/jicofo/auth/AuthenticationAuthority;", "jigasiEnabled", "(Lorg/jitsi/jicofo/xmpp/XmppProvider;Lorg/jitsi/jicofo/FocusManager;Ljava/lang/String;ZLorg/jitsi/jicofo/auth/AuthenticationAuthority;Z)V", "getAuthAuthority", "()Lorg/jitsi/jicofo/auth/AuthenticationAuthority;", "breakoutAddress", "Lorg/jxmpp/jid/DomainBareJid;", "connection", "Lorg/jivesoftware/smack/AbstractXMPPConnection;", "getFocusAuthJid", "()Ljava/lang/String;", "getFocusManager", "()Lorg/jitsi/jicofo/FocusManager;", "()Z", "getJigasiEnabled", "logger", "Lorg/jitsi/utils/logging2/Logger;", "getXmppProvider", "()Lorg/jitsi/jicofo/xmpp/XmppProvider;", "componentsChanged", "", "components", "", "Lorg/jitsi/jicofo/xmpp/XmppProvider$Component;", "handleConferenceIq", "Lorg/jivesoftware/smack/packet/IQ;", "query", "Lorg/jitsi/xmpp/extensions/jitsimeet/ConferenceIq;", "handleIQRequest", "iqRequest", "processExtensions", "room", "Lorg/jxmpp/jid/EntityBareJid;", "response", "roomExists", "jicofo"})
public final class ConferenceIqHandler
extends AbstractIqRequestHandler
implements XmppProvider.Listener {
    @NotNull
    private final XmppProvider xmppProvider;
    @NotNull
    private final FocusManager focusManager;
    @NotNull
    private final String focusAuthJid;
    private final boolean isFocusAnonymous;
    @Nullable
    private final AuthenticationAuthority authAuthority;
    private final boolean jigasiEnabled;
    @NotNull
    private final AbstractXMPPConnection connection;
    @Nullable
    private DomainBareJid breakoutAddress;
    @NotNull
    private final Logger logger;

    public ConferenceIqHandler(@NotNull XmppProvider xmppProvider, @NotNull FocusManager focusManager, @NotNull String focusAuthJid, boolean isFocusAnonymous, @Nullable AuthenticationAuthority authAuthority, boolean jigasiEnabled) {
        Intrinsics.checkNotNullParameter((Object)xmppProvider, (String)"xmppProvider");
        Intrinsics.checkNotNullParameter((Object)focusManager, (String)"focusManager");
        Intrinsics.checkNotNullParameter((Object)focusAuthJid, (String)"focusAuthJid");
        super("conference", "http://jitsi.org/protocol/focus", IQ.Type.set, IQRequestHandler.Mode.sync);
        this.xmppProvider = xmppProvider;
        this.focusManager = focusManager;
        this.focusAuthJid = focusAuthJid;
        this.isFocusAnonymous = isFocusAnonymous;
        this.authAuthority = authAuthority;
        this.jigasiEnabled = jigasiEnabled;
        this.connection = this.xmppProvider.getXmppConnection();
        this.logger = LoggerExtensionsKt.createLogger$default((Object)((Object)this), null, null, (int)3, null);
        this.xmppProvider.addListener((XmppProvider.Listener)this);
        this.registrationChanged(this.xmppProvider.getRegistered());
    }

    @NotNull
    public final XmppProvider getXmppProvider() {
        return this.xmppProvider;
    }

    @NotNull
    public final FocusManager getFocusManager() {
        return this.focusManager;
    }

    @NotNull
    public final String getFocusAuthJid() {
        return this.focusAuthJid;
    }

    public final boolean isFocusAnonymous() {
        return this.isFocusAnonymous;
    }

    @Nullable
    public final AuthenticationAuthority getAuthAuthority() {
        return this.authAuthority;
    }

    public final boolean getJigasiEnabled() {
        return this.jigasiEnabled;
    }

    @NotNull
    public final IQ handleConferenceIq(@NotNull ConferenceIq query) {
        Unit unit;
        Object object;
        String vnode;
        String string;
        boolean visitorRequested;
        JitsiMeetConferenceImpl conference;
        ConferenceIq response;
        EntityBareJid room;
        block14: {
            boolean bl;
            ConferenceIq conferenceIq;
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            EntityBareJid entityBareJid = query.getRoom();
            if (entityBareJid == null) {
                ErrorIQ errorIQ = IQ.createErrorResponse((IQ)((IQ)query), (StanzaError)StanzaError.from((StanzaError.Condition)StanzaError.Condition.bad_request, (String)"No 'room' specified.").build());
                Intrinsics.checkNotNullExpressionValue((Object)errorIQ, (String)"createErrorResponse(\n   \u2026fied.\").build()\n        )");
                return (IQ)errorIQ;
            }
            room = entityBareJid;
            ConferenceIq $this$handleConferenceIq_u24lambda_u2d0 = conferenceIq = new ConferenceIq();
            boolean bl2 = false;
            $this$handleConferenceIq_u24lambda_u2d0.setType(IQ.Type.result);
            $this$handleConferenceIq_u24lambda_u2d0.setStanzaId(query.getStanzaId());
            $this$handleConferenceIq_u24lambda_u2d0.setFrom(query.getTo());
            $this$handleConferenceIq_u24lambda_u2d0.setTo(query.getFrom());
            $this$handleConferenceIq_u24lambda_u2d0.setRoom(query.getRoom());
            $this$handleConferenceIq_u24lambda_u2d0.setFocusJid(this.focusAuthJid);
            response = conferenceIq;
            this.logger.info((Object)("Focus request for room: " + room));
            conference = this.focusManager.getConference(room);
            boolean roomExists = conference != null;
            IQ error = this.processExtensions(query, room, response, roomExists);
            if (error != null) {
                return error;
            }
            List list = query.getProperties();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"query.properties");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ConferenceIq.Property it = (ConferenceIq.Property)element$iv;
                    boolean bl3 = false;
                    if (!(Intrinsics.areEqual((Object)it.getName(), (Object)"visitor") && Intrinsics.areEqual((Object)it.getValue(), (Object)"true"))) continue;
                    bl = true;
                    break block14;
                }
                bl = visitorRequested = false;
            }
        }
        if (VisitorsConfig.config.getEnabled()) {
            JitsiMeetConferenceImpl jitsiMeetConferenceImpl = conference;
            string = jitsiMeetConferenceImpl != null ? jitsiMeetConferenceImpl.redirectVisitor(visitorRequested) : null;
        } else {
            string = vnode = null;
        }
        if ((object = (XmppVisitorConnectionConfig)XmppConfig.Companion.getVisitors().get(vnode)) != null && (object = object.getJid()) != null) {
            Object it = object;
            boolean bl = false;
            response.setVnode(vnode);
            response.setFocusJid((String)it);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            ConferenceIqHandler $this$handleConferenceIq_u24lambda_u2d3 = this;
            boolean bl = false;
            $this$handleConferenceIq_u24lambda_u2d3.logger.error((Object)("No XmppConnectionConfig for vnode=" + vnode));
        }
        Map map = query.getPropertiesMap();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"query.propertiesMap");
        boolean ready = FocusManager.conferenceRequest$default(this.focusManager, room, map, null, false, 12, null);
        if (!this.isFocusAnonymous && this.authAuthority == null) {
            ready = true;
        }
        response.setReady(Boolean.valueOf(ready));
        if (this.authAuthority != null) {
            response.addProperty(new ConferenceIq.Property("authentication", "true"));
            response.addProperty(new ConferenceIq.Property("externalAuth", String.valueOf(this.authAuthority.isExternal())));
        } else {
            response.addProperty(new ConferenceIq.Property("authentication", "false"));
        }
        if (this.jigasiEnabled) {
            response.addProperty(new ConferenceIq.Property("sipGatewayEnabled", "true"));
        }
        return (IQ)response;
    }

    private final IQ processExtensions(ConferenceIq query, EntityBareJid room, ConferenceIq response, boolean roomExists) {
        boolean isBreakoutRoom;
        boolean bl = isBreakoutRoom = this.breakoutAddress != null && Intrinsics.areEqual((Object)room.getDomain(), (Object)this.breakoutAddress);
        if (!isBreakoutRoom && this.authAuthority != null) {
            IQ authErrorOrResponse = this.authAuthority.processAuthentication(query, response);
            if (authErrorOrResponse != null) {
                return authErrorOrResponse;
            }
            if (!roomExists) {
                boolean breakoutRoomExists;
                block9: {
                    boolean bl2;
                    Iterable $this$any$iv = this.focusManager.getConferences();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            boolean bl3;
                            JitsiMeetConference conference = (JitsiMeetConference)element$iv;
                            boolean bl4 = false;
                            if (conference.getChatRoom() != null) {
                                ChatRoom it;
                                boolean bl5 = false;
                                bl3 = it.isBreakoutRoom() && Intrinsics.areEqual((Object)room.toString(), (Object)it.getMainRoom());
                            } else {
                                bl3 = false;
                            }
                            if (!bl3) continue;
                            bl2 = true;
                            break block9;
                        }
                        bl2 = breakoutRoomExists = false;
                    }
                }
                if (!breakoutRoomExists && this.authAuthority.getUserIdentity(query.getFrom()) == null) {
                    return ErrorFactory.createNotAuthorizedError((IQ)query, "not authorized user domain");
                }
            }
        }
        return null;
    }

    @Nullable
    public IQ handleIQRequest(@Nullable IQ iqRequest) {
        if (!(iqRequest instanceof ConferenceIq)) {
            ErrorIQ errorIQ;
            ErrorIQ it = errorIQ = IQ.createErrorResponse((IQ)iqRequest, (StanzaError)StanzaError.getBuilder((StanzaError.Condition)StanzaError.Condition.internal_server_error).build());
            boolean bl = false;
            this.logger.error((Object)("Received an unexpected IQ type: " + iqRequest));
            return (IQ)errorIQ;
        }
        Jid originalFrom = ((ConferenceIq)iqRequest).getFrom();
        ConferenceIq conferenceIq = (ConferenceIq)iqRequest;
        DomainBareJid domainBareJid = XmppConfig.client.getClientProxy();
        Intrinsics.checkNotNullExpressionValue((Object)originalFrom, (String)"originalFrom");
        conferenceIq.setFrom(UtilKt.parseJidFromClientProxyJid((DomainBareJid)domainBareJid, (Jid)originalFrom));
        TaskPools.Companion.getIoPool().execute(() -> ConferenceIqHandler.handleIQRequest$lambda-8(this, iqRequest, originalFrom));
        return null;
    }

    public void componentsChanged(@NotNull Set<XmppProvider.Component> components) {
        DomainBareJid domainBareJid;
        String address;
        Object v0;
        block3: {
            Intrinsics.checkNotNullParameter(components, (String)"components");
            Iterable iterable = components;
            for (Object t : iterable) {
                XmppProvider.Component it = (XmppProvider.Component)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getType(), (Object)"breakout_rooms")) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        XmppProvider.Component component = v0;
        String string = address = component != null ? component.getAddress() : null;
        if (address == null) {
            this.logger.info((Object)"No breakout room component discovered.");
            domainBareJid = null;
        } else {
            this.logger.info((Object)("Using breakout room component at " + address + "."));
            domainBareJid = JidCreate.domainBareFrom((String)address);
        }
        this.breakoutAddress = domainBareJid;
    }

    public void registrationChanged(boolean registered) {
        XmppProvider.Listener.DefaultImpls.registrationChanged((XmppProvider.Listener)this, (boolean)registered);
    }

    private static final void handleIQRequest$lambda-8(ConferenceIqHandler this$0, IQ $iqRequest, Jid $originalFrom) {
        IQ iQ;
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        IQ $this$handleIQRequest_u24lambda_u2d8_u24lambda_u2d7 = iQ = this$0.handleConferenceIq((ConferenceIq)$iqRequest);
        boolean bl = false;
        $this$handleIQRequest_u24lambda_u2d8_u24lambda_u2d7.setTo($originalFrom);
        IQ response = iQ;
        try {
            this$0.connection.sendStanza((Stanza)response);
        }
        catch (Exception e) {
            this$0.logger.error((Object)"Failed to send response", (Throwable)e);
        }
    }
}

