/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.coin;

import java.io.IOException;
import org.jitsi.xmpp.extensions.AbstractPacketExtension;
import org.jitsi.xmpp.extensions.DefaultPacketExtensionProvider;
import org.jitsi.xmpp.extensions.coin.CallInfoPacketExtension;
import org.jitsi.xmpp.extensions.coin.CoinIQProvider;
import org.jitsi.xmpp.extensions.coin.DisconnectionType;
import org.jitsi.xmpp.extensions.coin.EndpointPacketExtension;
import org.jitsi.xmpp.extensions.coin.EndpointStatusType;
import org.jitsi.xmpp.extensions.coin.JoiningType;
import org.jitsi.xmpp.extensions.coin.MediaPacketExtension;
import org.jitsi.xmpp.extensions.coin.MediaProvider;
import org.jitsi.xmpp.extensions.coin.StateType;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;

public class EndpointProvider
extends ExtensionElementProvider<EndpointPacketExtension> {
    public EndpointPacketExtension parse(XmlPullParser parser, int depth, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException {
        boolean done = false;
        String entity = parser.getAttributeValue("", "entity");
        StateType state = StateType.full;
        String stateStr = parser.getAttributeValue("", "state");
        if (stateStr != null) {
            state = StateType.parseString(stateStr);
        }
        EndpointPacketExtension ext = new EndpointPacketExtension(entity);
        ext.setAttribute("state", (Object)state);
        while (!done) {
            XmlPullParser.Event eventType = parser.next();
            String elementName = parser.getName();
            if (eventType == XmlPullParser.Event.START_ELEMENT) {
                switch (elementName) {
                    case "display-text": {
                        ext.setDisplayText(CoinIQProvider.parseText(parser));
                        break;
                    }
                    case "disconnection-method": {
                        ext.setDisconnectionType(DisconnectionType.parseString(parser.getText()));
                        break;
                    }
                    case "joining-method": {
                        ext.setJoiningType(JoiningType.parseString(CoinIQProvider.parseText(parser)));
                        break;
                    }
                    case "status": {
                        ext.setStatus(EndpointStatusType.parseString(CoinIQProvider.parseText(parser)));
                        break;
                    }
                    case "call-info": {
                        ExtensionElementProvider provider = new DefaultPacketExtensionProvider<CallInfoPacketExtension>(CallInfoPacketExtension.class);
                        AbstractPacketExtension childExtension = (CallInfoPacketExtension)provider.parse(parser);
                        ext.addChildExtension(childExtension);
                        break;
                    }
                    case "media": {
                        ExtensionElementProvider provider = new MediaProvider();
                        AbstractPacketExtension childExtension = (MediaPacketExtension)provider.parse(parser);
                        ext.addChildExtension(childExtension);
                        break;
                    }
                }
                continue;
            }
            if (eventType != XmlPullParser.Event.END_ELEMENT || !parser.getName().equals("endpoint")) continue;
            done = true;
        }
        return ext;
    }
}

