/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.privacy.provider;

import java.io.IOException;
import java.util.ArrayList;
import org.jivesoftware.smack.datatypes.UInt32;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.privacy.packet.Privacy;
import org.jivesoftware.smackx.privacy.packet.PrivacyItem;

public class PrivacyProvider
extends IQProvider<Privacy> {
    public Privacy parse(XmlPullParser parser, int initialDepth, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException {
        Privacy privacy = new Privacy();
        boolean done = false;
        while (!done) {
            XmlPullParser.Event eventType = parser.next();
            if (eventType == XmlPullParser.Event.START_ELEMENT) {
                if (parser.getName().equals("active")) {
                    String activeName = parser.getAttributeValue("", "name");
                    if (activeName == null) {
                        privacy.setDeclineActiveList(true);
                        continue;
                    }
                    privacy.setActiveName(activeName);
                    continue;
                }
                if (parser.getName().equals("default")) {
                    String defaultName = parser.getAttributeValue("", "name");
                    if (defaultName == null) {
                        privacy.setDeclineDefaultList(true);
                        continue;
                    }
                    privacy.setDefaultName(defaultName);
                    continue;
                }
                if (!parser.getName().equals("list")) continue;
                PrivacyProvider.parseList(parser, privacy);
                continue;
            }
            if (eventType != XmlPullParser.Event.END_ELEMENT || !parser.getName().equals("query")) continue;
            done = true;
        }
        return privacy;
    }

    private static void parseList(XmlPullParser parser, Privacy privacy) throws XmlPullParserException, IOException {
        boolean done = false;
        String listName = parser.getAttributeValue("", "name");
        ArrayList<PrivacyItem> items = new ArrayList<PrivacyItem>();
        while (!done) {
            XmlPullParser.Event eventType = parser.next();
            if (eventType == XmlPullParser.Event.START_ELEMENT) {
                if (!parser.getName().equals("item")) continue;
                items.add(PrivacyProvider.parseItem(parser));
                continue;
            }
            if (eventType != XmlPullParser.Event.END_ELEMENT || !parser.getName().equals("list")) continue;
            done = true;
        }
        privacy.setPrivacyList(listName, items);
    }

    private static PrivacyItem parseItem(XmlPullParser parser) throws XmlPullParserException, IOException {
        PrivacyItem item;
        boolean allow;
        String actionValue = parser.getAttributeValue("", "action");
        UInt32 order = ParserUtils.getUInt32Attribute((XmlPullParser)parser, (String)"order");
        String type = parser.getAttributeValue("", "type");
        switch (actionValue) {
            case "allow": {
                allow = true;
                break;
            }
            case "deny": {
                allow = false;
                break;
            }
            default: {
                throw new IOException("Unknown action value '" + actionValue + "'");
            }
        }
        if (type != null) {
            String value = parser.getAttributeValue("", "value");
            item = new PrivacyItem(PrivacyItem.Type.valueOf(type), value, allow, order);
        } else {
            item = new PrivacyItem(allow, order);
        }
        PrivacyProvider.parseItemChildElements(parser, item);
        return item;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void parseItemChildElements(XmlPullParser parser, PrivacyItem privacyItem) throws XmlPullParserException, IOException {
        int initialDepth = parser.getDepth();
        while (true) {
            XmlPullParser.Event eventType = parser.next();
            block0 : switch (eventType) {
                case START_ELEMENT: {
                    String name;
                    switch (name = parser.getName()) {
                        case "iq": {
                            privacyItem.setFilterIQ(true);
                            break block0;
                        }
                        case "message": {
                            privacyItem.setFilterMessage(true);
                            break block0;
                        }
                        case "presence-in": {
                            privacyItem.setFilterPresenceIn(true);
                            break block0;
                        }
                        case "presence-out": {
                            privacyItem.setFilterPresenceOut(true);
                            break block0;
                        }
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (parser.getDepth() != initialDepth) break;
                    return;
                }
            }
        }
    }
}

