/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pubsub;

import java.util.Collections;
import java.util.List;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smackx.pubsub.NodeExtension;
import org.jivesoftware.smackx.pubsub.PubSubElementType;
import org.jivesoftware.smackx.pubsub.Subscription;

public class SubscriptionsExtension
extends NodeExtension {
    protected List<Subscription> items = Collections.emptyList();

    public SubscriptionsExtension(List<Subscription> subList) {
        this(SubscriptionsNamespace.basic, null, subList);
    }

    public SubscriptionsExtension(String nodeId, List<Subscription> subList) {
        this(SubscriptionsNamespace.basic, nodeId, subList);
    }

    public SubscriptionsExtension(SubscriptionsNamespace subscriptionsNamespace, String nodeId, List<Subscription> subList) {
        super(subscriptionsNamespace.type, nodeId);
        if (subList != null) {
            this.items = subList;
        }
    }

    public List<Subscription> getSubscriptions() {
        return this.items;
    }

    @Override
    protected void addXml(XmlStringBuilder xml) {
        if (this.items == null || this.items.size() == 0) {
            xml.closeEmptyElement();
            return;
        }
        xml.rightAngleBracket();
        xml.append(this.items);
        xml.closeElement((NamedElement)this);
    }

    public static enum SubscriptionsNamespace {
        basic(PubSubElementType.SUBSCRIPTIONS),
        owner(PubSubElementType.SUBSCRIPTIONS_OWNER);

        public final PubSubElementType type;

        private SubscriptionsNamespace(PubSubElementType type) {
            this.type = type;
        }

        public static SubscriptionsNamespace fromXmlns(String xmlns) {
            for (SubscriptionsNamespace subscriptionsNamespace : SubscriptionsNamespace.values()) {
                if (!subscriptionsNamespace.type.getNamespace().getXmlns().equals(xmlns)) continue;
                return subscriptionsNamespace;
            }
            throw new IllegalArgumentException("Invalid Subscription namespace: " + xmlns);
        }
    }
}

