/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.rest;

import jakarta.servlet.DispatcherType;
import java.io.File;
import java.nio.file.Paths;
import java.util.EnumSet;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.rest.JettyBundleActivatorConfig;
import org.jitsi.utils.JavaVersion;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a$\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\b\b\u0002\u0010\n\u001a\u00020\u000b\u001aB\u0010\f\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\t2\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\t2\b\b\u0002\u0010\u000f\u001a\u00020\u000b2\b\b\u0002\u0010\n\u001a\u00020\u000b\u001a\u000e\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012\u001a\b\u0010\u0013\u001a\u00020\u000bH\u0002\u001a\u001a\u0010\u0014\u001a\u00020\u0015*\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\t\u001a\u0014\u0010\u0019\u001a\u00020\u0015*\u00020\u00012\b\b\u0002\u0010\u0018\u001a\u00020\t\u001a\n\u0010\u001a\u001a\u00020\u000b*\u00020\u0012\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u001b"}, d2={"servletContextHandler", "Lorg/eclipse/jetty/servlet/ServletContextHandler;", "Lorg/eclipse/jetty/server/Server;", "getServletContextHandler", "(Lorg/eclipse/jetty/server/Server;)Lorg/eclipse/jetty/servlet/ServletContextHandler;", "createJettyServer", "port", "", "host", "", "sendServerVersion", "", "createSecureJettyServer", "keyStorePath", "keyStorePassword", "needClientAuth", "createServer", "config", "Lorg/jitsi/rest/JettyBundleActivatorConfig;", "supportsTls13", "addServlet", "", "servlet", "Lorg/eclipse/jetty/servlet/ServletHolder;", "pathSpec", "enableCors", "isEnabled", "jicoco"})
@JvmName(name="JettyHelpers")
public final class JettyHelpers {
    @NotNull
    public static final Server createJettyServer(int port2, @Nullable String host, boolean sendServerVersion2) {
        HttpConfiguration httpConfiguration;
        HttpConfiguration $this$createJettyServer_u24lambda_u2d1 = httpConfiguration = new HttpConfiguration();
        boolean bl = false;
        $this$createJettyServer_u24lambda_u2d1.setSendServerVersion(sendServerVersion2);
        $this$createJettyServer_u24lambda_u2d1.addCustomizer(JettyHelpers::createJettyServer$lambda-1$lambda-0);
        HttpConfiguration config = httpConfiguration;
        HttpConfiguration $this$createJettyServer_u24lambda_u2d2 = $this$createJettyServer_u24lambda_u2d1 = new Server();
        boolean bl2 = false;
        $this$createJettyServer_u24lambda_u2d2.setHandler((Handler)new ServletContextHandler());
        HttpConfiguration server = $this$createJettyServer_u24lambda_u2d1;
        ServerConnector serverConnector = new ServerConnector[]{(ConnectionFactory)new HttpConnectionFactory(config)};
        ServerConnector $this$createJettyServer_u24lambda_u2d3 = serverConnector = new ServerConnector((Server)server, (ConnectionFactory[])serverConnector);
        boolean bl3 = false;
        $this$createJettyServer_u24lambda_u2d3.setPort(port2);
        $this$createJettyServer_u24lambda_u2d3.setHost(host);
        ServerConnector connector = serverConnector;
        server.addConnector((Connector)connector);
        return server;
    }

    public static /* synthetic */ Server createJettyServer$default(int n, String string, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string = null;
        }
        if ((n2 & 4) != 0) {
            bl = true;
        }
        return JettyHelpers.createJettyServer(n, string, bl);
    }

    @NotNull
    public static final Server createSecureJettyServer(int port2, @NotNull String keyStorePath, @Nullable String host, @Nullable String keyStorePassword, boolean needClientAuth2, boolean sendServerVersion2) {
        String[] stringArray;
        SslContextFactory.Server server;
        Intrinsics.checkNotNullParameter((Object)keyStorePath, (String)"keyStorePath");
        File sslContextFactoryKeyStoreFile = Paths.get(keyStorePath, new String[0]).toFile();
        SslContextFactory.Server $this$createSecureJettyServer_u24lambda_u2d4 = server = new SslContextFactory.Server();
        boolean bl = false;
        if (JettyHelpers.supportsTls13()) {
            stringArray = new String[]{"TLSv1.2", "TLSv1.3"};
            $this$createSecureJettyServer_u24lambda_u2d4.setIncludeProtocols(stringArray);
        } else {
            stringArray = new String[]{"TLSv1.2"};
            $this$createSecureJettyServer_u24lambda_u2d4.setIncludeProtocols(stringArray);
        }
        stringArray = new String[]{"TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256", "TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256", "TLS_DHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_DHE_RSA_WITH_AES_128_GCM_SHA256"};
        $this$createSecureJettyServer_u24lambda_u2d4.setIncludeCipherSuites(stringArray);
        $this$createSecureJettyServer_u24lambda_u2d4.setRenegotiationAllowed(false);
        if (keyStorePassword != null) {
            $this$createSecureJettyServer_u24lambda_u2d4.setKeyStorePassword(keyStorePassword);
        }
        $this$createSecureJettyServer_u24lambda_u2d4.setKeyStorePath(sslContextFactoryKeyStoreFile.getPath());
        $this$createSecureJettyServer_u24lambda_u2d4.setNeedClientAuth(needClientAuth2);
        SslContextFactory.Server sslContextFactory = server;
        SslContextFactory.Server $this$createSecureJettyServer_u24lambda_u2d5 = $this$createSecureJettyServer_u24lambda_u2d4 = new HttpConfiguration();
        boolean bl2 = false;
        $this$createSecureJettyServer_u24lambda_u2d5.setSecurePort(port2);
        $this$createSecureJettyServer_u24lambda_u2d5.setSecureScheme("https");
        $this$createSecureJettyServer_u24lambda_u2d5.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        $this$createSecureJettyServer_u24lambda_u2d5.setSendServerVersion(sendServerVersion2);
        SslContextFactory.Server config = $this$createSecureJettyServer_u24lambda_u2d4;
        SslContextFactory.Server $this$createSecureJettyServer_u24lambda_u2d6 = $this$createSecureJettyServer_u24lambda_u2d5 = new Server();
        boolean bl3 = false;
        $this$createSecureJettyServer_u24lambda_u2d6.setHandler((Handler)new ServletContextHandler());
        SslContextFactory.Server server2 = $this$createSecureJettyServer_u24lambda_u2d5;
        ServerConnector serverConnector = new ServerConnector[]{(ConnectionFactory)new SslConnectionFactory(sslContextFactory, "http/1.1"), (ConnectionFactory)new HttpConnectionFactory((HttpConfiguration)config)};
        ServerConnector $this$createSecureJettyServer_u24lambda_u2d7 = serverConnector = new ServerConnector((Server)server2, (ConnectionFactory[])serverConnector);
        boolean bl4 = false;
        $this$createSecureJettyServer_u24lambda_u2d7.setHost(host);
        $this$createSecureJettyServer_u24lambda_u2d7.setPort(port2);
        ServerConnector connector = serverConnector;
        server2.addConnector((Connector)connector);
        return server2;
    }

    public static /* synthetic */ Server createSecureJettyServer$default(int n, String string, String string2, String string3, boolean bl, boolean bl2, int n2, Object object) {
        if ((n2 & 4) != 0) {
            string2 = null;
        }
        if ((n2 & 8) != 0) {
            string3 = null;
        }
        if ((n2 & 0x10) != 0) {
            bl = false;
        }
        if ((n2 & 0x20) != 0) {
            bl2 = true;
        }
        return JettyHelpers.createSecureJettyServer(n, string, string2, string3, bl, bl2);
    }

    @NotNull
    public static final Server createServer(@NotNull JettyBundleActivatorConfig config) {
        Server server;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        if (config.isTls()) {
            int n = config.getTlsPort();
            String string = config.getKeyStorePath();
            Intrinsics.checkNotNull((Object)string);
            server = JettyHelpers.createSecureJettyServer(n, string, config.getHost(), config.getKeyStorePassword(), config.getNeedClientAuth(), config.getSendServerVersion());
        } else {
            server = JettyHelpers.createJettyServer(config.getPort(), config.getHost(), config.getSendServerVersion());
        }
        return server;
    }

    public static final boolean isEnabled(@NotNull JettyBundleActivatorConfig $this$isEnabled) {
        Intrinsics.checkNotNullParameter((Object)$this$isEnabled, (String)"<this>");
        return $this$isEnabled.getPort() != -1 || $this$isEnabled.getTlsPort() != -1;
    }

    @NotNull
    public static final ServletContextHandler getServletContextHandler(@NotNull Server $this$servletContextHandler) {
        Intrinsics.checkNotNullParameter((Object)$this$servletContextHandler, (String)"<this>");
        Handler handler = $this$servletContextHandler.getHandler();
        if (handler == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.eclipse.jetty.servlet.ServletContextHandler");
        }
        return (ServletContextHandler)handler;
    }

    public static final void enableCors(@NotNull ServletContextHandler $this$enableCors, @NotNull String pathSpec) {
        FilterHolder filterHolder;
        Intrinsics.checkNotNullParameter((Object)$this$enableCors, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)pathSpec, (String)"pathSpec");
        FilterHolder $this$enableCors_u24lambda_u2d8 = filterHolder = $this$enableCors.addFilter(CrossOriginFilter.class, pathSpec, EnumSet.of((Enum)DispatcherType.REQUEST));
        boolean bl = false;
        $this$enableCors_u24lambda_u2d8.setInitParameter("allowedOrigins", "*");
        $this$enableCors_u24lambda_u2d8.setInitParameter("Access-Control-Allow-Origin", "*");
        $this$enableCors_u24lambda_u2d8.setInitParameter("allowedMethods", "GET,POST");
        $this$enableCors_u24lambda_u2d8.setInitParameter("allowedHeaders", "X-Requested-With,Content-Type,Accept,Origin");
    }

    public static /* synthetic */ void enableCors$default(ServletContextHandler servletContextHandler, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "/*";
        }
        JettyHelpers.enableCors(servletContextHandler, string);
    }

    public static final void addServlet(@NotNull Server $this$addServlet, @NotNull ServletHolder servlet, @NotNull String pathSpec) {
        Intrinsics.checkNotNullParameter((Object)$this$addServlet, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)servlet, (String)"servlet");
        Intrinsics.checkNotNullParameter((Object)pathSpec, (String)"pathSpec");
        JettyHelpers.getServletContextHandler($this$addServlet).addServlet(servlet, pathSpec);
    }

    private static final boolean supportsTls13() {
        boolean bl;
        try {
            bl = JavaVersion.getJavaVersion() >= 11;
        }
        catch (Throwable t) {
            bl = false;
        }
        return bl;
    }

    private static final void createJettyServer$lambda-1$lambda-0(Connector connector, HttpConfiguration httpConfiguration, Request request) {
        if (StringsKt.equals((String)request.getMethod(), (String)"TRACE", (boolean)true)) {
            request.setHandled(true);
            request.getResponse().setStatus(405);
        }
    }
}

