/*
 * Decompiled with CFR 0.152.
 */
package free.util.audio;

import free.util.BlockingQueue;
import free.util.IOUtilities;
import free.util.PlatformUtils;
import free.util.audio.AudioClip;
import free.util.audio.AudioPlayer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public abstract class JavaxSampledAudioPlayer
implements Runnable,
AudioPlayer {
    private Thread playerThread = null;
    protected final BlockingQueue clipQueue = new BlockingQueue();

    public boolean isSupported() {
        return PlatformUtils.isJavaBetterThan("1.3");
    }

    public synchronized void play(AudioClip audioClip) throws IOException {
        if (this.playerThread == null) {
            this.playerThread = new Thread((Runnable)this, "JavaxSampledAudioPlayer");
            this.playerThread.setDaemon(true);
            this.playerThread.setPriority(10);
            this.playerThread.start();
        }
        this.clipQueue.push(audioClip);
    }

    protected static AudioFormat getFormatForPlaying(byte[] byArray) throws UnsupportedAudioFileException, IOException {
        AudioFormat audioFormat = AudioSystem.getAudioFileFormat(new ByteArrayInputStream(byArray)).getFormat();
        if (audioFormat.getEncoding() != AudioFormat.Encoding.PCM_SIGNED) {
            return new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits() * 2, audioFormat.getChannels(), audioFormat.getFrameSize() * 2, audioFormat.getFrameRate(), true);
        }
        return audioFormat;
    }

    protected static byte[] convertAudioData(byte[] byArray, AudioFormat audioFormat) throws UnsupportedAudioFileException, IOException {
        AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(new ByteArrayInputStream(byArray));
        if (audioFormat.matches(audioInputStream.getFormat())) {
            return byArray;
        }
        audioInputStream = AudioSystem.getAudioInputStream(audioFormat, audioInputStream);
        return IOUtilities.readToEnd(audioInputStream);
    }
}

