/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl;

import java.io.IOException;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCipher;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.TlsDecodeResult;
import org.bouncycastle.tls.crypto.TlsEncodeResult;
import org.bouncycastle.tls.crypto.TlsHMAC;
import org.bouncycastle.tls.crypto.impl.TlsImplUtils;
import org.bouncycastle.tls.crypto.impl.TlsSuiteHMac;

public class TlsNullCipher
implements TlsCipher {
    protected final TlsCryptoParameters cryptoParams;
    protected final TlsSuiteHMac readMac;
    protected final TlsSuiteHMac writeMac;

    public TlsNullCipher(TlsCryptoParameters tlsCryptoParameters, TlsHMAC tlsHMAC, TlsHMAC tlsHMAC2) throws IOException {
        if (TlsImplUtils.isTLSv13(tlsCryptoParameters)) {
            throw new TlsFatalAlert(80);
        }
        this.cryptoParams = tlsCryptoParameters;
        int n = tlsHMAC.getMacLength() + tlsHMAC2.getMacLength();
        byte[] byArray = TlsImplUtils.calculateKeyBlock(tlsCryptoParameters, n);
        int n2 = 0;
        tlsHMAC.setKey(byArray, n2, tlsHMAC.getMacLength());
        tlsHMAC2.setKey(byArray, n2 += tlsHMAC.getMacLength(), tlsHMAC2.getMacLength());
        if ((n2 += tlsHMAC2.getMacLength()) != n) {
            throw new TlsFatalAlert(80);
        }
        if (tlsCryptoParameters.isServer()) {
            this.writeMac = new TlsSuiteHMac(tlsCryptoParameters, tlsHMAC2);
            this.readMac = new TlsSuiteHMac(tlsCryptoParameters, tlsHMAC);
        } else {
            this.writeMac = new TlsSuiteHMac(tlsCryptoParameters, tlsHMAC);
            this.readMac = new TlsSuiteHMac(tlsCryptoParameters, tlsHMAC2);
        }
    }

    public int getCiphertextDecodeLimit(int n) {
        return n + this.writeMac.getSize();
    }

    public int getCiphertextEncodeLimit(int n, int n2) {
        return n + this.writeMac.getSize();
    }

    public int getPlaintextLimit(int n) {
        return n - this.writeMac.getSize();
    }

    public TlsEncodeResult encodePlaintext(long l, short s2, ProtocolVersion protocolVersion, int n, byte[] byArray, int n2, int n3) throws IOException {
        byte[] byArray2 = this.writeMac.calculateMac(l, s2, byArray, n2, n3);
        byte[] byArray3 = new byte[n + n3 + byArray2.length];
        System.arraycopy(byArray, n2, byArray3, n, n3);
        System.arraycopy(byArray2, 0, byArray3, n + n3, byArray2.length);
        return new TlsEncodeResult(byArray3, 0, byArray3.length, s2);
    }

    public TlsDecodeResult decodeCiphertext(long l, short s2, ProtocolVersion protocolVersion, byte[] byArray, int n, int n2) throws IOException {
        boolean bl;
        int n3 = this.readMac.getSize();
        if (n2 < n3) {
            throw new TlsFatalAlert(50);
        }
        int n4 = n2 - n3;
        byte[] byArray2 = this.readMac.calculateMac(l, s2, byArray, n, n4);
        boolean bl2 = bl = !TlsUtils.constantTimeAreEqual(n3, byArray2, 0, byArray, n + n4);
        if (bl) {
            throw new TlsFatalAlert(20);
        }
        return new TlsDecodeResult(byArray, n, n4, s2);
    }

    public void rekeyDecoder() throws IOException {
        throw new TlsFatalAlert(80);
    }

    public void rekeyEncoder() throws IOException {
        throw new TlsFatalAlert(80);
    }

    public boolean usesOpaqueRecordType() {
        return false;
    }
}

