/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.rewrite.handler;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.eclipse.jetty.rewrite.handler.Rule;
import org.eclipse.jetty.util.URIUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidUrlRule
extends Rule {
    private static final Logger LOG = LoggerFactory.getLogger(ValidUrlRule.class);
    String _code = "400";
    String _message = "Illegal Url";

    public ValidUrlRule() {
        this._handling = true;
        this._terminating = true;
    }

    public void setCode(String code) {
        this._code = code;
    }

    public void setMessage(String message) {
        this._message = message;
    }

    @Override
    public String matchAndApply(String target, HttpServletRequest request, HttpServletResponse response2) throws IOException {
        int codepoint;
        String uri = URIUtil.decodePath(request.getRequestURI());
        for (int i = 0; i < uri.length(); i += Character.charCount(codepoint)) {
            codepoint = uri.codePointAt(i);
            if (this.isValidChar(uri.codePointAt(i))) continue;
            int code = Integer.parseInt(this._code);
            if (this._message != null && !this._message.isEmpty()) {
                response2.sendError(code, this._message);
            } else {
                response2.setStatus(code);
            }
            return target;
        }
        return null;
    }

    protected boolean isValidChar(int codepoint) {
        Character.UnicodeBlock block = Character.UnicodeBlock.of(codepoint);
        LOG.debug("{} {} {} {}", Character.charCount(codepoint), codepoint, block, Character.isISOControl(codepoint));
        return !Character.isISOControl(codepoint) && block != null && !Character.UnicodeBlock.SPECIALS.equals(block);
    }

    @Override
    public String toString() {
        return super.toString() + "[" + this._code + ":" + this._message + "]";
    }
}

