/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj;

import java.time.Clock;
import java.time.Instant;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.Features;
import org.jitsi.nlj.MediaSourceDesc;
import org.jitsi.nlj.MediaSourceDescKt;
import org.jitsi.nlj.MediaSources;
import org.jitsi.nlj.PacketHandler;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.RtpReceiver;
import org.jitsi.nlj.RtpReceiverImpl;
import org.jitsi.nlj.RtpSender;
import org.jitsi.nlj.RtpSenderImpl;
import org.jitsi.nlj.SetLocalSsrcEvent;
import org.jitsi.nlj.SetMediaSourcesEvent;
import org.jitsi.nlj.Stoppable;
import org.jitsi.nlj.TransceiverEventHandler;
import org.jitsi.nlj.format.PayloadType;
import org.jitsi.nlj.rtcp.RtcpEventNotifier;
import org.jitsi.nlj.rtp.RtpExtension;
import org.jitsi.nlj.rtp.bandwidthestimation.BandwidthEstimator;
import org.jitsi.nlj.srtp.SrtpProfileInformation;
import org.jitsi.nlj.srtp.SrtpTransformers;
import org.jitsi.nlj.srtp.SrtpUtil;
import org.jitsi.nlj.srtp.TlsRole;
import org.jitsi.nlj.stats.EndpointConnectionStats;
import org.jitsi.nlj.stats.NodeStatsBlock;
import org.jitsi.nlj.stats.PacketIOActivity;
import org.jitsi.nlj.stats.PacketStreamStats;
import org.jitsi.nlj.stats.RtpReceiverStats;
import org.jitsi.nlj.stats.TransceiverStats;
import org.jitsi.nlj.transform.NodeStatsProducer;
import org.jitsi.nlj.transform.node.outgoing.OutgoingStatisticsSnapshot;
import org.jitsi.nlj.util.LocalSsrcAssociation;
import org.jitsi.nlj.util.ReadOnlyStreamInformationStore;
import org.jitsi.nlj.util.SsrcAssociation;
import org.jitsi.nlj.util.StreamInformationStoreImpl;
import org.jitsi.rtp.rtcp.RtcpPacket;
import org.jitsi.utils.MediaType;
import org.jitsi.utils.logging.DiagnosticContext;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u008a\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0006\u0018\u0000 \u0082\u00012\u00020\u00012\u00020\u0002:\u0002\u0082\u0001BG\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u000e\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>J\u000e\u0010?\u001a\u00020<2\u0006\u0010@\u001a\u00020AJ\u0016\u0010B\u001a\u00020<2\u0006\u0010C\u001a\u00020(2\u0006\u0010D\u001a\u00020EJ\u000e\u0010F\u001a\u00020<2\u0006\u0010G\u001a\u00020HJ\u000e\u0010I\u001a\u00020<2\u0006\u0010J\u001a\u00020KJ\u0006\u0010L\u001a\u00020<J\u0006\u0010M\u001a\u00020<J\u000e\u0010N\u001a\u00020<2\u0006\u0010O\u001a\u00020\u0016J\u000e\u0010P\u001a\u00020<2\u0006\u0010O\u001a\u00020\u0016J\u0011\u0010Q\u001a\b\u0012\u0004\u0012\u00020S0R\u00a2\u0006\u0002\u0010TJ\b\u0010U\u001a\u00020VH\u0016J\u0006\u0010W\u001a\u00020XJ\u000e\u0010Y\u001a\u00020<2\u0006\u0010Z\u001a\u00020[J\u000e\u0010\\\u001a\u00020\u00162\u0006\u0010]\u001a\u00020^J\u0006\u0010_\u001a\u00020\u0016J\u0006\u0010`\u001a\u00020\u0016J\u000e\u0010a\u001a\u00020\u00162\u0006\u0010C\u001a\u00020(J\u000e\u0010b\u001a\u00020<2\u0006\u0010=\u001a\u00020>J\u000e\u0010c\u001a\u00020<2\u0006\u0010C\u001a\u00020(J\u0019\u0010d\u001a\u00020<2\n\b\u0002\u0010e\u001a\u0004\u0018\u00010(H\u0007\u00a2\u0006\u0002\u0010fJ\u000e\u0010g\u001a\u00020<2\u0006\u0010h\u001a\u00020[J\u001c\u0010i\u001a\u00020j2\f\u0010k\u001a\b\u0012\u0004\u0012\u00020(0l2\u0006\u0010m\u001a\u00020jJ\u0016\u0010n\u001a\u00020<2\u0006\u0010]\u001a\u00020^2\u0006\u0010o\u001a\u00020\u0016J\u000e\u0010p\u001a\u00020<2\u0006\u0010q\u001a\u00020rJ\u0016\u0010s\u001a\u00020<2\u0006\u0010D\u001a\u00020E2\u0006\u0010C\u001a\u00020(J\u0019\u0010t\u001a\u00020\u00162\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020S0R\u00a2\u0006\u0002\u0010uJ\u000e\u0010v\u001a\u00020<2\u0006\u0010w\u001a\u00020rJ\u001e\u0010x\u001a\u00020<2\u0006\u0010y\u001a\u00020j2\u0006\u0010z\u001a\u00020{2\u0006\u0010|\u001a\u00020}J\u000e\u0010x\u001a\u00020<2\u0006\u00103\u001a\u000204J\u0018\u0010~\u001a\u00020<2\u0006\u00103\u001a\u0002042\u0006\u0010\u007f\u001a\u00020\u0016H\u0002J\t\u0010\u0080\u0001\u001a\u00020<H\u0016J\u0007\u0010\u0081\u0001\u001a\u00020<R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020#\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0017\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0011\u0010+\u001a\u00020,\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u000e\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u000202X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u00103\u001a\u0004\u0018\u000104X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u00106\"\u0004\b7\u00108R\u000e\u00109\u001a\u00020:X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0083\u0001"}, d2={"Lorg/jitsi/nlj/Transceiver;", "Lorg/jitsi/nlj/Stoppable;", "Lorg/jitsi/nlj/transform/NodeStatsProducer;", "id", "", "receiverExecutor", "Ljava/util/concurrent/ExecutorService;", "senderExecutor", "backgroundExecutor", "Ljava/util/concurrent/ScheduledExecutorService;", "diagnosticContext", "Lorg/jitsi/utils/logging/DiagnosticContext;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "eventHandler", "Lorg/jitsi/nlj/TransceiverEventHandler;", "clock", "Ljava/time/Clock;", "(Ljava/lang/String;Ljava/util/concurrent/ExecutorService;Ljava/util/concurrent/ExecutorService;Ljava/util/concurrent/ScheduledExecutorService;Lorg/jitsi/utils/logging/DiagnosticContext;Lorg/jitsi/utils/logging2/Logger;Lorg/jitsi/nlj/TransceiverEventHandler;Ljava/time/Clock;)V", "endpointConnectionStats", "Lorg/jitsi/nlj/stats/EndpointConnectionStats;", "internalTransformers", "", "getInternalTransformers", "()Z", "setInternalTransformers", "(Z)V", "logger", "mediaSources", "Lorg/jitsi/nlj/MediaSources;", "packetIOActivity", "Lorg/jitsi/nlj/stats/PacketIOActivity;", "getPacketIOActivity", "()Lorg/jitsi/nlj/stats/PacketIOActivity;", "readOnlyStreamInformationStore", "Lorg/jitsi/nlj/util/ReadOnlyStreamInformationStore;", "getReadOnlyStreamInformationStore", "()Lorg/jitsi/nlj/util/ReadOnlyStreamInformationStore;", "receiveSsrcs", "", "", "getReceiveSsrcs", "()Ljava/util/Set;", "rtcpEventNotifier", "Lorg/jitsi/nlj/rtcp/RtcpEventNotifier;", "getRtcpEventNotifier", "()Lorg/jitsi/nlj/rtcp/RtcpEventNotifier;", "rtpReceiver", "Lorg/jitsi/nlj/RtpReceiver;", "rtpSender", "Lorg/jitsi/nlj/RtpSender;", "srtpTransformers", "Lorg/jitsi/nlj/srtp/SrtpTransformers;", "getSrtpTransformers", "()Lorg/jitsi/nlj/srtp/SrtpTransformers;", "setSrtpTransformers", "(Lorg/jitsi/nlj/srtp/SrtpTransformers;)V", "streamInformationStore", "Lorg/jitsi/nlj/util/StreamInformationStoreImpl;", "addEndpointConnectionStatsListener", "", "listener", "Lorg/jitsi/nlj/stats/EndpointConnectionStats$EndpointConnectionStatsListener;", "addPayloadType", "payloadType", "Lorg/jitsi/nlj/format/PayloadType;", "addReceiveSsrc", "ssrc", "mediaType", "Lorg/jitsi/utils/MediaType;", "addRtpExtension", "rtpExtension", "Lorg/jitsi/nlj/rtp/RtpExtension;", "addSsrcAssociation", "ssrcAssociation", "Lorg/jitsi/nlj/util/SsrcAssociation;", "clearPayloadTypes", "clearRtpExtensions", "forceMuteAudio", "shouldMute", "forceMuteVideo", "getMediaSources", "", "Lorg/jitsi/nlj/MediaSourceDesc;", "()[Lorg/jitsi/nlj/MediaSourceDesc;", "getNodeStats", "Lorg/jitsi/nlj/stats/NodeStatsBlock;", "getTransceiverStats", "Lorg/jitsi/nlj/stats/TransceiverStats;", "handleIncomingPacket", "p", "Lorg/jitsi/nlj/PacketInfo;", "isFeatureEnabled", "feature", "Lorg/jitsi/nlj/Features;", "isReceivingAudio", "isReceivingVideo", "receivesSsrc", "removeEndpointConnectionStatsListener", "removeReceiveSsrc", "requestKeyFrame", "mediaSsrc", "(Ljava/lang/Long;)V", "sendPacket", "packetInfo", "sendProbing", "", "mediaSsrcs", "", "numBytes", "setFeature", "enabled", "setIncomingPacketHandler", "rtpHandler", "Lorg/jitsi/nlj/PacketHandler;", "setLocalSsrc", "setMediaSources", "([Lorg/jitsi/nlj/MediaSourceDesc;)Z", "setOutgoingPacketHandler", "outgoingPacketHandler", "setSrtpInformation", "chosenSrtpProtectionProfile", "tlsRole", "Lorg/jitsi/nlj/srtp/TlsRole;", "keyingMaterial", "", "setSrtpInformationInternal", "internal", "stop", "teardown", "Companion", "jitsi-media-transform"})
public final class Transceiver
implements Stoppable,
NodeStatsProducer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    @NotNull
    private final TransceiverEventHandler eventHandler;
    @NotNull
    private final Clock clock;
    @NotNull
    private final Logger logger;
    @NotNull
    private final PacketIOActivity packetIOActivity;
    @NotNull
    private final EndpointConnectionStats endpointConnectionStats;
    @NotNull
    private final StreamInformationStoreImpl streamInformationStore;
    @NotNull
    private final ReadOnlyStreamInformationStore readOnlyStreamInformationStore;
    @NotNull
    private final RtcpEventNotifier rtcpEventNotifier;
    @NotNull
    private MediaSources mediaSources;
    @Nullable
    private SrtpTransformers srtpTransformers;
    private boolean internalTransformers;
    @NotNull
    private final RtpSender rtpSender;
    @NotNull
    private final RtpReceiver rtpReceiver;

    public Transceiver(@NotNull String id, @NotNull ExecutorService receiverExecutor, @NotNull ExecutorService senderExecutor, @NotNull ScheduledExecutorService backgroundExecutor, @NotNull DiagnosticContext diagnosticContext, @NotNull Logger parentLogger, @NotNull TransceiverEventHandler eventHandler, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(receiverExecutor, "receiverExecutor");
        Intrinsics.checkNotNullParameter(senderExecutor, "senderExecutor");
        Intrinsics.checkNotNullParameter(backgroundExecutor, "backgroundExecutor");
        Intrinsics.checkNotNullParameter(diagnosticContext, "diagnosticContext");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        Intrinsics.checkNotNullParameter(eventHandler, "eventHandler");
        Intrinsics.checkNotNullParameter(clock, "clock");
        this.id = id;
        this.eventHandler = eventHandler;
        this.clock = clock;
        this.logger = LoggerExtensionsKt.createChildLogger$default(this, parentLogger, null, 2, null);
        this.packetIOActivity = new PacketIOActivity();
        this.endpointConnectionStats = new EndpointConnectionStats(this.logger, null, 2, null);
        this.streamInformationStore = new StreamInformationStoreImpl();
        this.readOnlyStreamInformationStore = this.streamInformationStore;
        this.rtcpEventNotifier = new RtcpEventNotifier();
        this.mediaSources = new MediaSources();
        this.rtpSender = new RtpSenderImpl(this.id, this.rtcpEventNotifier, senderExecutor, backgroundExecutor, this.streamInformationStore, this.logger, diagnosticContext);
        this.rtpReceiver = new RtpReceiverImpl(this.id, (Function1<? super RtcpPacket, Unit>)new Function1<RtcpPacket, Unit>(this){
            final /* synthetic */ Transceiver this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull RtcpPacket rtcpPacket) {
                Intrinsics.checkNotNullParameter(rtcpPacket, "rtcpPacket");
                if (rtcpPacket.length >= 1500) {
                    Transceiver.access$getLogger$p(this.this$0).warn("Sending large locally-generated RTCP packet of size " + rtcpPacket.length + ", first packet of type " + rtcpPacket.getPacketType() + " rc " + rtcpPacket.getReportCount() + ".");
                }
                Transceiver.access$getRtpSender$p(this.this$0).processPacket(new PacketInfo(rtcpPacket, null, 2, null));
            }
        }, this.rtcpEventNotifier, receiverExecutor, backgroundExecutor, this.streamInformationStore, this.eventHandler, this.logger, diagnosticContext);
        this.rtpSender.getBandwidthEstimator().addListener(new BandwidthEstimator.Listener(){

            @Override
            public void bandwidthEstimationChanged-_2icLw0(double newValue) {
                eventHandler.bandwidthEstimationChanged-_2icLw0(newValue);
            }
        });
        this.rtpReceiver.addLossListener(this.endpointConnectionStats.getIncomingLossTracker());
        this.rtpSender.addLossListener(this.endpointConnectionStats.getOutgoingLossTracker());
        RtcpEventNotifier.addRtcpEventListener$default(this.rtcpEventNotifier, this.endpointConnectionStats, false, 2, null);
        this.endpointConnectionStats.addListener(this.rtpSender);
        this.endpointConnectionStats.addListener(this.rtpReceiver);
    }

    public /* synthetic */ Transceiver(String string, ExecutorService executorService, ExecutorService executorService2, ScheduledExecutorService scheduledExecutorService, DiagnosticContext diagnosticContext, Logger logger, TransceiverEventHandler transceiverEventHandler, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x80) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue(clock2, "systemUTC()");
            clock = clock2;
        }
        this(string, executorService, executorService2, scheduledExecutorService, diagnosticContext, logger, transceiverEventHandler, clock);
    }

    @NotNull
    public final PacketIOActivity getPacketIOActivity() {
        return this.packetIOActivity;
    }

    @NotNull
    public final ReadOnlyStreamInformationStore getReadOnlyStreamInformationStore() {
        return this.readOnlyStreamInformationStore;
    }

    @NotNull
    public final RtcpEventNotifier getRtcpEventNotifier() {
        return this.rtcpEventNotifier;
    }

    @Nullable
    public final SrtpTransformers getSrtpTransformers() {
        return this.srtpTransformers;
    }

    public final void setSrtpTransformers(@Nullable SrtpTransformers srtpTransformers) {
        this.srtpTransformers = srtpTransformers;
    }

    public final boolean getInternalTransformers() {
        return this.internalTransformers;
    }

    public final void setInternalTransformers(boolean bl) {
        this.internalTransformers = bl;
    }

    public final boolean isReceivingAudio() {
        return this.rtpReceiver.isReceivingAudio();
    }

    public final boolean isReceivingVideo() {
        return this.rtpReceiver.isReceivingVideo();
    }

    public final void handleIncomingPacket(@NotNull PacketInfo p) {
        Intrinsics.checkNotNullParameter(p, "p");
        Instant instant = this.clock.instant();
        Intrinsics.checkNotNullExpressionValue(instant, "clock.instant()");
        this.packetIOActivity.setLastRtpPacketReceivedInstant(instant);
        this.rtpReceiver.enqueuePacket(p);
    }

    public final void sendPacket(@NotNull PacketInfo packetInfo) {
        Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
        Instant instant = this.clock.instant();
        Intrinsics.checkNotNullExpressionValue(instant, "clock.instant()");
        this.packetIOActivity.setLastRtpPacketSentInstant(instant);
        this.rtpSender.processPacket(packetInfo);
    }

    public final int sendProbing(@NotNull Collection<Long> mediaSsrcs, int numBytes) {
        Intrinsics.checkNotNullParameter(mediaSsrcs, "mediaSsrcs");
        return this.rtpSender.sendProbing(mediaSsrcs, numBytes);
    }

    public final void setIncomingPacketHandler(@NotNull PacketHandler rtpHandler) {
        Intrinsics.checkNotNullParameter(rtpHandler, "rtpHandler");
        this.rtpReceiver.setPacketHandler(rtpHandler);
    }

    public final void setOutgoingPacketHandler(@NotNull PacketHandler outgoingPacketHandler) {
        Intrinsics.checkNotNullParameter(outgoingPacketHandler, "outgoingPacketHandler");
        this.rtpSender.onOutgoingPacket(outgoingPacketHandler);
    }

    public final void addReceiveSsrc(long ssrc2, @NotNull MediaType mediaType) {
        Intrinsics.checkNotNullParameter((Object)mediaType, "mediaType");
        Logger $this$cdebug$iv = this.logger;
        boolean $i$f$cdebug = false;
        if ($this$cdebug$iv.isDebugEnabled()) {
            Logger logger = $this$cdebug$iv;
            boolean bl = false;
            logger.debug(this.hashCode() + " adding receive ssrc " + ssrc2 + " of type " + mediaType);
        }
        this.streamInformationStore.addReceiveSsrc(ssrc2, mediaType);
    }

    public final void removeReceiveSsrc(long ssrc2) {
        Logger $this$cinfo$iv = this.logger;
        boolean $i$f$cinfo = false;
        if ($this$cinfo$iv.isInfoEnabled()) {
            Logger logger = $this$cinfo$iv;
            boolean bl = false;
            logger.info("Transceiver " + this.hashCode() + " removing receive ssrc " + ssrc2);
        }
        this.streamInformationStore.removeReceiveSsrc(ssrc2);
    }

    public final void setLocalSsrc(@NotNull MediaType mediaType, long ssrc2) {
        Intrinsics.checkNotNullParameter((Object)mediaType, "mediaType");
        SetLocalSsrcEvent localSsrcSetEvent = new SetLocalSsrcEvent(mediaType, ssrc2);
        this.rtpSender.handleEvent(localSsrcSetEvent);
        this.rtpReceiver.handleEvent(localSsrcSetEvent);
    }

    public final boolean receivesSsrc(long ssrc2) {
        return this.streamInformationStore.getReceiveSsrcs().contains(ssrc2);
    }

    @NotNull
    public final Set<Long> getReceiveSsrcs() {
        return this.streamInformationStore.getReceiveSsrcs();
    }

    public final boolean setMediaSources(@NotNull MediaSourceDesc[] mediaSources2) {
        Intrinsics.checkNotNullParameter(mediaSources2, "mediaSources");
        Logger $this$cdebug$iv = this.logger;
        boolean $i$f$cdebug = false;
        if ($this$cdebug$iv.isDebugEnabled()) {
            Logger logger = $this$cdebug$iv;
            boolean bl = false;
            logger.debug(this.id + " setting media sources: " + ArraysKt.joinToString$default(mediaSources2, null, null, null, 0, null, null, 63, null));
        }
        boolean ret = this.mediaSources.setMediaSources(mediaSources2);
        MediaSourceDesc[] mergedMediaSources = this.mediaSources.getMediaSources();
        MediaSourceDesc[] signaledMediaSources = MediaSourceDescKt.copy(mediaSources2);
        this.rtpReceiver.handleEvent(new SetMediaSourcesEvent(mergedMediaSources, signaledMediaSources));
        return ret;
    }

    @NotNull
    public final MediaSourceDesc[] getMediaSources() {
        return this.mediaSources.getMediaSources();
    }

    @JvmOverloads
    public final void requestKeyFrame(@Nullable Long mediaSsrc) {
        this.rtpSender.requestKeyframe(mediaSsrc);
    }

    public static /* synthetic */ void requestKeyFrame$default(Transceiver transceiver2, Long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = null;
        }
        transceiver2.requestKeyFrame(l);
    }

    public final void addPayloadType(@NotNull PayloadType payloadType) {
        Intrinsics.checkNotNullParameter(payloadType, "payloadType");
        Logger $this$cdebug$iv = this.logger;
        boolean $i$f$cdebug = false;
        if ($this$cdebug$iv.isDebugEnabled()) {
            Logger logger = $this$cdebug$iv;
            boolean bl = false;
            logger.debug("Payload type added: " + payloadType);
        }
        this.streamInformationStore.addRtpPayloadType(payloadType);
    }

    public final void clearPayloadTypes() {
        Logger $this$cinfo$iv = this.logger;
        boolean $i$f$cinfo = false;
        if ($this$cinfo$iv.isInfoEnabled()) {
            Logger logger = $this$cinfo$iv;
            boolean bl = false;
            logger.info("All payload types being cleared");
        }
        this.streamInformationStore.clearRtpPayloadTypes();
    }

    public final void addRtpExtension(@NotNull RtpExtension rtpExtension) {
        Intrinsics.checkNotNullParameter(rtpExtension, "rtpExtension");
        Logger $this$cdebug$iv = this.logger;
        boolean $i$f$cdebug = false;
        if ($this$cdebug$iv.isDebugEnabled()) {
            Logger logger = $this$cdebug$iv;
            boolean bl = false;
            logger.debug("Adding RTP extension: " + rtpExtension);
        }
        this.streamInformationStore.addRtpExtensionMapping(rtpExtension);
    }

    public final void clearRtpExtensions() {
        Logger $this$cinfo$iv = this.logger;
        boolean $i$f$cinfo = false;
        if ($this$cinfo$iv.isInfoEnabled()) {
            Logger logger = $this$cinfo$iv;
            boolean bl = false;
            logger.info("Clearing all RTP extensions");
        }
    }

    public final void addSsrcAssociation(@NotNull SsrcAssociation ssrcAssociation) {
        Intrinsics.checkNotNullParameter(ssrcAssociation, "ssrcAssociation");
        Logger $this$cdebug$iv = this.logger;
        boolean $i$f$cdebug = false;
        if ($this$cdebug$iv.isDebugEnabled()) {
            Logger logger = $this$cdebug$iv;
            boolean bl = false;
            String location = ssrcAssociation instanceof LocalSsrcAssociation ? "local" : "remote";
            logger.debug("Adding " + location + " SSRC association: " + ssrcAssociation);
        }
        this.streamInformationStore.addSsrcAssociation(ssrcAssociation);
    }

    /*
     * WARNING - void declaration
     */
    public final void setSrtpInformation(int chosenSrtpProtectionProfile, @NotNull TlsRole tlsRole, @NotNull byte[] keyingMaterial) {
        void it;
        SrtpTransformers srtpTransformers;
        Object object;
        Intrinsics.checkNotNullParameter((Object)tlsRole, "tlsRole");
        Intrinsics.checkNotNullParameter(keyingMaterial, "keyingMaterial");
        SrtpProfileInformation srtpProfileInfo = SrtpUtil.Companion.getSrtpProfileInformationFromSrtpProtectionProfile(chosenSrtpProtectionProfile);
        Logger $this$cdebug$iv = this.logger;
        boolean $i$f$cdebug22 = false;
        if ($this$cdebug$iv.isDebugEnabled()) {
            object = $this$cdebug$iv;
            boolean bl = false;
            object.debug("Transceiver " + this.id + " creating transformers with:\nprofile info:\n" + srtpProfileInfo + "\ntls role: " + tlsRole);
        }
        SrtpTransformers $i$f$cdebug22 = srtpTransformers = SrtpUtil.Companion.initializeTransformer(srtpProfileInfo, keyingMaterial, tlsRole, this.logger);
        object = this;
        boolean bl = false;
        this.setSrtpInformationInternal((SrtpTransformers)it, true);
        ((Transceiver)object).srtpTransformers = srtpTransformers;
    }

    private final void setSrtpInformationInternal(SrtpTransformers srtpTransformers, boolean internal) {
        this.rtpReceiver.setSrtpTransformers(srtpTransformers);
        this.rtpSender.setSrtpTransformers(srtpTransformers);
        this.internalTransformers = internal;
    }

    public final void setSrtpInformation(@NotNull SrtpTransformers srtpTransformers) {
        Intrinsics.checkNotNullParameter(srtpTransformers, "srtpTransformers");
        this.setSrtpInformationInternal(srtpTransformers, false);
    }

    public final void forceMuteAudio(boolean shouldMute) {
        boolean bl = shouldMute;
        if (bl) {
            this.logger.info("Muting incoming audio");
        } else if (!bl) {
            this.logger.info("Unmuting incoming audio");
        }
        this.rtpReceiver.forceMuteAudio(shouldMute);
    }

    public final void forceMuteVideo(boolean shouldMute) {
        boolean bl = shouldMute;
        if (bl) {
            this.logger.info("Muting incoming video");
        } else if (!bl) {
            this.logger.info("Unmuting incoming video");
        }
        this.rtpReceiver.forceMuteVideo(shouldMute);
    }

    @Override
    @NotNull
    public NodeStatsBlock getNodeStats() {
        NodeStatsBlock nodeStatsBlock;
        NodeStatsBlock $this$getNodeStats_u24lambda_u2d10 = nodeStatsBlock = new NodeStatsBlock("Transceiver " + this.id);
        boolean bl = false;
        $this$getNodeStats_u24lambda_u2d10.addBlock(this.streamInformationStore.getNodeStats());
        $this$getNodeStats_u24lambda_u2d10.addBlock(this.mediaSources.getNodeStats());
        $this$getNodeStats_u24lambda_u2d10.addJson("endpointConnectionStats", this.endpointConnectionStats.getSnapshot().toJson());
        $this$getNodeStats_u24lambda_u2d10.addBlock(this.rtpReceiver.getNodeStats());
        $this$getNodeStats_u24lambda_u2d10.addBlock(this.rtpSender.getNodeStats());
        return nodeStatsBlock;
    }

    @NotNull
    public final TransceiverStats getTransceiverStats() {
        EndpointConnectionStats.Snapshot snapshot = this.endpointConnectionStats.getSnapshot();
        RtpReceiverStats rtpReceiverStats = this.rtpReceiver.getStats();
        OutgoingStatisticsSnapshot outgoingStatisticsSnapshot = this.rtpSender.getStreamStats();
        PacketStreamStats.Snapshot snapshot2 = this.rtpSender.getPacketStreamStats();
        BandwidthEstimator bandwidthEstimator = this.rtpSender.getBandwidthEstimator();
        Instant instant = this.clock.instant();
        Intrinsics.checkNotNullExpressionValue(instant, "clock.instant()");
        return new TransceiverStats(snapshot, rtpReceiverStats, outgoingStatisticsSnapshot, snapshot2, bandwidthEstimator.getStats(instant), this.rtpSender.getTransportCcEngineStats());
    }

    public final void addEndpointConnectionStatsListener(@NotNull EndpointConnectionStats.EndpointConnectionStatsListener listener) {
        Intrinsics.checkNotNullParameter(listener, "listener");
        this.endpointConnectionStats.addListener(listener);
    }

    public final void removeEndpointConnectionStatsListener(@NotNull EndpointConnectionStats.EndpointConnectionStatsListener listener) {
        Intrinsics.checkNotNullParameter(listener, "listener");
        this.endpointConnectionStats.removeListener(listener);
    }

    @Override
    public void stop() {
        block1: {
            this.rtpReceiver.stop();
            this.rtpSender.stop();
            if (!this.internalTransformers) break block1;
            SrtpTransformers srtpTransformers = this.srtpTransformers;
            if (srtpTransformers != null) {
                srtpTransformers.close();
            }
        }
    }

    public final void teardown() {
        this.logger.info("Tearing down");
        this.rtpReceiver.tearDown();
        this.rtpSender.tearDown();
    }

    public final void setFeature(@NotNull Features feature, boolean enabled2) {
        Intrinsics.checkNotNullParameter((Object)feature, "feature");
        this.rtpReceiver.setFeature(feature, enabled2);
        this.rtpSender.setFeature(feature, enabled2);
    }

    public final boolean isFeatureEnabled(@NotNull Features feature) {
        Intrinsics.checkNotNullParameter((Object)feature, "feature");
        return this.rtpReceiver.isFeatureEnabled(feature);
    }

    @JvmOverloads
    public final void requestKeyFrame() {
        Transceiver.requestKeyFrame$default(this, null, 1, null);
    }

    public static final /* synthetic */ Logger access$getLogger$p(Transceiver $this) {
        return $this.logger;
    }

    public static final /* synthetic */ RtpSender access$getRtpSender$p(Transceiver $this) {
        return $this.rtpSender;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jitsi/nlj/Transceiver$Companion;", "", "()V", "jitsi-media-transform"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

