/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.transform.node.incoming;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.format.PayloadType;
import org.jitsi.nlj.format.RtxPayloadType;
import org.jitsi.nlj.rtp.RtxPacket;
import org.jitsi.nlj.stats.NodeStatsBlock;
import org.jitsi.nlj.transform.node.TransformerNode;
import org.jitsi.nlj.util.ReadOnlyStreamInformationStore;
import org.jitsi.rtp.extensions.unsigned.UnsignedKt;
import org.jitsi.rtp.rtp.RtpPacket;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0013H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0014R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jitsi/nlj/transform/node/incoming/RtxHandler;", "Lorg/jitsi/nlj/transform/node/TransformerNode;", "streamInformationStore", "Lorg/jitsi/nlj/util/ReadOnlyStreamInformationStore;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "(Lorg/jitsi/nlj/util/ReadOnlyStreamInformationStore;Lorg/jitsi/utils/logging2/Logger;)V", "logger", "numPaddingPacketsReceived", "", "numRtxPacketsReceived", "rtxPtToRtxPayloadType", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/jitsi/nlj/format/RtxPayloadType;", "getNodeStats", "Lorg/jitsi/nlj/stats/NodeStatsBlock;", "trace", "", "f", "Lkotlin/Function0;", "transform", "Lorg/jitsi/nlj/PacketInfo;", "packetInfo", "jitsi-media-transform"})
public final class RtxHandler
extends TransformerNode {
    @NotNull
    private final ReadOnlyStreamInformationStore streamInformationStore;
    @NotNull
    private final Logger logger;
    private int numPaddingPacketsReceived;
    private int numRtxPacketsReceived;
    @NotNull
    private final ConcurrentHashMap<Integer, RtxPayloadType> rtxPtToRtxPayloadType;

    public RtxHandler(@NotNull ReadOnlyStreamInformationStore streamInformationStore, @NotNull Logger parentLogger) {
        Intrinsics.checkNotNullParameter(streamInformationStore, "streamInformationStore");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        super("RTX handler");
        this.streamInformationStore = streamInformationStore;
        this.logger = LoggerExtensionsKt.createChildLogger$default(this, parentLogger, null, 2, null);
        this.rtxPtToRtxPayloadType = new ConcurrentHashMap();
        this.streamInformationStore.onRtpPayloadTypesChanged((Function1<? super Map<Byte, ? extends PayloadType>, Unit>)new Function1<Map<Byte, ? extends PayloadType>, Unit>(){

            /*
             * WARNING - void declaration
             */
            @Override
            public final void invoke(@NotNull Map<Byte, ? extends PayloadType> currentPayloadTypes) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                void $this$filterIsInstanceTo$iv$iv;
                Intrinsics.checkNotNullParameter(currentPayloadTypes, "currentPayloadTypes");
                rtxPtToRtxPayloadType.clear();
                Iterable $this$filterIsInstance$iv = currentPayloadTypes.values();
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof RtxPayloadType)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv;
                RtxHandler rtxHandler = this;
                boolean $i$f$map = false;
                destination$iv$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    RtxPayloadType rtxPayloadType = (RtxPayloadType)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl = false;
                    ((Map)rtxHandler.rtxPtToRtxPayloadType).put(UnsignedKt.toPositiveInt(it.getPt()), it);
                    collection.add(Unit.INSTANCE);
                }
                List cfr_ignored_0 = (List)destination$iv$iv2;
            }
        });
    }

    @Override
    @Nullable
    protected PacketInfo transform(@NotNull PacketInfo packetInfo) {
        Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
        RtpPacket rtpPacket = (RtpPacket)packetInfo.packetAs();
        RtxPayloadType rtxPayloadType = this.rtxPtToRtxPayloadType.get(UnsignedKt.toPositiveInt(rtpPacket.getPayloadType()));
        if (rtxPayloadType == null) {
            return packetInfo;
        }
        RtxPayloadType rtxPayloadType2 = rtxPayloadType;
        Long l = this.streamInformationStore.getLocalPrimarySsrc(rtpPacket.getSsrc());
        if (l == null) {
            return packetInfo;
        }
        long originalSsrc = l;
        if (packetInfo.getShouldDiscard()) {
            return null;
        }
        if (rtpPacket.getPayloadLength() - rtpPacket.getPaddingSize() < 2) {
            Logger $this$cdebug$iv22 = this.logger;
            boolean $i$f$cdebug = false;
            if ($this$cdebug$iv22.isDebugEnabled()) {
                Logger logger = $this$cdebug$iv22;
                boolean bl = false;
                logger.debug("RTX packet is padding, ignore");
            }
            int $this$cdebug$iv22 = this.numPaddingPacketsReceived;
            this.numPaddingPacketsReceived = $this$cdebug$iv22 + 1;
            return null;
        }
        int originalSeqNum = RtxPacket.Companion.getOriginalSequenceNumber(rtpPacket);
        int originalPt = rtxPayloadType2.getAssociatedPayloadType();
        RtxPacket.Companion.removeOriginalSequenceNumber(rtpPacket);
        rtpPacket.setSequenceNumber(originalSeqNum);
        rtpPacket.setPayloadType(originalPt);
        rtpPacket.setSsrc(originalSsrc);
        Logger $this$cdebug$iv = this.logger;
        boolean $i$f$cdebug = false;
        if ($this$cdebug$iv.isDebugEnabled()) {
            Logger logger = $this$cdebug$iv;
            boolean bl = false;
            logger.debug("Recovered RTX packet.  Original packet: " + originalSsrc + " " + originalSeqNum);
        }
        int n = this.numRtxPacketsReceived;
        this.numRtxPacketsReceived = n + 1;
        packetInfo.resetPayloadVerification();
        return packetInfo;
    }

    @Override
    @NotNull
    public NodeStatsBlock getNodeStats() {
        NodeStatsBlock nodeStatsBlock;
        NodeStatsBlock $this$getNodeStats_u24lambda_u2d2 = nodeStatsBlock = super.getNodeStats();
        boolean bl = false;
        $this$getNodeStats_u24lambda_u2d2.addNumber("num_rtx_packets_received", this.numRtxPacketsReceived);
        $this$getNodeStats_u24lambda_u2d2.addNumber("num_padding_packets_received", this.numPaddingPacketsReceived);
        $this$getNodeStats_u24lambda_u2d2.addString("rtx_payload_types", this.rtxPtToRtxPayloadType.values().toString());
        return nodeStatsBlock;
    }

    @Override
    public void trace(@NotNull Function0<Unit> f) {
        Intrinsics.checkNotNullParameter(f, "f");
        f.invoke();
    }
}

