/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.format.PayloadType;
import org.jitsi.nlj.format.PayloadTypeKt;
import org.jitsi.nlj.rtp.RtpExtension;
import org.jitsi.nlj.rtp.RtpExtensionType;
import org.jitsi.nlj.rtp.SsrcAssociationType;
import org.jitsi.nlj.stats.NodeStatsBlock;
import org.jitsi.nlj.util.LocalSsrcAssociation;
import org.jitsi.nlj.util.ReceiveSsrcStore;
import org.jitsi.nlj.util.RemoteSsrcAssociation;
import org.jitsi.nlj.util.SsrcAssociation;
import org.jitsi.nlj.util.SsrcAssociationStore;
import org.jitsi.nlj.util.StreamInformationStore;
import org.jitsi.utils.MediaType;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u00104\u001a\u00020\u000e2\u0006\u00105\u001a\u00020\u001a2\u0006\u00106\u001a\u000207H\u0016J\u0010\u00108\u001a\u00020\u000e2\u0006\u00109\u001a\u00020\u0005H\u0016J\u0010\u0010:\u001a\u00020\u000e2\u0006\u0010;\u001a\u00020\tH\u0016J\u0010\u0010<\u001a\u00020\u000e2\u0006\u0010=\u001a\u00020>H\u0016J\b\u0010?\u001a\u00020\u000eH\u0016J\b\u0010@\u001a\u00020\u000eH\u0016J\u0017\u0010A\u001a\u0004\u0018\u00010\u001a2\u0006\u0010B\u001a\u00020\u001aH\u0016\u00a2\u0006\u0002\u0010CJ\b\u0010D\u001a\u00020EH\u0016J\u001f\u0010F\u001a\u0004\u0018\u00010\u001a2\u0006\u0010G\u001a\u00020\u001a2\u0006\u0010H\u001a\u00020IH\u0016\u00a2\u0006\u0002\u0010JJ*\u0010K\u001a\u00020\u000e2\u0006\u0010L\u001a\u00020\u000b2\u0018\u0010M\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0004\u0012\u00020\u000e0\fj\u0002`\u000fH\u0016J,\u0010N\u001a\u00020\u000e2\"\u0010M\u001a\u001e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0015\u0012\u0004\u0012\u00020\u000e0\fj\u0002`\u0016H\u0016J\u0010\u0010O\u001a\u00020\u000e2\u0006\u00105\u001a\u00020\u001aH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\n\u001a&\u0012\u0004\u0012\u00020\u000b\u0012\u001c\u0012\u001a\u0012\u0016\u0012\u0014\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0004\u0012\u00020\u000e0\fj\u0002`\u000f0\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010\u0014\u001a$\u0012 \u0012\u001e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0015\u0012\u0004\u0012\u00020\u000e0\fj\u0002`\u00160\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001cR\u000e\u0010!\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00050#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R \u0010&\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u001e\u0010+\u001a\u00020*2\u0006\u0010)\u001a\u00020*@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u001e\u0010.\u001a\u00020*2\u0006\u0010)\u001a\u00020*@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010-R\u001e\u00100\u001a\u00020*2\u0006\u0010)\u001a\u00020*@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010-R\u001e\u00102\u001a\u00020*2\u0006\u0010)\u001a\u00020*@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010-\u00a8\u0006P"}, d2={"Lorg/jitsi/nlj/util/StreamInformationStoreImpl;", "Lorg/jitsi/nlj/util/StreamInformationStore;", "()V", "_rtpExtensions", "", "Lorg/jitsi/nlj/rtp/RtpExtension;", "_rtpPayloadTypes", "", "", "Lorg/jitsi/nlj/format/PayloadType;", "extensionHandlers", "Lorg/jitsi/nlj/rtp/RtpExtensionType;", "Lkotlin/Function1;", "", "", "Lorg/jitsi/nlj/util/RtpExtensionHandler;", "extensionsLock", "", "localSsrcAssociations", "Lorg/jitsi/nlj/util/SsrcAssociationStore;", "payloadTypeHandlers", "", "Lorg/jitsi/nlj/util/RtpPayloadTypesChangedHandler;", "payloadTypesLock", "primaryMediaSsrcs", "", "", "getPrimaryMediaSsrcs", "()Ljava/util/Set;", "receiveSsrcStore", "Lorg/jitsi/nlj/util/ReceiveSsrcStore;", "receiveSsrcs", "getReceiveSsrcs", "remoteSsrcAssociations", "rtpExtensions", "", "getRtpExtensions", "()Ljava/util/List;", "rtpPayloadTypes", "getRtpPayloadTypes", "()Ljava/util/Map;", "<set-?>", "", "supportsFir", "getSupportsFir", "()Z", "supportsPli", "getSupportsPli", "supportsRemb", "getSupportsRemb", "supportsTcc", "getSupportsTcc", "addReceiveSsrc", "ssrc", "mediaType", "Lorg/jitsi/utils/MediaType;", "addRtpExtensionMapping", "rtpExtension", "addRtpPayloadType", "payloadType", "addSsrcAssociation", "ssrcAssociation", "Lorg/jitsi/nlj/util/SsrcAssociation;", "clearRtpExtensions", "clearRtpPayloadTypes", "getLocalPrimarySsrc", "secondarySsrc", "(J)Ljava/lang/Long;", "getNodeStats", "Lorg/jitsi/nlj/stats/NodeStatsBlock;", "getRemoteSecondarySsrc", "primarySsrc", "associationType", "Lorg/jitsi/nlj/rtp/SsrcAssociationType;", "(JLorg/jitsi/nlj/rtp/SsrcAssociationType;)Ljava/lang/Long;", "onRtpExtensionMapping", "rtpExtensionType", "handler", "onRtpPayloadTypesChanged", "removeReceiveSsrc", "jitsi-media-transform"})
public final class StreamInformationStoreImpl
implements StreamInformationStore {
    @NotNull
    private final Object extensionsLock = new Object();
    @NotNull
    private final Map<RtpExtensionType, List<Function1<Integer, Unit>>> extensionHandlers = new LinkedHashMap();
    @NotNull
    private final List<RtpExtension> _rtpExtensions = new CopyOnWriteArrayList();
    @NotNull
    private final Object payloadTypesLock = new Object();
    @NotNull
    private final List<Function1<Map<Byte, ? extends PayloadType>, Unit>> payloadTypeHandlers = new ArrayList();
    @NotNull
    private final Map<Byte, PayloadType> _rtpPayloadTypes = new ConcurrentHashMap();
    @NotNull
    private final Map<Byte, PayloadType> rtpPayloadTypes;
    @NotNull
    private final SsrcAssociationStore localSsrcAssociations;
    @NotNull
    private final SsrcAssociationStore remoteSsrcAssociations;
    @NotNull
    private final ReceiveSsrcStore receiveSsrcStore;
    private boolean supportsFir;
    private boolean supportsPli;
    private boolean supportsRemb;
    private boolean supportsTcc;

    public StreamInformationStoreImpl() {
        Map<Byte, PayloadType> map = Collections.unmodifiableMap(this._rtpPayloadTypes);
        Intrinsics.checkNotNullExpressionValue(map, "unmodifiableMap(_rtpPayloadTypes)");
        this.rtpPayloadTypes = map;
        this.localSsrcAssociations = new SsrcAssociationStore("Local SSRC Associations");
        this.remoteSsrcAssociations = new SsrcAssociationStore("Remote SSRC Associations");
        this.receiveSsrcStore = new ReceiveSsrcStore(this.localSsrcAssociations);
        this.supportsFir = true;
    }

    @Override
    @NotNull
    public List<RtpExtension> getRtpExtensions() {
        return this._rtpExtensions;
    }

    @Override
    @NotNull
    public Map<Byte, PayloadType> getRtpPayloadTypes() {
        return this.rtpPayloadTypes;
    }

    @Override
    @NotNull
    public Set<Long> getReceiveSsrcs() {
        return this.receiveSsrcStore.getReceiveSsrcs();
    }

    @Override
    @NotNull
    public Set<Long> getPrimaryMediaSsrcs() {
        return this.receiveSsrcStore.getPrimaryMediaSsrcs();
    }

    @Override
    public boolean getSupportsFir() {
        return this.supportsFir;
    }

    @Override
    public boolean getSupportsPli() {
        return this.supportsPli;
    }

    @Override
    public boolean getSupportsRemb() {
        return this.supportsRemb;
    }

    @Override
    public boolean getSupportsTcc() {
        return this.supportsTcc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRtpExtensionMapping(@NotNull RtpExtension rtpExtension) {
        Intrinsics.checkNotNullParameter(rtpExtension, "rtpExtension");
        Object object = this.extensionsLock;
        synchronized (object) {
            Unit unit;
            boolean bl = false;
            this._rtpExtensions.add(rtpExtension);
            List<Function1<Integer, Unit>> list = this.extensionHandlers.get((Object)rtpExtension.getType());
            if (list != null) {
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Function1 it = (Function1)element$iv;
                    boolean bl2 = false;
                    it.invoke(Integer.valueOf(rtpExtension.getId()));
                }
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Unit unit2 = unit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearRtpExtensions() {
        Object object = this.extensionsLock;
        synchronized (object) {
            boolean bl = false;
            this._rtpExtensions.clear();
            Iterable $this$forEach$iv = this.extensionHandlers.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                List handlers = (List)element$iv;
                boolean bl2 = false;
                Iterable $this$forEach$iv2 = handlers;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Function1 it = (Function1)element$iv2;
                    boolean bl3 = false;
                    it.invoke(null);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRtpExtensionMapping(@NotNull RtpExtensionType rtpExtensionType, @NotNull Function1<? super Integer, Unit> handler) {
        Intrinsics.checkNotNullParameter((Object)rtpExtensionType, "rtpExtensionType");
        Intrinsics.checkNotNullParameter(handler, "handler");
        Object object = this.extensionsLock;
        synchronized (object) {
            Unit unit;
            Object v1;
            block8: {
                Object object2;
                boolean bl = false;
                Map<RtpExtensionType, List<Function1<Integer, Unit>>> $this$getOrPut$iv = this.extensionHandlers;
                boolean $i$f$getOrPut = false;
                Iterable<Function1<Integer, Unit>> value$iv = $this$getOrPut$iv.get((Object)rtpExtensionType);
                if (value$iv == null) {
                    boolean bl2 = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(rtpExtensionType, answer$iv);
                    object2 = answer$iv;
                } else {
                    object2 = value$iv;
                }
                object2.add(handler);
                value$iv = this._rtpExtensions;
                for (Object e : value$iv) {
                    RtpExtension it = (RtpExtension)e;
                    boolean bl3 = false;
                    if (!(it.getType() == rtpExtensionType)) continue;
                    v1 = e;
                    break block8;
                }
                v1 = null;
            }
            RtpExtension rtpExtension = v1;
            if (rtpExtension != null) {
                RtpExtension it = rtpExtension;
                boolean bl = false;
                handler.invoke(Integer.valueOf(it.getId()));
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Unit unit2 = unit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRtpPayloadType(@NotNull PayloadType payloadType) {
        Intrinsics.checkNotNullParameter(payloadType, "payloadType");
        Object object = this.payloadTypesLock;
        synchronized (object) {
            Object v2;
            Object it;
            block9: {
                Object v1;
                Iterable iterable;
                StreamInformationStoreImpl streamInformationStoreImpl;
                Iterable iterable2;
                block8: {
                    Object v0;
                    block7: {
                        boolean bl = false;
                        this._rtpPayloadTypes.put(payloadType.getPt(), payloadType);
                        iterable2 = this.getRtpPayloadTypes().values();
                        streamInformationStoreImpl = this;
                        iterable = iterable2;
                        for (Object t : iterable) {
                            it = (PayloadType)t;
                            boolean bl2 = false;
                            if (!PayloadTypeKt.supportsPli((Set<String>)((PayloadType)it).getRtcpFeedbackSet())) continue;
                            v0 = t;
                            break block7;
                        }
                        v0 = null;
                    }
                    streamInformationStoreImpl.supportsPli = v0 != null;
                    iterable2 = this.getRtpPayloadTypes().values();
                    streamInformationStoreImpl = this;
                    iterable = iterable2;
                    for (Object t : iterable) {
                        it = (PayloadType)t;
                        boolean bl = false;
                        if (!PayloadTypeKt.supportsRemb((Set<String>)((PayloadType)it).getRtcpFeedbackSet())) continue;
                        v1 = t;
                        break block8;
                    }
                    v1 = null;
                }
                streamInformationStoreImpl.supportsRemb = v1 != null;
                iterable2 = this.getRtpPayloadTypes().values();
                streamInformationStoreImpl = this;
                iterable = iterable2;
                for (Object t : iterable) {
                    it = (PayloadType)t;
                    boolean bl = false;
                    if (!PayloadTypeKt.supportsTcc((Set<String>)((PayloadType)it).getRtcpFeedbackSet())) continue;
                    v2 = t;
                    break block9;
                }
                v2 = null;
            }
            streamInformationStoreImpl.supportsTcc = v2 != null;
            Iterable $this$forEach$iv = this.payloadTypeHandlers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Function1)element$iv;
                boolean bl = false;
                it.invoke(this._rtpPayloadTypes);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearRtpPayloadTypes() {
        Object object = this.payloadTypesLock;
        synchronized (object) {
            boolean bl = false;
            this._rtpPayloadTypes.clear();
            this.supportsPli = false;
            this.supportsRemb = false;
            this.supportsTcc = false;
            Iterable $this$forEach$iv = this.payloadTypeHandlers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Function1 it = (Function1)element$iv;
                boolean bl2 = false;
                it.invoke(this._rtpPayloadTypes);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRtpPayloadTypesChanged(@NotNull Function1<? super Map<Byte, ? extends PayloadType>, Unit> handler) {
        Intrinsics.checkNotNullParameter(handler, "handler");
        Object object = this.payloadTypesLock;
        synchronized (object) {
            boolean bl = false;
            this.payloadTypeHandlers.add(handler);
            handler.invoke(this._rtpPayloadTypes);
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    @Nullable
    public Long getLocalPrimarySsrc(long secondarySsrc) {
        return this.localSsrcAssociations.getPrimarySsrc(secondarySsrc);
    }

    @Override
    @Nullable
    public Long getRemoteSecondarySsrc(long primarySsrc, @NotNull SsrcAssociationType associationType) {
        Intrinsics.checkNotNullParameter((Object)associationType, "associationType");
        return this.remoteSsrcAssociations.getSecondarySsrc(primarySsrc, associationType);
    }

    @Override
    public void addSsrcAssociation(@NotNull SsrcAssociation ssrcAssociation) {
        Intrinsics.checkNotNullParameter(ssrcAssociation, "ssrcAssociation");
        SsrcAssociation ssrcAssociation2 = ssrcAssociation;
        if (ssrcAssociation2 instanceof LocalSsrcAssociation) {
            this.localSsrcAssociations.addAssociation(ssrcAssociation);
        } else if (ssrcAssociation2 instanceof RemoteSsrcAssociation) {
            this.remoteSsrcAssociations.addAssociation(ssrcAssociation);
        }
    }

    @Override
    public void addReceiveSsrc(long ssrc2, @NotNull MediaType mediaType) {
        Intrinsics.checkNotNullParameter((Object)mediaType, "mediaType");
        this.receiveSsrcStore.addReceiveSsrc(ssrc2, mediaType);
    }

    @Override
    public void removeReceiveSsrc(long ssrc2) {
        this.receiveSsrcStore.removeReceiveSsrc(ssrc2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public NodeStatsBlock getNodeStats() {
        NodeStatsBlock $this$getNodeStats_u24lambda_u2d21_u24lambda_u2d18;
        Object it;
        NodeStatsBlock nodeStatsBlock;
        NodeStatsBlock nodeStatsBlock2;
        NodeStatsBlock $this$getNodeStats_u24lambda_u2d21 = nodeStatsBlock2 = new NodeStatsBlock("Stream Information Store");
        boolean bl = false;
        NodeStatsBlock nodeStatsBlock3 = nodeStatsBlock = new NodeStatsBlock("RTP Extensions");
        NodeStatsBlock nodeStatsBlock4 = $this$getNodeStats_u24lambda_u2d21;
        boolean bl2 = false;
        Object $this$forEach$iv = this.getRtpExtensions();
        boolean $i$f$forEach = false;
        Iterator<Object> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object t = iterator2.next();
            it = (RtpExtension)t;
            boolean bl3 = false;
            $this$getNodeStats_u24lambda_u2d21_u24lambda_u2d18.addString(String.valueOf(((RtpExtension)it).getId()), ((RtpExtension)it).getType().toString());
        }
        nodeStatsBlock4.addBlock(nodeStatsBlock);
        $this$getNodeStats_u24lambda_u2d21_u24lambda_u2d18 = nodeStatsBlock = new NodeStatsBlock("RTP Payload Types");
        nodeStatsBlock4 = $this$getNodeStats_u24lambda_u2d21;
        boolean bl4 = false;
        $this$forEach$iv = this.getRtpPayloadTypes();
        $i$f$forEach = false;
        for (Map.Entry entry : $this$forEach$iv.entrySet()) {
            void $this$getNodeStats_u24lambda_u2d21_u24lambda_u2d20;
            it = entry;
            boolean bl5 = false;
            $this$getNodeStats_u24lambda_u2d21_u24lambda_u2d20.addString(String.valueOf(((Number)it.getKey()).intValue()), ((PayloadType)it.getValue()).toString());
        }
        nodeStatsBlock4.addBlock(nodeStatsBlock);
        $this$getNodeStats_u24lambda_u2d21.addBlock(this.localSsrcAssociations.getNodeStats());
        $this$getNodeStats_u24lambda_u2d21.addBlock(this.remoteSsrcAssociations.getNodeStats());
        $this$getNodeStats_u24lambda_u2d21.addBlock(this.receiveSsrcStore.getNodeStats());
        $this$getNodeStats_u24lambda_u2d21.addBoolean("supports_pli", this.getSupportsPli());
        $this$getNodeStats_u24lambda_u2d21.addBoolean("supports_fir", this.getSupportsFir());
        return nodeStatsBlock2;
    }
}

