/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.rtp.extensions;

import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.rtp.extensions.ByteKt;
import org.jitsi.rtp.util.BufferPool;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0000\u001a\n\u0010\u0002\u001a\u00020\u0003*\u00020\u0003\u001a\u0012\u0010\u0004\u001a\u00020\u0005*\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003\u001a\n\u0010\u0007\u001a\u00020\u0005*\u00020\u0003\u001a\u0012\u0010\u0007\u001a\u00020\u0005*\u00020\u00032\u0006\u0010\b\u001a\u00020\u0005\u001a\u0015\u0010\t\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003H\u0086\u0002\u001a\u001a\u0010\n\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0003\u001a\u0012\u0010\f\u001a\u00020\r*\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0005\u001a\u001a\u0010\f\u001a\u00020\r*\u00020\u00032\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005\u001a\"\u0010\u000f\u001a\u00020\r*\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013\u001a*\u0010\u0014\u001a\u00020\r*\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0005\u001a\n\u0010\u0018\u001a\u00020\r*\u00020\u0003\u001a\"\u0010\u0019\u001a\u00020\r*\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u0005\u001a\"\u0010\u001d\u001a\u00020\r*\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u0005\u001a\u0012\u0010\u001e\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0005\u001a\u001a\u0010\u001e\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u0005\u001a\n\u0010!\u001a\u00020\"*\u00020\u0003\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"HEX_CHARS", "", "clone", "Ljava/nio/ByteBuffer;", "compareToFromBeginning", "", "other", "get3Bytes", "index", "plus", "put", "buf", "put3Bytes", "", "value", "putBitAsBoolean", "byteIndex", "destBitPos", "isSet", "", "putBits", "src", "", "numBits", "rewindOneByte", "shiftDataLeft", "startPos", "endPos", "numBytes", "shiftDataRight", "subBuffer", "startPosition", "size", "toHex", "", "rtp"})
public final class ByteBufferKt {
    @NotNull
    private static final char[] HEX_CHARS;

    @NotNull
    public static final ByteBuffer clone(@NotNull ByteBuffer $this$clone) {
        Intrinsics.checkNotNullParameter($this$clone, "<this>");
        int startPosition = $this$clone.position();
        ByteBuffer clone = ByteBuffer.wrap(BufferPool.Companion.getGetArray().invoke($this$clone.capacity()));
        $this$clone.rewind();
        clone.put($this$clone);
        $this$clone.position(startPosition);
        clone.flip();
        Intrinsics.checkNotNullExpressionValue(clone, "clone");
        return clone;
    }

    public static final void rewindOneByte(@NotNull ByteBuffer $this$rewindOneByte) {
        Intrinsics.checkNotNullParameter($this$rewindOneByte, "<this>");
        $this$rewindOneByte.position($this$rewindOneByte.position() - 1);
    }

    public static final void put3Bytes(@NotNull ByteBuffer $this$put3Bytes, int value2) {
        Intrinsics.checkNotNullParameter($this$put3Bytes, "<this>");
        $this$put3Bytes.put((byte)((value2 & 0xFF0000) >>> 16));
        $this$put3Bytes.put((byte)((value2 & 0xFF00) >>> 8));
        $this$put3Bytes.put((byte)(value2 & 0xFF));
    }

    public static final void put3Bytes(@NotNull ByteBuffer $this$put3Bytes, int index, int value2) {
        Intrinsics.checkNotNullParameter($this$put3Bytes, "<this>");
        $this$put3Bytes.put(index, (byte)((value2 & 0xFF0000) >>> 16));
        $this$put3Bytes.put(index + 1, (byte)((value2 & 0xFF00) >>> 8));
        $this$put3Bytes.put(index + 2, (byte)(value2 & 0xFF));
    }

    public static final int get3Bytes(@NotNull ByteBuffer $this$get3Bytes) {
        Intrinsics.checkNotNullParameter($this$get3Bytes, "<this>");
        int byte1 = ($this$get3Bytes.get() & 0xFF) << 16;
        int byte2 = ($this$get3Bytes.get() & 0xFF) << 8;
        int byte3 = $this$get3Bytes.get() & 0xFF;
        return byte1 | byte2 | byte3;
    }

    public static final int get3Bytes(@NotNull ByteBuffer $this$get3Bytes, int index) {
        Intrinsics.checkNotNullParameter($this$get3Bytes, "<this>");
        int byte1 = ($this$get3Bytes.get(index) & 0xFF) << 16;
        int byte2 = ($this$get3Bytes.get(index + 1) & 0xFF) << 8;
        int byte3 = $this$get3Bytes.get(index + 2) & 0xFF;
        return byte1 | byte2 | byte3;
    }

    public static final void putBits(@NotNull ByteBuffer $this$putBits, int byteIndex, int destBitPos, byte src, int numBits) {
        Intrinsics.checkNotNullParameter($this$putBits, "<this>");
        byte by = $this$putBits.get(byteIndex);
        by = ByteKt.putBits(by, destBitPos, numBits, src);
        $this$putBits.put(byteIndex, by);
    }

    public static final void putBitAsBoolean(@NotNull ByteBuffer $this$putBitAsBoolean, int byteIndex, int destBitPos, boolean isSet) {
        Intrinsics.checkNotNullParameter($this$putBitAsBoolean, "<this>");
        byte by = $this$putBitAsBoolean.get(byteIndex);
        by = ByteKt.putBit(by, destBitPos, isSet);
        $this$putBitAsBoolean.put(byteIndex, by);
    }

    @NotNull
    public static final String toHex(@NotNull ByteBuffer $this$toHex) {
        Intrinsics.checkNotNullParameter($this$toHex, "<this>");
        StringBuffer result2 = new StringBuffer();
        int prevPosition = $this$toHex.position();
        int n = $this$toHex.limit();
        for (int i = 0; i < n; ++i) {
            byte octet = $this$toHex.get(i);
            int firstIndex = (octet & 0xF0) >>> 4;
            int secondIndex = octet & 0xF;
            result2.append(HEX_CHARS[firstIndex]);
            result2.append(HEX_CHARS[secondIndex]);
            if ((i + 1) % 16 == 0) {
                result2.append("\n");
                continue;
            }
            if ((i + 1) % 4 != 0) continue;
            result2.append(" ");
        }
        $this$toHex.position(prevPosition);
        String string = result2.toString();
        Intrinsics.checkNotNullExpressionValue(string, "result.toString()");
        return string;
    }

    @NotNull
    public static final ByteBuffer subBuffer(@NotNull ByteBuffer $this$subBuffer, int startPosition, int size) {
        Intrinsics.checkNotNullParameter($this$subBuffer, "<this>");
        if (startPosition + size > $this$subBuffer.limit()) {
            throw new Exception("SubBuffer goes beyond the buffer's limit (limit " + $this$subBuffer.limit() + ", requested end of buffer " + (startPosition + size) + ")");
        }
        ByteBuffer byteBuffer = $this$subBuffer.duplicate().position(startPosition).limit(startPosition + size);
        if (byteBuffer == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.nio.ByteBuffer");
        }
        ByteBuffer byteBuffer2 = byteBuffer.slice();
        Intrinsics.checkNotNullExpressionValue(byteBuffer2, "duplicate().position(sta\u2026e) as ByteBuffer).slice()");
        return byteBuffer2;
    }

    @NotNull
    public static final ByteBuffer subBuffer(@NotNull ByteBuffer $this$subBuffer, int startPosition) {
        Intrinsics.checkNotNullParameter($this$subBuffer, "<this>");
        return ByteBufferKt.subBuffer($this$subBuffer, startPosition, $this$subBuffer.limit() - startPosition);
    }

    @NotNull
    public static final ByteBuffer put(@NotNull ByteBuffer $this$put, int index, @NotNull ByteBuffer buf) {
        Intrinsics.checkNotNullParameter($this$put, "<this>");
        Intrinsics.checkNotNullParameter(buf, "buf");
        int currentPosition = $this$put.position();
        $this$put.position(index);
        $this$put.put(buf);
        $this$put.position(currentPosition);
        return $this$put;
    }

    public static final void shiftDataRight(@NotNull ByteBuffer $this$shiftDataRight, int startPos, int endPos, int numBytes) {
        int index;
        Intrinsics.checkNotNullParameter($this$shiftDataRight, "<this>");
        if (endPos + numBytes >= $this$shiftDataRight.limit() && $this$shiftDataRight.capacity() > endPos + numBytes) {
            $this$shiftDataRight.limit(endPos + numBytes + 1);
        }
        if (startPos <= (index = endPos)) {
            while (true) {
                $this$shiftDataRight.put(index + numBytes, $this$shiftDataRight.get(index));
                if (index == startPos) break;
                --index;
            }
        }
    }

    public static final void shiftDataLeft(@NotNull ByteBuffer $this$shiftDataLeft, int startPos, int endPos, int numBytes) {
        Intrinsics.checkNotNullParameter($this$shiftDataLeft, "<this>");
        int index = startPos;
        if (index <= endPos) {
            while (true) {
                $this$shiftDataLeft.put(index - numBytes, $this$shiftDataLeft.get(index));
                if (index == endPos) break;
                ++index;
            }
        }
    }

    public static final int compareToFromBeginning(@NotNull ByteBuffer $this$compareToFromBeginning, @NotNull ByteBuffer other) {
        Intrinsics.checkNotNullParameter($this$compareToFromBeginning, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        ByteBuffer byteBuffer = $this$compareToFromBeginning.duplicate().rewind();
        if (byteBuffer == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.nio.ByteBuffer");
        }
        ByteBuffer thisRewound = byteBuffer;
        ByteBuffer byteBuffer2 = other.duplicate().rewind();
        if (byteBuffer2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.nio.ByteBuffer");
        }
        ByteBuffer otherRewound = byteBuffer2;
        return thisRewound.compareTo(otherRewound);
    }

    @NotNull
    public static final ByteBuffer plus(@NotNull ByteBuffer $this$plus, @NotNull ByteBuffer other) {
        Intrinsics.checkNotNullParameter($this$plus, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        ByteBuffer newBuf = ByteBuffer.wrap(BufferPool.Companion.getGetArray().invoke($this$plus.limit() + other.limit()));
        newBuf.rewind();
        ByteBuffer byteBuffer = $this$plus.duplicate().rewind();
        if (byteBuffer == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.nio.ByteBuffer");
        }
        newBuf.put(byteBuffer);
        ByteBuffer byteBuffer2 = other.duplicate().rewind();
        if (byteBuffer2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.nio.ByteBuffer");
        }
        newBuf.put(byteBuffer2);
        newBuf.flip();
        Intrinsics.checkNotNullExpressionValue(newBuf, "newBuf");
        return newBuf;
    }

    static {
        char[] cArray = "0123456789ABCDEF".toCharArray();
        Intrinsics.checkNotNullExpressionValue(cArray, "this as java.lang.String).toCharArray()");
        HEX_CHARS = cArray;
    }
}

