/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.rtp.rtcp.rtcpfb.transport_layer_fb.tcc;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.rtp.extensions.bytearray.ByteArrayExtensionsKt;
import org.jitsi.rtp.rtcp.RtcpHeaderBuilder;
import org.jitsi.rtp.rtcp.rtcpfb.RtcpFbPacket;
import org.jitsi.rtp.rtcp.rtcpfb.transport_layer_fb.tcc.LastChunk;
import org.jitsi.rtp.rtcp.rtcpfb.transport_layer_fb.tcc.PacketReport;
import org.jitsi.rtp.rtcp.rtcpfb.transport_layer_fb.tcc.ReceivedPacketReport;
import org.jitsi.rtp.rtcp.rtcpfb.transport_layer_fb.tcc.RtcpFbTccPacket;
import org.jitsi.rtp.rtp.RtpSequenceNumber;
import org.jitsi.rtp.rtp.RtpSequenceNumberKt;
import org.jitsi.rtp.util.BufferPool;
import org.jitsi.rtp.util.RtpUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0014\u0010\"\u001a\u00020#2\n\u0010$\u001a\u00060\u0007j\u0002`%H\u0002J\u0016\u0010&\u001a\u00020#2\u0006\u0010'\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\u0005J\u0006\u0010)\u001a\u00020\u0005J\u0016\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\u0005J\u0006\u0010.\u001a\u00020/J\u0006\u00100\u001a\u00020+J\u0016\u00101\u001a\u00020+2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u0007R)\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0010\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001e\u0010\u001b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\rR\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u00065"}, d2={"Lorg/jitsi/rtp/rtcp/rtcpfb/transport_layer_fb/tcc/RtcpFbTccPacketBuilder;", "", "rtcpHeader", "Lorg/jitsi/rtp/rtcp/RtcpHeaderBuilder;", "mediaSourceSsrc", "", "feedbackPacketSeqNum", "", "(Lorg/jitsi/rtp/rtcp/RtcpHeaderBuilder;JI)V", "<set-?>", "Lorg/jitsi/rtp/rtp/RtpSequenceNumber;", "base_seq_no_", "getBase_seq_no_-Y2GOy3c", "()I", "I", "base_time_ticks_", "encoded_chunks_", "", "Lorg/jitsi/rtp/rtcp/rtcpfb/transport_layer_fb/tcc/Chunk;", "getFeedbackPacketSeqNum", "last_chunk_", "Lorg/jitsi/rtp/rtcp/rtcpfb/transport_layer_fb/tcc/LastChunk;", "last_timestamp_us_", "getMediaSourceSsrc", "()J", "setMediaSourceSsrc", "(J)V", "num_seq_no_", "getNum_seq_no_", "packets_", "Lorg/jitsi/rtp/rtcp/rtcpfb/transport_layer_fb/tcc/PacketReport;", "getRtcpHeader", "()Lorg/jitsi/rtp/rtcp/RtcpHeaderBuilder;", "size_bytes_", "AddDeltaSize", "", "deltaSize", "Lorg/jitsi/rtp/rtcp/rtcpfb/transport_layer_fb/tcc/DeltaSize;", "AddReceivedPacket", "seqNum", "timestamp_us", "GetBaseTimeUs", "SetBase", "", "base_sequence", "ref_timestamp_us", "build", "Lorg/jitsi/rtp/rtcp/rtcpfb/transport_layer_fb/tcc/RtcpFbTccPacket;", "clear", "writeTo", "buf", "", "offset", "rtp"})
@SuppressFBWarnings(value={"NM_METHOD_NAMING_CONVENTION"}, justification="This class is a port and use the original names.")
public final class RtcpFbTccPacketBuilder {
    @NotNull
    private final RtcpHeaderBuilder rtcpHeader;
    private long mediaSourceSsrc;
    private final int feedbackPacketSeqNum;
    private int base_seq_no_;
    private long base_time_ticks_;
    private int num_seq_no_;
    @NotNull
    private LastChunk last_chunk_;
    @NotNull
    private final List<Integer> encoded_chunks_;
    private int size_bytes_;
    private long last_timestamp_us_;
    @NotNull
    private final List<PacketReport> packets_;

    public RtcpFbTccPacketBuilder(@NotNull RtcpHeaderBuilder rtcpHeader, long mediaSourceSsrc, int feedbackPacketSeqNum) {
        Intrinsics.checkNotNullParameter(rtcpHeader, "rtcpHeader");
        this.rtcpHeader = rtcpHeader;
        this.mediaSourceSsrc = mediaSourceSsrc;
        this.feedbackPacketSeqNum = feedbackPacketSeqNum;
        this.base_seq_no_ = RtpSequenceNumber.Companion.getINVALID-Y2GOy3c();
        this.base_time_ticks_ = -1L;
        this.last_chunk_ = new LastChunk();
        this.encoded_chunks_ = new ArrayList();
        this.size_bytes_ = 20;
        this.packets_ = new ArrayList();
    }

    public /* synthetic */ RtcpFbTccPacketBuilder(RtcpHeaderBuilder rtcpHeaderBuilder, long l, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            rtcpHeaderBuilder = new RtcpHeaderBuilder(0, false, 0, 0, 0, 0L, 63, null);
        }
        if ((n2 & 2) != 0) {
            l = -1L;
        }
        if ((n2 & 4) != 0) {
            n = -1;
        }
        this(rtcpHeaderBuilder, l, n);
    }

    @NotNull
    public final RtcpHeaderBuilder getRtcpHeader() {
        return this.rtcpHeader;
    }

    public final long getMediaSourceSsrc() {
        return this.mediaSourceSsrc;
    }

    public final void setMediaSourceSsrc(long l) {
        this.mediaSourceSsrc = l;
    }

    public final int getFeedbackPacketSeqNum() {
        return this.feedbackPacketSeqNum;
    }

    public final int getBase_seq_no_-Y2GOy3c() {
        return this.base_seq_no_;
    }

    public final int getNum_seq_no_() {
        return this.num_seq_no_;
    }

    public final void SetBase(int base_sequence, long ref_timestamp_us) {
        this.base_seq_no_ = RtpSequenceNumberKt.toRtpSequenceNumber(base_sequence);
        this.base_time_ticks_ = ref_timestamp_us % 0xFA00000000L / (long)64000;
        this.last_timestamp_us_ = this.GetBaseTimeUs();
    }

    public final boolean AddReceivedPacket(int seqNum2, long timestamp_us) {
        int delta_size;
        int sequence_number = RtpSequenceNumberKt.toRtpSequenceNumber(seqNum2);
        long delta_full = (timestamp_us - this.last_timestamp_us_) % 0xFA00000000L;
        if (delta_full > 0x7D00000000L) {
            delta_full -= 0xFA00000000L;
        }
        delta_full += (long)(delta_full < 0L ? -125 : 125);
        short delta = (short)(delta_full /= (long)250);
        if ((long)delta != delta_full) {
            return false;
        }
        int next_seq_no = RtpSequenceNumber.plus-MMyMW7M(this.base_seq_no_, this.num_seq_no_);
        if (!RtpSequenceNumber.equals-impl0(sequence_number, next_seq_no)) {
            int lastSeqNo = RtpSequenceNumber.minus-MMyMW7M(next_seq_no, 1);
            if (RtpSequenceNumber.compareTo-m4k8pQA(sequence_number, lastSeqNo) <= 0) {
                return false;
            }
            while (!RtpSequenceNumber.equals-impl0(next_seq_no, sequence_number)) {
                if (!this.AddDeltaSize(0)) {
                    return false;
                }
                next_seq_no = RtpSequenceNumber.plus-MMyMW7M(next_seq_no, 1);
            }
        }
        int n = delta_size = delta >= 0 && delta <= 255 ? 1 : 2;
        if (!this.AddDeltaSize(delta_size)) {
            return false;
        }
        this.packets_.add(new ReceivedPacketReport(sequence_number, delta));
        this.last_timestamp_us_ += (long)(delta * 250);
        this.size_bytes_ += delta_size;
        return true;
    }

    public final long GetBaseTimeUs() {
        return this.base_time_ticks_ * (long)64000;
    }

    private final boolean AddDeltaSize(int deltaSize) {
        int add_chunk_size;
        if (this.num_seq_no_ == 65535) {
            return false;
        }
        int n = add_chunk_size = this.last_chunk_.Empty() ? 2 : 0;
        if (this.size_bytes_ + deltaSize + add_chunk_size > 1200) {
            return false;
        }
        if (this.last_chunk_.CanAdd(deltaSize)) {
            this.size_bytes_ += add_chunk_size;
            this.last_chunk_.Add(deltaSize);
            ++this.num_seq_no_;
            return true;
        }
        if (this.size_bytes_ + deltaSize + 2 > 1200) {
            return false;
        }
        this.encoded_chunks_.add(this.last_chunk_.Emit());
        this.size_bytes_ += 2;
        this.last_chunk_.Add(deltaSize);
        ++this.num_seq_no_;
        return true;
    }

    @NotNull
    public final RtcpFbTccPacket build() {
        int packetSize = this.size_bytes_ + RtpUtils.Companion.getNumPaddingBytes(this.size_bytes_);
        byte[] buf = BufferPool.Companion.getGetArray().invoke(packetSize);
        this.writeTo(buf, 0);
        return new RtcpFbTccPacket(buf, 0, packetSize);
    }

    public final void writeTo(@NotNull byte[] buf, int offset) {
        RtcpHeaderBuilder rtcpHeaderBuilder;
        Intrinsics.checkNotNullParameter(buf, "buf");
        int paddingBytes = RtpUtils.Companion.getNumPaddingBytes(this.size_bytes_);
        RtcpHeaderBuilder $this$writeTo_u24lambda_u2d0 = rtcpHeaderBuilder = this.rtcpHeader;
        boolean bl = false;
        $this$writeTo_u24lambda_u2d0.setPacketType(205);
        $this$writeTo_u24lambda_u2d0.setReportCount(15);
        $this$writeTo_u24lambda_u2d0.setLength(RtpUtils.Companion.calculateRtcpLengthFieldValue(this.size_bytes_ + paddingBytes));
        rtcpHeaderBuilder.writeTo(buf, offset);
        RtcpFbPacket.Companion.setMediaSourceSsrc(buf, offset, this.mediaSourceSsrc);
        RtcpFbTccPacket.Companion.setBaseSeqNum(buf, offset, this.base_seq_no_);
        RtcpFbTccPacket.Companion.setPacketStatusCount(buf, offset, this.num_seq_no_);
        RtcpFbTccPacket.Companion.setReferenceTimeTicks(buf, offset, (int)this.base_time_ticks_);
        RtcpFbTccPacket.Companion.setFeedbackPacketCount(buf, offset, this.feedbackPacketSeqNum);
        int currOffset = 0;
        currOffset = 20;
        Iterable $this$forEach$iv = this.encoded_chunks_;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int it = ((Number)element$iv).intValue();
            boolean bl2 = false;
            ByteArrayExtensionsKt.putShort(buf, currOffset, (short)it);
            currOffset += 2;
        }
        if (!this.last_chunk_.Empty()) {
            int chunk = this.last_chunk_.EncodeLast();
            ByteArrayExtensionsKt.putShort(buf, currOffset, (short)chunk);
            currOffset += 2;
        }
        $this$forEach$iv = this.packets_;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PacketReport it = (PacketReport)element$iv;
            boolean bl3 = false;
            if (!(it instanceof ReceivedPacketReport)) continue;
            int n = ((ReceivedPacketReport)it).getDeltaTicks();
            boolean bl4 = 0 <= n ? n < 256 : false;
            if (bl4) {
                n = currOffset;
                currOffset = n + 1;
                buf[n] = (byte)((ReceivedPacketReport)it).getDeltaTicks();
                continue;
            }
            ByteArrayExtensionsKt.putShort(buf, currOffset, ((ReceivedPacketReport)it).getDeltaTicks());
            currOffset += 2;
        }
        int n = 0;
        while (n < paddingBytes) {
            int it = n++;
            boolean bl5 = false;
            int n2 = currOffset;
            currOffset = n2 + 1;
            buf[n2] = 0;
        }
    }

    public final void clear() {
        this.num_seq_no_ = 0;
        this.size_bytes_ = 20;
    }

    public RtcpFbTccPacketBuilder() {
        this(null, 0L, 0, 7, null);
    }
}

