/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.stats;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerImpl;
import org.jitsi.xmpp.extensions.colibri.ColibriStatsExtension;

public abstract class Statistics {
    private static final Logger logger = new LoggerImpl(Statistics.class.getName());
    protected final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Map<String, Object> stats = new HashMap<String, Object>();

    public static ColibriStatsExtension toXmppExtensionElement(Statistics statistics) {
        ColibriStatsExtension ext = new ColibriStatsExtension();
        for (Map.Entry<String, Object> e : statistics.getStats().entrySet()) {
            ext.addStat(new ColibriStatsExtension.Stat(e.getKey(), e.getValue()));
        }
        return ext;
    }

    public static ColibriStatsExtension toXmppExtensionElementFiltered(Statistics statistics, List<String> whitelist) {
        ColibriStatsExtension ext = new ColibriStatsExtension();
        Map<String, Object> m3 = statistics.getStats();
        whitelist.forEach(k -> {
            Object v = m3.get(k);
            if (v != null) {
                ext.addStat(new ColibriStatsExtension.Stat((String)k, v));
            }
        });
        return ext;
    }

    public abstract void generate();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getStat(String stat) {
        Object value2;
        Lock lock = this.lock.readLock();
        lock.lock();
        try {
            value2 = this.stats.get(stat);
        }
        finally {
            lock.unlock();
        }
        return value2;
    }

    public double getStatAsDouble(String stat) {
        double d;
        Object o = this.getStat(stat);
        double defaultValue = 0.0;
        if (o == null) {
            d = defaultValue;
        } else if (o instanceof Number) {
            d = ((Number)o).floatValue();
        } else {
            String s2 = o.toString();
            if (s2 == null || s2.length() == 0) {
                d = defaultValue;
            } else {
                try {
                    d = Double.parseDouble(s2);
                }
                catch (NumberFormatException nfe) {
                    d = defaultValue;
                }
            }
        }
        return d;
    }

    public float getStatAsFloat(String stat) {
        float f;
        Object o = this.getStat(stat);
        float defaultValue = 0.0f;
        if (o == null) {
            f = defaultValue;
        } else if (o instanceof Number) {
            f = ((Number)o).floatValue();
        } else {
            String s2 = o.toString();
            if (s2 == null || s2.length() == 0) {
                f = defaultValue;
            } else {
                try {
                    f = Float.parseFloat(s2);
                }
                catch (NumberFormatException nfe) {
                    f = defaultValue;
                }
            }
        }
        return f;
    }

    public int getStatAsInt(String stat) {
        int i;
        Object o = this.getStat(stat);
        int defaultValue = 0;
        if (o == null) {
            i = defaultValue;
        } else if (o instanceof Number) {
            i = ((Number)o).intValue();
        } else {
            String s2 = o.toString();
            if (s2 == null || s2.length() == 0) {
                i = defaultValue;
            } else {
                try {
                    i = Integer.parseInt(s2);
                }
                catch (NumberFormatException nfe) {
                    i = defaultValue;
                }
            }
        }
        return i;
    }

    public Map<String, Object> getStats() {
        HashMap<String, Object> stats;
        Lock lock = this.lock.readLock();
        lock.lock();
        try {
            stats = new HashMap<String, Object>(this.stats);
        }
        finally {
            lock.unlock();
        }
        return stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStat(String stat, Object value2) {
        Lock lock = this.lock.writeLock();
        lock.lock();
        try {
            this.unlockedSetStat(stat, value2);
        }
        finally {
            lock.unlock();
        }
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder();
        for (Map.Entry<String, Object> e : this.getStats().entrySet()) {
            s2.append(e.getKey()).append(":").append(e.getValue()).append("\n");
        }
        return s2.toString();
    }

    protected void unlockedSetStat(String stat, Object value2) {
        if (value2 instanceof AtomicLong || value2 instanceof AtomicInteger) {
            logger.warn(() -> "Using an Atomic number as a stat for " + stat + ", probably not what we want");
        }
        if (value2 == null) {
            this.stats.remove(stat);
        } else {
            this.stats.put(stat, value2);
        }
    }
}

