/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.stats;

import java.lang.management.ManagementFactory;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.locks.Lock;
import org.jetbrains.annotations.NotNull;
import org.jitsi.metrics.BooleanMetric;
import org.jitsi.metrics.InfoMetric;
import org.jitsi.nlj.rtcp.RembHandler;
import org.jitsi.nlj.stats.EndpointConnectionStats;
import org.jitsi.nlj.stats.PacketStreamStats;
import org.jitsi.nlj.stats.TransceiverStats;
import org.jitsi.nlj.transform.node.incoming.IncomingSsrcStats;
import org.jitsi.nlj.transform.node.incoming.IncomingStatisticsSnapshot;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.Endpoint;
import org.jitsi.videobridge.EndpointConnectionStatusMonitor;
import org.jitsi.videobridge.Videobridge;
import org.jitsi.videobridge.load_management.JvbLoadManager;
import org.jitsi.videobridge.metrics.VideobridgeMetricsContainer;
import org.jitsi.videobridge.relay.Relay;
import org.jitsi.videobridge.relay.RelayConfig;
import org.jitsi.videobridge.shutdown.ShutdownState;
import org.jitsi.videobridge.stats.Statistics;
import org.jitsi.videobridge.transport.ice.IceTransport;
import org.jitsi.videobridge.xmpp.XmppConnection;
import org.json.simple.JSONArray;

public class VideobridgeStatistics
extends Statistics {
    private final DateFormat timestampFormat;
    private static final int CONFERENCE_SIZE_BUCKETS = 22;
    private static final InfoMetric regionInfo = RelayConfig.config.getRegion() != null ? VideobridgeMetricsContainer.getInstance().registerInfo("region", "The currently configured region.", RelayConfig.config.getRegion()) : null;
    private static final String relayId = RelayConfig.config.getEnabled() ? RelayConfig.config.getRelayId() : null;
    public static final String EPS_NO_MSG_TRANSPORT_AFTER_DELAY = "num_eps_no_msg_transport_after_delay";
    public static final String TOTAL_ICE_SUCCEEDED_RELAYED = "total_ice_succeeded_relayed";
    public static final String MUC_CLIENTS_CONFIGURED = "muc_clients_configured";
    public static final String MUC_CLIENTS_CONNECTED = "muc_clients_connected";
    public static final String MUCS_CONFIGURED = "mucs_configured";
    public static final String MUCS_JOINED = "mucs_joined";
    public static final String INCOMING_LOSS = "incoming_loss";
    public static final String OUTGOING_LOSS = "outgoing_loss";
    private static final String TOTAL_AIMD_BWE_EXPIRATIONS = "total_aimd_bwe_expirations";
    public static final String OVERALL_LOSS = "overall_loss";
    private boolean inGenerate = false;
    @NotNull
    private final Videobridge videobridge;
    @NotNull
    private final XmppConnection xmppConnection;
    private final BooleanMetric healthy = VideobridgeMetricsContainer.getInstance().registerBooleanMetric("healthy", "Whether the Videobridge instance is healthy or not.", true);

    public VideobridgeStatistics(@NotNull Videobridge videobridge, @NotNull XmppConnection xmppConnection) {
        this.videobridge = videobridge;
        this.xmppConnection = xmppConnection;
        this.timestampFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        this.timestampFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.unlockedSetStat("bit_rate_download", 0);
        this.unlockedSetStat("bit_rate_upload", 0);
        this.unlockedSetStat("conferences", 0);
        this.unlockedSetStat("participants", 0);
        this.unlockedSetStat("threads", 0);
        this.unlockedSetStat("videochannels", 0);
        this.unlockedSetStat("jitter_aggregate", 0.0);
        this.unlockedSetStat("rtt_aggregate", 0.0);
        this.unlockedSetStat("largest_conference", 0);
        this.unlockedSetStat("conference_sizes", "[]");
        this.unlockedSetStat("current_timestamp", this.timestampFormat.format(new Date()));
        this.unlockedSetStat("healthy", this.healthy.setAndGet(videobridge.getJvbHealthChecker().getResult() == null));
        this.unlockedSetStat("version", videobridge.getVersion().toString());
        String releaseId = videobridge.getReleaseId();
        if (releaseId != null) {
            this.unlockedSetStat("release", releaseId);
        }
        if (regionInfo != null) {
            this.unlockedSetStat("region", regionInfo.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate() {
        boolean inGenerate;
        Lock lock = this.lock.writeLock();
        lock.lock();
        try {
            if (this.inGenerate) {
                inGenerate = true;
            } else {
                inGenerate = false;
                this.inGenerate = true;
            }
        }
        finally {
            lock.unlock();
        }
        if (!inGenerate) {
            try {
                this.generate0();
            }
            finally {
                lock.lock();
                try {
                    this.inGenerate = false;
                }
                finally {
                    lock.unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generate0() {
        Videobridge.Statistics jvbStats = this.videobridge.getStatistics();
        int videoChannels = 0;
        int octoConferences = 0;
        int endpoints = 0;
        int localEndpoints = 0;
        int octoEndpoints = 0;
        double bitrateDownloadBps = 0.0;
        double bitrateUploadBps = 0.0;
        long packetRateUpload = 0L;
        long packetRateDownload = 0L;
        double relayBitrateIncomingBps = 0.0;
        double relayBitrateOutgoingBps = 0.0;
        long relayPacketRateOutgoing = 0L;
        long relayPacketRateIncoming = 0L;
        long incomingPacketsReceived = 0L;
        long incomingPacketsLost = 0L;
        long outgoingPacketsReceived = 0L;
        long outgoingPacketsLost = 0L;
        double jitterSumMs = 0.0;
        int jitterCount = 0;
        double rttSumMs = 0.0;
        long rttCount = 0L;
        int largestConferenceSize = 0;
        int[] conferenceSizes = new int[22];
        int[] audioSendersBuckets = new int[22];
        int[] videoSendersBuckets = new int[22];
        int inactiveConferences = 0;
        int p2pConferences = 0;
        int inactiveEndpoints = 0;
        int receiveOnlyEndpoints = 0;
        int numAudioSenders = 0;
        int numVideoSenders = 0;
        int numOversending = 0;
        int endpointsWithHighOutgoingLoss = 0;
        int numLocalActiveEndpoints = 0;
        int endpointsWithSuspendedSources = 0;
        for (Conference conference : this.videobridge.getConferences()) {
            boolean inactive;
            if (conference.isP2p()) {
                ++p2pConferences;
            }
            if (inactive = conference.isInactive()) {
                ++inactiveConferences;
                inactiveEndpoints += conference.getEndpointCount();
            } else {
                numLocalActiveEndpoints += conference.getLocalEndpointCount();
            }
            if (conference.hasRelays()) {
                ++octoConferences;
            }
            int numConferenceEndpoints = conference.getEndpointCount();
            int numLocalEndpoints = conference.getLocalEndpointCount();
            localEndpoints += numLocalEndpoints;
            if (numConferenceEndpoints > largestConferenceSize) {
                largestConferenceSize = numConferenceEndpoints;
            }
            VideobridgeStatistics.updateBuckets(conferenceSizes, numConferenceEndpoints);
            endpoints += numConferenceEndpoints;
            octoEndpoints += numConferenceEndpoints - numLocalEndpoints;
            int conferenceAudioSenders = 0;
            int conferenceVideoSenders = 0;
            for (Endpoint endpoint : conference.getLocalEndpoints()) {
                double endpointOutgoingFractionLost;
                if (endpoint.getAcceptVideo()) {
                    ++videoChannels;
                }
                if (endpoint.isOversending()) {
                    ++numOversending;
                }
                boolean sendingAudio = endpoint.isSendingAudio();
                boolean sendingVideo = endpoint.isSendingVideo();
                if (sendingAudio) {
                    ++conferenceAudioSenders;
                }
                if (sendingVideo) {
                    ++conferenceVideoSenders;
                }
                if (!(sendingAudio || sendingVideo || inactive)) {
                    ++receiveOnlyEndpoints;
                }
                if (endpoint.hasSuspendedSources()) {
                    ++endpointsWithSuspendedSources;
                }
                TransceiverStats transceiverStats = endpoint.getTransceiver().getTransceiverStats();
                IncomingStatisticsSnapshot incomingStats = transceiverStats.getRtpReceiverStats().getIncomingStats();
                PacketStreamStats.Snapshot incomingPacketStreamStats = transceiverStats.getRtpReceiverStats().getPacketStreamStats();
                bitrateDownloadBps += incomingPacketStreamStats.getBitrateBps();
                packetRateDownload += incomingPacketStreamStats.getPacketRate();
                for (IncomingSsrcStats.Snapshot ssrcStats : incomingStats.getSsrcStats().values()) {
                    double ssrcJitter = ssrcStats.getJitter();
                    if (ssrcJitter == 0.0) continue;
                    jitterSumMs += Math.abs(ssrcJitter);
                    ++jitterCount;
                }
                PacketStreamStats.Snapshot outgoingStats = transceiverStats.getOutgoingPacketStreamStats();
                bitrateUploadBps += outgoingStats.getBitrateBps();
                packetRateUpload += outgoingStats.getPacketRate();
                EndpointConnectionStats.Snapshot endpointConnectionStats = transceiverStats.getEndpointConnectionStats();
                double endpointRtt = endpointConnectionStats.getRtt();
                if (endpointRtt > 0.0) {
                    rttSumMs += endpointRtt;
                    ++rttCount;
                }
                incomingPacketsReceived += endpointConnectionStats.getIncomingLossStats().getPacketsReceived();
                incomingPacketsLost += endpointConnectionStats.getIncomingLossStats().getPacketsLost();
                long endpointOutgoingPacketsReceived = endpointConnectionStats.getOutgoingLossStats().getPacketsReceived();
                long endpointOutgoingPacketsLost = endpointConnectionStats.getOutgoingLossStats().getPacketsLost();
                outgoingPacketsReceived += endpointOutgoingPacketsReceived;
                outgoingPacketsLost += endpointOutgoingPacketsLost;
                if (inactive || endpointOutgoingPacketsLost + endpointOutgoingPacketsReceived <= 0L || !((endpointOutgoingFractionLost = (double)endpointOutgoingPacketsLost / (double)(endpointOutgoingPacketsLost + endpointOutgoingPacketsReceived)) > 0.1)) continue;
                ++endpointsWithHighOutgoingLoss;
            }
            for (Relay relay : conference.getRelays()) {
                relayBitrateIncomingBps += relay.getIncomingBitrateBps();
                relayPacketRateIncoming += relay.getIncomingPacketRate();
                relayBitrateOutgoingBps += relay.getOutgoingBitrateBps();
                relayPacketRateOutgoing += relay.getOutgoingPacketRate();
            }
            VideobridgeStatistics.updateBuckets(audioSendersBuckets, conferenceAudioSenders);
            numAudioSenders += conferenceAudioSenders;
            VideobridgeStatistics.updateBuckets(videoSendersBuckets, conferenceVideoSenders);
            numVideoSenders += conferenceVideoSenders;
        }
        double jitterAggregate = jitterCount > 0 ? jitterSumMs / (double)jitterCount : 0.0;
        double rttAggregate = rttCount > 0L ? rttSumMs / (double)rttCount : 0.0;
        JSONArray conferenceSizesJson = new JSONArray();
        for (int size : conferenceSizes) {
            conferenceSizesJson.add(size);
        }
        JSONArray audioSendersJson = new JSONArray();
        for (int n : audioSendersBuckets) {
            audioSendersJson.add(n);
        }
        JSONArray videoSendersJson = new JSONArray();
        for (int n : videoSendersBuckets) {
            videoSendersJson.add(n);
        }
        int threadCount = ManagementFactory.getThreadMXBean().getThreadCount();
        double incomingLoss = 0.0;
        if (incomingPacketsReceived + incomingPacketsLost > 0L) {
            incomingLoss = (double)incomingPacketsLost / (double)(incomingPacketsReceived + incomingPacketsLost);
        }
        double outgoingLoss = 0.0;
        if (outgoingPacketsReceived + outgoingPacketsLost > 0L) {
            outgoingLoss = (double)outgoingPacketsLost / (double)(outgoingPacketsReceived + outgoingPacketsLost);
        }
        double overallLoss = 0.0;
        if (incomingPacketsReceived + incomingPacketsLost + outgoingPacketsReceived + outgoingPacketsLost > 0L) {
            overallLoss = (double)(outgoingPacketsLost + incomingPacketsLost) / (double)(incomingPacketsReceived + incomingPacketsLost + outgoingPacketsReceived + outgoingPacketsLost);
        }
        Lock lock = this.lock.writeLock();
        lock.lock();
        try {
            this.unlockedSetStat(INCOMING_LOSS, incomingLoss);
            this.unlockedSetStat(OUTGOING_LOSS, outgoingLoss);
            this.unlockedSetStat(OVERALL_LOSS, overallLoss);
            this.unlockedSetStat("endpoints_with_high_outgoing_loss", endpointsWithHighOutgoingLoss);
            this.unlockedSetStat("local_active_endpoints", numLocalActiveEndpoints);
            this.unlockedSetStat("bit_rate_download", bitrateDownloadBps / 1000.0);
            this.unlockedSetStat("bit_rate_upload", bitrateUploadBps / 1000.0);
            this.unlockedSetStat("packet_rate_download", packetRateDownload);
            this.unlockedSetStat("packet_rate_upload", packetRateUpload);
            this.unlockedSetStat(TOTAL_AIMD_BWE_EXPIRATIONS, jvbStats.incomingBitrateExpirations.get());
            this.unlockedSetStat("jitter_aggregate", jitterAggregate);
            this.unlockedSetStat("rtt_aggregate", rttAggregate);
            this.unlockedSetStat("total_failed_conferences", jvbStats.failedConferences.get());
            this.unlockedSetStat("total_partially_failed_conferences", jvbStats.partiallyFailedConferences.get());
            this.unlockedSetStat("total_conferences_created", jvbStats.conferencesCreated.get());
            this.unlockedSetStat("total_conferences_completed", jvbStats.conferencesCompleted.get());
            this.unlockedSetStat("total_ice_failed", IceTransport.Companion.getIceFailed().get());
            this.unlockedSetStat("total_ice_succeeded", IceTransport.Companion.getIceSucceeded().get());
            this.unlockedSetStat("total_ice_succeeded_tcp", IceTransport.Companion.getIceSucceededTcp().get());
            this.unlockedSetStat(TOTAL_ICE_SUCCEEDED_RELAYED, IceTransport.Companion.getIceSucceededRelayed().get());
            this.unlockedSetStat("total_conference_seconds", jvbStats.totalConferenceSeconds.get());
            this.unlockedSetStat("total_loss_controlled_participant_seconds", jvbStats.totalLossControlledParticipantMs.get() / 1000L);
            this.unlockedSetStat("total_loss_limited_participant_seconds", jvbStats.totalLossLimitedParticipantMs.get() / 1000L);
            this.unlockedSetStat("total_loss_degraded_participant_seconds", jvbStats.totalLossDegradedParticipantMs.get() / 1000L);
            this.unlockedSetStat("total_participants", jvbStats.totalEndpoints.get());
            this.unlockedSetStat("total_visitors", jvbStats.totalVisitors.get());
            this.unlockedSetStat(EPS_NO_MSG_TRANSPORT_AFTER_DELAY, jvbStats.numEndpointsNoMessageTransportAfterDelay.get());
            this.unlockedSetStat("total_relays", jvbStats.totalRelays.get());
            this.unlockedSetStat("num_relays_no_msg_transport_after_delay", jvbStats.numRelaysNoMessageTransportAfterDelay.get());
            this.unlockedSetStat("total_keyframes_received", jvbStats.keyframesReceived.get());
            this.unlockedSetStat("total_layering_changes_received", jvbStats.layeringChangesReceived.get());
            this.unlockedSetStat("total_video_stream_milliseconds_received", jvbStats.totalVideoStreamMillisecondsReceived.get());
            this.unlockedSetStat("stress_level", jvbStats.stressLevel);
            this.unlockedSetStat("average_participant_stress", JvbLoadManager.Companion.getAverageParticipantStress());
            this.unlockedSetStat("num_eps_oversending", numOversending);
            this.unlockedSetStat("conferences", jvbStats.currentConferences.get());
            this.unlockedSetStat("octo_conferences", octoConferences);
            this.unlockedSetStat("inactive_conferences", inactiveConferences);
            this.unlockedSetStat("p2p_conferences", p2pConferences);
            this.unlockedSetStat("endpoints", endpoints);
            this.unlockedSetStat("visitors", jvbStats.currentVisitors.get());
            this.unlockedSetStat("participants", endpoints);
            this.unlockedSetStat("local_endpoints", localEndpoints);
            this.unlockedSetStat("receive_only_endpoints", receiveOnlyEndpoints);
            this.unlockedSetStat("inactive_endpoints", inactiveEndpoints);
            this.unlockedSetStat("octo_endpoints", octoEndpoints);
            this.unlockedSetStat("endpoints_sending_audio", numAudioSenders);
            this.unlockedSetStat("endpoints_sending_video", numVideoSenders);
            this.unlockedSetStat("videochannels", videoChannels);
            this.unlockedSetStat("largest_conference", largestConferenceSize);
            this.unlockedSetStat("conference_sizes", conferenceSizesJson);
            this.unlockedSetStat("conferences_by_audio_senders", audioSendersJson);
            this.unlockedSetStat("conferences_by_video_senders", videoSendersJson);
            this.unlockedSetStat("threads", threadCount);
            this.unlockedSetStat("graceful_shutdown", this.videobridge.isInGracefulShutdown());
            if (this.videobridge.getShutdownState() == ShutdownState.SHUTTING_DOWN) {
                this.unlockedSetStat("shutting_down", true);
            }
            this.unlockedSetStat("drain", this.videobridge.getDrainMode());
            this.unlockedSetStat("total_data_channel_messages_received", jvbStats.dataChannelMessagesReceived.get());
            this.unlockedSetStat("total_data_channel_messages_sent", jvbStats.dataChannelMessagesSent.get());
            this.unlockedSetStat("total_colibri_web_socket_messages_received", jvbStats.colibriWebSocketMessagesReceived.get());
            this.unlockedSetStat("total_colibri_web_socket_messages_sent", jvbStats.colibriWebSocketMessagesSent.get());
            this.unlockedSetStat("total_bytes_received", jvbStats.totalBytesReceived.get());
            this.unlockedSetStat("dtls_failed_endpoints", jvbStats.endpointsDtlsFailed.get());
            this.unlockedSetStat("total_bytes_sent", jvbStats.totalBytesSent.get());
            this.unlockedSetStat("total_packets_received", jvbStats.packetsReceived.get());
            this.unlockedSetStat("total_packets_sent", jvbStats.packetsSent.get());
            this.unlockedSetStat("colibri2", true);
            this.unlockedSetStat("total_bytes_received_octo", jvbStats.totalRelayBytesReceived.get());
            this.unlockedSetStat("total_bytes_sent_octo", jvbStats.totalRelayBytesSent.get());
            this.unlockedSetStat("total_packets_received_octo", jvbStats.relayPacketsReceived.get());
            this.unlockedSetStat("total_packets_sent_octo", jvbStats.relayPacketsSent.get());
            this.unlockedSetStat("octo_receive_bitrate", relayBitrateIncomingBps);
            this.unlockedSetStat("octo_receive_packet_rate", relayPacketRateIncoming);
            this.unlockedSetStat("octo_send_bitrate", relayBitrateOutgoingBps);
            this.unlockedSetStat("octo_send_packet_rate", relayPacketRateOutgoing);
            this.unlockedSetStat("total_dominant_speaker_changes", jvbStats.dominantSpeakerChanges.get());
            this.unlockedSetStat("endpoints_with_suspended_sources", endpointsWithSuspendedSources);
            this.unlockedSetStat("current_timestamp", this.timestampFormat.format(new Date()));
            if (relayId != null) {
                this.unlockedSetStat("relay_id", relayId);
            }
            this.unlockedSetStat(MUC_CLIENTS_CONFIGURED, this.xmppConnection.getMucClientManager().getClientCount());
            this.unlockedSetStat(MUC_CLIENTS_CONNECTED, this.xmppConnection.getMucClientManager().getClientConnectedCount());
            this.unlockedSetStat(MUCS_CONFIGURED, this.xmppConnection.getMucClientManager().getMucCount());
            this.unlockedSetStat(MUCS_JOINED, this.xmppConnection.getMucClientManager().getMucJoinedCount());
            this.unlockedSetStat("preemptive_kfr_sent", jvbStats.preemptiveKeyframeRequestsSent.get());
            this.unlockedSetStat("preemptive_kfr_suppressed", jvbStats.preemptiveKeyframeRequestsSuppressed.get());
            this.unlockedSetStat("endpoints_with_spurious_remb", RembHandler.Companion.endpointsWithSpuriousRemb());
            this.unlockedSetStat("healthy", this.healthy.setAndGet(this.videobridge.getJvbHealthChecker().getResult() == null));
            this.unlockedSetStat("endpoints_disconnected", EndpointConnectionStatusMonitor.endpointsDisconnected.get());
            this.unlockedSetStat("endpoints_reconnected", EndpointConnectionStatusMonitor.endpointsReconnected.get());
        }
        finally {
            lock.unlock();
        }
    }

    private static void updateBuckets(int[] buckets, int n) {
        int index;
        int n2 = index = Math.min(n, buckets.length - 1);
        buckets[n2] = buckets[n2] + 1;
    }
}

