/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.colibri;

import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerImpl;
import org.jitsi.xmpp.extensions.AbstractPacketExtension;
import org.jitsi.xmpp.extensions.colibri.ColibriConferenceIQ;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.XmlStringBuilder;

public class ColibriStatsExtension
extends AbstractPacketExtension {
    private static final Logger logger = new LoggerImpl(ColibriConferenceIQ.class.getName());
    public static final String ELEMENT = "stats";
    public static final String NAMESPACE = "http://jitsi.org/protocol/colibri";
    public static final String BITRATE_DOWNLOAD = "bit_rate_download";
    public static final String BITRATE_UPLOAD = "bit_rate_upload";
    public static final String CONFERENCES = "conferences";
    public static final String OCTO_CONFERENCES = "octo_conferences";
    public static final String INACTIVE_CONFERENCES = "inactive_conferences";
    public static final String P2P_CONFERENCES = "p2p_conferences";
    public static final String CONFERENCE_SIZES = "conference_sizes";
    public static final String CONFERENCES_BY_AUDIO_SENDERS = "conferences_by_audio_senders";
    public static final String CONFERENCES_BY_VIDEO_SENDERS = "conferences_by_video_senders";
    public static final String CPU_USAGE = "cpu_usage";
    public static final String JITTER_AGGREGATE = "jitter_aggregate";
    public static final String LARGEST_CONFERENCE = "largest_conference";
    public static final String LOSS_RATE_DOWNLOAD = "loss_rate_download";
    public static final String LOSS_RATE_UPLOAD = "loss_rate_upload";
    public static final String OCTO_RECEIVE_BITRATE = "octo_receive_bitrate";
    public static final String OCTO_RECEIVE_PACKET_RATE = "octo_receive_packet_rate";
    public static final String OCTO_SEND_BITRATE = "octo_send_bitrate";
    public static final String OCTO_SEND_PACKET_RATE = "octo_send_packet_rate";
    public static final String PACKET_RATE_DOWNLOAD = "packet_rate_download";
    public static final String PACKET_RATE_UPLOAD = "packet_rate_upload";
    public static final String PARTICIPANTS = "participants";
    public static final String INACTIVE_ENDPOINTS = "inactive_endpoints";
    public static final String RECEIVE_ONLY_ENDPOINTS = "receive_only_endpoints";
    public static final String ENDPOINTS_SENDING_AUDIO = "endpoints_sending_audio";
    public static final String ENDPOINTS_SENDING_VIDEO = "endpoints_sending_video";
    public static final String OCTO_ENDPOINTS = "octo_endpoints";
    public static final String REGION = "region";
    public static final String RELAY_ID = "relay_id";
    public static final String RTP_LOSS = "rtp_loss";
    public static final String RTT_AGGREGATE = "rtt_aggregate";
    public static final String SHUTDOWN_IN_PROGRESS = "graceful_shutdown";
    public static final String DRAIN = "drain";
    public static final String SUPPORTS_SIP = "supports_sip";
    public static final String SUPPORTS_TRANSCRIPTION = "supports_transcription";
    public static final String THREADS = "threads";
    public static final String TIMESTAMP = "current_timestamp";
    public static final String TOTAL_BYTES_RECEIVED = "total_bytes_received";
    public static final String TOTAL_BYTES_RECEIVED_OCTO = "total_bytes_received_octo";
    public static final String TOTAL_BYTES_SENT = "total_bytes_sent";
    public static final String TOTAL_BYTES_SENT_OCTO = "total_bytes_sent_octo";
    public static final String TOTAL_COLIBRI_WEB_SOCKET_MESSAGES_RECEIVED = "total_colibri_web_socket_messages_received";
    public static final String TOTAL_COLIBRI_WEB_SOCKET_MESSAGES_SENT = "total_colibri_web_socket_messages_sent";
    public static final String TOTAL_CALLS_WITH_DROPPED_MEDIA = "total_calls_with_dropped_media";
    public static final String TOTAL_CONFERENCES_COMPLETED = "total_conferences_completed";
    public static final String TOTAL_CONFERENCES_CREATED = "total_conferences_created";
    public static final String TOTAL_CONFERENCE_SECONDS = "total_conference_seconds";
    public static final String TOTAL_DATA_CHANNEL_MESSAGES_RECEIVED = "total_data_channel_messages_received";
    public static final String TOTAL_DATA_CHANNEL_MESSAGES_SENT = "total_data_channel_messages_sent";
    public static final String TOTAL_FAILED_CONFERENCES = "total_failed_conferences";
    public static final String TOTAL_ICE_FAILED = "total_ice_failed";
    public static final String TOTAL_ICE_SUCCEEDED = "total_ice_succeeded";
    public static final String TOTAL_ICE_SUCCEEDED_TCP = "total_ice_succeeded_tcp";
    public static final String TOTAL_LOSS_CONTROLLED_PARTICIPANT_SECONDS = "total_loss_controlled_participant_seconds";
    public static final String TOTAL_LOSS_LIMITED_PARTICIPANT_SECONDS = "total_loss_limited_participant_seconds";
    public static final String TOTAL_LOSS_DEGRADED_PARTICIPANT_SECONDS = "total_loss_degraded_participant_seconds";
    public static final String TOTAL_MEMORY = "total_memory";
    public static final String TOTAL_PARTICIPANTS = "total_participants";
    public static final String TOTAL_PARTIALLY_FAILED_CONFERENCES = "total_partially_failed_conferences";
    public static final String TOTAL_PACKETS_DROPPED_OCTO = "total_packets_dropped_octo";
    public static final String TOTAL_PACKETS_RECEIVED = "total_packets_received";
    public static final String TOTAL_PACKETS_RECEIVED_OCTO = "total_packets_received_octo";
    public static final String TOTAL_PACKETS_SENT = "total_packets_sent";
    public static final String TOTAL_PACKETS_SENT_OCTO = "total_packets_sent_octo";
    public static final String USED_MEMORY = "used_memory";
    public static final String VERSION = "version";
    public static final String RELEASE = "release";
    public static final String VIDEO_CHANNELS = "videochannels";
    public static final String VIDEO_STREAMS = "videostreams";
    public static final String TOTAL_DOMINANT_SPEAKER_CHANGES = "total_dominant_speaker_changes";

    private static Integer getInt(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        String str = obj.toString();
        try {
            return Integer.valueOf(str);
        }
        catch (NumberFormatException e) {
            logger.error("Error parsing an int: " + obj);
            return null;
        }
    }

    public static ColibriStatsExtension clone(ColibriStatsExtension source) {
        ColibriStatsExtension destination = AbstractPacketExtension.clone(source);
        for (Stat stat : source.getChildExtensionsOfType(Stat.class)) {
            destination.addStat(Stat.clone(stat));
        }
        return destination;
    }

    public ColibriStatsExtension() {
        super(NAMESPACE, ELEMENT);
    }

    public void addStat(Stat stat) {
        this.addChildExtension(stat);
    }

    public void addStat(String name, Object value2) {
        this.addStat(new Stat(name, value2));
    }

    public Stat getStat(String name) {
        for (Stat stat : this.getChildExtensionsOfType(Stat.class)) {
            if (!stat.getName().equals(name)) continue;
            return stat;
        }
        return null;
    }

    public Object getValue(String name) {
        Stat stat = this.getStat(name);
        return stat == null ? null : stat.getValue();
    }

    public String getValueAsString(String name) {
        Object o = this.getValue(name);
        if (o != null) {
            return o instanceof String ? (String)o : o.toString();
        }
        return null;
    }

    public Integer getValueAsInt(String name) {
        return ColibriStatsExtension.getInt(this.getValue(name));
    }

    @Override
    public List<? extends ExtensionElement> getChildExtensions() {
        return Collections.unmodifiableList(super.getChildExtensions());
    }

    public static class Stat
    extends AbstractPacketExtension {
        public static final String ELEMENT = "stat";
        public static final QName QNAME = new QName("http://jitsi.org/protocol/colibri", "stat");
        public static final String NAME_ATTR_NAME = "name";
        public static final String VALUE_ATTR_NAME = "value";

        public Stat() {
            super(ColibriStatsExtension.NAMESPACE, ELEMENT);
        }

        public Stat(String name, Object value2) {
            this();
            this.setName(name);
            this.setValue(value2);
        }

        @Override
        public String getElementName() {
            return ELEMENT;
        }

        public String getName() {
            return this.getAttributeAsString(NAME_ATTR_NAME);
        }

        @Override
        public String getNamespace() {
            return ColibriStatsExtension.NAMESPACE;
        }

        public Object getValue() {
            return this.getAttribute(VALUE_ATTR_NAME);
        }

        public void setName(String name) {
            this.setAttribute(NAME_ATTR_NAME, name);
        }

        public void setValue(Object value2) {
            this.setAttribute(VALUE_ATTR_NAME, value2);
        }

        @Override
        public String toXML(XmlEnvironment enclosingNamespace) {
            String name = this.getName();
            Object value2 = this.getValue();
            if (name == null || value2 == null) {
                return "";
            }
            return new XmlStringBuilder().halfOpenElement(ELEMENT).attribute(NAME_ATTR_NAME, name).attribute(VALUE_ATTR_NAME, value2.toString()).closeEmptyElement().toString();
        }
    }
}

