/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.pcap4j.packet.Dot112040BssCoexistenceElement;
import org.pcap4j.packet.Dot11ChannelUsageElement;
import org.pcap4j.packet.Dot11DsssParameterSetElement;
import org.pcap4j.packet.Dot11ExtendedCapabilitiesElement;
import org.pcap4j.packet.Dot11ExtendedSupportedRatesElement;
import org.pcap4j.packet.Dot11FrameControl;
import org.pcap4j.packet.Dot11HTCapabilitiesElement;
import org.pcap4j.packet.Dot11HtControl;
import org.pcap4j.packet.Dot11InterworkingElement;
import org.pcap4j.packet.Dot11ManagementPacket;
import org.pcap4j.packet.Dot11MeshIdElement;
import org.pcap4j.packet.Dot11RequestElement;
import org.pcap4j.packet.Dot11SequenceControl;
import org.pcap4j.packet.Dot11SsidElement;
import org.pcap4j.packet.Dot11SsidListElement;
import org.pcap4j.packet.Dot11SupportedOperatingClassesElement;
import org.pcap4j.packet.Dot11SupportedRatesElement;
import org.pcap4j.packet.Dot11VendorSpecificElement;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.namednumber.Dot11InformationElementId;
import org.pcap4j.util.ByteArrays;
import org.pcap4j.util.MacAddress;

public final class Dot11ProbeRequestPacket
extends Dot11ManagementPacket {
    private static final long serialVersionUID = -2305355759191727871L;
    private final Dot11ProbeRequestHeader header;

    public static Dot11ProbeRequestPacket newPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        Dot11ProbeRequestHeader h2 = new Dot11ProbeRequestHeader(rawData, offset, length);
        return new Dot11ProbeRequestPacket(rawData, offset, length, h2);
    }

    private Dot11ProbeRequestPacket(byte[] rawData, int offset, int length, Dot11ProbeRequestHeader h2) {
        super(rawData, offset, length, h2.length());
        this.header = h2;
    }

    private static Dot11ProbeRequestPacket newPacket(Builder builder2) {
        Dot11ProbeRequestHeader h2 = new Dot11ProbeRequestHeader(builder2);
        return new Dot11ProbeRequestPacket(builder2, h2);
    }

    private Dot11ProbeRequestPacket(Builder builder2, Dot11ProbeRequestHeader h2) {
        super(builder2, h2);
        this.header = h2;
    }

    @Override
    public Dot11ProbeRequestHeader getHeader() {
        return this.header;
    }

    @Override
    public Builder getBuilder() {
        return new Builder(this);
    }

    public static final class Dot11ProbeRequestHeader
    extends Dot11ManagementPacket.Dot11ManagementHeader {
        private static final long serialVersionUID = -2203820242563461514L;
        private final Dot11SsidElement ssid;
        private final Dot11SupportedRatesElement supportedRates;
        private final Dot11RequestElement request;
        private final Dot11ExtendedSupportedRatesElement extendedSupportedRates;
        private final Dot11DsssParameterSetElement dsssParameterSet;
        private final Dot11SupportedOperatingClassesElement supportedOperatingClasses;
        private final Dot11HTCapabilitiesElement htCapabilities;
        private final Dot112040BssCoexistenceElement twentyFortyBssCoexistence;
        private final Dot11ExtendedCapabilitiesElement extendedCapabilities;
        private final Dot11SsidListElement ssidList;
        private final Dot11ChannelUsageElement channelUsage;
        private final Dot11InterworkingElement interworking;
        private final Dot11MeshIdElement meshId;
        private final List<Dot11VendorSpecificElement> vendorSpecificElements;

        private Dot11ProbeRequestHeader(byte[] rawData, int offset, int length) throws IllegalRawDataException {
            super(rawData, offset, length);
            int elemLen;
            int mgmtHeaderLen = super.calcLength();
            if ((length -= mgmtHeaderLen) > 0 && rawData[offset += mgmtHeaderLen] == (Byte)Dot11InformationElementId.SSID.value()) {
                this.ssid = Dot11SsidElement.newInstance(rawData, offset, length);
                elemLen = this.ssid.length();
                offset += elemLen;
                length -= elemLen;
            } else {
                this.ssid = null;
            }
            if (length > 0 && rawData[offset] == (Byte)Dot11InformationElementId.SUPPORTED_RATES.value()) {
                this.supportedRates = Dot11SupportedRatesElement.newInstance(rawData, offset, length);
                elemLen = this.supportedRates.length();
                offset += elemLen;
                length -= elemLen;
            } else {
                this.supportedRates = null;
            }
            if (length > 0 && rawData[offset] == (Byte)Dot11InformationElementId.REQUEST.value()) {
                this.request = Dot11RequestElement.newInstance(rawData, offset, length);
                elemLen = this.request.length();
                offset += elemLen;
                length -= elemLen;
            } else {
                this.request = null;
            }
            if (length > 0 && rawData[offset] == (Byte)Dot11InformationElementId.EXTENDED_SUPPORTED_RATES.value()) {
                this.extendedSupportedRates = Dot11ExtendedSupportedRatesElement.newInstance(rawData, offset, length);
                elemLen = this.extendedSupportedRates.length();
                offset += elemLen;
                length -= elemLen;
            } else {
                this.extendedSupportedRates = null;
            }
            if (length > 0 && rawData[offset] == (Byte)Dot11InformationElementId.DSSS_PARAMETER_SET.value()) {
                this.dsssParameterSet = Dot11DsssParameterSetElement.newInstance(rawData, offset, length);
                elemLen = this.dsssParameterSet.length();
                offset += elemLen;
                length -= elemLen;
            } else {
                this.dsssParameterSet = null;
            }
            if (length > 0 && rawData[offset] == (Byte)Dot11InformationElementId.SUPPORTED_OPERATING_CLASSES.value()) {
                this.supportedOperatingClasses = Dot11SupportedOperatingClassesElement.newInstance(rawData, offset, length);
                elemLen = this.supportedOperatingClasses.length();
                offset += elemLen;
                length -= elemLen;
            } else {
                this.supportedOperatingClasses = null;
            }
            if (length > 0 && rawData[offset] == (Byte)Dot11InformationElementId.HT_CAPABILITIES.value()) {
                this.htCapabilities = Dot11HTCapabilitiesElement.newInstance(rawData, offset, length);
                elemLen = this.htCapabilities.length();
                offset += elemLen;
                length -= elemLen;
            } else {
                this.htCapabilities = null;
            }
            if (length > 0 && rawData[offset] == (Byte)Dot11InformationElementId.IE_20_40_BSS_COEXISTENCE.value()) {
                this.twentyFortyBssCoexistence = Dot112040BssCoexistenceElement.newInstance(rawData, offset, length);
                elemLen = this.twentyFortyBssCoexistence.length();
                offset += elemLen;
                length -= elemLen;
            } else {
                this.twentyFortyBssCoexistence = null;
            }
            if (length > 0 && rawData[offset] == (Byte)Dot11InformationElementId.EXTENDED_CAPABILITIES.value()) {
                this.extendedCapabilities = Dot11ExtendedCapabilitiesElement.newInstance(rawData, offset, length);
                elemLen = this.extendedCapabilities.length();
                offset += elemLen;
                length -= elemLen;
            } else {
                this.extendedCapabilities = null;
            }
            if (length > 0 && rawData[offset] == (Byte)Dot11InformationElementId.SSID_LIST.value()) {
                this.ssidList = Dot11SsidListElement.newInstance(rawData, offset, length);
                elemLen = this.ssidList.length();
                offset += elemLen;
                length -= elemLen;
            } else {
                this.ssidList = null;
            }
            if (length > 0 && rawData[offset] == (Byte)Dot11InformationElementId.CHANNEL_USAGE.value()) {
                this.channelUsage = Dot11ChannelUsageElement.newInstance(rawData, offset, length);
                elemLen = this.channelUsage.length();
                offset += elemLen;
                length -= elemLen;
            } else {
                this.channelUsage = null;
            }
            if (length > 0 && rawData[offset] == (Byte)Dot11InformationElementId.INTERWORKING.value()) {
                this.interworking = Dot11InterworkingElement.newInstance(rawData, offset, length);
                elemLen = this.interworking.length();
                offset += elemLen;
                length -= elemLen;
            } else {
                this.interworking = null;
            }
            if (length > 0 && rawData[offset] == (Byte)Dot11InformationElementId.MESH_ID.value()) {
                this.meshId = Dot11MeshIdElement.newInstance(rawData, offset, length);
                elemLen = this.meshId.length();
                offset += elemLen;
                length -= elemLen;
            } else {
                this.meshId = null;
            }
            this.vendorSpecificElements = new ArrayList<Dot11VendorSpecificElement>();
            while (length > 0 && rawData[offset] == (Byte)Dot11InformationElementId.VENDOR_SPECIFIC.value()) {
                Dot11VendorSpecificElement elem = Dot11VendorSpecificElement.newInstance(rawData, offset, length);
                this.vendorSpecificElements.add(elem);
                int elemLen2 = elem.length();
                offset += elemLen2;
                length -= elemLen2;
            }
        }

        private Dot11ProbeRequestHeader(Builder builder2) {
            super(builder2);
            this.ssid = builder2.ssid;
            this.supportedRates = builder2.supportedRates;
            this.request = builder2.request;
            this.extendedSupportedRates = builder2.extendedSupportedRates;
            this.dsssParameterSet = builder2.dsssParameterSet;
            this.supportedOperatingClasses = builder2.supportedOperatingClasses;
            this.htCapabilities = builder2.htCapabilities;
            this.twentyFortyBssCoexistence = builder2.twentyFortyBssCoexistence;
            this.extendedCapabilities = builder2.extendedCapabilities;
            this.ssidList = builder2.ssidList;
            this.channelUsage = builder2.channelUsage;
            this.interworking = builder2.interworking;
            this.meshId = builder2.meshId;
            this.vendorSpecificElements = builder2.vendorSpecificElements == null ? Collections.emptyList() : new ArrayList<Dot11VendorSpecificElement>(builder2.vendorSpecificElements);
        }

        public Dot11SsidElement getSsid() {
            return this.ssid;
        }

        public Dot11SupportedRatesElement getSupportedRates() {
            return this.supportedRates;
        }

        public Dot11RequestElement getRequest() {
            return this.request;
        }

        public Dot11ExtendedSupportedRatesElement getExtendedSupportedRates() {
            return this.extendedSupportedRates;
        }

        public Dot11DsssParameterSetElement getDsssParameterSet() {
            return this.dsssParameterSet;
        }

        public Dot11SupportedOperatingClassesElement getSupportedOperatingClasses() {
            return this.supportedOperatingClasses;
        }

        public Dot11HTCapabilitiesElement getHtCapabilities() {
            return this.htCapabilities;
        }

        public Dot112040BssCoexistenceElement get2040BssCoexistence() {
            return this.twentyFortyBssCoexistence;
        }

        public Dot11ExtendedCapabilitiesElement getExtendedCapabilities() {
            return this.extendedCapabilities;
        }

        public Dot11SsidListElement getSsidList() {
            return this.ssidList;
        }

        public Dot11ChannelUsageElement getChannelUsage() {
            return this.channelUsage;
        }

        public Dot11InterworkingElement getInterworking() {
            return this.interworking;
        }

        public Dot11MeshIdElement getMeshId() {
            return this.meshId;
        }

        public List<Dot11VendorSpecificElement> getVendorSpecificElements() {
            return new ArrayList<Dot11VendorSpecificElement>(this.vendorSpecificElements);
        }

        @Override
        protected List<byte[]> getRawFields() {
            List<byte[]> rawFields = super.getRawFields();
            if (this.ssid != null) {
                rawFields.add(this.ssid.getRawData());
            }
            if (this.supportedRates != null) {
                rawFields.add(this.supportedRates.getRawData());
            }
            if (this.request != null) {
                rawFields.add(this.request.getRawData());
            }
            if (this.extendedSupportedRates != null) {
                rawFields.add(this.extendedSupportedRates.getRawData());
            }
            if (this.dsssParameterSet != null) {
                rawFields.add(this.dsssParameterSet.getRawData());
            }
            if (this.supportedOperatingClasses != null) {
                rawFields.add(this.supportedOperatingClasses.getRawData());
            }
            if (this.htCapabilities != null) {
                rawFields.add(this.htCapabilities.getRawData());
            }
            if (this.twentyFortyBssCoexistence != null) {
                rawFields.add(this.twentyFortyBssCoexistence.getRawData());
            }
            if (this.extendedCapabilities != null) {
                rawFields.add(this.extendedCapabilities.getRawData());
            }
            if (this.ssidList != null) {
                rawFields.add(this.ssidList.getRawData());
            }
            if (this.channelUsage != null) {
                rawFields.add(this.channelUsage.getRawData());
            }
            if (this.interworking != null) {
                rawFields.add(this.interworking.getRawData());
            }
            if (this.meshId != null) {
                rawFields.add(this.meshId.getRawData());
            }
            for (Dot11VendorSpecificElement elem : this.vendorSpecificElements) {
                rawFields.add(elem.getRawData());
            }
            return rawFields;
        }

        @Override
        public int calcLength() {
            int len = super.calcLength();
            if (this.ssid != null) {
                len += this.ssid.length();
            }
            if (this.supportedRates != null) {
                len += this.supportedRates.length();
            }
            if (this.request != null) {
                len += this.request.length();
            }
            if (this.extendedSupportedRates != null) {
                len += this.extendedSupportedRates.length();
            }
            if (this.dsssParameterSet != null) {
                len += this.dsssParameterSet.length();
            }
            if (this.supportedOperatingClasses != null) {
                len += this.supportedOperatingClasses.length();
            }
            if (this.htCapabilities != null) {
                len += this.htCapabilities.length();
            }
            if (this.twentyFortyBssCoexistence != null) {
                len += this.twentyFortyBssCoexistence.length();
            }
            if (this.extendedCapabilities != null) {
                len += this.extendedCapabilities.length();
            }
            if (this.ssidList != null) {
                len += this.ssidList.length();
            }
            if (this.channelUsage != null) {
                len += this.channelUsage.length();
            }
            if (this.interworking != null) {
                len += this.interworking.length();
            }
            if (this.meshId != null) {
                len += this.meshId.length();
            }
            for (Dot11VendorSpecificElement elem : this.vendorSpecificElements) {
                len += elem.length();
            }
            return len;
        }

        @Override
        protected String buildString() {
            StringBuilder sb = new StringBuilder();
            String ls = System.getProperty("line.separator");
            sb.append(super.buildString());
            sb.append("  Tags:").append(ls);
            if (this.ssid != null) {
                sb.append(this.ssid.toString("    "));
            }
            if (this.supportedRates != null) {
                sb.append(this.supportedRates.toString("    "));
            }
            if (this.request != null) {
                sb.append(this.request.toString("    "));
            }
            if (this.extendedSupportedRates != null) {
                sb.append(this.extendedSupportedRates.toString("    "));
            }
            if (this.dsssParameterSet != null) {
                sb.append(this.dsssParameterSet.toString("    "));
            }
            if (this.supportedOperatingClasses != null) {
                sb.append(this.supportedOperatingClasses.toString("    "));
            }
            if (this.htCapabilities != null) {
                sb.append(this.htCapabilities.toString("    "));
            }
            if (this.twentyFortyBssCoexistence != null) {
                sb.append(this.twentyFortyBssCoexistence.toString("    "));
            }
            if (this.extendedCapabilities != null) {
                sb.append(this.extendedCapabilities.toString("    "));
            }
            if (this.ssidList != null) {
                sb.append(this.ssidList.toString("    "));
            }
            if (this.channelUsage != null) {
                sb.append(this.channelUsage.toString("    "));
            }
            if (this.interworking != null) {
                sb.append(this.interworking.toString("    "));
            }
            if (this.meshId != null) {
                sb.append(this.meshId.toString("    "));
            }
            for (Dot11VendorSpecificElement elem : this.vendorSpecificElements) {
                sb.append(elem.toString("    "));
            }
            return sb.toString();
        }

        @Override
        protected String getHeaderName() {
            return "IEEE802.11 Probe Request header";
        }

        @Override
        protected int calcHashCode() {
            int prime = 31;
            int result2 = super.calcHashCode();
            result2 = 31 * result2 + (this.channelUsage == null ? 0 : this.channelUsage.hashCode());
            result2 = 31 * result2 + (this.dsssParameterSet == null ? 0 : this.dsssParameterSet.hashCode());
            result2 = 31 * result2 + (this.extendedCapabilities == null ? 0 : this.extendedCapabilities.hashCode());
            result2 = 31 * result2 + (this.extendedSupportedRates == null ? 0 : this.extendedSupportedRates.hashCode());
            result2 = 31 * result2 + (this.htCapabilities == null ? 0 : this.htCapabilities.hashCode());
            result2 = 31 * result2 + (this.interworking == null ? 0 : this.interworking.hashCode());
            result2 = 31 * result2 + (this.meshId == null ? 0 : this.meshId.hashCode());
            result2 = 31 * result2 + (this.request == null ? 0 : this.request.hashCode());
            result2 = 31 * result2 + (this.ssid == null ? 0 : this.ssid.hashCode());
            result2 = 31 * result2 + (this.ssidList == null ? 0 : this.ssidList.hashCode());
            result2 = 31 * result2 + (this.supportedOperatingClasses == null ? 0 : this.supportedOperatingClasses.hashCode());
            result2 = 31 * result2 + (this.supportedRates == null ? 0 : this.supportedRates.hashCode());
            result2 = 31 * result2 + (this.twentyFortyBssCoexistence == null ? 0 : this.twentyFortyBssCoexistence.hashCode());
            result2 = 31 * result2 + this.vendorSpecificElements.hashCode();
            return result2;
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            Dot11ProbeRequestHeader other = (Dot11ProbeRequestHeader)obj;
            if (this.channelUsage == null ? other.channelUsage != null : !this.channelUsage.equals(other.channelUsage)) {
                return false;
            }
            if (this.dsssParameterSet == null ? other.dsssParameterSet != null : !this.dsssParameterSet.equals(other.dsssParameterSet)) {
                return false;
            }
            if (this.extendedCapabilities == null ? other.extendedCapabilities != null : !this.extendedCapabilities.equals(other.extendedCapabilities)) {
                return false;
            }
            if (this.extendedSupportedRates == null ? other.extendedSupportedRates != null : !this.extendedSupportedRates.equals(other.extendedSupportedRates)) {
                return false;
            }
            if (this.htCapabilities == null ? other.htCapabilities != null : !this.htCapabilities.equals(other.htCapabilities)) {
                return false;
            }
            if (this.interworking == null ? other.interworking != null : !this.interworking.equals(other.interworking)) {
                return false;
            }
            if (this.meshId == null ? other.meshId != null : !this.meshId.equals(other.meshId)) {
                return false;
            }
            if (this.request == null ? other.request != null : !this.request.equals(other.request)) {
                return false;
            }
            if (this.ssid == null ? other.ssid != null : !this.ssid.equals(other.ssid)) {
                return false;
            }
            if (this.ssidList == null ? other.ssidList != null : !this.ssidList.equals(other.ssidList)) {
                return false;
            }
            if (this.supportedOperatingClasses == null ? other.supportedOperatingClasses != null : !this.supportedOperatingClasses.equals(other.supportedOperatingClasses)) {
                return false;
            }
            if (this.supportedRates == null ? other.supportedRates != null : !this.supportedRates.equals(other.supportedRates)) {
                return false;
            }
            if (this.twentyFortyBssCoexistence == null ? other.twentyFortyBssCoexistence != null : !this.twentyFortyBssCoexistence.equals(other.twentyFortyBssCoexistence)) {
                return false;
            }
            return this.vendorSpecificElements.equals(other.vendorSpecificElements);
        }
    }

    public static final class Builder
    extends Dot11ManagementPacket.Builder {
        private Dot11SsidElement ssid;
        private Dot11SupportedRatesElement supportedRates;
        private Dot11RequestElement request;
        private Dot11ExtendedSupportedRatesElement extendedSupportedRates;
        private Dot11DsssParameterSetElement dsssParameterSet;
        private Dot11SupportedOperatingClassesElement supportedOperatingClasses;
        private Dot11HTCapabilitiesElement htCapabilities;
        private Dot112040BssCoexistenceElement twentyFortyBssCoexistence;
        private Dot11ExtendedCapabilitiesElement extendedCapabilities;
        private Dot11SsidListElement ssidList;
        private Dot11ChannelUsageElement channelUsage;
        private Dot11InterworkingElement interworking;
        private Dot11MeshIdElement meshId;
        private List<Dot11VendorSpecificElement> vendorSpecificElements;

        public Builder() {
        }

        private Builder(Dot11ProbeRequestPacket packet) {
            super(packet);
            this.ssid = packet.header.ssid;
            this.supportedRates = packet.header.supportedRates;
            this.request = packet.header.request;
            this.extendedSupportedRates = packet.header.extendedSupportedRates;
            this.dsssParameterSet = packet.header.dsssParameterSet;
            this.supportedOperatingClasses = packet.header.supportedOperatingClasses;
            this.htCapabilities = packet.header.htCapabilities;
            this.twentyFortyBssCoexistence = packet.header.twentyFortyBssCoexistence;
            this.extendedCapabilities = packet.header.extendedCapabilities;
            this.ssidList = packet.header.ssidList;
            this.channelUsage = packet.header.channelUsage;
            this.interworking = packet.header.interworking;
            this.meshId = packet.header.meshId;
            this.vendorSpecificElements = packet.header.vendorSpecificElements;
        }

        public Builder ssid(Dot11SsidElement ssid) {
            this.ssid = ssid;
            return this;
        }

        public Builder supportedRates(Dot11SupportedRatesElement supportedRates) {
            this.supportedRates = supportedRates;
            return this;
        }

        public Builder request(Dot11RequestElement request) {
            this.request = request;
            return this;
        }

        public Builder extendedSupportedRates(Dot11ExtendedSupportedRatesElement extendedSupportedRates) {
            this.extendedSupportedRates = extendedSupportedRates;
            return this;
        }

        public Builder dsssParameterSet(Dot11DsssParameterSetElement dsssParameterSet) {
            this.dsssParameterSet = dsssParameterSet;
            return this;
        }

        public Builder supportedOperatingClasses(Dot11SupportedOperatingClassesElement supportedOperatingClasses) {
            this.supportedOperatingClasses = supportedOperatingClasses;
            return this;
        }

        public Builder htCapabilities(Dot11HTCapabilitiesElement htCapabilities) {
            this.htCapabilities = htCapabilities;
            return this;
        }

        public Builder twentyFortyBssCoexistence(Dot112040BssCoexistenceElement twentyFortyBssCoexistence) {
            this.twentyFortyBssCoexistence = twentyFortyBssCoexistence;
            return this;
        }

        public Builder extendedCapabilities(Dot11ExtendedCapabilitiesElement extendedCapabilities) {
            this.extendedCapabilities = extendedCapabilities;
            return this;
        }

        public Builder ssidList(Dot11SsidListElement ssidList) {
            this.ssidList = ssidList;
            return this;
        }

        public Builder channelUsage(Dot11ChannelUsageElement channelUsage) {
            this.channelUsage = channelUsage;
            return this;
        }

        public Builder interworking(Dot11InterworkingElement interworking) {
            this.interworking = interworking;
            return this;
        }

        public Builder meshId(Dot11MeshIdElement meshId) {
            this.meshId = meshId;
            return this;
        }

        public Builder vendorSpecificElements(List<Dot11VendorSpecificElement> vendorSpecificElements) {
            this.vendorSpecificElements = vendorSpecificElements;
            return this;
        }

        @Override
        public Builder frameControl(Dot11FrameControl frameControl) {
            super.frameControl(frameControl);
            return this;
        }

        @Override
        public Builder duration(short duration) {
            super.duration(duration);
            return this;
        }

        @Override
        public Builder address1(MacAddress address1) {
            super.address1(address1);
            return this;
        }

        @Override
        public Builder address2(MacAddress address2) {
            super.address2(address2);
            return this;
        }

        @Override
        public Builder address3(MacAddress address3) {
            super.address3(address3);
            return this;
        }

        @Override
        public Builder sequenceControl(Dot11SequenceControl sequenceControl) {
            super.sequenceControl(sequenceControl);
            return this;
        }

        @Override
        public Builder htControl(Dot11HtControl htControl) {
            super.htControl(htControl);
            return this;
        }

        @Override
        public Builder fcs(Integer fcs) {
            super.fcs(fcs);
            return this;
        }

        @Override
        public Builder correctChecksumAtBuild(boolean correctChecksumAtBuild) {
            super.correctChecksumAtBuild(correctChecksumAtBuild);
            return this;
        }

        @Override
        public Dot11ProbeRequestPacket build() {
            this.checkForNull();
            return Dot11ProbeRequestPacket.newPacket(this);
        }
    }
}

