/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.ArrayList;
import java.util.List;
import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.GtpVersion;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.LengthBuilder;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.factory.PacketFactories;
import org.pcap4j.packet.namednumber.GtpV1ExtensionHeaderType;
import org.pcap4j.packet.namednumber.GtpV1MessageType;
import org.pcap4j.packet.namednumber.NotApplicable;
import org.pcap4j.util.ByteArrays;

public final class GtpV1Packet
extends AbstractPacket {
    private static final long serialVersionUID = 4638029542367352625L;
    private final GtpV1Header header;
    private final Packet payload;

    public static GtpV1Packet newPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new GtpV1Packet(rawData, offset, length);
    }

    private GtpV1Packet(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        GtpV1ExtensionHeaderType type2;
        this.header = new GtpV1Header(rawData, offset, length);
        int payloadLength = this.header.getLengthAsInt();
        if (this.header.isExtensionHeaderFieldPresent() || this.header.isSequenceNumberFieldPresent() || this.header.isNPduNumberFieldPresent()) {
            payloadLength -= 4;
        }
        if (payloadLength < 0) {
            throw new IllegalRawDataException("The value of length field seems to be wrong: " + this.header.getLengthAsInt());
        }
        this.payload = payloadLength != 0 ? ((type2 = this.header.getNextExtensionHeaderType()) != null ? PacketFactories.getFactory(Packet.class, GtpV1ExtensionHeaderType.class).newInstance(rawData, offset + this.header.length(), payloadLength, type2) : PacketFactories.getFactory(Packet.class, NotApplicable.class).newInstance(rawData, offset + this.header.length(), payloadLength, NotApplicable.UNKNOWN)) : null;
    }

    private GtpV1Packet(Builder builder2) {
        if (builder2 == null || builder2.version == null || builder2.protocolType == null || builder2.messageType == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder2).append(", builder.version: ").append((Object)builder2.version).append(", builder.protocolType: ").append((Object)builder2.protocolType).append(", builder.messageType: ").append(builder2.messageType);
            throw new NullPointerException(sb.toString());
        }
        this.payload = builder2.payloadBuilder != null ? builder2.payloadBuilder.build() : null;
        this.header = new GtpV1Header(builder2, this.payload != null ? this.payload.length() : 0);
    }

    @Override
    public GtpV1Header getHeader() {
        return this.header;
    }

    @Override
    public Packet getPayload() {
        return this.payload;
    }

    @Override
    public Builder getBuilder() {
        return new Builder(this);
    }

    public static enum ProtocolType {
        GTP_PRIME(false),
        GTP(true);

        private final boolean value;

        private ProtocolType(boolean value2) {
            this.value = value2;
        }

        public static ProtocolType getInstance(boolean value2) {
            for (ProtocolType ver : ProtocolType.values()) {
                if (ver.value != value2) continue;
                return ver;
            }
            throw new IllegalArgumentException("Invalid value: " + value2);
        }

        public boolean getValue() {
            return this.value;
        }

        public String toString() {
            return this.value ? "GTP" : "GTP'";
        }
    }

    public static final class GtpV1Header
    extends AbstractPacket.AbstractHeader {
        private static final long serialVersionUID = -1746545325551976324L;
        private static final int FIRST_OCTET_OFFSET = 0;
        private static final int FIRST_OCTET_SIZE = 1;
        private static final int MSG_TYPE_OFFSET = 1;
        private static final int MSG_TYPE_SIZE = 1;
        private static final int LENGTH_OFFSET = 2;
        private static final int LENGTH_SIZE = 2;
        private static final int TUNNEL_ID_OFFSET = 4;
        private static final int TUNNEL_ID_SIZE = 4;
        private static final int GTP_V1_HEADER_MIM_SIZE = 8;
        private static final int SEQ_OFFSET = 8;
        private static final int SEQ_SIZE = 2;
        private static final int NPDU_OFFSET = 10;
        private static final int NPDU_SIZE = 1;
        private static final int NEXT_HEADER_OFFSET = 11;
        private static final int NEXT_HEADER_SIZE = 1;
        private static final int GTP_V1_HEADER_MAX_SIZE = 12;
        private final GtpVersion version;
        private final ProtocolType protocolType;
        private final boolean reserved;
        private final boolean extensionHeaderFlag;
        private final boolean sequenceNumberFlag;
        private final boolean nPduNumberFlag;
        private final GtpV1MessageType messageType;
        private final short length;
        private final int teid;
        private final Short sequenceNumber;
        private final Byte nPduNumber;
        private final GtpV1ExtensionHeaderType nextExtensionHeaderType;

        private GtpV1Header(byte[] rawData, int offset, int length) throws IllegalRawDataException {
            if (length < 8) {
                StringBuilder sb = new StringBuilder(80);
                sb.append("The data is too short to build a GTPv1 header(").append(8).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
                throw new IllegalRawDataException(sb.toString());
            }
            byte firstOctet = ByteArrays.getByte(rawData, 0 + offset);
            this.version = GtpVersion.getInstance(firstOctet >> 5 & 7);
            this.protocolType = ProtocolType.getInstance((firstOctet & 0x10) != 0);
            this.reserved = (firstOctet & 8) >> 3 != 0;
            this.extensionHeaderFlag = (firstOctet & 4) >> 2 != 0;
            this.sequenceNumberFlag = (firstOctet & 2) >> 1 != 0;
            this.nPduNumberFlag = (firstOctet & 1) != 0;
            this.messageType = GtpV1MessageType.getInstance(ByteArrays.getByte(rawData, 1 + offset));
            this.length = ByteArrays.getShort(rawData, 2 + offset);
            this.teid = ByteArrays.getInt(rawData, 4 + offset);
            if (this.sequenceNumberFlag | this.nPduNumberFlag | this.extensionHeaderFlag) {
                if (length < 12) {
                    StringBuilder sb = new StringBuilder(80);
                    sb.append("The data is too short to build a GTPv1 header(").append(12).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
                    throw new IllegalRawDataException(sb.toString());
                }
                this.sequenceNumber = ByteArrays.getShort(rawData, 8 + offset);
                this.nPduNumber = ByteArrays.getByte(rawData, 10 + offset);
                this.nextExtensionHeaderType = GtpV1ExtensionHeaderType.getInstance(rawData[11 + offset]);
            } else {
                this.sequenceNumber = null;
                this.nPduNumber = null;
                this.nextExtensionHeaderType = null;
            }
        }

        private GtpV1Header(Builder builder2, int payloadLen) {
            this.protocolType = builder2.protocolType;
            this.version = builder2.version;
            this.reserved = builder2.reserved;
            this.messageType = builder2.messageType;
            this.nPduNumberFlag = builder2.nPduNumberFlag;
            this.sequenceNumber = builder2.sequenceNumber;
            this.nPduNumber = builder2.nPduNumber;
            this.nextExtensionHeaderType = builder2.nextExtensionHeaderType;
            this.sequenceNumberFlag = builder2.sequenceNumberFlag;
            this.teid = builder2.teid;
            this.extensionHeaderFlag = builder2.extensionHeaderFlag;
            this.length = builder2.correctLengthAtBuild ? (this.sequenceNumberFlag | this.nPduNumberFlag | this.extensionHeaderFlag ? (short)(payloadLen + 4) : (short)payloadLen) : builder2.length;
        }

        public GtpVersion getVersion() {
            return this.version;
        }

        public ProtocolType getProtocolType() {
            return this.protocolType;
        }

        public boolean getReserved() {
            return this.reserved;
        }

        public boolean isExtensionHeaderFieldPresent() {
            return this.extensionHeaderFlag;
        }

        public boolean isSequenceNumberFieldPresent() {
            return this.sequenceNumberFlag;
        }

        public boolean isNPduNumberFieldPresent() {
            return this.nPduNumberFlag;
        }

        public GtpV1MessageType getMessageType() {
            return this.messageType;
        }

        public short getLength() {
            return this.length;
        }

        public int getLengthAsInt() {
            return 0xFFFF & this.length;
        }

        public int getTeid() {
            return this.teid;
        }

        public long getTeidAsLong() {
            return (long)this.teid & 0xFFFFFFFFL;
        }

        public Short getSequenceNumber() {
            return this.sequenceNumber;
        }

        public Integer getSequenceNumberAsInt() {
            if (this.sequenceNumber == null) {
                return null;
            }
            return this.sequenceNumber & 0xFFFF;
        }

        public Byte getNPduNumber() {
            return this.nPduNumber;
        }

        public Integer getNPduNumberAsInt() {
            if (this.nPduNumber == null) {
                return null;
            }
            return this.nPduNumber & 0xFF;
        }

        public GtpV1ExtensionHeaderType getNextExtensionHeaderType() {
            return this.nextExtensionHeaderType;
        }

        @Override
        protected List<byte[]> getRawFields() {
            byte flags = (byte)(this.version.getValue() << 5);
            if (this.protocolType.getValue()) {
                flags = (byte)(flags | 0x10);
            }
            if (this.reserved) {
                flags = (byte)(flags | 8);
            }
            if (this.extensionHeaderFlag) {
                flags = (byte)(flags | 4);
            }
            if (this.sequenceNumberFlag) {
                flags = (byte)(flags | 2);
            }
            if (this.nPduNumberFlag) {
                flags = (byte)(flags | 1);
            }
            ArrayList<byte[]> rawFields = new ArrayList<byte[]>();
            rawFields.add(ByteArrays.toByteArray(flags));
            rawFields.add(ByteArrays.toByteArray((Byte)this.messageType.value()));
            rawFields.add(ByteArrays.toByteArray(this.length));
            rawFields.add(ByteArrays.toByteArray(this.teid));
            if (this.sequenceNumber != null) {
                rawFields.add(ByteArrays.toByteArray(this.sequenceNumber));
            }
            if (this.nPduNumber != null) {
                rawFields.add(ByteArrays.toByteArray(this.nPduNumber));
            }
            if (this.nextExtensionHeaderType != null) {
                rawFields.add(ByteArrays.toByteArray((Byte)this.nextExtensionHeaderType.value()));
            }
            return rawFields;
        }

        @Override
        protected int calcLength() {
            int len = 8;
            if (this.sequenceNumber != null) {
                len += 2;
            }
            if (this.nPduNumber != null) {
                ++len;
            }
            if (this.nextExtensionHeaderType != null) {
                ++len;
            }
            return len;
        }

        @Override
        protected String buildString() {
            StringBuilder sb = new StringBuilder();
            String ls = System.getProperty("line.separator");
            sb.append("[GTPv1 Header (").append(this.length()).append(" bytes)]").append(ls);
            sb.append("  Version: ").append((Object)this.version).append(ls);
            sb.append("  Protocol Type: ").append((Object)this.protocolType).append(ls);
            sb.append("  Reserved Flag: ").append(this.reserved).append(ls);
            sb.append("  Extension Flag: ").append(this.extensionHeaderFlag).append(ls);
            sb.append("  Sequence Flag: ").append(this.sequenceNumberFlag).append(ls);
            sb.append("  NPDU Flag: ").append(this.nPduNumberFlag).append(ls);
            sb.append("  Message Type: ").append(this.messageType).append(ls);
            sb.append("  Length: ").append(this.getLengthAsInt()).append(" [bytes]").append(ls);
            sb.append("  Tunnel ID: ").append(this.getTeidAsLong()).append(ls);
            if (this.sequenceNumber != null) {
                sb.append("  Sequence Number: ").append(this.getSequenceNumberAsInt()).append(ls);
            }
            if (this.nPduNumber != null) {
                sb.append("  NPDU Number: ").append(this.getNPduNumberAsInt()).append(ls);
            }
            if (this.nextExtensionHeaderType != null) {
                sb.append("  Next Extension Header: ").append(this.getNextExtensionHeaderType()).append(ls);
            }
            return sb.toString();
        }

        @Override
        protected int calcHashCode() {
            int prime = 31;
            int result2 = 17;
            result2 = 31 * result2 + (this.extensionHeaderFlag ? 1231 : 1237);
            result2 = 31 * result2 + this.length;
            result2 = 31 * result2 + this.messageType.hashCode();
            result2 = 31 * result2 + (this.nPduNumber == null ? 0 : this.nPduNumber.hashCode());
            result2 = 31 * result2 + (this.nPduNumberFlag ? 1231 : 1237);
            result2 = 31 * result2 + (this.nextExtensionHeaderType == null ? 0 : this.nextExtensionHeaderType.hashCode());
            result2 = 31 * result2 + this.protocolType.hashCode();
            result2 = 31 * result2 + (this.reserved ? 1231 : 1237);
            result2 = 31 * result2 + (this.sequenceNumber == null ? 0 : this.sequenceNumber.hashCode());
            result2 = 31 * result2 + (this.sequenceNumberFlag ? 1231 : 1237);
            result2 = 31 * result2 + this.teid;
            result2 = 31 * result2 + this.version.hashCode();
            return result2;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!this.getClass().isInstance(obj)) {
                return false;
            }
            GtpV1Header other = (GtpV1Header)obj;
            if (this.extensionHeaderFlag != other.extensionHeaderFlag) {
                return false;
            }
            if (this.length != other.length) {
                return false;
            }
            if (!this.messageType.equals(other.messageType)) {
                return false;
            }
            if (this.nPduNumber == null ? other.nPduNumber != null : !this.nPduNumber.equals(other.nPduNumber)) {
                return false;
            }
            if (this.nPduNumberFlag != other.nPduNumberFlag) {
                return false;
            }
            if (this.nextExtensionHeaderType == null ? other.nextExtensionHeaderType != null : !this.nextExtensionHeaderType.equals(other.nextExtensionHeaderType)) {
                return false;
            }
            if (this.protocolType != other.protocolType) {
                return false;
            }
            if (this.reserved != other.reserved) {
                return false;
            }
            if (this.sequenceNumber == null ? other.sequenceNumber != null : !this.sequenceNumber.equals(other.sequenceNumber)) {
                return false;
            }
            if (this.sequenceNumberFlag != other.sequenceNumberFlag) {
                return false;
            }
            if (this.teid != other.teid) {
                return false;
            }
            return this.version == other.version;
        }
    }

    public static final class Builder
    extends AbstractPacket.AbstractBuilder
    implements LengthBuilder<GtpV1Packet> {
        private GtpVersion version;
        private ProtocolType protocolType;
        private boolean reserved;
        private boolean sequenceNumberFlag;
        private boolean extensionHeaderFlag;
        private boolean nPduNumberFlag;
        private GtpV1MessageType messageType;
        private short length;
        private int teid;
        private Short sequenceNumber;
        private Byte nPduNumber;
        private GtpV1ExtensionHeaderType nextExtensionHeaderType;
        private boolean correctLengthAtBuild;
        private Packet.Builder payloadBuilder;

        public Builder() {
        }

        public Builder(GtpV1Packet packet) {
            this.protocolType = packet.header.protocolType;
            this.version = packet.header.version;
            this.reserved = packet.header.reserved;
            this.length = packet.header.length;
            this.messageType = packet.header.messageType;
            this.nPduNumberFlag = packet.header.nPduNumberFlag;
            this.sequenceNumber = packet.header.sequenceNumber;
            this.nPduNumber = packet.header.nPduNumber;
            this.nextExtensionHeaderType = packet.header.nextExtensionHeaderType;
            this.sequenceNumberFlag = packet.header.sequenceNumberFlag;
            this.teid = packet.header.teid;
            this.extensionHeaderFlag = packet.header.extensionHeaderFlag;
            this.payloadBuilder = packet.payload != null ? packet.payload.getBuilder() : null;
        }

        public Builder protocolType(ProtocolType protocolType) {
            this.protocolType = protocolType;
            return this;
        }

        public Builder reserved(boolean reserved) {
            this.reserved = reserved;
            return this;
        }

        public Builder length(short length) {
            this.length = length;
            return this;
        }

        public Builder extensionHeaderFlag(boolean extensionHeaderFlag) {
            this.extensionHeaderFlag = extensionHeaderFlag;
            return this;
        }

        public Builder sequenceNumberFlag(boolean sequenceNumberFlag) {
            this.sequenceNumberFlag = sequenceNumberFlag;
            return this;
        }

        public Builder nPduNumberFlag(boolean nPduNumberFlag) {
            this.nPduNumberFlag = nPduNumberFlag;
            return this;
        }

        public Builder messageType(GtpV1MessageType messageType) {
            this.messageType = messageType;
            return this;
        }

        public Builder teid(int teid) {
            this.teid = teid;
            return this;
        }

        public Builder sequenceNumber(Short sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            return this;
        }

        public Builder nPduNumber(Byte nPduNumber) {
            this.nPduNumber = nPduNumber;
            return this;
        }

        public Builder nextExtensionHeaderType(GtpV1ExtensionHeaderType nextExtensionHeaderType) {
            this.nextExtensionHeaderType = nextExtensionHeaderType;
            return this;
        }

        public Builder version(GtpVersion version2) {
            this.version = version2;
            return this;
        }

        @Override
        public Builder payloadBuilder(Packet.Builder payloadBuilder) {
            this.payloadBuilder = payloadBuilder;
            return this;
        }

        @Override
        public Packet.Builder getPayloadBuilder() {
            return this.payloadBuilder;
        }

        public Builder correctLengthAtBuild(boolean correctLengthAtBuild) {
            this.correctLengthAtBuild = correctLengthAtBuild;
            return this;
        }

        @Override
        public GtpV1Packet build() {
            return new GtpV1Packet(this);
        }
    }
}

