/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IpV4Packet;
import org.pcap4j.packet.LengthBuilder;
import org.pcap4j.packet.namednumber.IpV4OptionType;
import org.pcap4j.util.ByteArrays;

public final class IpV4StreamIdOption
implements IpV4Packet.IpV4Option {
    private static final long serialVersionUID = -2067863811913941432L;
    private final IpV4OptionType type = IpV4OptionType.STREAM_ID;
    private final byte length;
    private final short streamId;

    public static IpV4StreamIdOption newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new IpV4StreamIdOption(rawData, offset, length);
    }

    private IpV4StreamIdOption(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        if (length < 4) {
            StringBuilder sb = new StringBuilder(50);
            sb.append("The raw data length must be more than 3. rawData: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb.toString());
        }
        if (rawData[0 + offset] != (Byte)this.getType().value()) {
            StringBuilder sb = new StringBuilder(100);
            sb.append("The type must be: ").append(this.getType().valueAsString()).append(" rawData: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb.toString());
        }
        if (rawData[1 + offset] != 4) {
            throw new IllegalRawDataException("Invalid value of length field: " + rawData[1 + offset]);
        }
        this.length = rawData[1 + offset];
        this.streamId = ByteArrays.getShort(rawData, 2 + offset);
    }

    private IpV4StreamIdOption(Builder builder2) {
        if (builder2 == null) {
            throw new NullPointerException("builder: " + builder2);
        }
        this.streamId = builder2.streamId;
        this.length = builder2.correctLengthAtBuild ? (byte)this.length() : builder2.length;
    }

    @Override
    public IpV4OptionType getType() {
        return this.type;
    }

    public byte getLength() {
        return this.length;
    }

    public int getLengthAsInt() {
        return 0xFF & this.length;
    }

    public short getStreamId() {
        return this.streamId;
    }

    public int getStreamIdAsInt() {
        return 0xFFFF & this.streamId;
    }

    @Override
    public int length() {
        return 4;
    }

    @Override
    public byte[] getRawData() {
        byte[] rawData = new byte[this.length()];
        rawData[0] = (Byte)this.getType().value();
        rawData[1] = this.length;
        rawData[2] = (byte)(this.streamId >> 8);
        rawData[3] = (byte)this.streamId;
        return rawData;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[option-type: ").append(this.getType());
        sb.append("] [option-length: ").append(this.getLengthAsInt());
        sb.append(" bytes] [streamId: ").append(this.getStreamIdAsInt());
        sb.append("]");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        IpV4StreamIdOption other = (IpV4StreamIdOption)obj;
        return this.streamId == other.streamId && this.length == other.length;
    }

    public int hashCode() {
        int result2 = 17;
        result2 = 31 * result2 + this.length;
        result2 = 31 * result2 + this.streamId;
        return result2;
    }

    public static final class Builder
    implements LengthBuilder<IpV4StreamIdOption> {
        private byte length;
        private short streamId;
        private boolean correctLengthAtBuild;

        public Builder() {
        }

        private Builder(IpV4StreamIdOption option) {
            this.length = option.length;
            this.streamId = option.streamId;
        }

        public Builder length(byte length) {
            this.length = length;
            return this;
        }

        public Builder streamId(short streamId) {
            this.streamId = streamId;
            return this;
        }

        public Builder correctLengthAtBuild(boolean correctLengthAtBuild) {
            this.correctLengthAtBuild = correctLengthAtBuild;
            return this;
        }

        @Override
        public IpV4StreamIdOption build() {
            return new IpV4StreamIdOption(this);
        }
    }
}

