/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.internals.ProcessorNode;
import org.apache.kafka.streams.processor.internals.SinkNode;
import org.apache.kafka.streams.processor.internals.SourceNode;

public class ProcessorTopology {
    private final List<ProcessorNode> processorNodes;
    private final Map<String, SourceNode> sourcesByTopic;
    private final Map<String, SinkNode> sinksByTopic;
    private final List<StateStore> stateStores;
    private final List<StateStore> globalStateStores;
    private final Map<String, String> storeToChangelogTopic;
    private final Set<String> repartitionTopics;

    public static ProcessorTopology with(List<ProcessorNode> processorNodes, Map<String, SourceNode> sourcesByTopic, List<StateStore> stateStoresByName, Map<String, String> storeToChangelogTopic) {
        return new ProcessorTopology(processorNodes, sourcesByTopic, Collections.emptyMap(), stateStoresByName, Collections.emptyList(), storeToChangelogTopic, Collections.emptySet());
    }

    static ProcessorTopology withSources(List<ProcessorNode> processorNodes, Map<String, SourceNode> sourcesByTopic) {
        return new ProcessorTopology(processorNodes, sourcesByTopic, Collections.emptyMap(), Collections.emptyList(), Collections.emptyList(), Collections.emptyMap(), Collections.emptySet());
    }

    static ProcessorTopology withLocalStores(List<StateStore> stateStores, Map<String, String> storeToChangelogTopic) {
        return new ProcessorTopology(Collections.emptyList(), Collections.emptyMap(), Collections.emptyMap(), stateStores, Collections.emptyList(), storeToChangelogTopic, Collections.emptySet());
    }

    static ProcessorTopology withGlobalStores(List<StateStore> stateStores, Map<String, String> storeToChangelogTopic) {
        return new ProcessorTopology(Collections.emptyList(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyList(), stateStores, storeToChangelogTopic, Collections.emptySet());
    }

    static ProcessorTopology withRepartitionTopics(List<ProcessorNode> processorNodes, Map<String, SourceNode> sourcesByTopic, Set<String> repartitionTopics) {
        return new ProcessorTopology(processorNodes, sourcesByTopic, Collections.emptyMap(), Collections.emptyList(), Collections.emptyList(), Collections.emptyMap(), repartitionTopics);
    }

    public ProcessorTopology(List<ProcessorNode> processorNodes, Map<String, SourceNode> sourcesByTopic, Map<String, SinkNode> sinksByTopic, List<StateStore> stateStores, List<StateStore> globalStateStores, Map<String, String> stateStoreToChangelogTopic, Set<String> repartitionTopics) {
        this.processorNodes = Collections.unmodifiableList(processorNodes);
        this.sourcesByTopic = Collections.unmodifiableMap(sourcesByTopic);
        this.sinksByTopic = Collections.unmodifiableMap(sinksByTopic);
        this.stateStores = Collections.unmodifiableList(stateStores);
        this.globalStateStores = Collections.unmodifiableList(globalStateStores);
        this.storeToChangelogTopic = Collections.unmodifiableMap(stateStoreToChangelogTopic);
        this.repartitionTopics = Collections.unmodifiableSet(repartitionTopics);
    }

    public Set<String> sourceTopics() {
        return this.sourcesByTopic.keySet();
    }

    public SourceNode source(String topic) {
        return this.sourcesByTopic.get(topic);
    }

    public Set<SourceNode> sources() {
        return new HashSet<SourceNode>(this.sourcesByTopic.values());
    }

    public Set<String> sinkTopics() {
        return this.sinksByTopic.keySet();
    }

    public SinkNode sink(String topic) {
        return this.sinksByTopic.get(topic);
    }

    public Set<SinkNode> sinks() {
        return new HashSet<SinkNode>(this.sinksByTopic.values());
    }

    public List<ProcessorNode> processors() {
        return this.processorNodes;
    }

    public List<StateStore> stateStores() {
        return this.stateStores;
    }

    public List<StateStore> globalStateStores() {
        return this.globalStateStores;
    }

    public Map<String, String> storeToChangelogTopic() {
        return this.storeToChangelogTopic;
    }

    boolean isRepartitionTopic(String topic) {
        return this.repartitionTopics.contains(topic);
    }

    private String childrenToString(String indent, List<ProcessorNode<?, ?>> children) {
        if (children == null || children.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder(indent + "\tchildren:\t[");
        for (ProcessorNode<?, ?> child : children) {
            sb.append(child.name());
            sb.append(", ");
        }
        sb.setLength(sb.length() - 2);
        sb.append("]\n");
        for (ProcessorNode<?, ?> child : children) {
            sb.append(child.toString(indent)).append(this.childrenToString(indent, child.children()));
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        StringBuilder sb = new StringBuilder(indent + "ProcessorTopology:\n");
        for (SourceNode source : this.sourcesByTopic.values()) {
            sb.append(source.toString(indent + "\t")).append(this.childrenToString(indent + "\t", source.children()));
        }
        return sb.toString();
    }

    public Set<String> processorConnectedStateStores(String processorName) {
        for (ProcessorNode node : this.processorNodes) {
            if (!node.name().equals(processorName)) continue;
            return node.stateStores;
        }
        return Collections.emptySet();
    }
}

