/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.history;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import org.opensolaris.opengrok.OpenGrokLogger;
import org.opensolaris.opengrok.configuration.RuntimeEnvironment;
import org.opensolaris.opengrok.history.History;
import org.opensolaris.opengrok.history.HistoryEntry;
import org.opensolaris.opengrok.history.HistoryException;
import org.opensolaris.opengrok.history.MonotoneRepository;
import org.opensolaris.opengrok.util.Executor;

class MonotoneHistoryParser
implements Executor.StreamHandler {
    private List<HistoryEntry> entries = new ArrayList<HistoryEntry>();
    private final MonotoneRepository repository;
    private final String mydir;

    MonotoneHistoryParser(MonotoneRepository repository) {
        this.repository = repository;
        this.mydir = repository.getDirectoryName() + File.separator;
    }

    History parse(File file, String changeset) throws HistoryException {
        try {
            Executor executor = this.repository.getHistoryLogExecutor(file, changeset);
            int status = executor.exec(true, this);
            if (status != 0) {
                throw new HistoryException("Failed to get history for: \"" + file.getAbsolutePath() + "\" Exit code: " + status);
            }
        }
        catch (IOException e) {
            throw new HistoryException("Failed to get history for: \"" + file.getAbsolutePath() + "\"", e);
        }
        return new History(this.entries);
    }

    @Override
    public void processStream(InputStream input) throws IOException {
        String s;
        RuntimeEnvironment env = RuntimeEnvironment.getInstance();
        DateFormat df = this.repository.getDateFormat();
        BufferedReader in = new BufferedReader(new InputStreamReader(input));
        HistoryEntry entry = null;
        int state = 0;
        block12: while ((s = in.readLine()) != null) {
            if ((s = s.trim()).startsWith("-----------------------------------------------------------------")) {
                if (entry != null && state > 2) {
                    this.entries.add(entry);
                }
                entry = new HistoryEntry();
                entry.setActive(true);
                state = 0;
                continue;
            }
            switch (state) {
                case 0: {
                    if (!s.startsWith("Revision:")) continue block12;
                    String rev = s.substring("Revision:".length()).trim();
                    entry.setRevision(rev);
                    ++state;
                    continue block12;
                }
                case 1: {
                    if (!s.startsWith("Author:")) continue block12;
                    entry.setAuthor(s.substring("Author:".length()).trim());
                    ++state;
                    continue block12;
                }
                case 2: {
                    if (!s.startsWith("Date:")) continue block12;
                    Date date = new Date();
                    try {
                        date = df.parse(s.substring("date:".length()).trim());
                    }
                    catch (ParseException pe) {
                        OpenGrokLogger.getLogger().log(Level.WARNING, "Could not parse date: " + s, pe);
                    }
                    entry.setDate(date);
                    ++state;
                    continue block12;
                }
                case 3: {
                    if (s.startsWith("Modified ") || s.startsWith("Added ") || s.startsWith("Deleted ")) {
                        ++state;
                        continue block12;
                    }
                    if (!s.equalsIgnoreCase("ChangeLog:")) continue block12;
                    state = 5;
                    continue block12;
                }
                case 4: {
                    String[] files;
                    if (s.startsWith("Modified ") || s.startsWith("Added ") || s.startsWith("Deleted ")) continue block12;
                    if (s.equalsIgnoreCase("ChangeLog:")) {
                        state = 5;
                        continue block12;
                    }
                    for (String f : files = s.split(" ")) {
                        File file = new File(this.mydir, f);
                        try {
                            entry.addFile(env.getPathRelativeToSourceRoot(file, 0));
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            // empty catch block
                        }
                    }
                    continue block12;
                }
                case 5: {
                    entry.appendMessage(s);
                    continue block12;
                }
            }
            OpenGrokLogger.getLogger().warning("Unknown parser state: " + state);
        }
        if (entry != null && state > 2) {
            this.entries.add(entry);
        }
    }
}

