/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.protocol;

import com.sun.corba.se.impl.orbutil.DenseIntMapImpl;
import com.sun.corba.se.pept.protocol.ClientRequestDispatcher;
import com.sun.corba.se.spi.oa.ObjectAdapterFactory;
import com.sun.corba.se.spi.orb.ORB;
import com.sun.corba.se.spi.protocol.CorbaServerRequestDispatcher;
import com.sun.corba.se.spi.protocol.LocalClientRequestDispatcherFactory;
import com.sun.corba.se.spi.protocol.RequestDispatcherRegistry;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class RequestDispatcherRegistryImpl
implements RequestDispatcherRegistry {
    private ORB orb;
    protected int defaultId;
    private DenseIntMapImpl SDRegistry;
    private DenseIntMapImpl CSRegistry;
    private DenseIntMapImpl OAFRegistry;
    private DenseIntMapImpl LCSFRegistry;
    private Set objectAdapterFactories;
    private Set objectAdapterFactoriesView;
    private Map stringToServerSubcontract;

    public RequestDispatcherRegistryImpl(ORB oRB, int n) {
        this.orb = oRB;
        this.defaultId = n;
        this.SDRegistry = new DenseIntMapImpl();
        this.CSRegistry = new DenseIntMapImpl();
        this.OAFRegistry = new DenseIntMapImpl();
        this.LCSFRegistry = new DenseIntMapImpl();
        this.objectAdapterFactories = new HashSet();
        this.objectAdapterFactoriesView = Collections.unmodifiableSet(this.objectAdapterFactories);
        this.stringToServerSubcontract = new HashMap();
    }

    @Override
    public synchronized void registerClientRequestDispatcher(ClientRequestDispatcher clientRequestDispatcher, int n) {
        this.CSRegistry.set(n, clientRequestDispatcher);
    }

    @Override
    public synchronized void registerLocalClientRequestDispatcherFactory(LocalClientRequestDispatcherFactory localClientRequestDispatcherFactory, int n) {
        this.LCSFRegistry.set(n, localClientRequestDispatcherFactory);
    }

    @Override
    public synchronized void registerServerRequestDispatcher(CorbaServerRequestDispatcher corbaServerRequestDispatcher, int n) {
        this.SDRegistry.set(n, corbaServerRequestDispatcher);
    }

    @Override
    public synchronized void registerServerRequestDispatcher(CorbaServerRequestDispatcher corbaServerRequestDispatcher, String string) {
        this.stringToServerSubcontract.put(string, corbaServerRequestDispatcher);
    }

    @Override
    public synchronized void registerObjectAdapterFactory(ObjectAdapterFactory objectAdapterFactory, int n) {
        this.objectAdapterFactories.add(objectAdapterFactory);
        this.OAFRegistry.set(n, objectAdapterFactory);
    }

    @Override
    public CorbaServerRequestDispatcher getServerRequestDispatcher(int n) {
        CorbaServerRequestDispatcher corbaServerRequestDispatcher = (CorbaServerRequestDispatcher)this.SDRegistry.get(n);
        if (corbaServerRequestDispatcher == null) {
            corbaServerRequestDispatcher = (CorbaServerRequestDispatcher)this.SDRegistry.get(this.defaultId);
        }
        return corbaServerRequestDispatcher;
    }

    @Override
    public CorbaServerRequestDispatcher getServerRequestDispatcher(String string) {
        CorbaServerRequestDispatcher corbaServerRequestDispatcher = (CorbaServerRequestDispatcher)this.stringToServerSubcontract.get(string);
        if (corbaServerRequestDispatcher == null) {
            corbaServerRequestDispatcher = (CorbaServerRequestDispatcher)this.SDRegistry.get(this.defaultId);
        }
        return corbaServerRequestDispatcher;
    }

    @Override
    public LocalClientRequestDispatcherFactory getLocalClientRequestDispatcherFactory(int n) {
        LocalClientRequestDispatcherFactory localClientRequestDispatcherFactory = (LocalClientRequestDispatcherFactory)this.LCSFRegistry.get(n);
        if (localClientRequestDispatcherFactory == null) {
            localClientRequestDispatcherFactory = (LocalClientRequestDispatcherFactory)this.LCSFRegistry.get(this.defaultId);
        }
        return localClientRequestDispatcherFactory;
    }

    @Override
    public ClientRequestDispatcher getClientRequestDispatcher(int n) {
        ClientRequestDispatcher clientRequestDispatcher = (ClientRequestDispatcher)this.CSRegistry.get(n);
        if (clientRequestDispatcher == null) {
            clientRequestDispatcher = (ClientRequestDispatcher)this.CSRegistry.get(this.defaultId);
        }
        return clientRequestDispatcher;
    }

    @Override
    public ObjectAdapterFactory getObjectAdapterFactory(int n) {
        ObjectAdapterFactory objectAdapterFactory = (ObjectAdapterFactory)this.OAFRegistry.get(n);
        if (objectAdapterFactory == null) {
            objectAdapterFactory = (ObjectAdapterFactory)this.OAFRegistry.get(this.defaultId);
        }
        return objectAdapterFactory;
    }

    public Set getObjectAdapterFactories() {
        return this.objectAdapterFactoriesView;
    }
}

