/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.commandLine;

import com.intellij.execution.configurations.ParametersList;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.run.PhpCommandLineSettings;
import com.jetbrains.php.run.PhpConfigurationOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpCommandLineCommand {
    @NotNull
    private final List<String> myOptions;
    @Nullable
    private String myScriptPath;
    @Nullable
    private String myWorkingDirectory;
    @NotNull
    private final List<String> myArgs;
    @NotNull
    private final Map<String, String> myEnvs;
    @NotNull
    private final String myPhpBinary;
    private boolean myPassParentEnvs;

    protected PhpCommandLineCommand(@NotNull String phpBinary) {
        if (phpBinary == null) {
            PhpCommandLineCommand.$$$reportNull$$$0(0);
        }
        this.myOptions = new ArrayList<String>();
        this.myScriptPath = null;
        this.myWorkingDirectory = null;
        this.myArgs = new ArrayList<String>();
        this.myEnvs = new HashMap<String, String>();
        this.myPassParentEnvs = true;
        this.myPhpBinary = phpBinary;
    }

    @NotNull
    public List<String> getOptions() {
        List<String> list = this.myOptions;
        if (list == null) {
            PhpCommandLineCommand.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Nullable
    public String getScriptPath() {
        return this.myScriptPath;
    }

    @Nullable
    public String getWorkingDirectory() {
        return this.myWorkingDirectory;
    }

    @NotNull
    public List<String> getArgs() {
        List<String> list = this.myArgs;
        if (list == null) {
            PhpCommandLineCommand.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public Map<String, String> getEnvs() {
        Map<String, String> map = this.myEnvs;
        if (map == null) {
            PhpCommandLineCommand.$$$reportNull$$$0(3);
        }
        return map;
    }

    @NotNull
    public String getPhpBinary() {
        String string = this.myPhpBinary;
        if (string == null) {
            PhpCommandLineCommand.$$$reportNull$$$0(4);
        }
        return string;
    }

    public boolean isPassParentEnvs() {
        return this.myPassParentEnvs;
    }

    public PhpCommandLineCommand addOption(@NotNull String option) {
        if (option == null) {
            PhpCommandLineCommand.$$$reportNull$$$0(5);
        }
        this.myOptions.add(option);
        return this;
    }

    public PhpCommandLineCommand addConfigurationOptions(@NotNull List<PhpConfigurationOption> configurationOptions) {
        if (configurationOptions == null) {
            PhpCommandLineCommand.$$$reportNull$$$0(6);
        }
        for (PhpConfigurationOption configurationOption : configurationOptions) {
            this.addOption(configurationOption.getText());
        }
        return this;
    }

    public PhpCommandLineCommand setScript(@Nullable String scriptPath) {
        this.myScriptPath = scriptPath;
        return this;
    }

    public PhpCommandLineCommand setWorkingDirectory(@Nullable String workingDirectory) {
        this.myWorkingDirectory = workingDirectory;
        return this;
    }

    public PhpCommandLineCommand addArguments(@NotNull List<String> args) {
        if (args == null) {
            PhpCommandLineCommand.$$$reportNull$$$0(7);
        }
        this.myArgs.addAll(args);
        return this;
    }

    public PhpCommandLineCommand addArgument(@NotNull String arg) {
        if (arg == null) {
            PhpCommandLineCommand.$$$reportNull$$$0(8);
        }
        this.myArgs.add(arg);
        return this;
    }

    public PhpCommandLineCommand addEnv(@NotNull String name, @NotNull String value) {
        if (name == null) {
            PhpCommandLineCommand.$$$reportNull$$$0(9);
        }
        if (value == null) {
            PhpCommandLineCommand.$$$reportNull$$$0(10);
        }
        this.myEnvs.put(name, value);
        return this;
    }

    public PhpCommandLineCommand addEnvs(@NotNull Map<String, String> envs) {
        if (envs == null) {
            PhpCommandLineCommand.$$$reportNull$$$0(11);
        }
        this.myEnvs.putAll(envs);
        return this;
    }

    public PhpCommandLineCommand setPassParentEnvs(boolean passParentEnvs) {
        this.myPassParentEnvs = passParentEnvs;
        return this;
    }

    public PhpCommandLineCommand importCommandLineSettings(@NotNull PhpCommandLineSettings commandLineSettings, @Nullable String defaultWorkingDirectory) {
        String workingDirectory;
        if (commandLineSettings == null) {
            PhpCommandLineCommand.$$$reportNull$$$0(12);
        }
        this.setWorkingDirectory(!StringUtil.isEmptyOrSpaces((String)(workingDirectory = commandLineSettings.getWorkingDirectory())) ? workingDirectory : defaultWorkingDirectory);
        this.addEnvs(commandLineSettings.getEnvs());
        this.setPassParentEnvs(commandLineSettings.isPassParentEnvs());
        String parameters = commandLineSettings.getParameters();
        if (StringUtil.isNotEmpty((String)parameters)) {
            String[] params;
            for (String param : params = ParametersList.parse((String)parameters)) {
                this.addOption(param);
            }
        }
        return this;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpBinary";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/config/commandLine/PhpCommandLineCommand";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationOptions";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arg";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLineSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/config/commandLine/PhpCommandLineCommand";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgs";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvs";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPhpBinary";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addOption";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addConfigurationOptions";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addArguments";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addArgument";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addEnv";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addEnvs";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "importCommandLineSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

