/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phpunit;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.PathUtil;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.phpunit.PhpUnitFrameworkType;
import com.jetbrains.php.phpunit.PhpUnitLocalRunConfiguration;
import com.jetbrains.php.phpunit.PhpUnitLocalRunConfigurationType;
import com.jetbrains.php.phpunit.PhpUnitRunConfigurationSettings;
import com.jetbrains.php.phpunit.PhpUnitSettings;
import com.jetbrains.php.phpunit.PhpUnitSettingsManager;
import com.jetbrains.php.phpunit.PhpUnitTestRunnerSettings;
import com.jetbrains.php.phpunit.PhpUnitUtil;
import com.jetbrains.php.testFramework.PhpTestFrameworkComposerConfig;
import com.jetbrains.php.testFramework.PhpTestFrameworkConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpUnitComposerConfig
extends PhpTestFrameworkComposerConfig {
    private static final String PACKAGE = "phpunit/phpunit";
    private static final String RELATIVE_PATH = "autoload.php";

    public PhpUnitComposerConfig() {
        super(PhpUnitFrameworkType.getInstance(), PACKAGE, RELATIVE_PATH);
    }

    @Override
    public void updateSettings(@NotNull Project project, @Nullable PhpInterpreter interpreter) {
        PhpUnitSettings settings;
        if (project == null) {
            PhpUnitComposerConfig.$$$reportNull$$$0(0);
        }
        if ((settings = PhpUnitSettingsManager.getInstance(project).getSettingsByInterpreter(interpreter)) == null || StringUtil.isEmpty((String)settings.getCustomLoaderPath())) {
            String autoloader = this.findFromComposerVendor(project);
            if (StringUtil.isEmpty((String)autoloader)) {
                return;
            }
            PhpUnitSettings newSettings = PhpUnitSettingsManager.getInstance(project).getOrCreateByInterpreter(interpreter);
            newSettings.setCustomLoaderPath(interpreter == null || !interpreter.isRemote() ? PathUtil.toSystemDependentName((String)autoloader) : autoloader);
            if (newSettings.getLoadMethod() == PhpUnitSettings.LoadMethod.CUSTOM_LOADER) {
                this.updateRunConfigurations(project, newSettings);
                this.notify(project, newSettings);
            }
        }
    }

    @Override
    protected void updateRunConfigurations(@NotNull Project project, @NotNull PhpTestFrameworkConfiguration configuration) {
        VirtualFile file;
        if (project == null) {
            PhpUnitComposerConfig.$$$reportNull$$$0(1);
        }
        if (configuration == null) {
            PhpUnitComposerConfig.$$$reportNull$$$0(2);
        }
        if ((file = VfsUtil.findRelativeFile((VirtualFile)project.getBaseDir(), (String[])new String[]{FileUtil.toCanonicalPath((String)this.getDefaultConfigName())})) == null) {
            file = VfsUtil.findRelativeFile((VirtualFile)project.getBaseDir(), (String[])new String[]{FileUtil.toCanonicalPath((String)(this.getDefaultConfigName() + ".dist"))});
        }
        if (file == null) {
            return;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile == null || !PhpUnitUtil.isPhpUnitConfigurationFile(psiFile)) {
            return;
        }
        configuration.setUseConfigurationFile(true);
        configuration.setConfigurationFilePath(file.getPath());
        ConfigurationFactory[] factories = this.getConfigurationType().getConfigurationFactories();
        if (factories == null || factories.length != 1) {
            return;
        }
        RunManager runManager = RunManager.getInstance((Project)project);
        RunnerAndConfigurationSettings settings = runManager.createConfiguration(file.getName(), factories[0]);
        PhpUnitTestRunnerSettings testRunnerSettings = ((PhpUnitRunConfigurationSettings)((PhpUnitLocalRunConfiguration)settings.getConfiguration()).getSettings()).getTestRunnerSettings();
        testRunnerSettings.setScope(PhpUnitTestRunnerSettings.Scope.XML);
        runManager.addConfiguration(settings);
    }

    @Override
    @NotNull
    protected String getDefaultConfigName() {
        if ("phpunit.xml" == null) {
            PhpUnitComposerConfig.$$$reportNull$$$0(3);
        }
        return "phpunit.xml";
    }

    @Override
    @NotNull
    protected ConfigurationType getConfigurationType() {
        PhpUnitLocalRunConfigurationType phpUnitLocalRunConfigurationType = PhpUnitLocalRunConfigurationType.getInstance();
        if (phpUnitLocalRunConfigurationType == null) {
            PhpUnitComposerConfig.$$$reportNull$$$0(4);
        }
        return phpUnitLocalRunConfigurationType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phpunit/PhpUnitComposerConfig";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phpunit/PhpUnitComposerConfig";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultConfigName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateSettings";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateRunConfigurations";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

