/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.introduce.inplace;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceContext;
import com.jetbrains.php.refactoring.introduce.inplace.PhpConstantInClassIntroducePanel;
import com.jetbrains.php.refactoring.introduce.inplace.PhpConstantInplaceIntroduceFacade;
import com.jetbrains.php.refactoring.introduce.inplace.PhpInplaceFieldIntroducer;
import com.jetbrains.php.refactoring.introduce.inplace.PhpInplaceVariableIntroducer;
import com.jetbrains.php.refactoring.introduce.introduceConstant.PhpIntroduceConstantHandler;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpInplaceConstantInClassIntroducer
extends PhpInplaceVariableIntroducer {
    private static final String LAST_SELECTED_VISIBILITY = PhpInplaceConstantInClassIntroducer.class.getName() + ".lastSelectedVisibility";
    private final PhpIntroduceContext myContext;
    private final PhpConstantInClassIntroducePanel myPanel;
    private final PhpModifier.Access myAccess;

    public PhpInplaceConstantInClassIntroducer(PhpIntroduceContext context, PsiNamedElement element, PhpModifier.Access access) {
        super(element, context, "Introduce constant");
        this.myContext = context;
        Project project = context.getProject();
        this.myAccess = access;
        this.myPanel = PhpConstantInClassIntroducePanel.canBeShown(project) ? new PhpConstantInClassIntroducePanel(project, this.myAccess) : null;
    }

    @Override
    protected void adjustCaret(PsiElement elementToSelect) {
        ClassConstantReference reference = (ClassConstantReference)PsiTreeUtil.getParentOfType((PsiElement)this.myContext.getFile().findElementAt(this.myEditor.getCaretModel().getOffset()), ClassConstantReference.class);
        PhpInplaceFieldIntroducer.adjustCaretForReference(reference != null ? reference.getElement() : elementToSelect, this.myEditor);
    }

    @Nullable
    protected JComponent getComponent() {
        return this.myPanel != null ? this.myPanel.getRootPanel() : null;
    }

    @Nullable
    public static PhpModifier.Access getLastSelectedAccess(@NotNull Project project) {
        if (project == null) {
            PhpInplaceConstantInClassIntroducer.$$$reportNull$$$0(0);
        }
        String access = StringUtil.notNullize((String)PropertiesComponent.getInstance((Project)project).getValue(LAST_SELECTED_VISIBILITY));
        for (PhpModifier.Access a : PhpModifier.Access.values()) {
            if (!StringUtil.equals((CharSequence)a.toString(), (CharSequence)access)) continue;
            return a;
        }
        return null;
    }

    protected void moveOffsetAfter(boolean success) {
        PhpModifier.Access access;
        PhpModifier.Access access2 = access = this.myPanel != null ? this.myPanel.getAccess() : null;
        if (success && access != this.myAccess) {
            PhpNamedElement constant = PhpConstantInplaceIntroduceFacade.resolveConstantReferenceAtCaret(this.myContext, true);
            Object constantWrapper = PhpPsiUtil.getParentByCondition((PsiElement)constant, (Condition<? super PsiElement>)((Condition)c -> PhpPsiUtil.isOfType(c, PhpElementTypes.CLASS_CONSTANTS)));
            if (constantWrapper != null) {
                WriteAction.run(() -> constantWrapper.replace(PhpIntroduceConstantHandler.createClassConstantDeclaration(this.myContext, access, constant.getName())));
            }
            PropertiesComponent.getInstance((Project)this.myProject).setValue(LAST_SELECTED_VISIBILITY, access != null ? access.toString() : "");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/php/refactoring/introduce/inplace/PhpInplaceConstantInClassIntroducer", "getLastSelectedAccess"));
    }
}

