/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui;

import com.google.common.collect.Iterables;
import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInsight.documentation.QuickDocUtil;
import com.intellij.concurrency.AsyncFutureResult;
import com.intellij.concurrency.ResultConsumer;
import com.intellij.concurrency.SameThreadExecutor;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.connection.DGDepartment;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridPomTarget;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.DatabaseTableGridDataHookUp;
import com.intellij.database.datagrid.GridDataHookUpManager;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridPagingModel;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.extractors.DisplayHtmlValuesExtractor;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.model.DasConstraint;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasTable;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbTable;
import com.intellij.database.run.actions.CountRowsAction;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.util.CharOut;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.lang.documentation.AbstractDocumentationProvider;
import com.intellij.lang.documentation.ExternalDocumentationHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import gnu.trove.TIntHashSet;
import java.awt.Component;
import java.awt.Image;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataGridDocumentationProvider
extends AbstractDocumentationProvider
implements ExternalDocumentationHandler {
    private static final String URL_PREFIX = "db-doc://";
    private static final String VIEW_MODE_PROPERTY = "DataGrid.QuickDoc.View";
    private static final Key<State> GRID_HINT_STATE_KEY = Key.create((String)"GRID_HINT_STATE_KEY");
    private static final Key<Map<String, Image>> IMAGE_MAP_KEY = Key.create((String)"IMAGE_MAP_KEY");
    private static final AtomicLong ourImageCounter = new AtomicLong();

    public static String buildAndRunQueries(@NotNull DataGrid dataGrid, CharSequence initialValue) {
        boolean noRelationships;
        if (dataGrid == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(0);
        }
        DasTable databaseTable = DataGridUtil.getDatabaseTable(dataGrid);
        DbDataSource dataSource = DataGridUtil.getDatabaseSystem(dataGrid);
        if (dataSource == null || databaseTable == null) {
            return null;
        }
        ModelIndex<DataConsumer.Row> selectedRow = dataGrid.getSelectionModel().getSelectedRow();
        boolean badSelection = !selectedRow.isValid(dataGrid) || dataGrid.getSelectionModel().getSelectedRowCount() != 1;
        boolean bl = noRelationships = !DataGridDocumentationProvider.hasNavigatableKeys((DasDataSource)dataSource, databaseTable);
        if (badSelection || noRelationships) {
            dataGrid.putUserData(GRID_HINT_STATE_KEY, null);
            return null;
        }
        State state = (State)dataGrid.getUserData(GRID_HINT_STATE_KEY);
        List<QueryInfo> newQueries = DataGridDocumentationProvider.buildQueries((DasDataSource)dataSource, dataGrid, selectedRow, EnumSet.of(KeyType.FOREIGN, KeyType.EXPORTED));
        if (state != null && state.queries.equals(newQueries) && selectedRow.equals(state.row) && System.currentTimeMillis() - state.timestamp <= 5000L) {
            return state.current;
        }
        state = new State(newQueries, selectedRow, null);
        dataGrid.putUserData(GRID_HINT_STATE_KEY, state);
        DataGridDocumentationProvider.runQueries(dataGrid, state, initialValue.toString());
        return null;
    }

    public static boolean hasNavigatableKeys(@NotNull DasDataSource dataSource, @NotNull DasTable databaseTable) {
        if (dataSource == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(1);
        }
        if (databaseTable == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(2);
        }
        return !Iterables.isEmpty((Iterable)dataSource.getModel().getExportedKeys(databaseTable)) || !Iterables.isEmpty((Iterable)DasUtil.getForeignKeys((DasTable)databaseTable));
    }

    public static List<QueryInfo> buildQueries(@NotNull DasDataSource dataSource, @NotNull DataGrid dataGrid, @NotNull ModelIndex<DataConsumer.Row> selectedRow, @NotNull EnumSet<KeyType> keyTypes) {
        if (dataSource == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(3);
        }
        if (dataGrid == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(4);
        }
        if (selectedRow == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(5);
        }
        if (keyTypes == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(6);
        }
        GridModel model = dataGrid.getDataModel(DataAccessType.DATABASE_DATA);
        TIntHashSet selectedColumnIndices = new TIntHashSet((keyTypes.contains((Object)KeyType.SELECTED) ? dataGrid.getSelectionModel().getSelectedColumns() : model.getColumnIndices()).asArray());
        DasTable databaseTable = DataGridUtil.getDatabaseTable(dataGrid);
        LinkedHashMap queries = ContainerUtil.newLinkedHashMap();
        if (keyTypes.contains((Object)KeyType.FOREIGN)) {
            DataGridDocumentationProvider.collectForeignKeyQueries(queries, databaseTable, dataSource.getDbms(), dataGrid, selectedRow, selectedColumnIndices);
        }
        if (keyTypes.contains((Object)KeyType.EXPORTED)) {
            DataGridDocumentationProvider.collectExportedKeyQueries(queries, dataSource, databaseTable, dataSource.getDbms(), dataGrid, selectedRow, selectedColumnIndices);
        }
        return ContainerUtil.newArrayList(queries.values());
    }

    private static void collectForeignKeyQueries(@NotNull Map<String, QueryInfo> queries, @NotNull DasTable databaseTable, @NotNull Dbms dbms, @NotNull DataGrid dataGrid, @NotNull ModelIndex<DataConsumer.Row> selectedRow, @NotNull TIntHashSet selectedColumns) {
        if (queries == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(7);
        }
        if (databaseTable == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(8);
        }
        if (dbms == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(9);
        }
        if (dataGrid == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(10);
        }
        if (selectedRow == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(11);
        }
        if (selectedColumns == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(12);
        }
        ArrayList values2 = ContainerUtil.newArrayList();
        for (DasForeignKey key2 : DasUtil.getForeignKeys((DasTable)databaseTable)) {
            DasTable table = key2.getRefTable();
            if (table == null || !DataGridDocumentationProvider.tryCollectValues(dataGrid, selectedRow, selectedColumns, values2, key2.getColumnsRef().names())) continue;
            Iterable refColumns = key2.getRefColumns().names();
            DbDataSource system = DataGridUtil.getDatabaseSystem(dataGrid);
            String query = DbImplUtil.createSelectAllQuery(table, dbms, (DasDataSource)system, 2, refColumns, values2).getStatement();
            DataGridDocumentationProvider.collectQuery(queries, new QueryInfo(query, table, false, (String[])Iterables.toArray((Iterable)refColumns, String.class), values2.toArray()), (DasConstraint)key2);
        }
    }

    private static void collectExportedKeyQueries(@NotNull Map<String, QueryInfo> queries, @NotNull DasDataSource dataSource, @NotNull DasTable databaseTable, @NotNull Dbms dbms, @NotNull DataGrid dataGrid, @NotNull ModelIndex<DataConsumer.Row> selectedRow, @NotNull TIntHashSet selectedColumns) {
        if (queries == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(13);
        }
        if (dataSource == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(14);
        }
        if (databaseTable == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(15);
        }
        if (dbms == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(16);
        }
        if (dataGrid == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(17);
        }
        if (selectedRow == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(18);
        }
        if (selectedColumns == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(19);
        }
        JBIterable referencingKeys = dataSource.getModel().getExportedKeys(databaseTable).filter(DasForeignKey.class);
        ArrayList values2 = ContainerUtil.newArrayList();
        for (DasForeignKey key2 : referencingKeys) {
            if (!DataGridDocumentationProvider.tryCollectValues(dataGrid, selectedRow, selectedColumns, values2, key2.getRefColumns().names())) continue;
            DasTable table = key2.getTable();
            Iterable columnsRef = key2.getColumnsRef().names();
            DbDataSource system = DataGridUtil.getDatabaseSystem(dataGrid);
            String query = DbImplUtil.createSelectAllQuery(table, dbms, (DasDataSource)system, 1, columnsRef, values2).getStatement();
            DataGridDocumentationProvider.collectQuery(queries, new QueryInfo(query, table, true, (String[])Iterables.toArray((Iterable)columnsRef, String.class), values2.toArray()), (DasConstraint)key2);
        }
    }

    private static void collectQuery(@NotNull Map<String, QueryInfo> queries, @NotNull QueryInfo newQueryInfo, @NotNull DasConstraint key2) {
        String keyText;
        String query;
        QueryInfo info;
        if (queries == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(20);
        }
        if (newQueryInfo == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(21);
        }
        if (key2 == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(22);
        }
        if ((info = queries.get(query = newQueryInfo.query)) == null) {
            info = newQueryInfo;
            queries.put(query, info);
        }
        if (!info.keysAndColumns.contains(keyText = key2.getName() + "(" + StringUtil.join((Iterable)key2.getColumnsRef().names(), (String)", ") + ")")) {
            if (!info.keysAndColumns.isEmpty()) {
                info.keysAndColumns = info.keysAndColumns + ", ";
            }
            info.keysAndColumns = info.keysAndColumns + keyText;
        }
    }

    protected static boolean tryCollectValues(@NotNull DataGrid dataGrid, @NotNull ModelIndex<DataConsumer.Row> selectedRow, @NotNull TIntHashSet selectedColumns, @NotNull List<Object> values2, @NotNull Iterable<String> columnNames) {
        if (dataGrid == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(23);
        }
        if (selectedRow == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(24);
        }
        if (selectedColumns == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(25);
        }
        if (values2 == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(26);
        }
        if (columnNames == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(27);
        }
        values2.clear();
        boolean noIndexColumnSelected = JBIterable.from(columnNames).filter(columnName -> {
            ModelIndex<DataConsumer.Column> c2;
            if (dataGrid == null) {
                DataGridDocumentationProvider.$$$reportNull$$$0(46);
            }
            if (selectedColumns == null) {
                DataGridDocumentationProvider.$$$reportNull$$$0(47);
            }
            return (c2 = DataGridUtil.findColumn(dataGrid, columnName)).isValid(dataGrid) && selectedColumns.contains(c2.asInteger());
        }).isEmpty();
        if (noIndexColumnSelected) {
            return false;
        }
        GridModel<DataConsumer.Row, DataConsumer.Column> dataModel = dataGrid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        for (String name : columnNames) {
            ModelIndex<DataConsumer.Column> c2 = DataGridUtil.findColumn(dataGrid, name);
            if (!c2.isValid(dataGrid)) {
                return false;
            }
            values2.add(dataModel.getValueAt(selectedRow, c2));
        }
        return true;
    }

    private static void runQueries(final DataGrid dataGrid, final State state, final String initialValue) {
        if (state.queries.isEmpty()) {
            return;
        }
        final PsiElement element2 = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(DataManager.getInstance().getDataContext((Component)dataGrid.getComponent()));
        if (element2 == null || DataGridPomTarget.unwrapCell(element2) == null) {
            return;
        }
        final Project project = element2.getProject();
        DatabaseGridDataHookUp ownerEx = DataGridUtil.getDatabaseHookUp(dataGrid);
        if (ownerEx == null) {
            return;
        }
        ownerEx.getMessageBus().getDataProducer().processRequest(new DataRequest.RawRequest(ownerEx){

            @Override
            public void processRaw(DataRequest.Context context, DatabaseConnection connection2) {
                StringBuilder sb = new StringBuilder();
                for (QueryInfo info : state.queries) {
                    this.checkCancelled();
                    int length = sb.length();
                    DbImplUtil.tryLoadFirstNRows(connection2, info.query, sb, 1);
                    this.checkCancelled();
                    if (sb.length() == length) continue;
                    String title = !info.exported ? "Referenced " + info.table.getName() : "First referencing " + info.table.getName();
                    sb.insert(length, "<br><b>" + title + ":</b><br>" + info.keysAndColumns);
                }
                if (sb.length() == 0) {
                    return;
                }
                sb.insert(0, "<br>");
                dataGrid.putUserData(GRID_HINT_STATE_KEY, new State(state.queries, state.row, sb.toString()));
                String doc = sb.insert(0, initialValue).toString();
                QuickDocUtil.updateQuickDoc((Project)project, (PsiElement)element2, (String)doc);
            }

            void checkCancelled() {
                if (dataGrid.getUserData(GRID_HINT_STATE_KEY) != state) {
                    throw new ProcessCanceledException();
                }
            }
        });
    }

    @NotNull
    public static String getCellDocumentation(@NotNull DataGrid dataGrid, final Command mode) {
        if (dataGrid == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(28);
        }
        final Map<String, Image> imageMap = DataGridDocumentationProvider.getImageMap(dataGrid);
        StringBuilder sb = new StringBuilder(DisplayHtmlValuesExtractor.getHeader());
        SelectionModel selectionModel = dataGrid.getSelectionModel();
        boolean singleValue = selectionModel.getSelectedColumnCount() + selectionModel.getSelectedRowCount() == 2;
        final boolean plainMode = singleValue && mode != Command.transposed;
        CharOut.Wrapper out = new CharOut.Wrapper(CharOut.Util.newSink(sb)){
            int max;
            {
                super(delegate);
                this.max = 10240;
            }

            @Override
            @NotNull
            public CharOut append(@NotNull CharSequence seq) {
                CharSequence trimmedSeq;
                if (seq == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (seq.length() == 0) {
                    2 v0 = this;
                    if (v0 == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return v0;
                }
                boolean truncate = mode != Command.full && (double)seq.length() > 1.1 * (double)this.max;
                CharSequence charSequence = trimmedSeq = truncate ? seq.subSequence(0, this.max) : seq;
                if (plainMode) {
                    DataGridDocumentationProvider.appendHyperLinkCommand(this.getDelegate(), Command.transposed, null);
                    if (truncate) {
                        DataGridDocumentationProvider.appendHyperLinkCommand(this.getDelegate().append("&nbsp;&nbsp;&nbsp;"), Command.full, "All " + ExtractorsUtil.getPresentableSize(seq.length()));
                    }
                    super.append("<br><br><pre><code>");
                    this.appendInner(trimmedSeq);
                    super.append("</code>");
                    if (truncate) {
                        DataGridDocumentationProvider.appendHyperLinkCommand(this.getDelegate().append("&nbsp;"), Command.full, ExtractorsUtil.getPresentableSize(seq.length() - this.max) + " more...");
                    }
                    super.append("</pre>");
                } else if (truncate) {
                    this.appendInner(trimmedSeq);
                    super.append(" " + ExtractorsUtil.getPresentableSize(seq.length() - this.max) + " more...");
                } else {
                    this.appendInner(seq);
                }
                2 v2 = this;
                if (v2 == null) {
                    2.$$$reportNull$$$0(2);
                }
                return v2;
            }

            void appendInner(CharSequence trimmedSeq) {
                int cur = 0;
                int len = trimmedSeq.length();
                while (cur < len) {
                    int next = StringUtil.indexOf((CharSequence)trimmedSeq, (char)'\n', (int)cur);
                    next = next < 0 ? len : next;
                    super.append(trimmedSeq.subSequence(cur, next));
                    if (next != len) {
                        super.append(" \n");
                    }
                    cur = next + 1;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "seq";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/run/ui/DataGridDocumentationProvider$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/run/ui/DataGridDocumentationProvider$2";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "append";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "append";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        final ObjectFormatter delegateFormatter = dataGrid.getObjectFormatter();
        ObjectFormatter converter = new ObjectFormatter(){

            @Override
            @Nullable
            public String objectToString(@Nullable Object o, DataConsumer.Column column2, Dbms dbms, boolean forDisplay) {
                String s = delegateFormatter.objectToString(o, column2, dbms, true);
                if (o instanceof ObjectFormatter.ImageInfo) {
                    ObjectFormatter.ImageInfo info = (ObjectFormatter.ImageInfo)o;
                    long id = ourImageCounter.incrementAndGet();
                    String imageSpec = "http://img" + id;
                    imageMap.put(imageSpec, info.createImage());
                    delegateFormatter.objectToString(o, column2, dbms, forDisplay);
                    return "<img src=\"" + imageSpec + "\" alt=\"" + s + "\" height=\"" + info.height + "\" width=\"" + info.width + "\" />";
                }
                if (s == null) {
                    return null;
                }
                return plainMode ? JDOMUtil.legalizeChars((CharSequence)s).toString() : s;
            }
        };
        if (singleValue && mode != Command.transposed) {
            DataGridUtil.extractSelectedValues(dataGrid, ExtractorsUtil.getSingleValueExtractor(converter), out);
        } else {
            int[] columns = (mode == Command.transposed ? dataGrid.getVisibleColumns() : selectionModel.getSelectedColumns()).asArray();
            DisplayHtmlValuesExtractor extractor = new DisplayHtmlValuesExtractor(DocumentationComponent.COLOR_KEY.getDefaultColor(), converter);
            extractor.setTransposedMode(mode == Command.transposed);
            extractor.setIncludeRowNumbers(mode == Command.transposed);
            DataGridDocumentationProvider.appendHyperLinkCommand(out.getDelegate(), mode == Command.transposed ? Command.regular : Command.transposed, null).append("<br><br>");
            Dbms dbms = DataGridUtil.getDbms(dataGrid);
            List<DataConsumer.Column> allColumns = dataGrid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getColumns();
            List<DataConsumer.Row> selectedRows = DataGridUtil.getSelectedRows(dataGrid);
            ExtractorsUtil.extract(out, dbms, false, allColumns, extractor, selectedRows, columns);
        }
        String result2 = DataGridDocumentationProvider.buildAndRunQueries(dataGrid, sb);
        String string = (result2 == null ? sb : sb.append(result2)).append("<br><br><br>").toString();
        if (string == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(29);
        }
        return string;
    }

    @Nullable
    public Image getLocalImageForElement(@NotNull PsiElement element2, @NotNull String imageSpec) {
        DataGrid dataGrid;
        if (element2 == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(30);
        }
        if (imageSpec == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(31);
        }
        if ((dataGrid = DataGridPomTarget.unwrapDataGrid(element2)) == null) {
            return null;
        }
        Map<String, Image> map = DataGridDocumentationProvider.getImageMap(dataGrid);
        return map.get(imageSpec);
    }

    @NotNull
    private static Map<String, Image> getImageMap(@NotNull DataGrid dataGrid) {
        Map map;
        if (dataGrid == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(32);
        }
        if ((map = (Map)dataGrid.getUserData(IMAGE_MAP_KEY)) == null) {
            map = ContainerUtil.createConcurrentWeakValueMap();
            dataGrid.putUserData(IMAGE_MAP_KEY, map);
        }
        Map map2 = map;
        if (map2 == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(33);
        }
        return map2;
    }

    @Nullable
    public String getQuickNavigateInfo(PsiElement element2, PsiElement originalElement) {
        return null;
    }

    @Nullable
    public List<String> getUrlFor(PsiElement element2, PsiElement originalElement) {
        return null;
    }

    @Nullable
    public String generateDoc(PsiElement element2, @Nullable PsiElement originalElement) {
        DataGridPomTarget.Cell cell = DataGridPomTarget.unwrapCell(element2);
        if (cell != null) {
            PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)element2.getProject());
            Command command = Command.getCommand(propertiesComponent.getValue(VIEW_MODE_PROPERTY), Command.regular);
            return DataGridDocumentationProvider.getCellDocumentation(cell.dataGrid, command);
        }
        DataGrid dataGrid = DataGridPomTarget.unwrapDataGrid(element2);
        if (DataGridUtil.getQueryText(dataGrid) != null) {
            return DataGridDocumentationProvider.getGridDocumentation(element2.getProject(), dataGrid);
        }
        return null;
    }

    @Nullable
    private static String getGridDocumentation(Project project, @NotNull DataGrid dataGrid) {
        String queryText;
        if (dataGrid == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(34);
        }
        if ((queryText = DataGridUtil.getQueryText(dataGrid)) == null) {
            return null;
        }
        GridPagingModel pageModel = dataGrid.getDataHookup().getPageModel();
        String curCount = pageModel.getTotalRowCount() + (!pageModel.isTotalRowCountPrecise() ? "+" : "");
        return "<b>rows:</b> " + curCount + (pageModel.isTotalRowCountUpdateable() ? DataGridDocumentationProvider.getCountCommand(pageModel.isTotalRowCountPrecise()) : "") + "<br><br><pre><code>" + DbSqlUtil.sql2Html(project, (Language)DataGridUtil.getSqlDialect(dataGrid), queryText) + "</code></pre>";
    }

    @Nullable
    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element2) {
        return null;
    }

    @Nullable
    public PsiElement getDocumentationElementForLink(PsiManager psiManager, String link, PsiElement context) {
        return null;
    }

    public boolean handleExternal(PsiElement element2, PsiElement originalElement) {
        return false;
    }

    public boolean handleExternalLink(PsiManager psiManager, String link, PsiElement context) {
        return false;
    }

    public boolean canFetchDocumentationLink(String link) {
        return link.startsWith(URL_PREFIX);
    }

    @NotNull
    public String fetchExternalDocumentation(@NotNull String link, @Nullable PsiElement element2) {
        if (link == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(35);
        }
        if (element2 == null) {
            if ("" == null) {
                DataGridDocumentationProvider.$$$reportNull$$$0(36);
            }
            return "";
        }
        int paramStart = link.indexOf(63);
        String substring = link.substring(URL_PREFIX.length() + 1, paramStart == -1 ? link.length() : paramStart);
        Command command = Command.getCommand(substring, null);
        Project project = element2.getProject();
        if (command == Command.count) {
            int queryIdx;
            Long rowCount = DataGridDocumentationProvider.getUpdatedRowCount(project, element2);
            if (rowCount == null || !project.isOpen()) {
                if ("" == null) {
                    DataGridDocumentationProvider.$$$reportNull$$$0(37);
                }
                return "";
            }
            DocumentationComponent component = QuickDocUtil.getActiveDocComponent((Project)project);
            String text2 = component == null ? null : component.getText();
            int n = queryIdx = text2 == null ? -1 : text2.indexOf(link);
            if (queryIdx < 0) {
                if ("" == null) {
                    DataGridDocumentationProvider.$$$reportNull$$$0(38);
                }
                return "";
            }
            int idx0 = text2.lastIndexOf("</b>", queryIdx) + "</b>".length() + 1;
            int idx1 = text2.indexOf("</a>", queryIdx + link.length()) + "</a>".length();
            if (idx0 < 0 || idx1 < 0) {
                if ("" == null) {
                    DataGridDocumentationProvider.$$$reportNull$$$0(39);
                }
                return "";
            }
            String string = text2.substring(0, idx0) + rowCount.toString() + DataGridDocumentationProvider.getCountCommand(true) + text2.substring(idx1);
            if (string == null) {
                DataGridDocumentationProvider.$$$reportNull$$$0(40);
            }
            return string;
        }
        if (command == Command.transposed || command == Command.regular) {
            PropertiesComponent.getInstance((Project)project).setValue(VIEW_MODE_PROPERTY, command.name());
        }
        String string = DataGridDocumentationProvider.getCellDocumentation((DataGrid)ObjectUtils.assertNotNull((Object)DataGridPomTarget.unwrapDataGrid(element2)), command);
        if (string == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(41);
        }
        return string;
    }

    public boolean canHandleExternal(@Nullable PsiElement element2, @Nullable PsiElement originalElement) {
        return false;
    }

    @Nullable
    private static Long getUpdatedRowCount(@NotNull Project project, @Nullable PsiElement element2) {
        AsyncFutureResult<Long> rowCountResult;
        if (project == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(42);
        }
        if (element2 instanceof DbTable) {
            VirtualFile file = ((DbTable)element2).getVirtualFile();
            if (file == null) {
                return null;
            }
            final Disposable disposable = Disposer.newDisposable();
            Disposer.register((Disposable)project, (Disposable)disposable);
            DatabaseTableGridDataHookUp hookUp = GridDataHookUpManager.getInstance(project).getOrCreateLightweight(file, disposable, DGDepartment.QUICK_DOCUMENTATION);
            rowCountResult = CountRowsAction.countRows(hookUp);
            rowCountResult.addConsumer(SameThreadExecutor.INSTANCE, (ResultConsumer)new ResultConsumer<Long>(){

                public void onSuccess(Long value) {
                    Disposer.dispose((Disposable)disposable);
                }

                public void onFailure(@NotNull Throwable t) {
                    if (t == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    Disposer.dispose((Disposable)disposable);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/database/run/ui/DataGridDocumentationProvider$4", "onFailure"));
                }
            });
        } else {
            DataGrid grid = DataGridPomTarget.unwrapDataGrid(element2);
            if (grid == null) {
                return null;
            }
            rowCountResult = CountRowsAction.countRows(grid);
        }
        try {
            return (Long)rowCountResult.get();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getCountCommand(boolean refresh) {
        return "&nbsp&nbsp<a href=\"db-doc:///" + Command.count.name() + "\">click to " + (refresh ? "refresh" : "count(*)") + "</a>";
    }

    @NotNull
    private static CharOut appendHyperLinkCommand(@NotNull CharOut sb, @NotNull Command command, @Nullable String text2) {
        if (sb == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(43);
        }
        if (command == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(44);
        }
        CharOut charOut = sb.append("<a href=\"db-doc:///" + command.name() + "\">" + StringUtil.capitalize((String)StringUtil.notNullize((String)text2, (String)(command.name() + " View"))) + "</a>");
        if (charOut == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(45);
        }
        return charOut;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 29: 
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 45: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 29: 
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 45: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataGrid";
                break;
            }
            case 1: 
            case 3: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: 
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databaseTable";
                break;
            }
            case 5: 
            case 11: 
            case 18: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedRow";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyTypes";
                break;
            }
            case 7: 
            case 13: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queries";
                break;
            }
            case 9: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 12: 
            case 19: 
            case 25: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedColumns";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newQueryInfo";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnNames";
                break;
            }
            case 29: 
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/DataGridDocumentationProvider";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imageSpec";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "link";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/DataGridDocumentationProvider";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getCellDocumentation";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getImageMap";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchExternalDocumentation";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "appendHyperLinkCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildAndRunQueries";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hasNavigatableKeys";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "buildQueries";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "collectForeignKeyQueries";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "collectExportedKeyQueries";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "collectQuery";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "tryCollectValues";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getCellDocumentation";
                break;
            }
            case 29: 
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 45: {
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getLocalImageForElement";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getImageMap";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getGridDocumentation";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "fetchExternalDocumentation";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getUpdatedRowCount";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "appendHyperLinkCommand";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "lambda$tryCollectValues$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 29: 
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 45: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class QueryInfo {
        public final String query;
        public final DasTable table;
        public final boolean exported;
        public final String[] columnNames;
        public final Object[] values;
        public String keysAndColumns = "";

        QueryInfo(String query, DasTable table, boolean exported, String[] columnNames, Object[] values2) {
            this.query = query;
            this.table = table;
            this.exported = exported;
            this.columnNames = columnNames;
            this.values = values2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            QueryInfo info = (QueryInfo)o;
            return this.query.equals(info.query);
        }

        public int hashCode() {
            return this.query.hashCode();
        }
    }

    private static class State {
        final List<QueryInfo> queries;
        final ModelIndex<DataConsumer.Row> row;
        final String current;
        final long timestamp = System.currentTimeMillis();

        State(List<QueryInfo> queries, ModelIndex<DataConsumer.Row> row, String current) {
            this.queries = queries;
            this.row = row;
            this.current = current;
        }
    }

    public static enum KeyType {
        EXPORTED,
        FOREIGN,
        SELECTED;

    }

    private static enum Command {
        transposed,
        regular,
        full,
        count;


        static Command getCommand(String name, Command def) {
            try {
                return Enum.valueOf(Command.class, name);
            }
            catch (Exception e) {
                return def;
            }
        }
    }
}

