/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.htmltools.codeInspection.htmlInspections;

import com.intellij.codeInsight.daemon.impl.analysis.InsertRequiredAttributeFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.htmlInspections.HtmlLocalInspectionTool;
import com.intellij.htmltools.codeInspection.htmlInspections.InspectionUtils;
import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.ide.highlighter.XHtmlFileType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.util.HtmlUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class HtmlRequiredLangAttributeInspection
extends HtmlLocalInspectionTool {
    private static final String LANG = "lang";
    private static final String HTML = "html";
    private static final String XML_LANG = "xml:lang";
    private static final String XHTML_1 = "DTD XHTML 1.0";
    private static final String XHTML_11 = "DTD XHTML 1.1";

    protected void checkTag(@NotNull XmlTag tag, @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (tag == null) {
            HtmlRequiredLangAttributeInspection.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            HtmlRequiredLangAttributeInspection.$$$reportNull$$$0(1);
        }
        if (!HtmlUtil.isHtmlTagContainingFile((PsiElement)tag)) {
            return;
        }
        XmlAttribute lang = tag.getAttribute(LANG);
        XmlAttribute xmlLang = tag.getAttribute(XML_LANG);
        String tagName = tag.getName();
        ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>();
        if (!tagName.equalsIgnoreCase(HTML)) {
            return;
        }
        if (tag.getContainingFile().getFileType() == XHtmlFileType.INSTANCE) {
            XmlDocument doc = (XmlDocument)PsiTreeUtil.getContextOfType((PsiElement)tag, XmlDocument.class, (boolean)true);
            if (doc == null || doc.getProlog() == null || doc.getProlog().getDoctype() == null || doc.getProlog().getDoctype().getPublicId() == null) {
                return;
            }
            if (doc.getProlog().getDoctype().getPublicId().contains(XHTML_1)) {
                if (xmlLang != null || lang != null) {
                    return;
                }
                if (isOnTheFly) {
                    fixes.add((LocalQuickFix)new InsertRequiredAttributeFix(tag, XML_LANG, new String[0]));
                }
            } else if (doc.getProlog().getDoctype().getPublicId().contains(XHTML_11)) {
                if (tag.getAttribute(XML_LANG) != null) {
                    return;
                }
                if (isOnTheFly) {
                    fixes.add((LocalQuickFix)new InsertRequiredAttributeFix(tag, XML_LANG, new String[0]));
                }
            }
        } else if (tag.getContainingFile().getFileType() == HtmlFileType.INSTANCE) {
            if (tag.getAttribute(LANG) != null) {
                return;
            }
            if (isOnTheFly) {
                fixes.add((LocalQuickFix)new InsertRequiredAttributeFix(tag, LANG, new String[0]));
            }
        } else {
            return;
        }
        InspectionUtils.RegisterProblem(tag, holder, fixes, XmlBundle.message((String)"html.inspections.check.required.lang", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = XmlBundle.message((String)"html.inspections.check.required.lang", (Object[])new Object[0]);
        if (string == null) {
            HtmlRequiredLangAttributeInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("HtmlRequiredLangAttribute" == null) {
            HtmlRequiredLangAttributeInspection.$$$reportNull$$$0(3);
        }
        return "HtmlRequiredLangAttribute";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/htmltools/codeInspection/htmlInspections/HtmlRequiredLangAttributeInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/htmltools/codeInspection/htmlInspections/HtmlRequiredLangAttributeInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkTag";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

