/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.util;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.psi.JSDestructuringArray;
import com.intellij.lang.javascript.psi.JSDestructuringArrayRestElement;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSDestructuringObject;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;

public abstract class JSDestructuringVisitor
extends JSElementVisitor {
    public static final TokenSet VAR_AND_CONTAINERS = TokenSet.orSet((TokenSet[])new TokenSet[]{JSExtendedLanguagesTokenSetProvider.VARIABLES, JSExtendedLanguagesTokenSetProvider.DESTRUCTURING_ELEMENTS, JSElementTypes.DESTRUCTURING_CONTAINERS, TokenSet.create((IElementType[])new IElementType[]{JSStubElementTypes.DESTRUCTURING_ARRAY_REST})});

    public final void visitJSDestructuringObject(JSDestructuringObject node) {
        JSDestructuringProperty[] properties;
        for (JSDestructuringProperty property : properties = node.getProperties()) {
            JSInitializerOwner element = property.getDestructuringElement();
            if (element == null) continue;
            element.accept((PsiElementVisitor)this);
        }
    }

    public final void visitJSDestructuringArray(JSDestructuringArray node) {
        JSInitializerOwner[] elements;
        for (JSInitializerOwner element : elements = node.getElements()) {
            if (element == null) continue;
            element.accept((PsiElementVisitor)this);
        }
        JSDestructuringArrayRestElement rest = node.getRestElement();
        if (rest != null && rest.getVariable() != null) {
            rest.getVariable().accept((PsiElementVisitor)this);
        }
    }

    public final void visitJSParameterList(JSParameterList node) {
        this.acceptChildren((JSElement)node);
    }

    public final void visitJSVarStatement(JSVarStatement node) {
        this.acceptChildren((JSElement)node);
    }

    private void acceptChildren(JSElement node) {
        if (node instanceof StubBasedPsiElementBase) {
            PsiElement[] children;
            for (PsiElement child : children = ((StubBasedPsiElementBase)node).getStubOrPsiChildren(VAR_AND_CONTAINERS, PsiElement.ARRAY_FACTORY)) {
                child.accept((PsiElementVisitor)this);
            }
        } else {
            PsiElement[] children;
            for (PsiElement child : children = node.getChildren()) {
                if (child == null) continue;
                child.accept((PsiElementVisitor)this);
            }
        }
    }

    public abstract void visitJSParameter(JSParameter var1);

    public abstract void visitJSVariable(JSVariable var1);

    public void visitJSDestructuringElement(JSDestructuringElement destructuringElement) {
        JSDestructuringContainer target = destructuringElement.getTarget();
        if (target != null) {
            target.accept((PsiElementVisitor)this);
        }
    }
}

