/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.netty.handler;

import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.api.model.StreamType;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.Arrays;

public class FramedResponseStreamHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    private static final int HEADER_SIZE = 8;
    private final ByteBuf rawBuffer = Unpooled.buffer((int)1000);
    private byte[] header = new byte[8];
    private int headerCnt = 0;
    private byte[] payload = new byte[0];
    private int payloadCnt = 0;
    private ResultCallback<Frame> resultCallback;
    private StreamType streamType = null;

    public FramedResponseStreamHandler(ResultCallback<Frame> resultCallback) {
        this.resultCallback = resultCallback;
    }

    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
        this.rawBuffer.writeBytes(msg, 0, msg.readableBytes());
        Frame frame = null;
        do {
            if ((frame = this.decode()) == null) continue;
            this.resultCallback.onNext(frame);
        } while (frame != null);
    }

    private int read(byte[] buf, int offset, int length) {
        length = Math.min(this.rawBuffer.readableBytes(), length);
        this.rawBuffer.readBytes(buf, offset, length);
        this.rawBuffer.discardReadBytes();
        return length;
    }

    private Frame decode() {
        int count;
        if (this.headerCnt < 8) {
            int headerCount = this.read(this.header, this.headerCnt, 8 - this.headerCnt);
            if (headerCount == 0) {
                return null;
            }
            this.headerCnt += headerCount;
            this.streamType = FramedResponseStreamHandler.streamType(this.header[0]);
            if (this.streamType.equals((Object)StreamType.RAW)) {
                return new Frame(this.streamType, Arrays.copyOf(this.header, headerCount));
            }
            if (this.headerCnt < 8) {
                return null;
            }
        }
        if (this.streamType.equals((Object)StreamType.RAW)) {
            int count2;
            if (this.payloadCnt == 0) {
                this.payload = new byte[this.rawBuffer.readableBytes()];
            }
            if ((count2 = this.read(this.payload, this.payloadCnt, this.rawBuffer.readableBytes())) == 0) {
                return null;
            }
            this.payloadCnt = 0;
            return new Frame(StreamType.RAW, this.payload);
        }
        int payloadSize = ((this.header[4] & 0xFF) << 24) + ((this.header[5] & 0xFF) << 16) + ((this.header[6] & 0xFF) << 8) + (this.header[7] & 0xFF);
        if (this.payloadCnt == 0) {
            this.payload = new byte[payloadSize];
        }
        if ((count = this.read(this.payload, this.payloadCnt, payloadSize - this.payloadCnt)) == 0) {
            return null;
        }
        this.payloadCnt += count;
        if (this.payloadCnt < payloadSize) {
            return null;
        }
        this.headerCnt = 0;
        this.payloadCnt = 0;
        return new Frame(this.streamType, this.payload);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.resultCallback.onError(cause);
        ctx.close();
    }

    private static StreamType streamType(byte streamType) {
        switch (streamType) {
            case 0: {
                return StreamType.STDIN;
            }
            case 1: {
                return StreamType.STDOUT;
            }
            case 2: {
                return StreamType.STDERR;
            }
        }
        return StreamType.RAW;
    }
}

