/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.framework.ui;

import com.intellij.CommonBundle;
import com.intellij.execution.RunCanceledByUserException;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.ChooseFileEncodingAction;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.hash.HashMap;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ValidatingTableEditor;
import com.jetbrains.php.FrameworkBundle;
import com.jetbrains.php.framework.FrameworkRunConsoleAction;
import com.jetbrains.php.framework.FrameworkUtils;
import com.jetbrains.php.framework.data.FrameworkConfigurationDescription;
import com.jetbrains.php.framework.data.FrameworkDataService;
import com.jetbrains.php.framework.generators.FrameworkDescriptionProvider;
import com.jetbrains.php.framework.generators.custom.CustomUtils;
import com.jetbrains.php.framework.ui.FailedToParseDialog;
import com.jetbrains.php.framework.ui.FrameworkChooseProviderDialog;
import com.jetbrains.php.framework.ui.FrameworkEditDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrameworkCommandsForm {
    private static final Logger LOG = Logger.getInstance(FrameworkCommandsForm.class);
    private static final Icon EDIT_ACTION_ICON = AllIcons.Actions.Edit;
    private static final Icon SHOW_IN_EDITOR_ICON = AllIcons.Actions.EditSource;
    private static final Integer CREATE_WITH_PROJECT_VISIBILITY = 0;
    private static final Integer CREATE_WITH_GLOBAL_VISIBILITY = 1;
    private static final Integer DO_NOT_CREATE = 2;
    @NonNls
    private static final String SHOW_PREDEFINED_FRAMEWORK_COLUMN = "clt.show.predefined.framework.column";
    private static final boolean SHOW_PREDEFINED_FRAMEWORK_COLUMN_DEFAULT_VALUE = true;
    private final Project myProject;
    private JPanel myMainPanel;
    private JPanel myTableEditorPanel;
    private JRadioButton myPopupRadioButton;
    private JRadioButton myToolWindowRadioButton;
    private JBCheckBox myFrameworkTypeColumnCheckbox;
    private final ValidatingTableEditor<FrameworkDataService.FrameworkFileData> myTableEditor;
    private JPanel myEncodingComboBoxPlaceholder;
    private final ChooseFileEncodingAction myEncodingAction;
    private final Ref<Charset> myCharset;
    private final List<FrameworkConfigurationDescription> myFrameworksToOpenInEditor;

    public FrameworkCommandsForm(Project project) {
        this.$$$setupUI$$$();
        this.myCharset = new Ref();
        this.myFrameworksToOpenInEditor = new ArrayList<FrameworkConfigurationDescription>();
        this.myProject = project;
        this.myTableEditor = new FrameworkValidatingTableEditor(new AnActionButton[]{new EditActionButton(), new ReloadCommandsActionButton(), new ShowInEditorActionButton()});
        this.myTableEditorPanel.add(this.myTableEditor.getContentPane(), "Center");
        FrameworkDataService dataService = FrameworkDataService.getInstance(project);
        List<FrameworkDataService.FrameworkFileData> data = dataService.cloneData();
        this.myTableEditor.setModel(FrameworkCommandsForm.getColumnInfos(), data);
        this.myTableEditor.setColumnReorderingAllowed(false);
        this.myFrameworkTypeColumnCheckbox.setSelected(PropertiesComponent.getInstance().getBoolean(SHOW_PREDEFINED_FRAMEWORK_COLUMN, true));
        this.myFrameworkTypeColumnCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean selected = FrameworkCommandsForm.this.myFrameworkTypeColumnCheckbox.isSelected();
                PropertiesComponent.getInstance().setValue(FrameworkCommandsForm.SHOW_PREDEFINED_FRAMEWORK_COLUMN, selected, true);
                FrameworkCommandsForm.this.myTableEditor.setModel(FrameworkCommandsForm.getColumnInfos(), FrameworkCommandsForm.this.myTableEditor.getItems());
            }
        });
        this.myEncodingAction = FrameworkCommandsForm.installChooseEncodingCombo(this.myEncodingComboBoxPlaceholder, this.myCharset);
    }

    private static ChooseFileEncodingAction installChooseEncodingCombo(@NotNull JPanel parentPanel, final @NotNull Ref<Charset> selected) {
        if (parentPanel == null) {
            FrameworkCommandsForm.$$$reportNull$$$0(0);
        }
        if (selected == null) {
            FrameworkCommandsForm.$$$reportNull$$$0(1);
        }
        ChooseFileEncodingAction myAction = new ChooseFileEncodingAction(null){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                FrameworkCommandsForm.updateEncodingAction(this, (Ref<? extends Charset>)selected);
            }

            protected void chosen(VirtualFile virtualFile, @NotNull Charset charset) {
                if (charset == null) {
                    2.$$$reportNull$$$0(1);
                }
                selected.set((Object)(charset == NO_ENCODING ? null : charset));
                FrameworkCommandsForm.updateEncodingAction(this, (Ref<? extends Charset>)selected);
            }

            @NotNull
            protected DefaultActionGroup createPopupActionGroup(JComponent button) {
                DefaultActionGroup defaultActionGroup = this.createCharsetsActionGroup("<System Default>", (Charset)selected.get(), charset -> "Choose encoding '" + charset + "'");
                if (defaultActionGroup == null) {
                    2.$$$reportNull$$$0(2);
                }
                return defaultActionGroup;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "charset";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/framework/ui/FrameworkCommandsForm$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/framework/ui/FrameworkCommandsForm$2";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createPopupActionGroup";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "chosen";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        parentPanel.removeAll();
        Presentation templatePresentation = myAction.getTemplatePresentation();
        parentPanel.add((Component)myAction.createCustomComponent(templatePresentation), "Center");
        FrameworkCommandsForm.updateEncodingAction(myAction, selected);
        return myAction;
    }

    private static void updateEncodingAction(ChooseFileEncodingAction action, Ref<? extends Charset> selected) {
        action.getTemplatePresentation().setEnabled(true);
        Charset charset = (Charset)selected.get();
        action.getTemplatePresentation().setText(charset == null ? EncodingManager.getInstance().getDefaultCharsetName() : charset.displayName());
    }

    private boolean showConsoleInToolWindow() {
        return this.myToolWindowRadioButton.isSelected();
    }

    private void setShowConsoleInToolwindow(boolean show) {
        this.myPopupRadioButton.setSelected(!show);
        this.myToolWindowRadioButton.setSelected(show);
    }

    private static ColumnInfo<FrameworkDataService.FrameworkFileData, Object>[] getColumnInfos() {
        boolean showAll = PropertiesComponent.getInstance().getBoolean(SHOW_PREDEFINED_FRAMEWORK_COLUMN, true);
        if (showAll) {
            return new ColumnInfo[]{new EnabledColumnInfo(), new AliasColumnInfo(), new InvocationColumnInfo(), new PredefinedFrameworkColumnInfo()};
        }
        return new ColumnInfo[]{new EnabledColumnInfo(), new AliasColumnInfo(), new InvocationColumnInfo()};
    }

    @Nullable
    private <UserData> FrameworkConfigurationDescription loadCommands(FrameworkDescriptionProvider<UserData> provider, Component component) {
        UserData path;
        try {
            path = provider.getFrameworkUserData(component);
        }
        catch (RunCanceledByUserException e) {
            return null;
        }
        if (provider == CustomUtils.DESCRIPTION_PROVIDER) {
            try {
                EmptyProgressIndicator pi = new EmptyProgressIndicator();
                pi.start();
                FrameworkConfigurationDescription framework = provider.getFrameworkData(path, component, (ProgressIndicator)pi);
                this.myFrameworksToOpenInEditor.add(framework);
                return framework;
            }
            catch (RunCanceledByUserException e) {
                return null;
            }
            catch (FrameworkDescriptionProvider.FrameworkExecutionException e) {
                LOG.error("CustomUtils.DESCRIPTION_PROVIDER mustn't throw ExecutionException in getFrameworkData(CustomFrameworkData path).");
                return null;
            }
            catch (FrameworkDescriptionProvider.FrameworkParseException e) {
                LOG.error("CustomUtils.DESCRIPTION_PROVIDER mustn't throw FrameworkDescriptionProvider.FrameworkParseException in getFrameworkData(CustomFrameworkData path).");
                return null;
            }
        }
        return FrameworkCommandsForm.loadCommands(provider, component, path);
    }

    @Nullable
    private static <UserData> FrameworkConfigurationDescription loadCommands(FrameworkDescriptionProvider<UserData> provider, @Nullable Component component, @Nullable UserData path) {
        CommandsLoader loader = new CommandsLoader(provider, path, component);
        boolean success = ProgressManager.getInstance().runProcessWithProgressSynchronously(loader, FrameworkBundle.message("framework.settings.loading.framework.commands", provider.getFrameworkName()), true, null);
        if (!success) {
            return null;
        }
        if (loader.myErrorMessage != null) {
            Messages.showErrorDialog((Component)component, (String)FrameworkBundle.message("framework.settings.failed.to.load.commands", loader.myErrorMessage), (String)FrameworkBundle.message("framework.commands.form.messages.title.command.line.tools", new Object[0]));
            return null;
        }
        if (loader.myParseException != null) {
            class ParseExceptionDialogWrapper
            extends DialogWrapper {
                private JPanel myMainPanel;
                final /* synthetic */ Component val$component;

                ParseExceptionDialogWrapper(FrameworkDescriptionProvider.FrameworkParseException frameworkParseException) {
                    this.val$component = frameworkParseException;
                    super(true);
                    this.initialize(exception);
                }

                ParseExceptionDialogWrapper(@NotNull FrameworkDescriptionProvider.FrameworkParseException componentForConstruction, Component component) {
                    if (component == null) {
                        ParseExceptionDialogWrapper.$$$reportNull$$$0(0);
                    }
                    this.val$component = component;
                    super((Component)((Object)componentForConstruction), true);
                    this.initialize(exception);
                }

                private void initialize(final FrameworkDescriptionProvider.FrameworkParseException exception) {
                    this.setTitle(FrameworkBundle.message("framework.commands.form.error.message.title.add.framework", new Object[0]));
                    this.myMainPanel = new JPanel();
                    this.myMainPanel.add(new JLabel(FrameworkBundle.message("framework.commands.form.failed.to.parse.command.output", new Object[0])));
                    HyperlinkLabel hyperlinkLabel = new HyperlinkLabel(FrameworkBundle.message("framework.commands.form.details", new Object[0]));
                    this.myMainPanel.add((Component)hyperlinkLabel);
                    hyperlinkLabel.addHyperlinkListener(new HyperlinkListener(){

                        @Override
                        public void hyperlinkUpdate(HyperlinkEvent e) {
                            FailedToParseDialog failedToParseDialog = new FailedToParseDialog(exception, val$component);
                            failedToParseDialog.show();
                        }
                    });
                    this.init();
                }

                protected JComponent createCenterPanel() {
                    return this.myMainPanel;
                }

                @NotNull
                protected Action[] createActions() {
                    Action[] actionArray = new Action[]{this.getOKAction()};
                    if (actionArray == null) {
                        ParseExceptionDialogWrapper.$$$reportNull$$$0(1);
                    }
                    return actionArray;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument %s for @NotNull parameter of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "1";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/jetbrains/php/framework/ui/FrameworkCommandsForm$1ParseExceptionDialogWrapper";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/jetbrains/php/framework/ui/FrameworkCommandsForm$1ParseExceptionDialogWrapper";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "createActions";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "<init>";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            }
            ParseExceptionDialogWrapper dialogWrapper = component == null ? new ParseExceptionDialogWrapper(loader.myParseException, component) : new ParseExceptionDialogWrapper(loader.myParseException, component, component);
            dialogWrapper.show();
            return null;
        }
        FrameworkConfigurationDescription framework = loader.myFramework;
        if (framework != null) {
            int size = framework.getCommands().size();
            String message = FrameworkBundle.message("framework.settings.found.0.1.commands", size, size == 1 ? 0 : 1);
            if (component instanceof JComponent) {
                FrameworkCommandsForm.showMessageBalloon(message, (JComponent)component);
            } else {
                Notification info = new Notification("Command Line Tool", FrameworkBundle.message("framework.tool.window.message.title.command.line.tool", new Object[0]), StringUtil.decapitalize((String)message), NotificationType.INFORMATION);
                Notifications.Bus.notify((Notification)info, (Project)FrameworkUtils.getProject(component));
            }
        }
        return framework;
    }

    @Nullable
    private static String validateFrameworkDescription(FrameworkConfigurationDescription frameworkDescription) {
        if (StringUtil.isEmpty((String)frameworkDescription.getAlias())) {
            return FrameworkBundle.message("framework.settings.alias.should.be.provided", new Object[0]);
        }
        if (StringUtil.isEmpty((String)frameworkDescription.getInvokeText())) {
            return FrameworkBundle.message("framework.settings.tool.path.should.be.provided", new Object[0]);
        }
        return null;
    }

    public JComponent getContentPane() {
        return this.myMainPanel;
    }

    public boolean isModified(FrameworkDataService config) {
        return !Comparing.equal((Object)this.myCharset.get(), (Object)FrameworkDataService.getConsoleCharset()) || this.showConsoleInToolWindow() != FrameworkDataService.isConsoleInToolWindow() || FrameworkCommandsForm.isModified(this.myTableEditor.getItems(), config.cloneData());
    }

    public static boolean isModified(List<? extends FrameworkDataService.FrameworkFileData> items, List<? extends FrameworkDataService.FrameworkFileData> oldItems) {
        if (items.size() != oldItems.size()) {
            return true;
        }
        int currentInvalidItemsSize = 0;
        for (FrameworkDataService.FrameworkFileData frameworkFileData : items) {
            if (frameworkFileData.getFramework() != null) continue;
            ++currentInvalidItemsSize;
        }
        int oldInvalidItemsSize = 0;
        for (FrameworkDataService.FrameworkFileData frameworkFileData : oldItems) {
            if (frameworkFileData.getFramework() != null) continue;
            ++oldInvalidItemsSize;
        }
        if (currentInvalidItemsSize != oldInvalidItemsSize) {
            return true;
        }
        for (FrameworkDataService.FrameworkFileData frameworkFileData : items) {
            if (frameworkFileData.getFramework() == null) continue;
            boolean found = false;
            for (FrameworkDataService.FrameworkFileData frameworkFileData2 : oldItems) {
                if (frameworkFileData2.getFramework() == null || !frameworkFileData.getFramework().getName().equals(frameworkFileData2.getFramework().getName())) continue;
                found = true;
                if (frameworkFileData.getFramework().equals(frameworkFileData2.getFramework()) && frameworkFileData.isProjectVisibility() == frameworkFileData2.isProjectVisibility()) continue;
                return true;
            }
            if (found) continue;
            return true;
        }
        return false;
    }

    public void apply(FrameworkDataService config) {
        boolean inToolWindow = this.showConsoleInToolWindow();
        if (inToolWindow != FrameworkDataService.isConsoleInToolWindow()) {
            FrameworkDataService.setConsoleInToolWindow(inToolWindow);
            FrameworkRunConsoleAction.applyConsoleSettingsToAllProjects();
        }
        FrameworkDataService.setConsoleCharset((Charset)this.myCharset.get());
        for (Project openProject : ProjectManager.getInstance().getOpenProjects()) {
            FrameworkRunConsoleAction.clearInputEditorCache(openProject);
        }
        List items = this.myTableEditor.getItems();
        for (FrameworkDataService.FrameworkFileData item : items) {
            if (item.getFramework() == null || FrameworkCommandsForm.validateFrameworkDescription(item.getFramework()) == null) continue;
            item.getFramework().setEnabled(false);
        }
        config.loadChanged(items);
        this.updateFrameworksToOpen(items);
        if (this.myFrameworksToOpenInEditor.isEmpty()) {
            return;
        }
        FrameworkDataService service = FrameworkDataService.getInstance(this.myProject);
        ArrayList<VirtualFile> fileToOpen = new ArrayList<VirtualFile>(this.myFrameworksToOpenInEditor.size());
        for (FrameworkConfigurationDescription frameworkConfigurationDescription : this.myFrameworksToOpenInEditor) {
            FrameworkDataService.FrameworkFileData currentData = null;
            for (FrameworkDataService.FrameworkFileData item : items) {
                if (!frameworkConfigurationDescription.equals(item.getFramework())) continue;
                currentData = item;
                break;
            }
            if (currentData == null) continue;
            VirtualFile description = service.getFile(currentData);
            if (description == null) {
                LOG.error("Failed to write created framework tools configuration for " + frameworkConfigurationDescription.getName());
                continue;
            }
            fileToOpen.add(description);
        }
        Project project = FrameworkUtils.getProject(this.getContentPane());
        if (project != null) {
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
            for (VirtualFile virtualFile : fileToOpen) {
                fileEditorManager.openFile(virtualFile, false);
            }
        }
        this.myFrameworksToOpenInEditor.clear();
    }

    private void updateFrameworksToOpen(List<FrameworkDataService.FrameworkFileData> items) {
        Iterator<FrameworkConfigurationDescription> iterator = this.myFrameworksToOpenInEditor.iterator();
        while (iterator.hasNext()) {
            boolean found = false;
            String name = iterator.next().getName();
            for (FrameworkDataService.FrameworkFileData item : items) {
                if (item.getFramework() == null || !name.equals(item.getFramework().getName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            iterator.remove();
        }
    }

    public void reset(FrameworkDataService config) {
        this.setShowConsoleInToolwindow(FrameworkDataService.isConsoleInToolWindow());
        this.myCharset.set((Object)FrameworkDataService.getConsoleCharset());
        FrameworkCommandsForm.updateEncodingAction(this.myEncodingAction, this.myCharset);
        List<FrameworkDataService.FrameworkFileData> data = config.cloneData();
        this.myTableEditor.setModel(FrameworkCommandsForm.getColumnInfos(), data);
        this.myFrameworksToOpenInEditor.clear();
    }

    private static boolean isEnabled(FrameworkDataService.FrameworkFileData data) {
        return data.getFramework() != null && data.getFramework().isEnabled();
    }

    private static TableCellRenderer getRendererForString(FrameworkDataService.FrameworkFileData data) {
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setEnabled(FrameworkCommandsForm.isEnabled(data));
        return renderer;
    }

    private static void showMessageBalloon(String message, JComponent component) {
        JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message, MessageType.INFO, null).setShowCallout(false).setFadeoutTime(3000L).setHideOnAction(true).setHideOnClickOutside(true).setHideOnFrameResize(true).setHideOnKeyOutside(true).setBlockClicksThroughBalloon(false).createBalloon().showInCenterOf(component);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parentPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "selected";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/php/framework/ui/FrameworkCommandsForm";
        objectArray[2] = "installChooseEncodingCombo";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JBCheckBox jBCheckBox;
        JPanel jPanel2;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JPanel jPanel3;
        this.myMainPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel3.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel4.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)ResourceBundle.getBundle("messages/FrameworkBundle").getString("framework.show.console.in"), (int)0, (int)0, null, null));
        this.myPopupRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setSelected(true);
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("messages/FrameworkBundle").getString("framework.popup"));
        jPanel4.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myToolWindowRadioButton = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("messages/FrameworkBundle").getString("framework.tool.window"));
        jPanel4.add((Component)jRadioButton, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myTableEditorPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel3.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myFrameworkTypeColumnCheckbox = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, ResourceBundle.getBundle("messages/FrameworkBundle").getString("framework.show.framework.type"));
        jPanel2.add((Component)jBCheckBox, "South");
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel5, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, true));
        Spacer spacer2 = new Spacer();
        jPanel5.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Console encoding:");
        jPanel5.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myEncodingComboBoxPlaceholder = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 0, null, null, null, 0, true));
        Spacer spacer3 = new Spacer();
        jPanel3.add((Component)spacer3, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private class EditActionButton
    extends AnActionButton {
        private EditActionButton() {
            super(FrameworkBundle.message("framework.edit", new Object[0]), EDIT_ACTION_ICON);
        }

        public void updateButton(@NotNull AnActionEvent e) {
            if (e == null) {
                EditActionButton.$$$reportNull$$$0(0);
            }
            super.updateButton(e);
            boolean enabled = e.getPresentation().isEnabled();
            if (enabled) {
                List selectedItems = FrameworkCommandsForm.this.myTableEditor.getSelectedItems();
                boolean bl = enabled = selectedItems != null && selectedItems.size() == 1;
                if (enabled) {
                    enabled = ((FrameworkDataService.FrameworkFileData)selectedItems.get(0)).getFramework() != null;
                }
            }
            e.getPresentation().setEnabled(enabled);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            List selectedItems;
            if (e == null) {
                EditActionButton.$$$reportNull$$$0(1);
            }
            if ((selectedItems = FrameworkCommandsForm.this.myTableEditor.getSelectedItems()) == null || selectedItems.isEmpty()) {
                FrameworkCommandsForm.showMessageBalloon(FrameworkBundle.message("framework.commands.form.no.frameworks.selected", new Object[0]), FrameworkCommandsForm.this.myTableEditorPanel);
                return;
            }
            if (selectedItems.size() > 1) {
                FrameworkCommandsForm.showMessageBalloon(FrameworkBundle.message("framework.too.many.tools.selected", new Object[0]), FrameworkCommandsForm.this.myTableEditorPanel);
                return;
            }
            FrameworkDataService.FrameworkFileData data = (FrameworkDataService.FrameworkFileData)selectedItems.get(0);
            if (data == null) {
                FrameworkCommandsForm.showMessageBalloon(FrameworkBundle.message("framework.tool.description.file.is.invalid", new Object[0]), FrameworkCommandsForm.this.myTableEditorPanel);
                return;
            }
            new FrameworkEditDialog(FrameworkCommandsForm.this.getContentPane(), data).showAndGet();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/jetbrains/php/framework/ui/FrameworkCommandsForm$EditActionButton";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateButton";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ReloadCommandsActionButton
    extends AnActionButton {
        private ReloadCommandsActionButton() {
            super(FrameworkBundle.message("reload.command.list.from.executable", new Object[0]), AllIcons.Actions.Refresh);
        }

        public void updateButton(@NotNull AnActionEvent e) {
            if (e == null) {
                ReloadCommandsActionButton.$$$reportNull$$$0(0);
            }
            super.updateButton(e);
            boolean enabled = e.getPresentation().isEnabled();
            if (enabled) {
                List selectedItems = FrameworkCommandsForm.this.myTableEditor.getSelectedItems();
                if (selectedItems == null || selectedItems.isEmpty()) {
                    enabled = false;
                } else {
                    for (FrameworkDataService.FrameworkFileData item : selectedItems) {
                        if (item.getFramework() != null && FrameworkUtils.getMatchingProvider(item.getFramework()) != null) continue;
                        enabled = false;
                        break;
                    }
                }
            }
            e.getPresentation().setEnabled(enabled);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            List selectedItems;
            if (e == null) {
                ReloadCommandsActionButton.$$$reportNull$$$0(1);
            }
            if ((selectedItems = FrameworkCommandsForm.this.myTableEditor.getSelectedItems()) == null || selectedItems.isEmpty()) {
                FrameworkCommandsForm.showMessageBalloon(FrameworkBundle.message("framework.commands.form.no.frameworks.selected", new Object[0]), FrameworkCommandsForm.this.myTableEditorPanel);
                return;
            }
            HashMap filesAndProviders = new HashMap();
            for (FrameworkDataService.FrameworkFileData fileData : selectedItems) {
                FrameworkConfigurationDescription description = fileData.getFramework();
                if (description == null) {
                    FrameworkCommandsForm.showMessageBalloon(FrameworkBundle.message("there.are.invalid.frameworks.among.selected", new Object[0]), FrameworkCommandsForm.this.myTableEditorPanel);
                    return;
                }
                FrameworkDescriptionProvider provider = FrameworkUtils.getMatchingProvider(description);
                if (provider == null) {
                    FrameworkCommandsForm.showMessageBalloon(FrameworkBundle.message("framework.with.alias.0.can.t.be.reloaded", description.getAlias()), FrameworkCommandsForm.this.myTableEditorPanel);
                    return;
                }
                filesAndProviders.put(fileData, provider);
            }
            List oldItems = FrameworkCommandsForm.this.myTableEditor.getItems();
            ArrayList<FrameworkDataService.FrameworkFileData> freshItems = new ArrayList<FrameworkDataService.FrameworkFileData>(oldItems.size());
            for (FrameworkDataService.FrameworkFileData data : oldItems) {
                FrameworkDescriptionProvider provider = (FrameworkDescriptionProvider)filesAndProviders.get(data);
                if (provider == null) {
                    freshItems.add(data);
                    continue;
                }
                this.recreateFileData(freshItems, data, provider);
            }
            FrameworkCommandsForm.this.myTableEditor.setModel(FrameworkCommandsForm.getColumnInfos(), freshItems);
        }

        private <UserData> void recreateFileData(List<FrameworkDataService.FrameworkFileData> freshItems, FrameworkDataService.FrameworkFileData data, FrameworkDescriptionProvider<UserData> provider) {
            FrameworkConfigurationDescription oldDescription = data.getFramework();
            UserData path = provider.parseUserData(oldDescription);
            FrameworkConfigurationDescription freshDescription = FrameworkCommandsForm.loadCommands(provider, FrameworkCommandsForm.this.getContentPane(), path);
            if (freshDescription == null) {
                freshItems.add(data);
            } else {
                freshDescription.setName(oldDescription.getName());
                freshDescription.setAlias(oldDescription.getAlias());
                freshDescription.setEnabled(oldDescription.isEnabled());
                freshItems.add(new FrameworkDataService.FrameworkFileData(freshDescription, null, FrameworkDataService.getFileName(freshDescription.getName()), data.isProjectVisibility()));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/jetbrains/php/framework/ui/FrameworkCommandsForm$ReloadCommandsActionButton";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateButton";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ShowInEditorActionButton
    extends AnActionButton {
        private ShowInEditorActionButton() {
            super(FrameworkBundle.message("framework.commands.form.show.in.editor", new Object[0]), SHOW_IN_EDITOR_ICON);
        }

        public void updateButton(@NotNull AnActionEvent e) {
            boolean enabled;
            if (e == null) {
                ShowInEditorActionButton.$$$reportNull$$$0(0);
            }
            super.updateButton(e);
            Project project = (Project)e.getData(CommonDataKeys.PROJECT);
            boolean bl = enabled = e.getPresentation().isEnabled() && project != null && !project.isDefault();
            if (enabled) {
                List selectedItems = FrameworkCommandsForm.this.myTableEditor.getSelectedItems();
                enabled = selectedItems != null && !selectedItems.isEmpty();
            }
            e.getPresentation().setEnabled(enabled);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project;
            if (e == null) {
                ShowInEditorActionButton.$$$reportNull$$$0(1);
            }
            if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) == null || project.isDefault()) {
                return;
            }
            List selectedItems = FrameworkCommandsForm.this.myTableEditor.getSelectedItems();
            if (selectedItems == null || selectedItems.isEmpty()) {
                FrameworkCommandsForm.showMessageBalloon(FrameworkBundle.message("framework.commands.form.no.frameworks.selected", new Object[0]), FrameworkCommandsForm.this.myTableEditorPanel);
                return;
            }
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
            ArrayList<String> unopenedFiles = new ArrayList<String>();
            StringBuilder openedMessage = new StringBuilder();
            boolean first = true;
            FrameworkDataService service = FrameworkDataService.getInstance(FrameworkCommandsForm.this.myProject);
            for (FrameworkDataService.FrameworkFileData selectedItem : selectedItems) {
                VirtualFile fileToOpen = service.getFile(selectedItem);
                if (fileToOpen == null) {
                    unopenedFiles.add(selectedItem.getFileName());
                    continue;
                }
                if (first) {
                    openedMessage.append(FrameworkBundle.message("framework.opened", new Object[0]));
                } else {
                    openedMessage.append(",");
                }
                if (selectedItem.getFramework() != null) {
                    openedMessage.append(" ").append(selectedItem.getFramework().getName());
                }
                fileEditorManager.openFile(fileToOpen, false);
                first = false;
            }
            if (!unopenedFiles.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                boolean isFirst = true;
                for (String unopenedFile : unopenedFiles) {
                    if (!isFirst) {
                        sb.append(", ");
                    }
                    isFirst = false;
                    sb.append(unopenedFile);
                }
                openedMessage.append("\n").append(FrameworkBundle.message("framework.commands.form.0.not.created.yet.", sb.append(" ").toString()));
            }
            if (openedMessage.length() != 0) {
                FrameworkCommandsForm.showMessageBalloon(openedMessage.toString(), FrameworkCommandsForm.this.myTableEditorPanel);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/jetbrains/php/framework/ui/FrameworkCommandsForm$ShowInEditorActionButton";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateButton";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class FrameworkValidatingTableEditor
    extends ValidatingTableEditor<FrameworkDataService.FrameworkFileData> {
        private FrameworkValidatingTableEditor(AnActionButton ... buttons) {
            super(buttons);
        }

        protected FrameworkDataService.FrameworkFileData cloneOf(FrameworkDataService.FrameworkFileData frameworkDescription) {
            return new FrameworkDataService.FrameworkFileData(frameworkDescription.getFramework().cloneFramework(), frameworkDescription.getErrorMessage(), frameworkDescription.getFileName(), frameworkDescription.isProjectVisibility());
        }

        @Nullable
        protected FrameworkDataService.FrameworkFileData createItem() {
            Pair<FrameworkConfigurationDescription, Boolean> pair = this.createNewFramework(this.getContentPane());
            if (pair != null) {
                String name;
                HashSet<String> names = new HashSet<String>();
                for (FrameworkDataService.FrameworkFileData data : this.getItems()) {
                    names.add(FrameworkDataService.getFrameworkNameFromFileName(data.getFileName()));
                }
                String basicName = ((FrameworkConfigurationDescription)pair.getFirst()).getFramework().getName();
                if (StringUtil.isEmpty((String)basicName)) {
                    basicName = FrameworkBundle.message("framework.custom.part.of.filename", new Object[0]);
                }
                if (names.contains(basicName = basicName + "_" + ((FrameworkConfigurationDescription)pair.getFirst()).getAlias())) {
                    basicName = basicName + "_";
                    int i = 1;
                    while (names.contains(basicName + i)) {
                        ++i;
                    }
                    name = basicName + i;
                } else {
                    name = basicName;
                }
                ((FrameworkConfigurationDescription)pair.getFirst()).setName(name);
                return new FrameworkDataService.FrameworkFileData((FrameworkConfigurationDescription)pair.getFirst(), null, FrameworkDataService.getFileName(name), (Boolean)pair.getSecond());
            }
            return null;
        }

        @Nullable
        private Pair<FrameworkConfigurationDescription, Boolean> createNewFramework(Component component) {
            ArrayList<FrameworkDescriptionProvider<CustomUtils.CustomFrameworkData>> providersToAdd = new ArrayList<FrameworkDescriptionProvider<CustomUtils.CustomFrameworkData>>(((FrameworkDescriptionProvider[])FrameworkDescriptionProvider.EP.getExtensions()).length);
            Collections.addAll(providersToAdd, FrameworkDescriptionProvider.EP.getExtensions());
            Collections.sort(providersToAdd, (o1, o2) -> o1.getFrameworkName().compareTo(o2.getFrameworkName()));
            providersToAdd.add(CustomUtils.DESCRIPTION_PROVIDER);
            if (providersToAdd.size() == 1) {
                FrameworkDescriptionProvider provider = (FrameworkDescriptionProvider)providersToAdd.get(0);
                int load = Messages.showCheckboxMessageDialog((String)FrameworkBundle.message("framework.settings.add.0", StringUtil.decapitalize((String)provider.getFrameworkName())), (String)FrameworkBundle.message("framework.commands.form.messages.title.command.line.tools", new Object[0]), (String[])new String[]{CommonBundle.getOkButtonText()}, (String)FrameworkBundle.message("framework.commands.form.make.tool.globally.visible", new Object[0]), (boolean)false, (int)-1, (int)-1, (Icon)Messages.getQuestionIcon(), (t, v) -> {
                    if (t == 0) {
                        if (v.isSelected()) {
                            return CREATE_WITH_GLOBAL_VISIBILITY;
                        }
                        return CREATE_WITH_PROJECT_VISIBILITY;
                    }
                    return DO_NOT_CREATE;
                });
                if (load == DO_NOT_CREATE) {
                    return null;
                }
                FrameworkConfigurationDescription framework = FrameworkCommandsForm.this.loadCommands(provider, component);
                return framework == null ? null : Pair.create((Object)framework, (Object)(load == CREATE_WITH_PROJECT_VISIBILITY ? 1 : 0));
            }
            FrameworkChooseProviderDialog chooseProviderDialog = new FrameworkChooseProviderDialog(component, providersToAdd);
            boolean ok = chooseProviderDialog.showAndGet();
            if (ok) {
                FrameworkDescriptionProvider provider = chooseProviderDialog.getSelectedProvider();
                assert (provider != null);
                FrameworkConfigurationDescription framework = FrameworkCommandsForm.this.loadCommands(provider, component);
                return framework == null ? null : Pair.create((Object)framework, (Object)chooseProviderDialog.isProjectVisibility());
            }
            return null;
        }

        protected String validate(FrameworkDataService.FrameworkFileData frameworkDescription) {
            if (frameworkDescription.getFramework() != null) {
                return FrameworkCommandsForm.validateFrameworkDescription(frameworkDescription.getFramework());
            }
            return FrameworkBundle.message("framework.commands.form.invalid.description", new Object[0]);
        }
    }

    private static class PredefinedFrameworkColumnInfo
    extends ColumnInfo<FrameworkDataService.FrameworkFileData, String> {
        private PredefinedFrameworkColumnInfo() {
            super(FrameworkBundle.message("predefined.framework", new Object[0]));
        }

        public String valueOf(FrameworkDataService.FrameworkFileData frameworkDescription) {
            if (frameworkDescription.getFramework() == null) {
                return "";
            }
            FrameworkDescriptionProvider provider = FrameworkUtils.getMatchingProvider(frameworkDescription.getFramework());
            return provider == null ? "" : provider.getFrameworkName();
        }

        public boolean isCellEditable(FrameworkDataService.FrameworkFileData frameworkDescription) {
            return false;
        }

        public Class getColumnClass() {
            return String.class;
        }

        @Nullable
        public TableCellRenderer getRenderer(FrameworkDataService.FrameworkFileData data) {
            return FrameworkCommandsForm.getRendererForString(data);
        }
    }

    private static class InvocationColumnInfo
    extends ColumnInfo<FrameworkDataService.FrameworkFileData, String> {
        private InvocationColumnInfo() {
            super(FrameworkBundle.message("framework.settings.table.tool.path.header", new Object[0]));
        }

        public String valueOf(FrameworkDataService.FrameworkFileData frameworkDescription) {
            if (frameworkDescription.getFramework() == null) {
                return frameworkDescription.getErrorMessage();
            }
            return frameworkDescription.getFramework().getInvokeText();
        }

        public boolean isCellEditable(FrameworkDataService.FrameworkFileData frameworkDescription) {
            return false;
        }

        public Class getColumnClass() {
            return String.class;
        }

        public TableCellRenderer getRenderer(final FrameworkDataService.FrameworkFileData frameworkFileData) {
            return new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    String cellValue = (String)value;
                    if (frameworkFileData.getFramework() != null) {
                        this.setText(cellValue);
                    } else {
                        JPanel result = new JPanel(new FlowLayout());
                        JLabel mainLabel = new JLabel(FrameworkBundle.message("framework.commands.form.invalid.description", new Object[0]));
                        HyperlinkLabel linkLabel = new HyperlinkLabel(FrameworkBundle.message("framework.commands.form.more", new Object[0]));
                        result.add(mainLabel);
                        result.add((Component)linkLabel);
                        this.add(result);
                    }
                    this.setEnabled(FrameworkCommandsForm.isEnabled(frameworkFileData));
                    return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                }
            };
        }
    }

    private static class AliasColumnInfo
    extends ColumnInfo<FrameworkDataService.FrameworkFileData, String>
    implements ValidatingTableEditor.RowHeightProvider {
        private final int PREFERRED_HEIGHT;

        private AliasColumnInfo() {
            super(FrameworkBundle.message("framework.settings.table.alias.header", new Object[0]));
            JTextField field = new JTextField("text");
            this.PREFERRED_HEIGHT = field.getPreferredSize().height;
        }

        public String valueOf(FrameworkDataService.FrameworkFileData frameworkDescription) {
            if (frameworkDescription.getFramework() == null) {
                return "";
            }
            return frameworkDescription.getFramework().getAlias();
        }

        public boolean isCellEditable(FrameworkDataService.FrameworkFileData frameworkDescription) {
            return false;
        }

        public Class getColumnClass() {
            return String.class;
        }

        public int getRowHeight() {
            return this.PREFERRED_HEIGHT;
        }

        @Nullable
        public TableCellRenderer getRenderer(FrameworkDataService.FrameworkFileData data) {
            return FrameworkCommandsForm.getRendererForString(data);
        }
    }

    private static class EnabledColumnInfo
    extends ColumnInfo<FrameworkDataService.FrameworkFileData, Boolean> {
        private final int PREFERRED_WIDTH;

        private EnabledColumnInfo() {
            super(FrameworkBundle.message("framework.settings.table.enabled.header", new Object[0]));
            JLabel label = new JLabel(FrameworkBundle.message("framework.settings.table.enabled.header", new Object[0]));
            this.PREFERRED_WIDTH = label.getPreferredSize().width + 20;
        }

        public Boolean valueOf(FrameworkDataService.FrameworkFileData frameworkDescription) {
            return FrameworkCommandsForm.isEnabled(frameworkDescription);
        }

        public boolean isCellEditable(FrameworkDataService.FrameworkFileData frameworkDescription) {
            return frameworkDescription.getFramework() != null;
        }

        public void setValue(FrameworkDataService.FrameworkFileData frameworkDescription, Boolean value) {
            frameworkDescription.getFramework().setEnabled(value);
        }

        public Class getColumnClass() {
            return Boolean.class;
        }

        public int getWidth(JTable table) {
            return this.PREFERRED_WIDTH;
        }
    }

    private static class CommandsLoader<UserData>
    implements Runnable {
        private final FrameworkDescriptionProvider<UserData> myProvider;
        private final UserData myPath;
        private final Component myComponent;
        private FrameworkConfigurationDescription myFramework;
        private String myErrorMessage;
        private FrameworkDescriptionProvider.FrameworkParseException myParseException;

        private CommandsLoader(FrameworkDescriptionProvider<UserData> provider, @Nullable UserData path, @Nullable Component component) {
            this.myProvider = provider;
            this.myPath = path;
            this.myComponent = component;
        }

        @Override
        public void run() {
            ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
            progressIndicator.setIndeterminate(true);
            try {
                this.myFramework = this.myProvider.getFrameworkData(this.myPath, this.myComponent, progressIndicator);
            }
            catch (RunCanceledByUserException runCanceledByUserException) {
            }
            catch (FrameworkDescriptionProvider.FrameworkExecutionException e) {
                this.myErrorMessage = e.getExecutionException().getMessage();
            }
            catch (FrameworkDescriptionProvider.FrameworkParseException e) {
                this.myParseException = e;
            }
        }
    }
}

