/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phing.dom;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileInfoManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.GenericAttributeValue;
import com.jetbrains.php.config.library.PhpIncludePathManager;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.phing.PhingBundle;
import com.jetbrains.php.phing.dom.PhingPhpClassConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class PhingPhpFileReferenceSet
extends FileReferenceSet {
    private static final Condition<PsiFileSystemItem> COMPLETION_CONDITION = item -> item.isDirectory() || item instanceof PhpFile;
    private final GenericAttributeValue myValue;
    private final int myPathOffset;

    public PhingPhpFileReferenceSet(GenericAttributeValue attribValue) {
        super(attribValue.getRawText(), (PsiElement)attribValue.getXmlAttributeValue(), ElementManipulators.getOffsetInElement((PsiElement)attribValue.getXmlAttributeValue()), null, SystemInfo.isFileSystemCaseSensitive, true, null, false);
        this.myPathOffset = PhingPhpFileReferenceSet.calcPathOffset(attribValue.getRawText());
        this.myValue = attribValue;
        this.reparse();
    }

    protected GenericAttributeValue getAttributeValue() {
        return this.myValue;
    }

    protected int findSeparatorLength(@NotNull CharSequence sequence, int atOffset) {
        if (sequence == null) {
            PhingPhpFileReferenceSet.$$$reportNull$$$0(0);
        }
        return sequence.charAt(atOffset) == (atOffset >= this.myPathOffset ? (char)'.' : '/') ? 1 : 0;
    }

    protected int findSeparatorOffset(@NotNull CharSequence sequence, int startingFrom) {
        if (sequence == null) {
            PhingPhpFileReferenceSet.$$$reportNull$$$0(1);
        }
        return StringUtil.indexOf((CharSequence)sequence, (char)(startingFrom >= this.myPathOffset ? (char)'.' : '/'), (int)startingFrom);
    }

    protected static int calcPathOffset(String path) {
        int k = 0;
        while (path.startsWith("../", k)) {
            k += "../".length();
        }
        return k;
    }

    public static String convertAttributeValueToPath(String path) {
        int k = PhingPhpFileReferenceSet.calcPathOffset(path);
        return path.substring(0, k) + path.substring(k).replace('.', '/');
    }

    private static String convertPathToAttributeValue(String path) {
        int k = PhingPhpFileReferenceSet.calcPathOffset(path);
        return path.substring(0, k) + StringUtil.trimEnd((String)path.substring(k).replace('/', '.'), (String)".php");
    }

    protected boolean isSoft() {
        return true;
    }

    public FileReference createFileReference(TextRange range, int index, String text) {
        return new PhingPhpFileReference(this, range, index, text);
    }

    @NotNull
    public XmlAttributeValue getElement() {
        XmlAttributeValue xmlAttributeValue = (XmlAttributeValue)super.getElement();
        if (xmlAttributeValue == null) {
            PhingPhpFileReferenceSet.$$$reportNull$$$0(2);
        }
        return xmlAttributeValue;
    }

    public boolean isAbsolutePathReference() {
        return false;
    }

    @NotNull
    public Collection<PsiFileSystemItem> computeDefaultContexts() {
        ArrayList<PsiFileSystemItem> result = new ArrayList<PsiFileSystemItem>();
        XmlElement xmlElement = this.getAttributeValue().ensureXmlElementExists();
        PsiFile containingFile = xmlElement.getContainingFile();
        if (containingFile != null) {
            PsiDirectory parentDirectory = containingFile.getOriginalFile().getParent();
            result.add((PsiFileSystemItem)parentDirectory);
        }
        PsiManager psiManager = xmlElement.getManager();
        List otherRoots = PhpIncludePathManager.getInstance((Project)xmlElement.getProject()).getRoots();
        for (VirtualFile file : otherRoots) {
            PsiDirectory psiDirectory;
            if (file == null || !file.isDirectory() || (psiDirectory = psiManager.findDirectory(file)) == null) continue;
            result.add((PsiFileSystemItem)psiDirectory);
        }
        ArrayList<PsiFileSystemItem> arrayList = result;
        if (arrayList == null) {
            PhingPhpFileReferenceSet.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
        return COMPLETION_CONDITION;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phing/dom/PhingPhpFileReferenceSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phing/dom/PhingPhpFileReferenceSet";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "computeDefaultContexts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findSeparatorLength";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findSeparatorOffset";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PhingPhpFileReference
    extends FileReference {
        private PhingPhpFileReference(PhingPhpFileReferenceSet set, TextRange range, int index, String text) {
            super((FileReferenceSet)set, range, index, text);
        }

        public String getText() {
            PhingPhpFileReferenceSet refSet = this.getFileReferenceSet();
            String path = refSet.getPathString();
            if (this == refSet.getLastReference()) {
                VirtualFile virtualFile;
                Project project = this.getElement().getProject();
                PsiFileSystemItem phpClass = PhingPhpClassConverter.findPhpClass(PhingPhpFileReferenceSet.convertAttributeValueToPath(path), project, PsiManager.getInstance((Project)project), this.getElement().getContainingFile());
                if (phpClass != null && (virtualFile = phpClass.getVirtualFile()) != null) {
                    return virtualFile.getName();
                }
            }
            return super.getText();
        }

        @NotNull
        public PhingPhpFileReferenceSet getFileReferenceSet() {
            PhingPhpFileReferenceSet phingPhpFileReferenceSet = (PhingPhpFileReferenceSet)super.getFileReferenceSet();
            if (phingPhpFileReferenceSet == null) {
                PhingPhpFileReference.$$$reportNull$$$0(0);
            }
            return phingPhpFileReferenceSet;
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            if (this == this.getFileReferenceSet().getLastReference()) {
                String string = PhingBundle.message("framework.class.0.in.1.php.does.not.exist", this.getCanonicalText(), this.getCanonicalText());
                if (string == null) {
                    PhingPhpFileReference.$$$reportNull$$$0(1);
                }
                return string;
            }
            String string = super.getUnresolvedMessagePattern();
            if (string == null) {
                PhingPhpFileReference.$$$reportNull$$$0(2);
            }
            return string;
        }

        protected Object createLookupItem(PsiElement candidate) {
            if (candidate instanceof PhpFile) {
                PsiFile psiFile = (PsiFile)candidate;
                VirtualFile virtualFile = psiFile.getVirtualFile();
                String name = virtualFile != null ? virtualFile.getNameWithoutExtension() : psiFile.getName();
                return FileInfoManager.getFileLookupItem((PsiElement)psiFile, (String)name, (Icon)psiFile.getIcon(0));
            }
            return super.createLookupItem(candidate);
        }

        public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
            if (newElementName == null) {
                PhingPhpFileReference.$$$reportNull$$$0(3);
            }
            return super.handleElementRename(PhingPhpFileReferenceSet.convertPathToAttributeValue(newElementName));
        }

        protected PsiElement rename(String newName) throws IncorrectOperationException {
            return super.rename(PhingPhpFileReferenceSet.convertPathToAttributeValue(newName));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/phing/dom/PhingPhpFileReferenceSet$PhingPhpFileReference";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newElementName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileReferenceSet";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnresolvedMessagePattern";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/phing/dom/PhingPhpFileReferenceSet$PhingPhpFileReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "handleElementRename";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

