/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.colors.AbstractFontOptionsPanel;
import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.ide.DataManager;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.colors.DelegatingFontPreferences;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.impl.AppEditorFontOptions;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.ui.HoverHyperlinkLabel;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FontOptions
extends AbstractFontOptionsPanel {
    @NotNull
    private final ColorAndFontOptions myOptions;
    @Nullable
    private JCheckBox myOverwriteCheckBox;
    @Nullable
    private JLabel myBaseFontInfoLabel;
    private static final int FONT_PANEL_LEFT_OFFSET = 15;

    public FontOptions(@NotNull ColorAndFontOptions options) {
        if (options == null) {
            FontOptions.$$$reportNull$$$0(0);
        }
        this.myOptions = options;
    }

    @Nullable
    protected String getInheritedFontTitle() {
        return "default";
    }

    protected String getOverwriteFontTitle() {
        return ApplicationBundle.message((String)"settings.editor.font.overwrite", (Object[])new Object[0]);
    }

    @Override
    protected JComponent createControls() {
        Component inheritBox = this.createOverwriteCheckBox();
        if (inheritBox != null) {
            JPanel topPanel = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 2;
            c.insets = JBUI.insets((int)10, (int)5, (int)12, (int)0);
            c.anchor = 21;
            topPanel.add(inheritBox, c);
            c.gridy = 1;
            c.gridx = 0;
            c.gridwidth = 1;
            c.insets = JBUI.emptyInsets();
            topPanel.add(Box.createRigidArea((Dimension)JBDimension.create((Dimension)new Dimension(15, 0))), c);
            c.gridx = 1;
            c.anchor = 18;
            topPanel.add((Component)this.createFontSettingsPanel(), c);
            return topPanel;
        }
        return super.createControls();
    }

    @Nullable
    private Component createOverwriteCheckBox() {
        if (this.getInheritedFontTitle() != null) {
            JPanel overwritePanel = new JPanel(new FlowLayout(3, 0, 0));
            overwritePanel.setBorder(BorderFactory.createEmptyBorder());
            this.myOverwriteCheckBox = new JCheckBox();
            this.myOverwriteCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
            this.myOverwriteCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FontOptions.this.setDelegatingPreferences(!FontOptions.this.myOverwriteCheckBox.isSelected());
                }
            });
            overwritePanel.add(this.myOverwriteCheckBox);
            overwritePanel.add(new JLabel(this.getOverwriteFontTitle() + " "));
            overwritePanel.add(this.createHyperlinkLabel());
            overwritePanel.add(FontOptions.grayed(new JLabel(" (")));
            this.myBaseFontInfoLabel = FontOptions.grayed(new JLabel("?"));
            overwritePanel.add(this.myBaseFontInfoLabel);
            overwritePanel.add(FontOptions.grayed(new JLabel(")")));
            return overwritePanel;
        }
        return null;
    }

    private static JLabel grayed(JLabel label2) {
        label2.setForeground((Color)JBColor.GRAY);
        return label2;
    }

    private String getBaseFontInfo() {
        StringBuilder sb = new StringBuilder();
        FontPreferences basePrefs = this.getBaseFontPreferences();
        sb.append(basePrefs.getFontFamily());
        sb.append(',');
        sb.append(basePrefs.getSize(basePrefs.getFontFamily()));
        return sb.toString();
    }

    protected FontPreferences getBaseFontPreferences() {
        return AppEditorFontOptions.getInstance().getFontPreferences();
    }

    @NotNull
    private JLabel createHyperlinkLabel() {
        HoverHyperlinkLabel label2 = new HoverHyperlinkLabel(this.getInheritedFontTitle());
        label2.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    FontOptions.this.navigateToParentFontConfigurable();
                }
            }
        });
        HoverHyperlinkLabel hoverHyperlinkLabel = label2;
        if (hoverHyperlinkLabel == null) {
            FontOptions.$$$reportNull$$$0(1);
        }
        return hoverHyperlinkLabel;
    }

    protected void navigateToParentFontConfigurable() {
        Configurable fontConfigurable;
        Settings allSettings = (Settings)Settings.KEY.getData(DataManager.getInstance().getDataContext((Component)this.getPanel()));
        if (allSettings != null && (fontConfigurable = allSettings.find("editor.preferences.fonts.default")) != null) {
            allSettings.select(fontConfigurable);
        }
    }

    @Override
    protected void setDelegatingPreferences(boolean isDelegating) {
        FontPreferences currPrefs = this.getCurrentScheme().getFontPreferences();
        if (currPrefs instanceof DelegatingFontPreferences == isDelegating) {
            return;
        }
        if (isDelegating) {
            this.getCurrentScheme().setUseAppFontPreferencesInEditor();
        } else {
            this.getCurrentScheme().setFontPreferences(this.getFontPreferences());
        }
        this.updateOptionsList();
        this.updateDescription(true);
    }

    @Override
    protected boolean isReadOnly() {
        return ColorAndFontOptions.isReadOnly(this.myOptions.getSelectedScheme());
    }

    @Override
    protected boolean isDelegating() {
        return this.getFontPreferences() instanceof DelegatingFontPreferences;
    }

    @Override
    @NotNull
    protected FontPreferences getFontPreferences() {
        FontPreferences fontPreferences = this.getCurrentScheme().getFontPreferences();
        if (fontPreferences == null) {
            FontOptions.$$$reportNull$$$0(2);
        }
        return fontPreferences;
    }

    @Override
    protected void setFontSize(int fontSize) {
        this.getCurrentScheme().setEditorFontSize(fontSize);
    }

    @Override
    protected float getLineSpacing() {
        return this.getCurrentScheme().getLineSpacing();
    }

    @Override
    protected void setCurrentLineSpacing(float lineSpacing) {
        this.getCurrentScheme().setLineSpacing(lineSpacing);
    }

    protected EditorColorsScheme getCurrentScheme() {
        return this.myOptions.getSelectedScheme();
    }

    @Override
    protected void updateCustomOptions() {
        if (this.myOverwriteCheckBox != null) {
            this.myOverwriteCheckBox.setEnabled(!this.isReadOnly());
            this.myOverwriteCheckBox.setSelected(!this.isDelegating());
        }
        if (this.myBaseFontInfoLabel != null) {
            this.myBaseFontInfoLabel.setText(this.getBaseFontInfo());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/colors/FontOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/colors/FontOptions";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createHyperlinkLabel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFontPreferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

