/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.vfs.newvfs.persistent.ContentHashesUtil;
import com.intellij.openapi.vfs.newvfs.persistent.FlushingDaemon;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.io.IOUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ContentHashesSupport {
    private static volatile ContentHashesUtil.HashEnumerator ourHashesWithFileType;

    ContentHashesSupport() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void initContentHashesEnumerator() throws IOException {
        if (ourHashesWithFileType != null) {
            return;
        }
        Class<ContentHashesSupport> clazz = ContentHashesSupport.class;
        synchronized (ContentHashesSupport.class) {
            if (ourHashesWithFileType != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            File hashEnumeratorFile = new File(IndexInfrastructure.getPersistentIndexRoot(), "hashesWithFileType");
            try {
                ContentHashesUtil.HashEnumerator hashEnumerator = new ContentHashesUtil.HashEnumerator(hashEnumeratorFile, null);
                FlushingDaemon.everyFiveSeconds(ContentHashesSupport::flushContentHashes);
                ShutDownTracker.getInstance().registerShutdownTask(ContentHashesSupport::flushContentHashes);
                ourHashesWithFileType = hashEnumerator;
            }
            catch (IOException ex) {
                IOUtil.deleteAllFilesStartingWith((File)hashEnumeratorFile);
                throw ex;
            }
            return;
        }
    }

    static void flushContentHashes() {
        if (ourHashesWithFileType != null && ourHashesWithFileType.isDirty()) {
            ourHashesWithFileType.force();
        }
    }

    static byte[] calcContentHash(@NotNull byte[] bytes, @NotNull FileType fileType) {
        if (bytes == null) {
            ContentHashesSupport.$$$reportNull$$$0(0);
        }
        if (fileType == null) {
            ContentHashesSupport.$$$reportNull$$$0(1);
        }
        MessageDigest messageDigest = (MessageDigest)ContentHashesUtil.HASHER_CACHE.getValue();
        Charset defaultCharset = Charset.defaultCharset();
        messageDigest.update(fileType.getName().getBytes(defaultCharset));
        messageDigest.update((byte)0);
        messageDigest.update(String.valueOf(bytes.length).getBytes(defaultCharset));
        messageDigest.update((byte)0);
        messageDigest.update(bytes, 0, bytes.length);
        return messageDigest.digest();
    }

    static int calcContentHashIdWithFileType(@NotNull byte[] bytes, @Nullable Charset charset, @NotNull FileType fileType) throws IOException {
        if (bytes == null) {
            ContentHashesSupport.$$$reportNull$$$0(2);
        }
        if (fileType == null) {
            ContentHashesSupport.$$$reportNull$$$0(3);
        }
        return ContentHashesSupport.enumerateHash(ContentHashesSupport.calcContentHashWithFileType(bytes, charset, fileType));
    }

    static int calcContentHashId(@NotNull byte[] bytes, @NotNull FileType fileType) throws IOException {
        if (bytes == null) {
            ContentHashesSupport.$$$reportNull$$$0(4);
        }
        if (fileType == null) {
            ContentHashesSupport.$$$reportNull$$$0(5);
        }
        return ContentHashesSupport.enumerateHash(ContentHashesSupport.calcContentHash(bytes, fileType));
    }

    static int enumerateHash(@NotNull byte[] digest) throws IOException {
        if (digest == null) {
            ContentHashesSupport.$$$reportNull$$$0(6);
        }
        return ourHashesWithFileType.enumerate(digest);
    }

    static byte[] calcContentHashWithFileType(@NotNull byte[] bytes, @Nullable Charset charset, @NotNull FileType fileType) {
        if (bytes == null) {
            ContentHashesSupport.$$$reportNull$$$0(7);
        }
        if (fileType == null) {
            ContentHashesSupport.$$$reportNull$$$0(8);
        }
        MessageDigest messageDigest = (MessageDigest)ContentHashesUtil.HASHER_CACHE.getValue();
        Charset defaultCharset = Charset.defaultCharset();
        messageDigest.update(fileType.getName().getBytes(defaultCharset));
        messageDigest.update((byte)0);
        messageDigest.update(String.valueOf(bytes.length).getBytes(defaultCharset));
        messageDigest.update((byte)0);
        messageDigest.update((charset != null ? charset.name() : "null_charset").getBytes(defaultCharset));
        messageDigest.update((byte)0);
        messageDigest.update(bytes, 0, bytes.length);
        return messageDigest.digest();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "digest";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/indexing/ContentHashesSupport";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "calcContentHash";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "calcContentHashIdWithFileType";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "calcContentHashId";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "enumerateHash";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "calcContentHashWithFileType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

