/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogFileHistoryProvider;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.history.FileHistoryUi;
import com.intellij.vcs.log.history.FileHistoryUiFactory;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.impl.VcsLogContentUtil;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcsUtil.VcsUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogFileHistoryProviderImpl
implements VcsLogFileHistoryProvider {
    @NotNull
    public static final String TAB_NAME = "History";

    public boolean canShowFileHistory(@NotNull Project project, @NotNull FilePath path) {
        if (project == null) {
            VcsLogFileHistoryProviderImpl.$$$reportNull$$$0(0);
        }
        if (path == null) {
            VcsLogFileHistoryProviderImpl.$$$reportNull$$$0(1);
        }
        if (!Registry.is((String)"vcs.new.history")) {
            return false;
        }
        VirtualFile root = VcsLogUtil.getActualRoot(project, path);
        if (root == null) {
            return false;
        }
        VcsLogData dataManager = VcsProjectLog.getInstance(project).getDataManager();
        if (dataManager == null) {
            return false;
        }
        return dataManager.getIndex().isIndexingEnabled(root);
    }

    public void showFileHistory(@NotNull Project project, @NotNull FilePath path, @Nullable String revisionNumber) {
        boolean firstTime;
        if (project == null) {
            VcsLogFileHistoryProviderImpl.$$$reportNull$$$0(2);
        }
        if (path == null) {
            VcsLogFileHistoryProviderImpl.$$$reportNull$$$0(3);
        }
        FilePath correctedPath = VcsLogFileHistoryProviderImpl.getCorrectedPath(project, path, revisionNumber);
        Hash hash = revisionNumber != null ? HashImpl.build(revisionNumber) : null;
        FileHistoryUi fileHistoryUi = VcsLogContentUtil.findAndSelect(project, FileHistoryUi.class, ui -> ui.matches(correctedPath, hash));
        boolean bl = firstTime = fileHistoryUi == null;
        if (firstTime) {
            VcsLogManager logManager = VcsProjectLog.getInstance(project).getLogManager();
            assert (logManager != null);
            String suffix = hash != null ? " (" + hash.toShortString() + ")" : "";
            fileHistoryUi = VcsLogContentUtil.openLogTab(project, logManager, TAB_NAME, correctedPath.getName() + suffix, new FileHistoryUiFactory(correctedPath, hash), true);
        }
        if (hash != null) {
            fileHistoryUi.jumpToNearestCommit(hash);
        } else if (firstTime) {
            fileHistoryUi.jumpToRow(0);
        }
    }

    @NotNull
    private static FilePath getCorrectedPath(@NotNull Project project, @NotNull FilePath path, @Nullable String revisionNumber) {
        VirtualFile root;
        if (project == null) {
            VcsLogFileHistoryProviderImpl.$$$reportNull$$$0(4);
        }
        if (path == null) {
            VcsLogFileHistoryProviderImpl.$$$reportNull$$$0(5);
        }
        if (!(root = (VirtualFile)ObjectUtils.assertNotNull((Object)VcsLogUtil.getActualRoot(project, path))).equals(VcsUtil.getVcsRootFor((Project)project, (FilePath)path)) && path.isDirectory()) {
            path = VcsUtil.getFilePath((String)path.getPath(), (boolean)false);
        }
        if (revisionNumber == null) {
            FilePath filePath = VcsUtil.getLastCommitPath((Project)project, (FilePath)path);
            if (filePath == null) {
                VcsLogFileHistoryProviderImpl.$$$reportNull$$$0(6);
            }
            return filePath;
        }
        FilePath filePath = path;
        if (filePath == null) {
            VcsLogFileHistoryProviderImpl.$$$reportNull$$$0(7);
        }
        return filePath;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/history/VcsLogFileHistoryProviderImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/history/VcsLogFileHistoryProviderImpl";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCorrectedPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canShowFileHistory";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "showFileHistory";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCorrectedPath";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

