/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.ArrayList;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.regex.ARegularExpression;
import net.sf.saxon.regex.RegularExpression;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.StringValue;

public class Matches
extends SystemFunctionCall {
    private RegularExpression regexp;
    private boolean allow30features = false;

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.allow30features = DecimalValue.THREE.equals(visitor.getStaticContext().getXPathLanguageLevel());
        Expression e = this.simplifyArguments(visitor);
        if (e == this) {
            this.maybePrecompile(visitor);
        }
        return e;
    }

    private void maybePrecompile(ExpressionVisitor visitor) throws XPathException {
        if (this.regexp == null) {
            try {
                this.regexp = Matches.tryToCompile(this.argument, 1, 2, visitor.getStaticContext());
            }
            catch (XPathException err) {
                err.setLocator(this);
                throw err;
            }
        }
    }

    public Expression optimize(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        Expression e = super.optimize(visitor, contextItemType);
        if (e == this) {
            this.maybePrecompile(visitor);
        }
        return e;
    }

    public RegularExpression getCompiledRegularExpression() {
        return this.regexp;
    }

    public BooleanValue evaluateItem(XPathContext c) throws XPathException {
        RegularExpression re;
        AtomicValue sv0 = (AtomicValue)this.argument[0].evaluateItem(c);
        if (sv0 == null) {
            sv0 = StringValue.EMPTY_STRING;
        }
        if ((re = this.regexp) == null) {
            CharSequence flags;
            AtomicValue pat = (AtomicValue)this.argument[1].evaluateItem(c);
            if (this.argument.length == 2) {
                flags = "";
            } else {
                AtomicValue sv2 = (AtomicValue)this.argument[2].evaluateItem(c);
                if (sv2 == null) {
                    return null;
                }
                flags = sv2.getStringValueCS();
            }
            return BooleanValue.get(this.evalMatches(sv0, pat, flags, c));
        }
        return BooleanValue.get(re.containsMatch(sv0.getStringValueCS()));
    }

    public boolean evalMatches(AtomicValue input, AtomicValue regex, CharSequence flags, XPathContext context) throws XPathException {
        ARegularExpression re;
        if (regex == null) {
            return false;
        }
        try {
            re = new ARegularExpression(regex.getStringValue(), flags.toString(), this.allow30features ? "XP30" : "XP20", null);
        }
        catch (XPathException err) {
            XPathException de = new XPathException(err);
            de.maybeSetErrorCode("FORX0002");
            de.setXPathContext(context);
            throw de;
        }
        return re.containsMatch(input.getStringValueCS());
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        CharSequence flags;
        AtomicValue sv0 = (AtomicValue)arguments[0].head();
        if (sv0 == null) {
            sv0 = StringValue.EMPTY_STRING;
        }
        AtomicValue pat = (AtomicValue)arguments[1].head();
        if (arguments.length == 2) {
            flags = "";
        } else {
            AtomicValue sv2 = (AtomicValue)arguments[2].head();
            if (sv2 == null) {
                return EmptySequence.getInstance();
            }
            flags = sv2.getStringValueCS();
        }
        return BooleanValue.get(this.evalMatches(sv0, pat, flags, context));
    }

    public static RegularExpression tryToCompile(Expression[] args, int patternArg, int flagsArg, StaticContext env) throws XPathException {
        if (patternArg > args.length - 1) {
            return null;
        }
        String flagstr = null;
        if (args.length - 1 < flagsArg) {
            flagstr = "";
        } else if (args[flagsArg] instanceof StringLiteral) {
            flagstr = ((StringLiteral)args[flagsArg]).getStringValue();
        }
        if (args[patternArg] instanceof StringLiteral && flagstr != null) {
            try {
                String in = ((StringLiteral)args[patternArg]).getStringValue();
                String hostLang = DecimalValue.THREE.equals(env.getXPathLanguageLevel()) ? "XP30" : "XP20";
                ArrayList<String> warnings = new ArrayList<String>(1);
                RegularExpression re = Configuration.getPlatform().compileRegularExpression(in, flagstr, hostLang, warnings);
                for (String e : warnings) {
                    env.issueWarning(e, args[patternArg]);
                }
                return re;
            }
            catch (XPathException err) {
                err.maybeSetErrorCode("FORX0002");
                throw err;
            }
        }
        return null;
    }
}

