/*
 * Decompiled with CFR 0.152.
 */
package sbt;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.util.Locale;
import sbt.Resolvers;
import sbt.RichURI;
import sbt.RichURI$;
import sbt.internal.BuildLoader;
import sbt.internal.util.Util$;
import sbt.io.Hash$;
import sbt.io.IO$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;
import scala.sys.process.Process$;
import scala.util.control.NonFatal$;

public final class Resolvers$ {
    public static Resolvers$ MODULE$;
    private final Function1<BuildLoader.ResolveInfo, Option<Function0<File>>> local;
    private final Function1<BuildLoader.ResolveInfo, Option<Function0<File>>> remote;
    private final Function1<BuildLoader.ResolveInfo, Option<Function0<File>>> subversion;
    private final Function1<BuildLoader.ResolveInfo, Option<Function0<File>>> mercurial;
    private final Function1<BuildLoader.ResolveInfo, Option<Function0<File>>> git;

    static {
        new Resolvers$();
    }

    public Function1<BuildLoader.ResolveInfo, Option<Function0<File>>> local() {
        return this.local;
    }

    public Function1<BuildLoader.ResolveInfo, Option<Function0<File>>> remote() {
        return this.remote;
    }

    public Function1<BuildLoader.ResolveInfo, Option<Function0<File>>> subversion() {
        return this.subversion;
    }

    public Function1<BuildLoader.ResolveInfo, Option<Function0<File>>> mercurial() {
        return this.mercurial;
    }

    public Function1<BuildLoader.ResolveInfo, Option<Function0<File>>> git() {
        return this.git;
    }

    public void run(Seq<String> command) {
        this.run((Option<File>)None$.MODULE$, command);
    }

    public void run(Option<File> cwd, Seq<String> command) {
        Seq seq;
        if (Util$.MODULE$.isNonCygwinWindows()) {
            String string = "cmd";
            String string2 = "/c";
            seq = (Seq)((SeqLike)command.$plus$colon((Object)string2, Seq$.MODULE$.canBuildFrom())).$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom());
        } else {
            seq = command;
        }
        int result = Process$.MODULE$.apply(seq, cwd, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0])).$bang();
        if (result != 0) {
            throw package$.MODULE$.error(new StringBuilder(22).append("Nonzero exit code (").append(result).append("): ").append(command.mkString(" ")).toString());
        }
    }

    public File creates(File file, Function0<BoxedUnit> f) {
        if (!file.exists()) {
            try {
                f.apply$mcV$sp();
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    IO$.MODULE$.delete(file);
                    throw e;
                }
                throw throwable;
            }
        }
        return file;
    }

    public File uniqueSubdirectoryFor(URI uri, File in) {
        String string;
        in.mkdirs();
        File base = new File(in, Hash$.MODULE$.halfHashString(uri.normalize().toASCIIString()));
        Option<String> option = this.shortName(uri);
        if (option instanceof Some) {
            Some some = (Some)option;
            String n = (String)some.value();
            string = this.normalizeDirectoryName(n);
        } else if (None$.MODULE$.equals(option)) {
            string = "root";
        } else {
            throw new MatchError(option);
        }
        String last = string;
        return new File(base, last);
    }

    private Option<String> shortName(URI uri) {
        return Option$.MODULE$.apply((Object)RichURI$.MODULE$.fromURI(uri).withoutMarkerScheme().getPath()).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$3.split("/"))).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).filterNot((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isEmpty())))).lastOption());
    }

    private String normalizeDirectoryName(String name) {
        return this.dropExtensions(name).toLowerCase(Locale.ENGLISH).replaceAll("\\W+", "-");
    }

    private String dropExtensions(String name) {
        return (String)new StringOps(Predef$.MODULE$.augmentString(name)).takeWhile((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)Resolvers$.$anonfun$dropExtensions$1(BoxesRunTime.unboxToChar((Object)x$6))));
    }

    private static final URI normalized$1(URI uri) {
        RichURI qual$1 = RichURI$.MODULE$.fromURI(uri);
        String x$7 = "svn";
        String x$8 = qual$1.copy$default$2();
        String x$9 = qual$1.copy$default$3();
        int x$10 = qual$1.copy$default$4();
        String x$11 = qual$1.copy$default$5();
        String x$12 = qual$1.copy$default$6();
        String x$13 = qual$1.copy$default$7();
        return qual$1.copy(x$7, x$8, x$9, x$10, x$11, x$12, x$13);
    }

    public static final /* synthetic */ boolean $anonfun$dropExtensions$1(char x$6) {
        return x$6 != '.';
    }

    private Resolvers$() {
        MODULE$ = this;
        this.local = (Function1 & Serializable & scala.Serializable)info -> {
            URI uri = info.uri();
            File from = new File(uri);
            File to = MODULE$.uniqueSubdirectoryFor(uri, info.staging());
            return from.isDirectory() ? new Some((Function0 & Serializable & scala.Serializable)() -> from.canWrite() ? from : MODULE$.creates(to, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> IO$.MODULE$.copyDirectory(from, to))) : None$.MODULE$;
        };
        this.remote = (Function1 & Serializable & scala.Serializable)info -> {
            URL url = info.uri().toURL();
            File to = MODULE$.uniqueSubdirectoryFor(info.uri(), info.staging());
            return new Some((Function0 & Serializable & scala.Serializable)() -> MODULE$.creates(to, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> IO$.MODULE$.unzipURL(url, to, IO$.MODULE$.unzipURL$default$3(), IO$.MODULE$.unzipURL$default$4())));
        };
        this.subversion = (Function1 & Serializable & scala.Serializable)info -> {
            Some some;
            URI uri = RichURI$.MODULE$.fromURI(info.uri()).withoutMarkerScheme();
            File localCopy = MODULE$.uniqueSubdirectoryFor(Resolvers$.normalized$1(uri), info.staging());
            String from = RichURI$.MODULE$.fromURI(uri).withoutFragment().toASCIIString();
            String to = localCopy.getAbsolutePath();
            if (RichURI$.MODULE$.fromURI(uri).hasFragment()) {
                String revision = uri.getFragment();
                some = new Some((Function0 & Serializable & scala.Serializable)() -> MODULE$.creates(localCopy, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.run((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"svn", "checkout", "-q", "-r", revision, from, to}))));
            } else {
                some = new Some((Function0 & Serializable & scala.Serializable)() -> MODULE$.creates(localCopy, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.run((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"svn", "checkout", "-q", from, to}))));
            }
            return some;
        };
        this.mercurial = new Resolvers.DistributedVCS(){
            private final String scheme;

            public String scheme() {
                return this.scheme;
            }

            public void clone(String from, File to) {
                Resolvers$.MODULE$.run((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hg", "clone", "-q", from, to.getAbsolutePath()}));
            }

            public void checkout(String branch, File in) {
                Resolvers$.MODULE$.run((Option<File>)new Some((Object)in), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hg", "checkout", "-q", branch}));
            }
            {
                this.scheme = "hg";
            }
        }.toResolver();
        this.git = (Function1 & Serializable & scala.Serializable)info -> {
            Some some;
            URI uri = RichURI$.MODULE$.fromURI(info.uri()).withoutMarkerScheme();
            RichURI qual$2 = RichURI$.MODULE$.fromURI(uri);
            String x$14 = "git";
            String x$15 = qual$2.copy$default$2();
            String x$16 = qual$2.copy$default$3();
            int x$17 = qual$2.copy$default$4();
            String x$18 = qual$2.copy$default$5();
            String x$19 = qual$2.copy$default$6();
            String x$20 = qual$2.copy$default$7();
            File localCopy = MODULE$.uniqueSubdirectoryFor(qual$2.copy(x$14, x$15, x$16, x$17, x$18, x$19, x$20), info.staging());
            String from = RichURI$.MODULE$.fromURI(uri).withoutFragment().toASCIIString();
            if (RichURI$.MODULE$.fromURI(uri).hasFragment()) {
                String branch = uri.getFragment();
                some = new Some((Function0 & Serializable & scala.Serializable)() -> MODULE$.creates(localCopy, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    MODULE$.run((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"git", "clone", from, localCopy.getAbsolutePath()}));
                    MODULE$.run((Option<File>)new Some((Object)localCopy), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"git", "checkout", "-q", branch}));
                }));
            } else {
                some = new Some((Function0 & Serializable & scala.Serializable)() -> MODULE$.creates(localCopy, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.run((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"git", "clone", "--depth", "1", from, localCopy.getAbsolutePath()}))));
            }
            return some;
        };
    }
}

