/*
 * Decompiled with CFR 0.152.
 */
package net.bluecow.spectro.tool;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.bluecow.spectro.Clip;
import net.bluecow.spectro.ClipDataEdit;
import net.bluecow.spectro.ClipPanel;
import net.bluecow.spectro.Frame;
import net.bluecow.spectro.SpectroEditSession;
import net.bluecow.spectro.tool.CurvedSlider;
import net.bluecow.spectro.tool.Tool;

public class RegionThresholdTool
implements Tool {
    private ClipPanel clipPanel;
    private Clip clip;
    private final PropertyChangeListener clipEventHandler = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            if ("region".equals(evt.getPropertyName())) {
                RegionThresholdTool.this.thresholdSlider.setValue(100);
            }
        }
    };
    private ClipDataEdit origData;
    private final Box settingsPanel = Box.createVerticalBox();
    private final CurvedSlider thresholdSlider;
    private final int initialThreshold = 100;
    private final JCheckBox upper;

    public RegionThresholdTool() {
        this.settingsPanel.add(new JLabel("Cutoff Threshold"));
        this.thresholdSlider = new CurvedSlider(0.0, 10.0, 3.0);
        this.thresholdSlider.setOpaque(false);
        this.thresholdSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (RegionThresholdTool.this.thresholdSlider.getValueIsAdjusting()) {
                    RegionThresholdTool.this.applyRegionThreshold(RegionThresholdTool.this.thresholdSlider.getCurvedValue());
                }
            }
        });
        this.settingsPanel.add(this.thresholdSlider);
        this.upper = new JCheckBox("Upper Threshold");
        this.upper.setOpaque(false);
        this.upper.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RegionThresholdTool.this.applyRegionThreshold(RegionThresholdTool.this.thresholdSlider.getCurvedValue());
            }
        });
        this.settingsPanel.add(this.upper);
        this.settingsPanel.add(Box.createGlue());
    }

    public String getName() {
        return "Region Threshold";
    }

    public void activate(SpectroEditSession session) {
        this.clipPanel = session.getClipPanel();
        this.clip = this.clipPanel.getClip();
        this.clipPanel.setRegionMode(true);
        this.clipPanel.addPropertyChangeListener("region", this.clipEventHandler);
    }

    public void deactivate() {
        this.origData = null;
        this.clipPanel.removePropertyChangeListener("region", this.clipEventHandler);
        this.clip = null;
        this.clipPanel = null;
    }

    public JComponent getSettingsPanel() {
        return this.settingsPanel;
    }

    private void applyRegionThreshold(double threshold) {
        Rectangle region = this.clipPanel.getRegion();
        if (region == null || region.width == 0 || region.height == 0) {
            this.origData = null;
            return;
        }
        Rectangle frameRegion = this.clipPanel.toClipCoords(new Rectangle(region));
        if (this.origData == null || !this.origData.isSameRegion(frameRegion)) {
            this.origData = new ClipDataEdit(this.clip, frameRegion);
        }
        this.clip.beginEdit(frameRegion, "Region Threshold");
        double[][] orig = this.origData.getOldData();
        for (int i = frameRegion.x; i < frameRegion.x + frameRegion.width; ++i) {
            Frame frame = this.clip.getFrame(i);
            for (int j = frameRegion.y; j < frameRegion.y + frameRegion.height; ++j) {
                double origVal = orig[i - frameRegion.x][j - frameRegion.y];
                if (this.upper.isSelected() && Math.abs(origVal) > threshold) {
                    frame.setReal(j, 0.0);
                    continue;
                }
                if (!this.upper.isSelected() && Math.abs(origVal) < threshold) {
                    frame.setReal(j, 0.0);
                    continue;
                }
                frame.setReal(j, origVal);
            }
        }
        this.clip.endEdit();
    }
}

