/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.INodeExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreeNode;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.ITableIndexExtractor;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.ITableTriggerExtractor;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.IndexParentExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.IndexParentInfo;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.TriggerParentExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.TriggerParentInfo;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.SQLDatabaseMetaData;

public class TableWithChildNodesExpander
implements INodeExpander {
    private ITableTriggerExtractor triggerExtractor = null;
    private ITableIndexExtractor indexExtractor = null;

    public void setTableTriggerExtractor(ITableTriggerExtractor extractor) {
        this.triggerExtractor = extractor;
    }

    public void setTableIndexExtractor(ITableIndexExtractor extractor) {
        this.indexExtractor = extractor;
    }

    @Override
    public List<ObjectTreeNode> createChildren(ISession session, ObjectTreeNode parentNode) throws SQLException {
        INodeExpander expander;
        ObjectTreeNode triggerChild;
        DatabaseObjectInfo triggerParentInfo;
        ArrayList<ObjectTreeNode> childNodes = new ArrayList<ObjectTreeNode>();
        IDatabaseObjectInfo parentDbinfo = parentNode.getDatabaseObjectInfo();
        SQLDatabaseMetaData md = session.getSQLConnection().getSQLMetaData();
        String schemaName = parentDbinfo.getSchemaName();
        if (this.triggerExtractor != null) {
            triggerParentInfo = new TriggerParentInfo(parentDbinfo, schemaName, md);
            triggerChild = new ObjectTreeNode(session, triggerParentInfo);
            expander = new TriggerParentExpander();
            ((TriggerParentExpander)expander).setTableTriggerExtractor(this.triggerExtractor);
            triggerChild.addExpander(expander);
            childNodes.add(triggerChild);
        }
        if (this.indexExtractor != null) {
            triggerParentInfo = new IndexParentInfo(parentDbinfo, schemaName, md);
            triggerChild = new ObjectTreeNode(session, triggerParentInfo);
            expander = new IndexParentExpander();
            ((IndexParentExpander)expander).setTableIndexExtractor(this.indexExtractor);
            triggerChild.addExpander(expander);
            childNodes.add(triggerChild);
        }
        return childNodes;
    }
}

