/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.viewer.swing.gui;

import com.glavsoft.viewer.ConnectionPresenter;
import com.glavsoft.viewer.mvp.View;
import com.glavsoft.viewer.swing.ConnectionParams;
import com.glavsoft.viewer.swing.Utils;
import com.glavsoft.viewer.swing.WrongParameterException;
import com.glavsoft.viewer.swing.gui.AutoCompletionComboEditorDocument;
import com.glavsoft.viewer.swing.gui.HostnameComboboxRenderer;
import com.glavsoft.viewer.swing.gui.OptionsDialog;
import com.glavsoft.viewer.swing.gui.StatusBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowListener;
import java.util.LinkedList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class ConnectionView
extends JPanel
implements View {
    private static final int PADDING = 4;
    public static final int COLUMNS_HOST_FIELD = 30;
    public static final int COLUMNS_PORT_USER_FIELD = 13;
    public static final String CLOSE = "Close";
    public static final String CANCEL = "Cancel";
    private WindowListener appWindowListener;
    private final boolean hasSshSupport;
    private final JTextField serverPortField;
    private JCheckBox useSshTunnelingCheckbox;
    private final JComboBox serverNameCombo;
    private JTextField sshUserField;
    private JTextField sshHostField;
    private JTextField sshPortField;
    private JLabel sshUserLabel;
    private JLabel sshHostLabel;
    private JLabel sshPortLabel;
    private JLabel ssUserWarningLabel;
    private JButton clearHistoryButton;
    private JButton connectButton;
    private final JFrame view;
    private final ConnectionPresenter presenter;
    private final StatusBar statusBar;
    private boolean connectionInProgress;
    private JButton closeCancelButton;

    public ConnectionView(WindowListener appWindowListener, final ConnectionPresenter presenter, boolean useSsh) {
        this.appWindowListener = appWindowListener;
        this.hasSshSupport = useSsh;
        this.presenter = presenter;
        this.setLayout(new BorderLayout(0, 0));
        JPanel optionsPane = new JPanel(new GridBagLayout());
        this.add((Component)optionsPane, "Center");
        optionsPane.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.setLayout(new GridBagLayout());
        int gridRow = 0;
        this.serverNameCombo = new JComboBox();
        this.initConnectionsHistoryCombo();
        this.serverNameCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Object item = ConnectionView.this.serverNameCombo.getSelectedItem();
                if (item instanceof ConnectionParams) {
                    presenter.populateFromHistoryItem((ConnectionParams)item);
                }
            }
        });
        this.addFormFieldRow(optionsPane, gridRow, new JLabel("Remote Host:"), this.serverNameCombo, true);
        this.serverPortField = new JTextField(13);
        this.addFormFieldRow(optionsPane, ++gridRow, new JLabel("Port:"), this.serverPortField, false);
        ++gridRow;
        if (this.hasSshSupport) {
            gridRow = this.createSshOptions(optionsPane, gridRow);
        }
        JPanel buttonPanel = this.createButtons();
        GridBagConstraints cButtons = new GridBagConstraints();
        cButtons.gridx = 0;
        cButtons.gridy = gridRow;
        cButtons.weightx = 100.0;
        cButtons.weighty = 100.0;
        cButtons.gridwidth = 2;
        cButtons.gridheight = 1;
        optionsPane.add((Component)buttonPanel, cButtons);
        this.view = new JFrame("New TightVNC Connection");
        this.view.add((Component)this, "Center");
        this.statusBar = new StatusBar();
        this.view.add((Component)this.statusBar, "South");
        this.view.getRootPane().setDefaultButton(this.connectButton);
        this.view.addWindowListener(appWindowListener);
        Utils.decorateDialog(this.view);
        Utils.centerWindow(this.view);
    }

    private void initConnectionsHistoryCombo() {
        this.serverNameCombo.setEditable(true);
        new AutoCompletionComboEditorDocument(this.serverNameCombo);
        this.serverNameCombo.setRenderer(new HostnameComboboxRenderer());
        ConnectionParams prototypeDisplayValue = new ConnectionParams();
        prototypeDisplayValue.hostName = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX\u0427\u0427";
        this.serverNameCombo.setPrototypeDisplayValue(prototypeDisplayValue);
    }

    public void showReconnectDialog(String title, String message) {
        JOptionPane reconnectPane = new JOptionPane(message + "\nTry another connection?", 3, 0);
        JDialog reconnectDialog = reconnectPane.createDialog(this, title);
        Utils.decorateDialog(reconnectDialog);
        reconnectDialog.setVisible(true);
        if (reconnectPane.getValue() == null || (Integer)reconnectPane.getValue() == 1) {
            this.presenter.setNeedReconnection(false);
            this.closeView();
            this.view.dispose();
            this.closeApp();
        }
    }

    public void setConnectionInProgress(boolean enable) {
        if (enable) {
            this.connectionInProgress = true;
            this.closeCancelButton.setText(CANCEL);
            this.connectButton.setEnabled(false);
        } else {
            this.connectionInProgress = false;
            this.closeCancelButton.setText(CLOSE);
            this.connectButton.setEnabled(true);
        }
    }

    private JPanel createButtons() {
        JPanel buttonPanel = new JPanel();
        this.closeCancelButton = new JButton(CLOSE);
        this.closeCancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ConnectionView.this.connectionInProgress) {
                    ConnectionView.this.presenter.cancelConnection();
                    ConnectionView.this.setConnectionInProgress(false);
                } else {
                    ConnectionView.this.closeView();
                    ConnectionView.this.closeApp();
                }
            }
        });
        this.connectButton = new JButton("Connect");
        buttonPanel.add(this.connectButton);
        this.connectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConnectionView.this.setMessage("");
                Object item = ConnectionView.this.serverNameCombo.getSelectedItem();
                String hostName = item instanceof ConnectionParams ? ((ConnectionParams)item).hostName : (String)item;
                try {
                    ConnectionView.this.setConnectionInProgress(true);
                    ConnectionView.this.presenter.submitConnection(hostName);
                }
                catch (WrongParameterException wpe) {
                    if ("HostName".equals(wpe.getPropertyName())) {
                        ConnectionView.this.serverNameCombo.requestFocusInWindow();
                    }
                    if ("PortNumber".equals(wpe.getPropertyName())) {
                        ConnectionView.this.serverPortField.requestFocusInWindow();
                    }
                    ConnectionView.this.showConnectionErrorDialog(wpe.getMessage());
                    ConnectionView.this.setConnectionInProgress(false);
                }
            }
        });
        JButton optionsButton = new JButton("Options...");
        buttonPanel.add(optionsButton);
        optionsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsDialog od = new OptionsDialog((Window)ConnectionView.this.view);
                od.initControlsFromSettings(ConnectionView.this.presenter.getRfbSettings(), ConnectionView.this.presenter.getUiSettings(), true);
                od.setVisible(true);
                ConnectionView.this.view.toFront();
            }
        });
        this.clearHistoryButton = new JButton("Clear history");
        this.clearHistoryButton.setToolTipText("Clear connections history");
        buttonPanel.add(this.clearHistoryButton);
        this.clearHistoryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConnectionView.this.presenter.clearHistory();
                ConnectionView.this.clearHistoryButton.setEnabled(false);
                ConnectionView.this.view.toFront();
            }
        });
        buttonPanel.add(this.closeCancelButton);
        return buttonPanel;
    }

    private int createSshOptions(JPanel pane, int gridRow) {
        GridBagConstraints cUseSshTunnelLabel = new GridBagConstraints();
        cUseSshTunnelLabel.gridx = 0;
        cUseSshTunnelLabel.gridy = gridRow++;
        cUseSshTunnelLabel.weightx = 100.0;
        cUseSshTunnelLabel.weighty = 100.0;
        cUseSshTunnelLabel.gridwidth = 2;
        cUseSshTunnelLabel.gridheight = 1;
        cUseSshTunnelLabel.anchor = 21;
        cUseSshTunnelLabel.ipadx = 4;
        cUseSshTunnelLabel.ipady = 10;
        this.useSshTunnelingCheckbox = new JCheckBox("Use SSH tunneling");
        pane.add((Component)this.useSshTunnelingCheckbox, cUseSshTunnelLabel);
        this.sshHostLabel = new JLabel("SSH Server:");
        this.sshHostField = new JTextField(30);
        this.addFormFieldRow(pane, gridRow, this.sshHostLabel, this.sshHostField, true);
        this.sshPortLabel = new JLabel("SSH Port:");
        this.sshPortField = new JTextField(13);
        this.addFormFieldRow(pane, ++gridRow, this.sshPortLabel, this.sshPortField, false);
        ++gridRow;
        this.sshUserLabel = new JLabel("SSH User:");
        this.sshUserField = new JTextField(13);
        JPanel sshUserFieldPane = new JPanel(new FlowLayout(0, 0, 0));
        sshUserFieldPane.add(this.sshUserField);
        this.ssUserWarningLabel = new JLabel(" (will be asked if not specified)");
        sshUserFieldPane.add(this.ssUserWarningLabel);
        this.addFormFieldRow(pane, gridRow, this.sshUserLabel, sshUserFieldPane, false);
        this.useSshTunnelingCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean useSsh = e.getStateChange() == 1;
                ConnectionView.this.setUseSsh(useSsh);
                ConnectionView.this.presenter.setUseSsh(useSsh);
            }
        });
        return ++gridRow;
    }

    private void addFormFieldRow(JPanel pane, int gridRow, JLabel label, JComponent field, boolean fill) {
        GridBagConstraints cLabel = new GridBagConstraints();
        cLabel.gridx = 0;
        cLabel.gridy = gridRow;
        cLabel.weightx = 0.0;
        cLabel.weighty = 100.0;
        cLabel.gridheight = 1;
        cLabel.gridwidth = 1;
        cLabel.anchor = 22;
        cLabel.ipadx = 4;
        cLabel.ipady = 10;
        pane.add((Component)label, cLabel);
        GridBagConstraints cField = new GridBagConstraints();
        cField.gridx = 1;
        cField.gridy = gridRow;
        cField.weightx = 0.0;
        cField.weighty = 100.0;
        cField.gridheight = 1;
        cField.gridwidth = 1;
        cField.anchor = 21;
        if (fill) {
            cField.fill = 2;
        }
        pane.add((Component)field, cField);
    }

    public void setMessage(String message) {
        this.statusBar.setMessage(message);
    }

    public void setPortNumber(int portNumber) {
        this.serverPortField.setText(String.valueOf(portNumber));
    }

    public String getPortNumber() {
        return this.serverPortField.getText();
    }

    public void setSshHostName(String sshHostName) {
        if (this.hasSshSupport) {
            this.sshHostField.setText(sshHostName);
        }
    }

    public String getSshHostName() {
        if (this.hasSshSupport) {
            return this.sshHostField.getText();
        }
        return "";
    }

    public void setSshPortNumber(int sshPortNumber) {
        if (this.hasSshSupport) {
            this.sshPortField.setText(String.valueOf(sshPortNumber));
        }
    }

    public String getSshPortNumber() {
        if (this.hasSshSupport) {
            return this.sshPortField.getText();
        }
        return "";
    }

    public void setSshUserName(String sshUserName) {
        if (this.hasSshSupport) {
            this.sshUserField.setText(sshUserName);
        }
    }

    public String getSshUserName() {
        if (this.hasSshSupport) {
            return this.sshUserField.getText();
        }
        return "";
    }

    public void setUseSsh(boolean useSsh) {
        if (this.hasSshSupport) {
            this.useSshTunnelingCheckbox.setSelected(useSsh);
            this.sshUserLabel.setEnabled(useSsh);
            this.sshUserField.setEnabled(useSsh);
            this.ssUserWarningLabel.setEnabled(useSsh);
            this.sshHostLabel.setEnabled(useSsh);
            this.sshHostField.setEnabled(useSsh);
            this.sshPortLabel.setEnabled(useSsh);
            this.sshPortField.setEnabled(useSsh);
        }
    }

    public boolean getUseSsh() {
        return this.useSshTunnelingCheckbox.isSelected();
    }

    public void setConnectionsList(LinkedList<ConnectionParams> connections) {
        this.serverNameCombo.removeAllItems();
        for (ConnectionParams cp : connections) {
            this.serverNameCombo.addItem(new ConnectionParams(cp));
        }
        this.serverNameCombo.setPopupVisible(false);
        this.clearHistoryButton.setEnabled(this.serverNameCombo.getItemCount() > 0);
    }

    @Override
    public void showView() {
        this.view.setVisible(true);
        this.view.toFront();
        this.view.repaint();
    }

    @Override
    public void closeView() {
        this.view.setVisible(false);
    }

    public void showConnectionErrorDialog(String message) {
        JOptionPane errorPane = new JOptionPane(message, 0);
        JDialog errorDialog = errorPane.createDialog(this.view, "Connection error");
        Utils.decorateDialog(errorDialog);
        errorDialog.setVisible(true);
        if (!this.presenter.allowInteractive()) {
            this.presenter.cancelConnection();
            this.closeApp();
        }
    }

    public void closeApp() {
        this.appWindowListener.windowClosing(null);
    }

    public JFrame getFrame() {
        return this.view;
    }
}

